<?php
// Script to enable error reporting in all PHP files
$baseDir = __DIR__;

function findPhpFiles($dir) {
    $files = [];
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS)
    );
    foreach ($iterator as $file) {
        if ($file->isFile() && $file->getExtension() === 'php') {
            $files[] = $file->getPathname();
        }
    }
    return $files;
}

$files = findPhpFiles($baseDir);
$count = 0;

foreach ($files as $file) {
    $content = file_get_contents($file);
    $original = $content;
    
    // Replace error_reporting(E_ALL) with error_reporting(E_ALL)
    $content = str_replace("error_reporting(E_ALL)", "error_reporting(E_ALL)", $content);
    
    if ($content !== $original) {
        file_put_contents($file, $content);
        echo "Updated: $file\n";
        $count++;
    }
}

echo "\nTotal files updated: $count\n";
