<?php
/**
 * Auto Translate Helper - Include this in all pages for automatic translation
 * 
 * Usage: Just include this file after session_start() and setup/function.php
 * It will automatically detect IP, set language, and provide $visitorLang and $textDir
 */

// Only run if not already initialized
if (!defined('AUTO_TRANSLATE_INITIALIZED')) {
    define('AUTO_TRANSLATE_INITIALIZED', true);
    
    // Get IP and User Agent
    $ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    
    // Support Cloudflare and proxy headers
    if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
        $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
    } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $forwarded = $_SERVER['HTTP_X_FORWARDED_FOR'];
        if (strpos($forwarded, ',') !== false) {
            $ip = trim(explode(',', $forwarded)[0]);
        } else {
            $ip = trim($forwarded);
        }
    }
    
    // Initialize auto-translate
    if (function_exists('initAutoTranslate')) {
        $translateInfo = initAutoTranslate($ip, $userAgent);
        $visitorLang = $translateInfo['lang'];
        $textDir = $translateInfo['text_dir'];
        $visitorCountry = $translateInfo['country_code'];
    } else {
        // Fallback: use fetchIpData if available
        if (function_exists('fetchIpData')) {
            $ipData = fetchIpData($ip, $userAgent);
            if ($ipData && isset($ipData['country_code'])) {
                if (function_exists('setVisitorCountry')) {
                    setVisitorCountry($ipData['country_code']);
                }
                $_SESSION['visitor_country'] = $ipData['country_code'];
                $_SESSION['country_code'] = $ipData['country_code'];
            }
        }
        
        // Get visitor language
        $visitorCountry = $_SESSION['visitor_country'] ?? $_SESSION['country_code'] ?? 'US';
        $visitorLang = $_SESSION['visitor_lang'] ?? 'en';
        
        if (function_exists('getLangFromCountry')) {
            $visitorLang = getLangFromCountry($visitorCountry);
        }
        
        if (function_exists('getTextDirection')) {
            $textDir = getTextDirection($visitorCountry);
        } else {
            $textDir = 'ltr';
        }
    }
    
    // Make variables available globally
    if (!isset($GLOBALS['visitorLang'])) {
        $GLOBALS['visitorLang'] = $visitorLang;
    }
    if (!isset($GLOBALS['textDir'])) {
        $GLOBALS['textDir'] = $textDir;
    }
    if (!isset($GLOBALS['visitorCountry'])) {
        $GLOBALS['visitorCountry'] = $visitorCountry;
    }
}

// Use global variables if not set locally
if (!isset($visitorLang)) {
    $visitorLang = $GLOBALS['visitorLang'] ?? 'en';
}
if (!isset($textDir)) {
    $textDir = $GLOBALS['textDir'] ?? 'ltr';
}
if (!isset($visitorCountry)) {
    $visitorCountry = $GLOBALS['visitorCountry'] ?? 'US';
}
