<?php

function getBinInfo($bin) {
    $csvFile = __DIR__ . '/bin-list-data.csv';
    if (!file_exists($csvFile)) return false;

    if (($handle = fopen($csvFile, 'r')) === false) {
        return false;
    }

    fgetcsv($handle);

    while (($row = fgetcsv($handle)) !== false) {

        if (trim($row[0]) === $bin) {
            fclose($handle);

            return [
                'bin'         => $row[0],
                'scheme'      => strtoupper($row[1] ?: 'UNKNOWN'),
                'type'        => strtoupper($row[2] ?: 'UNKNOWN'),
                'card_tier'   => strtoupper($row[3] ?: 'UNKNOWN'),
                'issuer'      => strtoupper($row[4] ?: 'UNKNOWN'),
                'issuer_phone'=> $row[5] ?: '',
                'issuer_url'  => $row[6] ?: '',
                'isoCode2'    => $row[7] ?: '',
                'isoCode3'    => $row[8] ?: '',
                'country'     => $row[9] ?: ''
            ];
        }
    }

    fclose($handle);
    return false;
}