<?php
/**
 * Test script for new translation keys
 */

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/translate.php';

echo "=== Testing New Translation Keys ===\n\n";

// Test new keys
$testKeys = [
    'log_in_to_your_paypal_account',
    'required',
    'forgot_email'
];

$testCountries = ['US', 'ID', 'JP', 'ES', 'FR', 'DE'];

foreach ($testCountries as $country) {
    echo "Testing country: $country\n";
    $_SESSION['visitor_country'] = $country;
    
    foreach ($testKeys as $key) {
        $result = __($key);
        echo "  $key: $result\n";
        
        // Check if result is not the key itself (meaning translation found)
        if ($result === $key) {
            echo "    ⚠ WARNING: Key '$key' not found for country $country\n";
        }
    }
    echo "\n";
}

echo "=== Testing Complete ===\n";
