<?php
/**
 * Test script for translate.php to check for bugs
 * Run this script to test translation functionality
 */

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include translate.php
require_once __DIR__ . '/translate.php';

echo "=== Testing Translation System ===\n\n";

// Test 1: Basic translation
echo "Test 1: Basic translation (US -> English)\n";
$_SESSION['visitor_country'] = 'US';
$result = __('sign_in');
echo "Result: $result\n";
echo "Expected: Sign In\n";
echo ($result === 'Sign In' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 2: Indonesian translation
echo "Test 2: Indonesian translation (ID -> Indonesian)\n";
$_SESSION['visitor_country'] = 'ID';
$result = __('sign_in');
echo "Result: $result\n";
echo "Expected: Masuk\n";
echo ($result === 'Masuk' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 3: Japanese translation
echo "Test 3: Japanese translation (JP -> Japanese)\n";
$_SESSION['visitor_country'] = 'JP';
$result = __('sign_in');
echo "Result: $result\n";
echo "Expected: ログイン\n";
echo ($result === 'ログイン' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 4: Batch translation
echo "Test 4: Batch translation\n";
$_SESSION['visitor_country'] = 'ID';
$keys = ['sign_in', 'email', 'password'];
$results = __($keys);
echo "Results: " . print_r($results, true) . "\n";
echo (count($results) === 3 ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 5: Unknown country fallback
echo "Test 5: Unknown country fallback (XX -> English)\n";
$_SESSION['visitor_country'] = 'XX';
$result = __('sign_in');
echo "Result: $result\n";
echo "Expected: Sign In (fallback to English)\n";
echo ($result === 'Sign In' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 6: Unknown key fallback
echo "Test 6: Unknown key fallback\n";
$_SESSION['visitor_country'] = 'US';
$result = __('nonexistent_key_xyz');
echo "Result: $result\n";
echo "Expected: nonexistent_key_xyz (return key itself)\n";
echo ($result === 'nonexistent_key_xyz' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 7: getLangFromCountry function
echo "Test 7: getLangFromCountry function\n";
$lang = getLangFromCountry('ID');
echo "Country: ID -> Language: $lang\n";
echo "Expected: id\n";
echo ($lang === 'id' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

// Test 8: getTextDirection function
echo "Test 8: getTextDirection function\n";
$dir = getTextDirection('SA'); // Saudi Arabia -> Arabic -> RTL
echo "Country: SA -> Direction: $dir\n";
echo "Expected: rtl\n";
echo ($dir === 'rtl' ? "✓ PASS\n\n" : "✗ FAIL\n\n");

echo "=== Testing Complete ===\n";
