<?php
/**
 * Disney+ Save Template Handler
 * Saves the selected declined_template to control.json
 */

header('Content-Type: application/json');

// Get template number from request
$template = $_GET['template'] ?? null;

// Validate template (1-60)
$validTemplates = array_map('strval', range(1, 60));
if (!$template || !in_array($template, $validTemplates)) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid template number. Must be 1-60.'
    ]);
    exit;
}

// Load current config
$controlFile = __DIR__ . '/control.json';
$config = [];

if (file_exists($controlFile)) {
    $content = file_get_contents($controlFile);
    $config = json_decode($content, true) ?? [];
}

// Update declined_template
$config['declined_template'] = $template;

// Save config
$result = file_put_contents(
    $controlFile,
    json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES)
);

if ($result !== false) {
    echo json_encode([
        'success' => true,
        'message' => 'Template #' . $template . ' has been activated.',
        'template' => $template
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Failed to save configuration file.'
    ]);
}
